/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.io.IOException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class StandardScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private final String scriptEngineName;
    private final String scriptSourceLocator;
    private final Class<?>[] scriptInterfaces;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile ScriptEngine scriptEngine;

    public StandardScriptFactory(String scriptSourceLocator) {
        this(null, scriptSourceLocator, (Class[])null);
    }

    public StandardScriptFactory(String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        this(null, scriptSourceLocator, scriptInterfaces);
    }

    public StandardScriptFactory(String scriptEngineName, String scriptSourceLocator) {
        this(scriptEngineName, scriptSourceLocator, (Class[])null);
    }

    public StandardScriptFactory(String scriptEngineName, String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptEngineName = scriptEngineName;
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ScriptEngine retrieveScriptEngine(ScriptSource scriptSource) {
        ScriptEngine engine;
        String extension;
        String filename;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(this.beanClassLoader);
        if (this.scriptEngineName != null) {
            ScriptEngine engine2 = scriptEngineManager.getEngineByName(this.scriptEngineName);
            if (engine2 == null) {
                throw new IllegalStateException("Script engine named '" + this.scriptEngineName + "' not found");
            }
            return engine2;
        }
        if (scriptSource instanceof ResourceScriptSource && (filename = ((ResourceScriptSource)scriptSource).getResource().getFilename()) != null && (extension = StringUtils.getFilenameExtension(filename)) != null && (engine = scriptEngineManager.getEngineByExtension(extension)) != null) {
            return engine;
        }
        return null;
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    public Class<?>[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    @Override
    public boolean requiresConfigInterface() {
        return false;
    }

    @Override
    public Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        Object script;
        try {
            if (this.scriptEngine == null) {
                this.scriptEngine = this.retrieveScriptEngine(scriptSource);
                if (this.scriptEngine == null) {
                    throw new IllegalStateException("Could not determine script engine for " + scriptSource);
                }
            }
            script = this.scriptEngine.eval(scriptSource.getScriptAsString());
        }
        catch (Exception ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
        if (!ObjectUtils.isEmpty(actualInterfaces)) {
            Class<?> adaptedIfc;
            boolean adaptationRequired = false;
            for (Class<?> requestedIfc : actualInterfaces) {
                if (requestedIfc.isInstance(script)) continue;
                adaptationRequired = true;
            }
            if (adaptationRequired && (adaptedIfc = actualInterfaces.length == 1 ? actualInterfaces[0] : ClassUtils.createCompositeInterface(actualInterfaces, this.beanClassLoader)) != null) {
                if (!(this.scriptEngine instanceof Invocable)) {
                    throw new ScriptCompilationException(scriptSource, "ScriptEngine must implement Invocable in order to adapt it to an interface: " + this.scriptEngine);
                }
                Invocable invocable = (Invocable)((Object)this.scriptEngine);
                if (script != null) {
                    script = invocable.getInterface(script, adaptedIfc);
                }
                if (script == null && (script = invocable.getInterface(adaptedIfc)) == null) {
                    throw new ScriptCompilationException(scriptSource, "Could not adapt script to interface [" + adaptedIfc.getName() + "]");
                }
            }
        }
        if (script instanceof Class) {
            Class scriptClass = (Class)script;
            try {
                return scriptClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ScriptCompilationException(scriptSource, "Could not instantiate script class: " + scriptClass.getName(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new ScriptCompilationException(scriptSource, "Could not access script constructor: " + scriptClass.getName(), ex);
            }
        }
        return script;
    }

    @Override
    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        return null;
    }

    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        return scriptSource.isModified();
    }

    public String toString() {
        return "StandardScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

