/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;
    private Annotation[][] annotationsOnDimensions;
    public int originalSourceEnd;
    public int extendedDimensions;

    public ArrayTypeReference(char[] cArray, int n, long l) {
        super(cArray, l);
        this.originalSourceEnd = this.sourceEnd;
        this.dimensions = n;
        this.annotationsOnDimensions = null;
    }

    public ArrayTypeReference(char[] cArray, int n, Annotation[][] annotationArray, long l) {
        this(cArray, n, l);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
        this.annotationsOnDimensions = annotationArray;
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public int extraDimensions() {
        return this.extendedDimensions;
    }

    @Override
    public Annotation[][] getAnnotationsOnDimensions(boolean bl) {
        if (bl || this.annotationsOnDimensions == null || this.annotationsOnDimensions.length == 0 || this.extendedDimensions == 0 || this.extendedDimensions == this.dimensions) {
            return this.annotationsOnDimensions;
        }
        Annotation[][] annotationArray = new Annotation[this.dimensions][];
        int n = this.dimensions - this.extendedDimensions;
        System.arraycopy(this.annotationsOnDimensions, n, annotationArray, 0, this.extendedDimensions);
        System.arraycopy(this.annotationsOnDimensions, 0, annotationArray, this.extendedDimensions, n);
        return annotationArray;
    }

    @Override
    public void setAnnotationsOnDimensions(Annotation[][] annotationArray) {
        this.annotationsOnDimensions = annotationArray;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n = this.dimensions;
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            cArray[n2] = 91;
            cArray[n2 + 1] = 93;
        }
        return new char[][]{CharOperation.concat(this.token, cArray)};
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        TypeBinding typeBinding = scope.getType(this.token);
        return scope.createArrayType(typeBinding, this.dimensions);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            for (int i = 0; i < this.dimensions - 1; ++i) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i] != null) {
                    stringBuffer.append(' ');
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[i], stringBuffer);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("[]");
            }
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[this.dimensions - 1] != null) {
                stringBuffer.append(' ');
                ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[this.dimensions - 1], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append("...");
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i] != null) {
                    stringBuffer.append(" ");
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[i], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n;
                Annotation[] annotationArray = this.annotations[0];
                int n2 = n = annotationArray == null ? 0 : annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    annotationArray[i].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.annotationsOnDimensions != null) {
                for (Annotation[] annotationArray : this.annotationsOnDimensions) {
                    if (annotationArray == null) continue;
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation annotation = annotationArray[i];
                        annotation.traverse(aSTVisitor, blockScope);
                    }
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n;
                Annotation[] annotationArray = this.annotations[0];
                int n2 = n = annotationArray == null ? 0 : annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    annotationArray[i].traverse(aSTVisitor, classScope);
                }
            }
            if (this.annotationsOnDimensions != null) {
                for (Annotation[] annotationArray : this.annotationsOnDimensions) {
                    if (annotationArray == null) continue;
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation annotation = annotationArray[i];
                        annotation.traverse(aSTVisitor, classScope);
                    }
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    protected TypeBinding internalResolveType(Scope scope, int n) {
        TypeBinding typeBinding = super.internalResolveType(scope, n);
        return typeBinding;
    }
}

