/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.preverification;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;

public class FullFrame
extends StackMapFrame {
    public int variablesCount;
    public VerificationType[] variables;
    public int stackCount;
    public VerificationType[] stack;

    public FullFrame() {
    }

    public FullFrame(int n, VerificationType[] verificationTypeArray, VerificationType[] verificationTypeArray2) {
        this(n, verificationTypeArray.length, verificationTypeArray, verificationTypeArray2.length, verificationTypeArray2);
    }

    public FullFrame(int n, int n2, VerificationType[] verificationTypeArray, int n3, VerificationType[] verificationTypeArray2) {
        this.u2offsetDelta = n;
        this.variablesCount = n2;
        this.variables = verificationTypeArray;
        this.stackCount = n3;
        this.stack = verificationTypeArray2;
    }

    public void variablesAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationTypeVisitor verificationTypeVisitor) {
        for (int i = 0; i < this.variablesCount; ++i) {
            this.variables[i].variablesAccept(clazz, method, codeAttribute, n, i, verificationTypeVisitor);
        }
    }

    public void stackAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationTypeVisitor verificationTypeVisitor) {
        for (int i = 0; i < this.stackCount; ++i) {
            this.stack[i].stackAccept(clazz, method, codeAttribute, n, i, verificationTypeVisitor);
        }
    }

    @Override
    public int getTag() {
        return 255;
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrameVisitor stackMapFrameVisitor) {
        stackMapFrameVisitor.visitFullFrame(clazz, method, codeAttribute, n, this);
    }

    @Override
    public boolean equals(Object object) {
        VerificationType verificationType;
        VerificationType verificationType2;
        int n;
        if (!super.equals(object)) {
            return false;
        }
        FullFrame fullFrame = (FullFrame)object;
        if (this.u2offsetDelta != fullFrame.u2offsetDelta || this.variablesCount != fullFrame.variablesCount || this.stackCount != fullFrame.stackCount) {
            return false;
        }
        for (n = 0; n < this.variablesCount; ++n) {
            verificationType2 = this.variables[n];
            verificationType = fullFrame.variables[n];
            if (verificationType2.equals(verificationType)) continue;
            return false;
        }
        for (n = 0; n < this.stackCount; ++n) {
            verificationType2 = this.stack[n];
            verificationType = fullFrame.stack[n];
            if (verificationType2.equals(verificationType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n;
        int n2 = super.hashCode();
        for (n = 0; n < this.variablesCount; ++n) {
            n2 ^= this.variables[n].hashCode();
        }
        for (n = 0; n < this.stackCount; ++n) {
            n2 ^= this.stack[n].hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append("Var: ");
        for (n = 0; n < this.variablesCount; ++n) {
            stringBuffer = stringBuffer.append('[').append(this.variables[n].toString()).append(']');
        }
        stringBuffer.append(", Stack: ");
        for (n = 0; n < this.stackCount; ++n) {
            stringBuffer = stringBuffer.append('[').append(this.stack[n].toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

