/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class InstructionWriter
extends SimplifiedVisitor
implements InstructionVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private int codeLength;
    private CodeAttributeEditor codeAttributeEditor;

    public void reset(int n) {
        this.codeLength = n;
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.reset(n);
        }
    }

    public void extend(int n) {
        this.codeLength = n;
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.extend(n);
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        simpleInstruction.write(codeAttribute, n);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        try {
            constantInstruction.write(codeAttribute, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ConstantInstruction constantInstruction2 = new ConstantInstruction(constantInstruction.opcode, constantInstruction.constantIndex, constantInstruction.constant);
            this.replaceInstruction(n, constantInstruction2);
            constantInstruction.constantIndex = 0;
            constantInstruction.constant = 0;
            constantInstruction.write(codeAttribute, n);
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        try {
            variableInstruction.write(codeAttribute, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            VariableInstruction variableInstruction2 = new VariableInstruction(variableInstruction.opcode, variableInstruction.variableIndex, variableInstruction.constant);
            this.replaceInstruction(n, variableInstruction2);
            variableInstruction.variableIndex = 0;
            variableInstruction.constant = 0;
            variableInstruction.write(codeAttribute, n);
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        try {
            branchInstruction.write(codeAttribute, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BranchInstruction branchInstruction2 = new BranchInstruction(-56, branchInstruction.branchOffset);
            switch (branchInstruction.opcode) {
                default: {
                    branchInstruction2 = new BranchInstruction(branchInstruction.opcode, branchInstruction.branchOffset);
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    BranchInstruction branchInstruction3 = new BranchInstruction((byte)((branchInstruction.opcode + 1 ^ 1) - 1), 8);
                    this.insertBeforeInstruction(n, branchInstruction3);
                    break;
                }
                case -58: 
                case -57: {
                    BranchInstruction branchInstruction4 = new BranchInstruction((byte)(branchInstruction.opcode ^ 1), 8);
                    this.insertBeforeInstruction(n, branchInstruction4);
                    break;
                }
            }
            this.replaceInstruction(n, branchInstruction2);
            branchInstruction.branchOffset = 0;
            branchInstruction.write(codeAttribute, n);
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        switchInstruction.write(codeAttribute, n);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
            this.codeAttributeEditor = null;
        }
    }

    private void insertBeforeInstruction(int n, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.insertBeforeInstruction(n, instruction);
    }

    private void replaceInstruction(int n, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.replaceInstruction(n, instruction);
    }

    private void insertAfterInstruction(int n, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.insertAfterInstruction(n, instruction);
    }

    private void ensureCodeAttributeEditor() {
        if (this.codeAttributeEditor == null) {
            this.codeAttributeEditor = new CodeAttributeEditor(false, true);
            this.codeAttributeEditor.reset(this.codeLength);
        }
    }
}

