/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class DirectoryWriter
implements DataEntryWriter {
    private final File baseFile;
    private final boolean isFile;
    private File currentFile;
    private OutputStream currentOutputStream;
    private Finisher currentFinisher;

    public DirectoryWriter(File file, boolean bl) {
        this.baseFile = file;
        this.isFile = bl;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        File file;
        if (!this.isFile && this.currentFile != null) {
            this.closeEntry();
        }
        if (!(file = this.getFile(dataEntry)).exists() && !file.mkdirs()) {
            throw new IOException("Can't create directory [" + file.getPath() + "]");
        }
        return true;
    }

    @Override
    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    @Override
    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        File file = this.getFile(dataEntry);
        if (!this.isFile && this.currentFile != null && !this.currentFile.equals(file)) {
            this.closeEntry();
        }
        if (this.currentOutputStream == null) {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                throw new IOException("Can't create directory [" + file2.getPath() + "]");
            }
            this.currentOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.currentFinisher = finisher;
            this.currentFile = file;
        }
        return this.currentOutputStream;
    }

    @Override
    public void close() throws IOException {
        this.closeEntry();
    }

    private File getFile(DataEntry dataEntry) {
        return this.isFile ? this.baseFile : new File(this.baseFile, dataEntry.getName().replace('/', File.separatorChar));
    }

    private void closeEntry() throws IOException {
        if (this.currentOutputStream != null) {
            if (this.currentFinisher != null) {
                this.currentFinisher.finish();
                this.currentFinisher = null;
            }
            this.currentOutputStream.close();
            this.currentOutputStream = null;
            this.currentFile = null;
        }
    }
}

