#ifndef EFL_GENERATED_ELDBUS_MODEL_METHOD_HH
#define EFL_GENERATED_ELDBUS_MODEL_METHOD_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "eldbus_model_method.eo.h"
}

#include "eldbus_model_arguments.eo.hh"

namespace eldbus {

struct model_method;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace eldbus {

struct model_method
{
   Efl_Model_Load_Status call() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_successful_call_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL );
   }

   template <typename T>
   void
   callback_successful_call_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELDBUS_MODEL_METHOD_CLASS);
   }

   operator ::eldbus::model_method() const;
   operator ::eldbus::model_method&();
   operator ::eldbus::model_method const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::eldbus::model_method*() const { return static_cast<::eldbus::model_method*>(static_cast<D const*>(this)->p); }
      operator ::eldbus::model_method const*() const { return static_cast<::eldbus::model_method const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::eldbus::model_method const*() const { return static_cast<::eldbus::model_method const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace eldbus {

/// @brief Class model_method
struct model_method
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::model::base)
      , EO_CXX_INHERIT(eldbus::model_arguments)
      , EO_CXX_INHERIT(eo::base)
{
   /// @cond LOCAL
   struct _c_constructor
   {

      explicit _c_constructor(Eldbus_Proxy * proxy_, const Eldbus_Introspection_Method * method_)
         : proxy_(proxy_), method_(method_)
      {}
      void operator()()
      {
         ::eldbus_model_method_constructor(proxy_, method_);
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      Eldbus_Proxy * proxy_;
      const Eldbus_Introspection_Method * method_;
   };
   /// @endcond

   //@{
   /**
      @brief Constructs a new eldbus::model_method object.

      Constructs a new eldbus::model_method object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Since this class have a necessary constructor method, you must call it
      in the right place within this constructor parameters.

      Example:
      @code
      eldbus::model_method my_model_method(efl::eo::parent = parent_object,
         my_model_method.constructor(proxy_, method_));
      @endcode

      @see model_method::constructor
      @see model_method(Eo* eo)
   */
   explicit model_method(::efl::eo::parent_type _p, _c_constructor _c0)
      : model_method(_ctors_call(_p, _c0))
   {}

   explicit model_method(_c_constructor _c0)
      : model_method(_ctors_call(::efl::eo::parent = nullptr, _c0))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit model_method(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit model_method(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   model_method(model_method const& other)
      : model_method(eo_ref(other._eo_ptr()))
   {}

   ~model_method() {}

   /// @param proxy 
   /// @param method 
   ///
   static _c_constructor constructor(Eldbus_Proxy * proxy_, const Eldbus_Introspection_Method * method_);

   Efl_Model_Load_Status call() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_child_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILD_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EFL_MODEL_BASE_EVENT_CHILD_ADDED );
   }

   template <typename T>
   void
   callback_child_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILD_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_child_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILD_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EFL_MODEL_BASE_EVENT_CHILD_REMOVED );
   }

   template <typename T>
   void
   callback_child_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILD_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_count_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED );
   }

   template <typename T>
   void
   callback_children_count_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_load_status_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_LOAD_STATUS, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EFL_MODEL_BASE_EVENT_LOAD_STATUS );
   }

   template <typename T>
   void
   callback_load_status_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_LOAD_STATUS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_properties_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED );
   }

   template <typename T>
   void
   callback_properties_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_successful_call_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_method, function_type>,
         ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL );
   }

   template <typename T>
   void
   callback_successful_call_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELDBUS_MODEL_METHOD_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::eldbus::model_method::address_of<address_of>
      , ::eo_cxx::efl::model::base::address_of<address_of>
      , ::eo_cxx::eldbus::model_arguments::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::eldbus::model_method* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::eldbus::model_method::address_const_of<address_const_of>
      , ::eo_cxx::efl::model::base::address_const_of<address_const_of>
      , ::eo_cxx::eldbus::model_arguments::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::eldbus::model_method const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p, _c_constructor _c0)
   {
      Eo* _ret_eo = eo_add_ref(ELDBUS_MODEL_METHOD_CLASS, _p._eo_raw, _c0());

      _c0.register_ev_del_free_callback(_ret_eo);
      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::eldbus::model_method) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::eldbus::model_method>::value, "");

}


#include "eldbus_model_method.eo.impl.hh"

#endif // EFL_GENERATED_ELDBUS_MODEL_METHOD_HH

