/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PickleReader {
    private Viewer vwr;
    private GenericBinaryDocument binaryDoc;
    private Lst<Object> stack = new Lst();
    private Lst<Integer> marks = new Lst();
    private Lst<Object> build = new Lst();
    private Map<Integer, Object> memo = new Hashtable<Integer, Object>();
    private boolean logging;
    private int id;
    private int markCount;
    private int filePt;
    private int emptyListPt;
    private Object thisSection;
    private boolean inMovie;
    private boolean inNames;
    private int lastMark;
    private int retrieveCount;
    private static final byte APPEND = 97;
    private static final byte APPENDS = 101;
    private static final byte BINFLOAT = 71;
    private static final byte BININT = 74;
    private static final byte BININT1 = 75;
    private static final byte BININT2 = 77;
    private static final byte BINPUT = 113;
    private static final byte BINSTRING = 84;
    private static final byte BINUNICODE = 87;
    private static final byte BUILD = 98;
    private static final byte EMPTY_DICT = 125;
    private static final byte EMPTY_LIST = 93;
    private static final byte GLOBAL = 99;
    private static final byte LONG_BINPUT = 114;
    private static final byte MARK = 40;
    private static final byte NONE = 78;
    private static final byte OBJ = 111;
    private static final byte SETITEM = 115;
    private static final byte SETITEMS = 117;
    private static final byte SHORT_BINSTRING = 85;
    private static final byte STOP = 46;
    private static final byte BINGET = 104;
    private static final byte LONG_BINGET = 106;
    private static final byte TUPLE = 116;
    private static final byte INT = 73;

    PickleReader(GenericBinaryDocument genericBinaryDocument, Viewer viewer) {
        this.binaryDoc = genericBinaryDocument;
        this.vwr = viewer;
        this.stack.ensureCapacity(1000);
    }

    private void log(String string) {
        this.vwr.log(string + "\u0000");
    }

    Map<String, Object> getMap(boolean bl) throws Exception {
        Map map;
        String string;
        int n;
        Object object;
        this.logging = bl;
        boolean bl2 = true;
        block29: while (bl2) {
            byte by = this.binaryDoc.readByte();
            switch (by) {
                case 125: {
                    this.push(new Hashtable());
                    continue block29;
                }
                case 97: {
                    object = this.pop();
                    ((Lst)this.peek()).addLast(object);
                    continue block29;
                }
                case 101: {
                    Lst<Object> lst = this.getObjects(this.getMark());
                    if (this.inNames && this.markCount == 2) {
                        int n2 = (int)this.binaryDoc.getPosition();
                        Lst<Integer> lst2 = new Lst<Integer>();
                        lst2.addLast(this.filePt);
                        lst2.addLast(n2 - this.filePt);
                        lst.addLast(lst2);
                    }
                    ((Lst)this.peek()).addAll(lst);
                    continue block29;
                }
                case 71: {
                    double d = this.binaryDoc.readDouble();
                    this.push(d);
                    continue block29;
                }
                case 74: {
                    n = this.binaryDoc.readIntLE();
                    this.push(n);
                    continue block29;
                }
                case 75: {
                    n = this.binaryDoc.readByte() & 0xFF;
                    this.push(n);
                    continue block29;
                }
                case 77: {
                    n = (this.binaryDoc.readByte() & 0xFF | (this.binaryDoc.readByte() & 0xFF) << 8) & 0xFFFF;
                    this.push(n);
                    continue block29;
                }
                case 113: {
                    n = this.binaryDoc.readByte();
                    this.putMemo(n, false);
                    continue block29;
                }
                case 114: {
                    n = this.binaryDoc.readIntLE();
                    this.putMemo(n, true);
                    continue block29;
                }
                case 104: {
                    n = this.binaryDoc.readByte();
                    object = this.getMemo(n);
                    this.push(object == null ? "BINGET" + ++this.id : object);
                    continue block29;
                }
                case 106: {
                    n = this.binaryDoc.readIntLE();
                    object = this.getMemo(n);
                    if (object == null) {
                        Logger.error("did not find memo item for " + n);
                        this.push("LONG_BINGET" + ++this.id);
                        continue block29;
                    }
                    this.push(object);
                    continue block29;
                }
                case 85: {
                    n = this.binaryDoc.readByte() & 0xFF;
                    byte[] byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    string = new String(byArray, "UTF-8");
                    if (this.inNames && this.markCount == 3 && this.lastMark == this.stack.size()) {
                        this.filePt = this.emptyListPt;
                    }
                    this.push(string);
                    continue block29;
                }
                case 84: {
                    n = this.binaryDoc.readIntLE();
                    byte[] byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    string = new String(byArray, "UTF-8");
                    this.push(string);
                    continue block29;
                }
                case 87: {
                    n = this.binaryDoc.readIntLE();
                    byte[] byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    string = new String(byArray, "UTF-8");
                    this.push(string);
                    continue block29;
                }
                case 93: {
                    this.emptyListPt = (int)this.binaryDoc.getPosition() - 1;
                    this.push(new Lst());
                    continue block29;
                }
                case 99: {
                    Lst<Object> lst = new Lst();
                    lst.addLast("global");
                    lst.addLast(this.readString());
                    lst.addLast(this.readString());
                    this.push(lst);
                    continue block29;
                }
                case 98: {
                    object = this.pop();
                    this.build.addLast(object);
                    continue block29;
                }
                case 40: {
                    this.putMark(this.stack.size());
                    continue block29;
                }
                case 78: {
                    this.push(null);
                    continue block29;
                }
                case 111: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 115: {
                    object = this.pop();
                    if (!(this.peek() instanceof String)) {
                        Logger.error(this.peek() + " is not a string");
                    }
                    string = (String)this.pop();
                    ((Map)this.peek()).put(string, object);
                    continue block29;
                }
                case 117: {
                    int n3 = this.getMark();
                    Lst<Object> lst = this.getObjects(n3);
                    object = this.peek();
                    if (object instanceof Lst) {
                        for (n = 0; n < lst.size(); ++n) {
                            ((Lst)object).addLast(lst.get(n));
                        }
                        continue block29;
                    }
                    map = (Map)object;
                    n = lst.size();
                    while (--n >= 0) {
                        object = lst.get(n);
                        string = (String)lst.get(--n);
                        map.put(string, object);
                    }
                    continue block29;
                }
                case 46: {
                    bl2 = false;
                    continue block29;
                }
                case 116: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 73: {
                    string = this.readString();
                    try {
                        this.push(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        long l = Long.parseLong(string);
                        this.push((int)(l & 0xFFFFFFFFFFFFFFFFL));
                    }
                    continue block29;
                }
            }
            Logger.error("Pickle reader error: " + by + " " + this.binaryDoc.getPosition());
        }
        if (bl) {
            this.log("");
        }
        Logger.info("PyMOL Pickle reader cached " + this.memo.size() + " tokens; retrieved " + this.retrieveCount);
        this.memo = null;
        map = (Map)this.stack.remove(0);
        if (map.size() == 0) {
            n = this.stack.size();
            while (--n >= 0) {
                object = this.stack.get(n--);
                string = (String)this.stack.get(n);
                map.put(string, object);
            }
        }
        return map;
    }

    private void putMemo(int n, boolean bl) {
        Object object = this.peek();
        if (object instanceof String) {
            if (bl && this.markCount >= 6 || this.markCount == 3 && this.inMovie) {
                return;
            }
            this.memo.put(n, object);
        }
    }

    private Object getMemo(int n) {
        Object object = this.memo.get(n);
        if (object == null) {
            return object;
        }
        ++this.retrieveCount;
        return object;
    }

    private Lst<Object> getObjects(int n) {
        int n2;
        int n3 = this.stack.size() - n;
        Lst<Object> lst = new Lst<Object>();
        lst.ensureCapacity(n3);
        for (n2 = n; n2 < this.stack.size(); ++n2) {
            lst.addLast(this.stack.get(n2));
        }
        n2 = this.stack.size();
        while (--n2 >= n) {
            this.stack.remove(n2);
        }
        return lst;
    }

    private String readString() throws Exception {
        byte by;
        SB sB = new SB();
        while ((by = this.binaryDoc.readByte()) != 10) {
            sB.appendC((char)by);
        }
        return sB.toString();
    }

    private void putMark(int n) {
        if (this.logging) {
            this.log("\n " + Integer.toHexString((int)this.binaryDoc.getPosition()) + " [");
        }
        this.lastMark = n;
        this.marks.addLast(this.lastMark);
        ++this.markCount;
        switch (this.markCount) {
            case 2: {
                this.thisSection = this.stack.get(n - 2);
                if (!(this.thisSection instanceof String)) break;
                this.inMovie = "movie".equals(this.thisSection);
                this.inNames = "names".equals(this.thisSection);
                break;
            }
        }
    }

    private int getMark() {
        return (Integer)this.marks.remove(--this.markCount);
    }

    private void push(Object object) {
        if (this.logging && (object instanceof String || object instanceof Double || object instanceof Integer)) {
            this.log((object instanceof String ? "'" + object + "'" : object) + ", ");
        }
        this.stack.addLast(object);
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }
}

