/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private P3[] screens3f;
    private P3i scrVib;
    private boolean vibs;
    private BS bsSelected;
    private boolean showNumbers;

    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.bsSelected = this.vwr.getSelectionHalosEnabled() ? this.vwr.bsA() : null;
        this.g3d.addRenderer(1073742182);
        this.vibs = this.ms.vibrations != null && this.tm.vibrationOn;
        this.showNumbers = this.vwr.getTestFlag(3);
        boolean bl = false;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            if (!polyhedronArray[n].isValid || !this.render1(polyhedronArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean render1(Polyhedron polyhedron) {
        V3 v3;
        Object object;
        Object object2;
        T3[] t3Array;
        short s;
        if (polyhedron.visibilityFlags == 0) {
            return false;
        }
        short[] sArray = ((Polyhedra)this.shape).colixes;
        int n = -1;
        float f = 1.0f;
        if (polyhedron.id == null) {
            n = polyhedron.centralAtom.i;
            s = sArray == null || n >= sArray.length ? (short)0 : sArray[n];
            s = C.getColixInherited((short)s, (short)polyhedron.centralAtom.colixAtom);
        } else {
            s = polyhedron.colix;
            f = polyhedron.scale;
        }
        boolean bl = false;
        if (C.renderPass2((short)s)) {
            bl = true;
        } else if (!this.g3d.setC(s)) {
            return false;
        }
        P3[] p3Array = polyhedron.vertices;
        if (f != 1.0f) {
            t3Array = new T3[p3Array.length];
            if (f < 0.0f) {
                object2 = V3.newV((T3)polyhedron.center);
                object2.scale(-f - 1.0f);
                int n2 = t3Array.length;
                while (--n2 >= 0) {
                    V3 v32 = V3.newV((T3)p3Array[n2]);
                    v32.add((T3)object2);
                    t3Array[n2] = v32;
                }
            } else {
                int n3 = t3Array.length;
                while (--n3 >= 0) {
                    V3 v33 = V3.newVsub((T3)p3Array[n3], (T3)polyhedron.center);
                    v33.scaleAdd2(f, (T3)v33, (T3)polyhedron.center);
                    t3Array[n3] = v33;
                }
            }
            p3Array = t3Array;
        }
        if (this.screens3f == null || this.screens3f.length < p3Array.length) {
            this.screens3f = new P3[p3Array.length];
            int n4 = p3Array.length;
            while (--n4 >= 0) {
                this.screens3f[n4] = new P3();
            }
        }
        t3Array = this.screens3f;
        object2 = polyhedron.triangles;
        int[] nArray = polyhedron.pointScale > 0.0f ? polyhedron.getElemNos() : null;
        int n5 = p3Array.length;
        while (--n5 >= 0) {
            object = p3Array[n5] instanceof Atom ? (Atom)p3Array[n5] : null;
            T3 t3 = t3Array[n5];
            if (object == null) {
                this.tm.transformPtScrT3((T3)p3Array[n5], t3);
            } else if (object.isVisible(this.myVisibilityFlag)) {
                t3.set((float)object.sX, (float)object.sY, (float)object.sZ);
            } else if (this.vibs && object.hasVibration()) {
                this.scrVib = this.tm.transformPtVib((P3)object, this.ms.vibrations[object.i]);
                t3.set((float)this.scrVib.x, (float)this.scrVib.y, (float)this.scrVib.z);
            } else {
                this.tm.transformPt3f((T3)object, (P3)t3);
            }
            if (nArray != null && n5 + 1 < p3Array.length && this.g3d.setC(nArray[n5] < 0 ? (short)4 : this.vwr.cm.setElementArgb(nArray[n5], Integer.MAX_VALUE))) {
                this.g3d.fillSphereBits((int)this.tm.scaleToScreen((int)t3.z, (int)(polyhedron.pointScale * 1000.0f)), (P3)t3);
                this.g3d.setC(s);
            }
            if (!this.showNumbers || !this.g3d.setC((short)4)) continue;
            this.g3d.drawStringNoSlab("" + n5, null, (int)t3.x, (int)t3.y, (int)t3.z - 30, (short)0);
            this.g3d.setC(s);
        }
        n5 = this.bsSelected != null && this.bsSelected.get(n) ? 1 : 0;
        this.isAll = this.drawEdges == 1 || n5 != 0;
        this.frontOnly = this.drawEdges == 2;
        object = polyhedron.getNormixes();
        if (!bl || this.g3d.setC(s)) {
            int n6 = ((V3)object2).length;
            while (--n6 >= 0) {
                v3 = object2[n6];
                try {
                    if (this.showNumbers && !this.g3d.setC((short)(Math.round(Math.random() * 10.0) + 5L))) continue;
                    this.g3d.fillTriangleTwoSided((short)object[n6], (P3)t3Array[v3[0]], (P3)t3Array[v3[1]], (P3)t3Array[v3[2]]);
                }
                catch (Exception exception) {
                    System.out.println("PolyhedraRendererError");
                }
            }
        }
        if (n5 != 0) {
            s = 23;
        } else if (polyhedron.colixEdge != 0) {
            s = polyhedron.colixEdge;
        }
        if (this.g3d.setC(C.getColixTranslucent3((short)s, (boolean)false, (float)0.0f))) {
            int n7 = ((V3)object2).length;
            while (--n7 >= 0) {
                v3 = object2[n7];
                this.drawEdges((short)object[n7], (P3)t3Array[v3[0]], (P3)t3Array[v3[1]], (P3)t3Array[v3[2]], (int)(-v3[3]));
            }
        }
        return bl;
    }

    private void drawEdges(short s, P3 p3, P3 p32, P3 p33, int n) {
        if (this.isAll || this.frontOnly && this.vwr.gdata.isDirectedTowardsCamera(s)) {
            int n2;
            int n3 = n2 = this.g3d.isAntialiased() ? 6 : 3;
            if ((n & 1) == 1) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p32);
            }
            if ((n & 2) == 2) {
                this.g3d.fillCylinderBits((byte)3, n2, p32, p33);
            }
            if ((n & 4) == 4) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p33);
            }
        }
    }
}

