/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javajs.api.JSONEncodable;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinModelSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.JmolBioModel;
import org.jmol.modelset.JmolBioModelSet;
import org.jmol.modelset.Model;
import org.jmol.modelset.Orientation;
import org.jmol.modelset.StateScript;
import org.jmol.modelsetbio.BioModel;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Rectangle;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.util.Triangulator;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ModelSet
extends BondCollection {
    protected BS bsSymmetry;
    public String modelSetName;
    public Model[] am;
    public int mc;
    public SymmetryInterface[] unitCells;
    public boolean haveUnitCells;
    protected final Atom[] closest;
    protected int[] modelNumbers;
    public int[] modelFileNumbers;
    public String[] modelNumbersForAtomLabel;
    public String[] modelNames;
    public String[] frameTitles;
    protected BS[] elementsPresent;
    protected boolean isXYZ;
    public Properties modelSetProperties;
    public Map<String, Object> msInfo;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    private boolean isBbcageDefault;
    public BS bboxModels;
    private BS bboxAtoms;
    private final BoxInfo boxInfo;
    public Lst<StateScript> stateScripts;
    private int thisStateModel;
    protected Lst<V3[]> vibrationSteps;
    private BS selectedMolecules;
    boolean showRebondTimes = true;
    protected BS bsAll;
    public ShapeManager sm;
    private static float hbondMin = 2.5f;
    public boolean proteinStructureTainted;
    public SymmetryInterface symTemp;
    public Hashtable<String, BS> htPeaks;
    private Quat[] vOrientations;
    private Triangulator triangulator;
    private final P3 ptTemp;
    private final P3 ptTemp1;
    private final P3 ptTemp2;
    private final M3 matTemp;
    private final M3 matInv;
    private final M4 mat4;
    private final M4 mat4t;
    private final V3 vTemp;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    public P3[] translations;
    private SymmetryInterface pointGroup;
    private BoxInfo defaultBBox;
    private boolean maxBondWarned;

    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    public ModelSet(Viewer viewer, String string) {
        this.vwr = viewer;
        this.modelSetName = string;
        this.selectedMolecules = new BS();
        this.stateScripts = new Lst();
        this.boxInfo = new BoxInfo();
        this.boxInfo.addBoundBoxPoint(P3.new3(-10.0f, -10.0f, -10.0f));
        this.boxInfo.addBoundBoxPoint(P3.new3(10.0f, 10.0f, 10.0f));
        this.am = new Model[1];
        this.modelNumbers = new int[1];
        this.modelFileNumbers = new int[1];
        this.modelNumbersForAtomLabel = new String[1];
        this.modelNames = new String[1];
        this.frameTitles = new String[1];
        this.closest = new Atom[1];
        this.ptTemp = new P3();
        this.ptTemp1 = new P3();
        this.ptTemp2 = new P3();
        this.matTemp = new M3();
        this.matInv = new M3();
        this.mat4 = new M4();
        this.mat4t = new M4();
        this.vTemp = new V3();
        this.setupBC();
    }

    @Override
    protected void releaseModelSet() {
        this.am = null;
        this.closest[0] = null;
        this.am = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        this.releaseModelSetBC();
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.mc; ++i) {
                if (this.modelNumbers[i] != n && (n >= 1000000 || this.modelNumbers[i] != 1000000 + n)) continue;
                return i;
            }
            return -1;
        }
        if (n < 1000000) {
            return n;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getModelDataBaseName(BS bS) {
        for (int i = 0; i < this.mc; ++i) {
            if (!bS.equals(this.am[i].bsAtoms)) continue;
            return (String)this.getInfo(i, "dbName");
        }
        return null;
    }

    public void setTrajectory(int n) {
        if (n >= 0 && this.isTrajectory(n) && this.at[this.am[n].firstAtomIndex].mi != n) {
            this.trajectory.setModel(n);
        }
    }

    public BS getBitSetTrajectories() {
        return this.trajectory == null ? null : this.trajectory.getModelsSelected();
    }

    public void setTrajectoryBs(BS bS) {
        if (this.trajectory != null) {
            for (int i = 0; i < this.mc; ++i) {
                if (!bS.get(i)) continue;
                this.setTrajectory(i);
            }
        }
    }

    public void morphTrajectories(int n, int n2, float f) {
        if (n >= 0 && n2 >= 0 && this.isTrajectory(n) && this.isTrajectory(n2)) {
            this.trajectory.morph(n, n2, f);
        }
    }

    public P3 getTranslation(int n) {
        return this.translations == null || n >= this.translations.length ? null : this.translations[n];
    }

    public void translateModel(int n, T3 t3) {
        if (t3 == null) {
            P3 p3 = this.getTranslation(n);
            if (p3 == null) {
                return;
            }
            t3 = P3.newP(p3);
            t3.scale(-1.0f);
            this.translateModel(n, t3);
            this.translations[n] = null;
            return;
        }
        if (this.translations == null || this.translations.length <= n) {
            this.translations = new P3[this.mc];
        }
        if (this.translations[n] == null) {
            this.translations[n] = new P3();
        }
        this.translations[n].add(t3);
        BS bS = this.am[n].bsAtoms;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            this.at[n2].add(t3);
            n2 = bS.nextSetBit(n2 + 1);
        }
    }

    public P3[] getFrameOffsets(BS bS, boolean bl) {
        if (bS == null) {
            if (bl) {
                int n = this.mc;
                while (--n >= 0) {
                    Model model = this.am[n];
                    if (model.isJmolDataFrame || model.isTrajectory) continue;
                    this.translateModel(model.modelIndex, null);
                }
            }
            return null;
        }
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return null;
        }
        if (bl) {
            BS bS2 = BSUtil.copy(bS);
            P3 p3 = null;
            P3 p32 = new P3();
            for (int i = 0; i < this.mc; ++i) {
                int n2;
                Model model = this.am[i];
                if (!model.isJmolDataFrame && !model.isTrajectory && model.bsAtoms.get(n2 = bS2.nextSetBit(0))) {
                    if (p3 == null) {
                        p3 = P3.newP(this.at[n2]);
                    } else {
                        p32.sub2(p3, this.at[n2]);
                        this.translateModel(i, p32);
                    }
                }
                bS2.andNot(model.bsAtoms);
            }
            return null;
        }
        P3[] p3Array = new P3[this.mc];
        int n3 = this.mc;
        while (--n3 >= 0) {
            p3Array[n3] = new P3();
        }
        n3 = 0;
        int n4 = 0;
        P3 p3 = p3Array[0];
        boolean bl2 = this.trajectory != null && this.trajectory.steps.size() == this.mc;
        int n5 = bl2 ? this.mc : 1;
        p3Array[0].set(0.0f, 0.0f, 0.0f);
        block3: for (int i = 0; i < n5; ++i) {
            if (bl2) {
                this.setTrajectory(i);
            }
            for (int j = 0; j <= this.ac; ++j) {
                if (j == this.ac || this.at[j].mi != n3) {
                    if (n4 > 0) {
                        p3.scale(-1.0f / (float)n4);
                        if (n3 != 0) {
                            p3.sub(p3Array[0]);
                        }
                        n4 = 0;
                    }
                    if (j == this.ac) continue block3;
                    n3 = this.at[j].mi;
                    p3 = p3Array[n3];
                }
                if (!bS.get(j)) continue;
                p3.add(this.at[j]);
                ++n4;
            }
        }
        return p3Array;
    }

    public BS getAtoms(int n, Object object) {
        switch (n) {
            default: {
                return BSUtil.andNot(this.getAtomBitsMaybeDeleted(n, object), this.vwr.slm.bsDeleted);
            }
            case 1073742358: {
                int n2 = (Integer)object;
                int n3 = this.getModelNumberIndex(n2, true, true);
                return n3 < 0 && n2 > 0 ? new BS() : this.vwr.getModelUndeletedAtomsBitSet(n3);
            }
            case 1275203608: 
        }
        Object[] objectArray = new Object[]{null, null, null};
        this.vwr.shm.getShapePropertyData(21, "getCenters", objectArray);
        return objectArray[1] == null ? new BS() : (BS)objectArray[1];
    }

    public int findNearestAtomIndex(int n, int n2, BS bS, int n3) {
        if (this.ac == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearest2(n, n2, this.closest, bS, n3);
        this.sm.findNearestShapeAtomIndex(n, n2, this.closest, bS);
        int n4 = this.closest[0] == null ? -1 : this.closest[0].i;
        this.closest[0] = null;
        return n4;
    }

    public String calculatePointGroup(BS bS) {
        return (String)this.calculatePointGroupForFirstModel(bS, false, false, false, null, 0, 0.0f);
    }

    public Map<String, Object> getPointGroupInfo(BS bS) {
        return (Map)this.calculatePointGroupForFirstModel(bS, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BS bS, boolean bl, String string, int n, float f) {
        return (String)this.calculatePointGroupForFirstModel(bS, true, bl, false, string, n, f);
    }

    private Object calculatePointGroupForFirstModel(BS bS, boolean bl, boolean bl2, boolean bl3, String string, int n, float f) {
        Object object;
        boolean bl4;
        Object object2;
        boolean bl5;
        int n2;
        int n3 = this.vwr.am.cmi;
        int n4 = n2 = bS == null ? -1 : bS.nextSetBit(0);
        if (n3 < 0 && n2 >= 0) {
            n3 = this.at[n2].mi;
        }
        if (n3 < 0) {
            n3 = this.vwr.getVisibleFramesBitSet().nextSetBit(0);
            bS = null;
        }
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
        boolean bl6 = bl5 = bS != null && bS2.cardinality() != bS.cardinality();
        if (bS != null) {
            bS2.and(bS);
        }
        if ((n2 = bS2.nextSetBit(0)) < 0) {
            bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
            n2 = bS2.nextSetBit(0);
        }
        boolean bl7 = (object2 = this.vwr.shm.getShapePropertyIndex(18, "mad", n2)) != null && (Integer)object2 != 0 || this.vwr.tm.vibrationOn;
        SymmetryInterface symmetryInterface = Interface.getSymmetry(this.vwr, "ms");
        T3[] t3Array = this.at;
        SymmetryInterface symmetryInterface2 = this.pointGroup;
        boolean bl8 = bl4 = string != null && string.toUpperCase().indexOf(":POLY") >= 0;
        if (bl4) {
            object = new Object[]{n2, null};
            this.vwr.shm.getShapePropertyData(21, "points", (Object[])object);
            t3Array = (T3[])object[1];
            if (t3Array == null) {
                return null;
            }
            bS2 = null;
            bl7 = false;
            symmetryInterface2 = null;
        }
        if (string != null && string.indexOf(":") >= 0) {
            string = string.substring(0, string.indexOf(":"));
        }
        symmetryInterface2 = symmetryInterface.setPointGroup(symmetryInterface2, null, t3Array, bS2, bl7, this.vwr.getFloat(0x22000026), this.vwr.getFloat(0x22000028), bl5);
        if (!bl4) {
            this.pointGroup = symmetryInterface2;
        }
        if (!bl && !bl3) {
            return symmetryInterface2.getPointGroupName();
        }
        object = symmetryInterface2.getPointGroupInfo(n3, bl2, bl3, string, n, f);
        return bl3 ? object : (this.mc > 1 ? "frame " + this.getModelNumberDotted(n3) + "; " : "") + object;
    }

    public String getDefaultStructure(BS bS, BS bS2) {
        return this.haveBioModels ? this.bioModelset.getAllDefaultStructures(bS, bS2) : "";
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        if (n2 == 1073741852 && n != 2048) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bS : null, bl ? null : bS, bl ? null : bS2, " auto", false, true);
        }
        this.moleculeCount = 0;
        return this.makeConnections2(f, f2, n, n2, bS, bS2, bS3, bl, bl2, f3);
    }

    public void setPdbConectBonding(int n, int n2, BS bS) {
        short s = this.vwr.getMadBond();
        for (int i = n2; i < this.mc; ++i) {
            int n3;
            Lst lst = (Lst)this.getInfo(i, "PDB_CONECT_bonds");
            if (lst == null) continue;
            int n4 = lst.size();
            this.setInfo(i, "initialBondCount", n4);
            int[] nArray = (int[])this.getInfo(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])lst.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                Atom atom = this.at[n11];
                Atom atom2 = this.at[n12];
                if (bS != null) {
                    if (atom.isHetero()) {
                        bS.set(n11);
                    }
                    if (atom2.isHetero()) {
                        bS.set(n12);
                    }
                }
                if (atom.altloc != atom2.altloc && atom.altloc != '\u0000' && atom2.altloc != '\u0000') continue;
                this.getOrAddBond(atom, atom2, s2, s2 == 2048 ? (short)1 : s, null, 0.0f, false);
            }
        }
    }

    public void deleteAllBonds() {
        this.moleculeCount = 0;
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.remove(n);
        }
        this.deleteAllBonds2();
    }

    private void includeAllRelatedFrames(BS bS) {
        int n = 0;
        for (int i = 0; i < this.mc; ++i) {
            boolean bl;
            boolean bl2 = this.isTrajectory(i);
            boolean bl3 = bl = bl2 && bS.get(n = this.am[i].trajectoryBaseIndex);
            if (bS.get(i)) {
                if (!bl2 || bl) continue;
                bS.set(n);
                this.includeAllRelatedFrames(bS);
                return;
            }
            if (!bl2 && (!this.isJmolDataFrameForModel(i) || !bS.get(this.am[i].dataSourceFrame))) continue;
            bS.set(i);
        }
    }

    public BS deleteModels(BS bS) {
        int n;
        int n2;
        this.includeAllRelatedFrames(bS);
        int n3 = bS.cardinality();
        if (n3 == 0) {
            return null;
        }
        this.moleculeCount = 0;
        if (this.msInfo != null) {
            this.msInfo.remove("models");
        }
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            this.clearDataFrameReference(n4);
            n4 = bS.nextSetBit(n4 + 1);
        }
        if (n3 == this.mc) {
            BS bS2 = this.getModelAtomBitSetIncludingDeleted(-1, true);
            this.vwr.zap(true, false, false);
            return bS2;
        }
        this.validateBspf(false);
        Model[] modelArray = new Model[this.mc - n3];
        Model[] modelArray2 = this.am;
        BS bS3 = new BS();
        int n5 = 0;
        for (n2 = 0; n2 < this.mc; ++n2) {
            if (bS.get(n2)) {
                this.getAtomCountInModel(n2);
                bS3.or(this.getModelAtomBitSetIncludingDeleted(n2, false));
                continue;
            }
            this.am[n2].modelIndex = n5;
            modelArray[n5++] = this.am[n2];
        }
        this.am = modelArray;
        n2 = this.mc;
        BS bS4 = this.getBondsForSelectedAtoms(bS3, true);
        this.deleteBonds(bS4, true);
        int n6 = 0;
        for (n = 0; n < n2; ++n) {
            if (!bS.get(n)) {
                ++n6;
                continue;
            }
            int n7 = modelArray2[n].act;
            if (n7 == 0) continue;
            BS bS5 = modelArray2[n].bsAtoms;
            int n8 = modelArray2[n].firstAtomIndex;
            BSUtil.deleteBits(this.bsSymmetry, bS5);
            this.deleteModel(n6, n8, n7, bS5, bS4);
            int n9 = n2;
            while (--n9 > n) {
                modelArray2[n9].fixIndices(n6, n7, bS5);
            }
            this.vwr.shm.deleteShapeAtoms(new Object[]{modelArray, this.at, new int[]{n6, n8, n7}}, bS5);
            --this.mc;
        }
        this.haveBioModels = false;
        n = this.mc;
        while (--n >= 0) {
            if (!this.am[n].isBioModel) continue;
            this.haveBioModels = true;
            this.bioModelset = (JmolBioModelSet)((Object)this.am[n]);
        }
        this.validateBspf(false);
        this.bsAll = null;
        this.resetMolecules();
        this.isBbcageDefault = false;
        this.calcBoundBoxDimensions(null, 1.0f);
        return bS3;
    }

    private void deleteModel(int n, int n2, int n3, BS bS, BS bS2) {
        int n4;
        if (n < 0) {
            return;
        }
        this.modelNumbers = (int[])AU.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])AU.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])AU.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])AU.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])AU.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getInfoM("group3Lists");
        int[][] nArray = (int[][])this.getInfoM("group3Counts");
        int n5 = n + 1;
        if (stringArray != null && stringArray[n5] != null) {
            n4 = stringArray[n5].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n5][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n6 = n4;
                nArray2[n6] = nArray2[n6] - nArray[n5][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.msInfo.put("group3Lists", AU.deleteElements(stringArray, n, 1));
            this.msInfo.put("group3Counts", AU.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            this.unitCells = (SymmetryInterface[])AU.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (((StateScript)this.stateScripts.get(n4)).deleteAtoms(n, bS2, bS)) continue;
            this.stateScripts.remove(n4);
        }
        this.deleteModelAtoms(n2, n3, bS);
        this.vwr.deleteModelAtoms(n, n2, n3, bS);
    }

    public void setAtomProperty(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        switch (n) {
            case 1112152066: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                int n3;
                Object object;
                if (f > 4.0f) {
                    f = 4.0f;
                }
                if (fArray != null) {
                    object = new float[this.ac];
                    try {
                        n3 = bS.nextSetBit(0);
                        int n4 = 0;
                        while (n3 >= 0) {
                            object[n3] = fArray[n4++];
                            n3 = bS.nextSetBit(n3 + 1);
                        }
                    }
                    catch (Exception exception) {
                        return;
                    }
                    fArray = object;
                }
            }
            case 1112152070: 
            case 1112152076: {
                Object object = null;
                int n3 = 0;
                if (fArray == null) {
                    if (f > 16.0f) {
                        f = 16.1f;
                    }
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    n3 = (int)Math.floor(f * 2000.0f);
                } else {
                    object = new RadiusData(fArray, 0.0f, null, null);
                }
                this.sm.setShapeSizeBs(JC.shapeTokenIndex(n), n3, (RadiusData)object, bS);
                return;
            }
        }
        this.setAPm(bS, n, n2, f, string, fArray, stringArray);
    }

    public Object getFileData(int n) {
        if (n < 0) {
            return "";
        }
        Map<String, Object> map = (Map<String, Object>)this.getInfo(n, "fileData");
        if (map != null) {
            return map;
        }
        if (!this.getInfoB(n, "isCIF")) {
            return this.getPDBHeader(n);
        }
        map = this.vwr.getCifData(n);
        this.setInfo(n, "fileData", map);
        return map;
    }

    public BS addHydrogens(Lst<Atom> lst, P3[] p3Array) {
        int n = this.mc - 1;
        BS bS = new BS();
        if (this.isTrajectory(n) || this.am[n].getGroupCount() > 1) {
            return bS;
        }
        this.growAtomArrays(this.ac + p3Array.length);
        RadiusData radiusData = this.vwr.rd;
        short s = this.getDefaultMadFromOrder(1);
        this.am[n].dssrCache = null;
        int n2 = 0;
        int n3 = this.am[n].act + 1;
        while (n2 < lst.size()) {
            Atom atom = (Atom)lst.get(n2);
            Atom atom2 = this.addAtom(n, atom.group, 1, "H" + n3, null, n3, atom.getSeqID(), n3, p3Array[n2], Float.NaN, null, 0, 0.0f, 100.0f, Float.NaN, null, false, (byte)0, null);
            atom2.setMadAtom(this.vwr, radiusData);
            bS.set(atom2.i);
            this.bondAtoms(atom, atom2, 1, s, null, 0.0f, false, false);
            ++n2;
            ++n3;
        }
        this.sm.loadDefaultShapes(this);
        return bS;
    }

    protected void mergeModelArrays(ModelSet modelSet) {
        this.at = modelSet.at;
        this.bo = modelSet.bo;
        this.stateScripts = modelSet.stateScripts;
        this.proteinStructureTainted = modelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = modelSet.bsSymmetry;
        this.modelFileNumbers = modelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = modelSet.modelNumbersForAtomLabel;
        this.modelNames = modelSet.modelNames;
        this.modelNumbers = modelSet.modelNumbers;
        this.frameTitles = modelSet.frameTitles;
        if (this.msInfo != null) {
            this.msInfo.remove("models");
        }
        this.mergeAtomArrays(modelSet);
    }

    public SymmetryInterface getUnitCell(int n) {
        if (n < 0 || n >= this.mc) {
            return null;
        }
        if (this.am[n].simpleCage != null) {
            return this.am[n].simpleCage;
        }
        if (this.unitCells != null && n < this.unitCells.length && this.unitCells[n].haveUnitCell()) {
            return this.unitCells[n];
        }
        if (this.getInfo(n, "unitCellParams") != null) {
            if (this.unitCells == null) {
                this.unitCells = new SymmetryInterface[this.mc];
            }
            this.getSymTemp(true).setSymmetryInfo(n, this.am[n].auxiliaryInfo, null);
            SymmetryInterface symmetryInterface = this.symTemp;
            this.symTemp = null;
            this.haveUnitCells = true;
            this.unitCells[n] = symmetryInterface;
            return this.unitCells[n];
        }
        return null;
    }

    public void setModelCage(int n, SymmetryInterface symmetryInterface) {
        if (n >= 0 && n < this.mc) {
            this.am[n].simpleCage = symmetryInterface;
            this.haveUnitCells = true;
        }
    }

    public Lst<Object> getPlaneIntersection(int n, P4 p4, float f, int n2, SymmetryInterface symmetryInterface) {
        P3[] p3Array = null;
        switch (n) {
            case 1747587102: {
                if (symmetryInterface == null) {
                    return null;
                }
                p3Array = symmetryInterface.getCanonicalCopy(f, true);
                break;
            }
            case 1678381065: {
                p3Array = this.getBoxInfo().getCanonicalCopy(f);
            }
        }
        Lst<Object> lst = new Lst<Object>();
        lst.addLast(p3Array);
        return this.intersectPlane(p4, lst, n2);
    }

    public String getModelName(int n) {
        return this.mc < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getInfo(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getInfo(n, "fileName");
    }

    public String getModelFileType(int n) {
        return (String)this.getInfo(n, "fileType");
    }

    public void setFrameTitle(BS bS, Object object) {
        if (object instanceof String) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.frameTitles[n] = (String)object;
                n = bS.nextSetBit(n + 1);
            }
        } else {
            String[] stringArray = (String[])object;
            int n = bS.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (n2 < stringArray.length) {
                    this.frameTitles[n] = stringArray[n2++];
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.mc ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    Group[] getGroups() {
        int n = 0;
        for (int i = 0; i < this.mc; ++i) {
            n += this.am[i].getGroupCount();
        }
        Group[] groupArray = new Group[n];
        int n2 = 0;
        for (int i = 0; i < this.mc; ++i) {
            for (int j = 0; j < this.am[i].chainCount; ++j) {
                for (int k = 0; k < this.am[i].chains[j].groupCount; ++k) {
                    groupArray[n2] = this.am[i].chains[j].groups[k];
                    groupArray[n2].groupIndex = n2;
                    ++n2;
                }
            }
        }
        return groupArray;
    }

    public float[] getUnitCellParams() {
        SymmetryInterface symmetryInterface = this.getUnitCell(0);
        return symmetryInterface == null ? null : symmetryInterface.getUnitCellParams();
    }

    public boolean setCrystallographicDefaults() {
        return !this.haveBioModels && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public P3 getBoundBoxCenter(int n) {
        return this.isJmolDataFrameForModel(n) ? new P3() : (this.getDefaultBoundBox() == null ? this.boxInfo : this.defaultBBox).getBoundBoxCenter();
    }

    public V3 getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBBoxVertices() {
        return this.boxInfo.getBoundBoxVertices();
    }

    public void setBoundBox(T3 t3, T3 t32, boolean bl, float f) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(t3, t32, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.eBS(this.bboxAtoms);
        }
        this.ptTemp.setT(this.boxInfo.getBoundBoxCenter());
        V3 v3 = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.eP(this.ptTemp) + " " + Escape.eP(v3) + "\n#or\n" : "";
        this.ptTemp.sub(v3);
        string = string + "boundbox corners " + Escape.eP(this.ptTemp) + " ";
        this.ptTemp.scaleAdd2(2.0f, v3, this.ptTemp);
        float f = Math.abs(8.0f * v3.x * v3.y * v3.z);
        string = string + Escape.eP(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public BS findAtomsInRectangle(Rectangle rectangle) {
        BS bS = this.vwr.getVisibleFramesBitSet();
        BS bS2 = new BS();
        int n = this.ac;
        while (--n >= 0) {
            Atom atom = this.at[n];
            if (!bS.get(atom.mi)) {
                n = this.am[atom.mi].firstAtomIndex;
                continue;
            }
            if (!atom.checkVisible() || !rectangle.contains(atom.sX, atom.sY)) continue;
            bS2.set(n);
        }
        return bS2;
    }

    public VDW getDefaultVdwType(int n) {
        return !this.am[n].isBioModel ? VDW.AUTO_BABEL : (this.am[n].hydrogenCount == 0 ? VDW.AUTO_JMOL : VDW.AUTO_BABEL);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrameForModel(n)) {
            this.am[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, P3 p3, boolean bl) {
        if (this.isJmolDataFrameForModel(n)) {
            float f = this.am[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        if (bl && this.getDefaultBoundBox() != null) {
            return this.defaultBBox.getMaxDim() / 2.0f * 1.2f;
        }
        float f = 0.0f;
        int n2 = this.ac;
        while (--n2 >= 0) {
            if (this.isJmolDataFrameForAtom(this.at[n2])) {
                n = this.at[n2].mi;
                while (n2 >= 0 && this.at[n2].mi == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.at[n2];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BS bS, float f) {
        if (bS != null && bS.nextSetBit(0) < 0) {
            bS = null;
        }
        if (bS == null && this.isBbcageDefault || this.ac == 0) {
            return;
        }
        if (this.getDefaultBoundBox() == null) {
            this.bboxAtoms = BSUtil.copy(bS);
            this.bboxModels = this.getModelBS(this.bboxAtoms, false);
            if (this.calcAtomsMinMax(bS, this.boxInfo) == this.ac) {
                this.isBbcageDefault = true;
            }
            if (bS == null && this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        } else {
            Point3fi[] point3fiArray = this.defaultBBox.getBoundBoxVertices();
            this.boxInfo.reset();
            for (int i = 0; i < 8; ++i) {
                this.boxInfo.addBoundBoxPoint(point3fiArray[i]);
            }
        }
        this.boxInfo.setBbcage(f);
    }

    private BoxInfo getDefaultBoundBox() {
        T3[] t3Array = (T3[])this.getInfoM("boundbox");
        if (t3Array == null) {
            this.defaultBBox = null;
        } else {
            if (this.defaultBBox == null) {
                this.defaultBBox = new BoxInfo();
            }
            this.defaultBBox.setBoundBoxFromCriticalPoints(t3Array);
        }
        return this.defaultBBox;
    }

    public BoxInfo getBoxInfo(BS bS, float f) {
        if (bS == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bS, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BS bS, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bS == null;
        int n3 = n = bl ? this.ac - 1 : bS.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrameForAtom(this.at[n3])) {
                boxInfo.addBoundBoxPoint(this.at[n3]);
            }
            n3 = bl ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        P3 p3 = new P3();
        for (int i = 0; i < this.mc; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            P3[] p3Array = this.unitCells[i].getUnitCellVerticesNoOffset();
            P3 p32 = this.unitCells[i].getCartesianOffset();
            for (int j = 0; j < 8; ++j) {
                p3.add2(p32, p3Array[j]);
                this.boxInfo.addBoundBoxPoint(p3);
            }
        }
    }

    public float calcRotationRadiusBs(BS bS) {
        P3 p3 = this.getAtomSetCenter(bS);
        float f = 0.0f;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.at[n];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bS.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public P3[][] getCenterAndPoints(Lst<Object[]> lst, boolean bl) {
        BS bS;
        BS bS2;
        int n = bl ? 1 : 0;
        int n2 = lst.size();
        while (--n2 >= 0) {
            Object[] objectArray = (Object[])lst.get(n2);
            bS2 = (BS)objectArray[0];
            if (objectArray[1] instanceof BS) {
                bS = (BS)objectArray[1];
                n += Math.min(bS2.cardinality(), bS.cardinality());
                continue;
            }
            n += Math.min(bS2.cardinality(), ((P3[])objectArray[1]).length);
        }
        P3[][] p3Array = new P3[2][n];
        if (bl) {
            p3Array[0][0] = new P3();
            p3Array[1][0] = new P3();
        }
        int n3 = lst.size();
        while (--n3 >= 0) {
            int n4;
            Object[] objectArray = (Object[])lst.get(n3);
            bS2 = (BS)objectArray[0];
            if (objectArray[1] instanceof BS) {
                bS = (BS)objectArray[1];
                int n5 = bS2.nextSetBit(0);
                n4 = bS.nextSetBit(0);
                while (n5 >= 0 && n4 >= 0) {
                    p3Array[0][--n] = this.at[n5];
                    p3Array[1][n] = this.at[n4];
                    if (bl) {
                        p3Array[0][0].add(this.at[n5]);
                        p3Array[1][0].add(this.at[n4]);
                    }
                    n5 = bS2.nextSetBit(n5 + 1);
                    n4 = bS.nextSetBit(n4 + 1);
                }
                continue;
            }
            P3[] p3Array2 = (P3[])objectArray[1];
            n4 = bS2.nextSetBit(0);
            for (int i = 0; n4 >= 0 && i < p3Array2.length; ++i) {
                p3Array[0][--n] = this.at[n4];
                p3Array[1][n] = p3Array2[i];
                if (bl) {
                    p3Array[0][0].add(this.at[n4]);
                    p3Array[1][0].add(p3Array2[i]);
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
        }
        if (bl) {
            p3Array[0][0].scale(1.0f / (float)(p3Array[0].length - 1));
            p3Array[1][0].scale(1.0f / (float)(p3Array[1].length - 1));
        }
        return p3Array;
    }

    public P3 getAtomSetCenter(BS bS) {
        P3 p3 = new P3();
        int n = 0;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (!this.isJmolDataFrameForAtom(this.at[n2])) {
                ++n;
                p3.add(this.at[n2]);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        if (n > 1) {
            p3.scale(1.0f / (float)n);
        }
        return p3;
    }

    public P3 getAverageAtomPoint() {
        if (this.averageAtomPoint == null) {
            this.averageAtomPoint = this.getAtomSetCenter(this.vwr.getAllAtoms());
        }
        return this.averageAtomPoint;
    }

    protected void setAPm(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        this.setAPa(bS, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 1094715417: 
            case 1631586315: {
                if (!this.vwr.getBoolean(603979944)) break;
                this.assignAromaticBondsBs(true, null);
            }
        }
    }

    public StateScript addStateScript(String string, BS bS, BS bS2, BS bS3, String string2, boolean bl, boolean bl2) {
        int n = this.vwr.am.cmi;
        if (bl) {
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "all #" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bS, bS2, bS3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.addLast(stateScript);
        }
        return stateScript;
    }

    void freezeModels() {
        this.haveBioModels = false;
        int n = this.mc;
        while (--n >= 0) {
            this.haveBioModels |= this.am[n].freeze();
        }
    }

    public Map<STR, float[]> getStructureList() {
        return this.vwr.getStructureList();
    }

    public Object getInfoM(String string) {
        return this.msInfo == null ? null : this.msInfo.get(string);
    }

    public boolean getMSInfoB(String string) {
        Object object = this.getInfoM(string);
        return object instanceof Boolean && (Boolean)object != false;
    }

    public boolean isTrajectory(int n) {
        return this.am[n].isTrajectory;
    }

    public boolean isTrajectorySubFrame(int n) {
        return this.am[n].trajectoryBaseIndex != n;
    }

    public boolean isTrajectoryMeasurement(int[] nArray) {
        return this.trajectory != null && this.trajectory.hasMeasure(nArray);
    }

    public BS getModelBS(BS bS, boolean bl) {
        int n;
        BS bS2 = new BS();
        short s = 0;
        boolean bl2 = bS == null;
        bl &= this.trajectory != null;
        int n2 = n = bl2 ? 0 : bS.nextSetBit(0);
        while (n2 >= 0 && n2 < this.ac) {
            s = this.at[n2].mi;
            bS2.set(s);
            if (bl) {
                this.trajectory.getModelBS(s, bS2);
            }
            n2 = this.am[s].firstAtomIndex + this.am[s].act - 1;
            n2 = bl2 ? n2 + 1 : bS.nextSetBit(n2 + 1);
        }
        return bS2;
    }

    public BS getIterativeModels(boolean bl) {
        BS bS = new BS();
        for (int i = 0; i < this.mc; ++i) {
            if (!bl && this.isJmolDataFrameForModel(i) || this.isTrajectorySubFrame(i)) continue;
            bS.set(i);
        }
        return bS;
    }

    public void fillAtomData(AtomData atomData, int n) {
        Object object;
        if ((n & 4) != 0) {
            this.getMolecules();
            atomData.bsMolecules = new BS[this.molecules.length];
            atomData.atomMolecule = new int[this.ac];
            for (int i = 0; i < this.molecules.length; ++i) {
                atomData.bsMolecules[i] = this.molecules[i].atomList;
                object = atomData.bsMolecules[i];
                int n2 = ((BS)object).nextSetBit(0);
                while (n2 >= 0) {
                    atomData.atomMolecule[n2] = i;
                    n2 = ((BS)object).nextSetBit(n2 + 1);
                }
            }
        }
        if ((n & 8) != 0) {
            object = new int[1];
            atomData.hAtomRadius = (float)this.vwr.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.calculateHydrogens(atomData.bsSelected, (int[])object, false, true, null);
            atomData.hydrogenAtomCount = object[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.am[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.ac == 0 ? 0 : (int)this.at[atomData.firstAtomIndex].mi;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        this.fillADa(atomData, n);
    }

    public String getModelNumberDotted(int n) {
        return this.mc < 1 || n >= this.mc || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        return this.modelNumbers[n == Integer.MAX_VALUE ? this.mc - 1 : n];
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.am[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.am[n].auxiliaryInfo;
    }

    public void setInfo(int n, Object object, Object object2) {
        this.am[n].auxiliaryInfo.put((String)object, object2);
    }

    public Object getInfo(int n, String string) {
        return n < 0 ? null : this.am[n].auxiliaryInfo.get(string);
    }

    protected boolean getInfoB(int n, String string) {
        Map<String, Object> map = this.am[n].auxiliaryInfo;
        return map != null && map.containsKey(string) && (Boolean)map.get(string) != false;
    }

    protected int getInfoI(int n, String string) {
        Map<String, Object> map = this.am[n].auxiliaryInfo;
        if (map != null && map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public int getInsertionCountInModel(int n) {
        return this.am[n].insertionCount;
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)Math.floor(f);
        for (n = (int)Math.floor(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getChainCountInModelWater(int n, boolean bl) {
        if (n < 0) {
            int n2 = 0;
            int n3 = this.mc;
            while (--n3 >= 0) {
                n2 += this.am[n3].getChainCount(bl);
            }
            return n2;
        }
        return this.am[n].getChainCount(bl);
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            int n2 = 0;
            int n3 = this.mc;
            while (--n3 >= 0) {
                n2 += this.am[n3].getGroupCount();
            }
            return n2;
        }
        return this.am[n].getGroupCount();
    }

    public void calcSelectedGroupsCount() {
        BS bS = this.vwr.bsA();
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].calcSelectedGroupsCount(bS);
        }
    }

    public boolean isJmolDataFrameForModel(int n) {
        return n >= 0 && n < this.mc && this.am[n].isJmolDataFrame;
    }

    private boolean isJmolDataFrameForAtom(Atom atom) {
        return this.am[atom.mi].isJmolDataFrame;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.am[string == null ? this.am[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.am[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.am[n2].dataSourceFrame = n;
            this.am[n2].jmolFrameType = string;
            model.dataFrames.put(string, n2);
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, n2);
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.am[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = this.am[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.mc; ++i) {
            Map<String, Integer> map = this.am[i].dataFrames;
            if (map == null) continue;
            Iterator<Integer> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                iterator.remove();
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.mc ? this.am[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.mc ? this.am[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, Orientation orientation) {
        this.am[n].orientation = orientation;
    }

    public Orientation getModelOrientation(int n) {
        return this.am[n].orientation;
    }

    public String getPDBHeader(int n) {
        return this.am[n].isBioModel ? ((JmolBioModel)((Object)this.am[n])).getFullPDBHeader() : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.am[n].isBioModel) {
            return this.getPDBHeader(n);
        }
        String string = (String)this.getInfo(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public int getAltLocCountInModel(int n) {
        return this.am[n].altLocCount;
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        String string = (String)this.getInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        return this.am[n].biosymmetryCount > 0 ? this.am[n].biosymmetryCount : (this.unitCells == null || this.unitCells[n] == null ? 0 : this.unitCells[n].getSpaceGroupOperationCount());
    }

    public int[] getModelCellRange(int n) {
        return this.unitCells == null ? null : this.unitCells[n].getCellRange();
    }

    public int getLastVibrationVector(int n, int n2) {
        if (this.vibrations != null) {
            int n3 = n < 0 || this.isTrajectory(n) || n >= this.mc - 1 ? this.ac : this.am[n + 1].firstAtomIndex;
            int n4 = n <= 0 ? 0 : this.am[n].firstAtomIndex;
            int n5 = n3;
            while (--n5 >= n4) {
                Vibration vibration;
                if (n >= 0 && this.at[n5].mi != n || (n2 != 1275072532 && n2 != 0 || (vibration = (Vibration)((Object)this.getModulation(n5))) == null) && (n2 != 4166 && n2 != 0 || (vibration = this.getVibration(n5, false)) == null) || !vibration.isNonzero()) continue;
                return n5;
            }
        }
        return -1;
    }

    public Lst<Object> getModulationList(BS bS, char c, P3 p3) {
        Lst<Object> lst = new Lst<Object>();
        if (this.vibrations != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (this.vibrations[n] instanceof JmolModulationSet) {
                    lst.addLast(((JmolModulationSet)((Object)this.vibrations[n])).getModulation(c, p3));
                } else {
                    lst.addLast(Float.valueOf(c == 'O' ? Float.NaN : -1.0f));
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        return lst;
    }

    public BS getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BS bS = new BS();
        for (int i = 0; i < this.mc; ++i) {
            bS.or(this.elementsPresent[i]);
        }
        return bS;
    }

    public int getMoleculeIndex(int n, boolean bl) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return bl ? this.molecules[i].indexInModel : i;
        }
        return 0;
    }

    public BS getMoleculeBitSet(BS bS) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BS bS2 = BSUtil.copy(bS);
        BS bS3 = BSUtil.copy(bS);
        int n = 0;
        BS bS4 = new BS();
        while ((n = bS3.length() - 1) >= 0) {
            bS4 = this.getMoleculeBitSetForAtom(n);
            if (bS4 == null) {
                bS3.clear(n);
                bS2.clear(n);
                continue;
            }
            bS3.andNot(bS4);
            bS2.or(bS4);
        }
        return bS2;
    }

    public BS getMoleculeBitSetForAtom(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public V3 getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        V3 v3 = (V3)this.getInfo(n, "dipole");
        if (v3 == null) {
            v3 = (V3)this.getInfo(n, "DIPOLE_VEC");
        }
        return v3;
    }

    public V3 calculateMolecularDipole(int n, BS bS) {
        int n2;
        if (bS != null) {
            n2 = bS.nextSetBit(0);
            if (n2 < 0) {
                return null;
            }
            n = this.at[n2].mi;
        }
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        if (bS == null) {
            bS = this.getModelAtomBitSetIncludingDeleted(-1, false);
        }
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (this.at[n4].mi == n && !this.at[n4].isDeleted()) {
                float f3 = this.partialCharges[n4];
                if (f3 < 0.0f) {
                    ++n3;
                    f2 += f3;
                    v32.scaleAdd2(f3, this.at[n4], v32);
                } else if (f3 > 0.0f) {
                    ++n2;
                    f += f3;
                    v3.scaleAdd2(f3, this.at[n4], v3);
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        if (Math.abs(f + f2) > 0.01f) {
            Logger.info("Dipole calculation requires balanced charges: " + f + " " + f2);
            return null;
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        v3.add(v32);
        v3.scale(4.8f);
        return v3;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (n != i) continue;
            n2 += this.am[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount() {
        BS bS = this.vwr.bsA();
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        BS bS2 = new BS();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BSUtil.copy2(bS, bS2);
            bS2.and(this.molecules[i].atomList);
            if (bS2.length() <= 0) continue;
            this.selectedMolecules.set(i);
        }
    }

    public void setCentroid(BS bS, int[] nArray) {
        BS bS2 = this.getNotInCentroid(bS, nArray);
        if (bS2 != null && bS2.nextSetBit(0) >= 0) {
            this.vwr.deleteAtoms(bS2, false);
        }
    }

    private BS getNotInCentroid(BS bS, int[] nArray) {
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return null;
        }
        SymmetryInterface symmetryInterface = this.getUnitCell(this.at[n].mi);
        return symmetryInterface == null ? null : symmetryInterface.notInCentroid(this, bS, nArray);
    }

    public JmolMolecule[] getMolecules() {
        int n;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        Model model = null;
        BS[] bSArray = new BS[this.mc];
        Lst<BS> lst = null;
        for (n = 0; n < this.mc; ++n) {
            bSArray[n] = this.vwr.getModelUndeletedAtomsBitSet(n);
            model = this.am[n];
            model.moleculeCount = 0;
            lst = model.isBioModel ? ((JmolBioModel)((Object)model)).getBioBranches(lst) : null;
        }
        this.molecules = JmolMolecule.getMolecules(this.at, bSArray, lst, null);
        n = this.moleculeCount = this.molecules.length;
        while (--n >= 0) {
            model = this.am[this.molecules[n].modelIndex];
            model.firstMoleculeIndex = n;
            ++model.moleculeCount;
        }
        return this.molecules;
    }

    protected void initializeBspf() {
        if (this.bspf != null && this.bspf.isValid) {
            return;
        }
        if (this.showRebondTimes) {
            Logger.startTimer("build bspf");
        }
        Bspf bspf = new Bspf(3);
        if (Logger.debugging) {
            Logger.debug("sequential bspt order");
        }
        BS bS = BS.newN(this.mc);
        int n = this.ac;
        while (--n >= 0) {
            Atom atom = this.at[n];
            if (atom.isDeleted() || this.isTrajectorySubFrame(atom.mi)) continue;
            bspf.addTuple(this.am[atom.mi].trajectoryBaseIndex, atom);
            bS.set(atom.mi);
        }
        if (this.showRebondTimes) {
            Logger.checkTimer("build bspf", false);
            bspf.stats();
        }
        n = bS.nextSetBit(0);
        while (n >= 0) {
            bspf.validateModel(n, true);
            n = bS.nextSetBit(n + 1);
        }
        bspf.isValid = true;
        this.bspf = bspf;
    }

    protected void initializeBspt(int n) {
        this.initializeBspf();
        if (this.bspf.isInitializedIndex(n)) {
            return;
        }
        this.bspf.initialize(n, this.at, this.vwr.getModelUndeletedAtomsBitSet(n));
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, T3 t3, float f) {
        if (n < 0) {
            atomIndexIterator.setCenter(t3, f);
            return;
        }
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.am[n].firstAtomIndex, Integer.MAX_VALUE, t3, f, null);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, int n2, float f, RadiusData radiusData) {
        if (n < 0) {
            n = this.at[n2].mi;
        }
        n = this.am[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.am[n].firstAtomIndex, n2, this.at[n2], f, radiusData);
    }

    public AtomIndexIterator getSelectedAtomIterator(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AtomIteratorWithinModel atomIteratorWithinModel;
        this.initializeBspf();
        if (bl4) {
            BS bS2 = this.getModelBS(bS, false);
            int n = bS2.nextSetBit(0);
            while (n >= 0) {
                this.initializeBspt(n);
                n = bS2.nextSetBit(n + 1);
            }
            atomIteratorWithinModel = new AtomIteratorWithinModelSet(bS2);
        } else {
            atomIteratorWithinModel = new AtomIteratorWithinModel();
        }
        atomIteratorWithinModel.initialize(this.bspf, bS, bl, bl2, bl3, this.vwr.isParallel());
        return atomIteratorWithinModel;
    }

    @Override
    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.am[n].getBondCount();
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.ac : this.am[n].act;
    }

    public BS getModelAtomBitSetIncludingDeletedBs(BS bS) {
        BS bS2 = new BS();
        if (bS == null && this.bsAll == null) {
            this.bsAll = BSUtil.setAll(this.ac);
        }
        if (bS == null) {
            bS2.or(this.bsAll);
        } else {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                bS2.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                n = bS.nextSetBit(n + 1);
            }
        }
        return bS2;
    }

    public BS getModelAtomBitSetIncludingDeleted(int n, boolean bl) {
        BS bS;
        BS bS2 = bS = n < 0 ? this.bsAll : this.am[n].bsAtoms;
        if (bS == null) {
            bS = this.bsAll = BSUtil.setAll(this.ac);
        }
        return bl ? BSUtil.copy(bS) : bS;
    }

    protected BS getAtomBitsMaybeDeleted(int n, Object object) {
        switch (n) {
            default: {
                BS bS = new BS();
                return this.getAtomBitsMDa(n, object, bS);
            }
            case 1073741864: 
            case 1073741916: 
            case 1073741925: 
            case 1073742128: 
            case 1073742189: 
            case 1086324744: {
                BS bS = new BS();
                return this.haveBioModels ? this.bioModelset.getAtomBitsStr(n, (String)object, bS) : bS;
            }
            case 1073742331: 
            case 1677721602: {
                return this.getAtomBitsMDb(n, object);
            }
            case 1678381065: {
                BoxInfo boxInfo = this.getBoxInfo((BS)object, 1.0f);
                BS bS = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.at[n2])) {
                        bS.clear(n2);
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                return bS;
            }
            case 1094713349: {
                BS bS = new BS();
                int[] nArray = (int[])object;
                this.ptTemp1.set((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
                boolean bl = false;
                int n3 = this.ac;
                while (--n3 >= 0) {
                    if (!this.isInLatticeCell(n3, this.ptTemp1, this.ptTemp2, bl)) continue;
                    bS.set(n3);
                }
                return bS;
            }
            case 1094713350: {
                BS bS = BSUtil.newBitSet2(0, this.ac);
                int[] nArray = (int[])object;
                int[] nArray2 = new int[]{nArray[0] / 1000 - 1, nArray[1] / 1000 - 1, nArray[2] / 1000 - 1, nArray[0] / 1000, nArray[1] / 1000, nArray[2] / 1000, 0};
                int n4 = this.mc;
                while (--n4 >= 0) {
                    SymmetryInterface symmetryInterface = this.getUnitCell(n4);
                    if (symmetryInterface == null) {
                        BSUtil.andNot(bS, this.am[n4].bsAtoms);
                        continue;
                    }
                    bS.andNot(symmetryInterface.notInCentroid(this, this.am[n4].bsAtoms, nArray2));
                }
                return bS;
            }
            case 0x41400010: {
                return this.getMoleculeBitSet((BS)object);
            }
            case 1073742363: {
                return this.getSelectCodeRange((int[])object);
            }
            case 0x20002C: {
                BS bS = BS.newN(this.ac);
                short s = -1;
                int n5 = 0;
                int n6 = this.ac;
                block15: while (--n6 >= 0) {
                    Atom atom = this.at[n6];
                    BS bS2 = atom.atomSymmetry;
                    if (bS2 == null) continue;
                    if (atom.mi != s) {
                        s = atom.mi;
                        if (this.getModelCellRange(s) == null) continue;
                        n5 = this.getModelSymmetryCount(s);
                    }
                    int n7 = 0;
                    int n8 = n5;
                    while (--n8 >= 0) {
                        if (!bS2.get(n8) || ++n7 <= 1) continue;
                        bS.set(n6);
                        continue block15;
                    }
                }
                return bS;
            }
            case 1088421903: {
                return BSUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = BS.newN(this.ac)) : this.bsSymmetry);
            }
            case 1747587102: 
        }
        BS bS = new BS();
        SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return bS;
        }
        this.ptTemp1.set(1.0f, 1.0f, 1.0f);
        int n9 = this.ac;
        while (--n9 >= 0) {
            if (!this.isInLatticeCell(n9, this.ptTemp1, this.ptTemp2, false)) continue;
            bS.set(n9);
        }
        return bS;
    }

    private BS getSelectCodeRange(int[] nArray) {
        BS bS = new BS();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        boolean bl = this.vwr.getBoolean(603979823);
        if (n3 >= 0 && n3 < 300 && !bl) {
            n3 = this.chainToUpper(n3);
        }
        int n4 = this.mc;
        while (--n4 >= 0) {
            if (!this.am[n4].isBioModel) continue;
            BioModel bioModel = (BioModel)this.am[n4];
            int n5 = bioModel.chainCount;
            while (--n5 >= 0) {
                int n6;
                Chain chain = bioModel.chains[n5];
                if (n3 != -1 && n3 != (n6 = chain.chainID) && (bl || n6 <= 0 || n6 >= 300 || n3 != this.chainToUpper(n6))) continue;
                Group[] groupArray = chain.groups;
                int n7 = chain.groupCount;
                int n8 = 0;
                while (n8 >= 0) {
                    n8 = ModelSet.selectSeqcodeRange(groupArray, n7, n8, n, n2, bS);
                }
            }
        }
        return bS;
    }

    private static int selectSeqcodeRange(Group[] groupArray, int n, int n2, int n3, int n4, BS bS) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = false;
        for (n9 = n2; n9 < n && groupArray[n9].seqcode != n3; ++n9) {
        }
        if (n9 == n) {
            if (n2 > 0) {
                return -1;
            }
            bl = true;
            n8 = Integer.MAX_VALUE;
            n7 = n;
            while (--n7 >= 0) {
                n6 = groupArray[n7].seqcode;
                if (n6 <= n3 || n6 - n3 >= n8) continue;
                n9 = n7;
                n8 = n6 - n3;
            }
            if (n8 == Integer.MAX_VALUE) {
                return -1;
            }
        }
        if (n4 == Integer.MAX_VALUE) {
            n5 = n - 1;
            bl = true;
        } else {
            for (n5 = n9; n5 < n && groupArray[n5].seqcode != n4; ++n5) {
            }
            if (n5 == n) {
                if (n2 > 0) {
                    return -1;
                }
                bl = true;
                n8 = Integer.MAX_VALUE;
                for (n7 = n9; n7 < n; ++n7) {
                    n6 = groupArray[n7].seqcode;
                    if (n6 >= n4 || n4 - n6 >= n8) continue;
                    n5 = n7;
                    n8 = n4 - n6;
                }
                if (n8 == Integer.MAX_VALUE) {
                    return -1;
                }
            }
        }
        for (n7 = n9; n7 <= n5; ++n7) {
            groupArray[n7].setAtomBits(bS);
        }
        return bl ? -1 : n5 + 1;
    }

    private boolean isInLatticeCell(int n, P3 p3, P3 p32, boolean bl) {
        short s = this.at[n].mi;
        SymmetryInterface symmetryInterface = this.getUnitCell(s);
        p32.setT(this.at[n]);
        return symmetryInterface != null && symmetryInterface.checkUnitCell(symmetryInterface, p3, p32, bl);
    }

    public BS getAtomsWithinRadius(float f, BS bS, boolean bl, RadiusData radiusData) {
        BS bS2 = new BS();
        BS bS3 = this.getIterativeModels(false);
        bS = BSUtil.andNot(bS, this.vwr.slm.bsDeleted);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        if (bl) {
            boolean bl2 = !this.vwr.g.legacyJavaFloat;
            P3 p3 = new P3();
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                int n2 = this.mc;
                while (--n2 >= 0) {
                    if (!bS3.get(n2)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(f, this.at[n].getFractionalUnitCoordPt(bl2, true, p3), bS2, -1);
                        continue;
                    }
                    this.setIteratorForAtom(atomIndexIterator, n2, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        } else {
            bS2.or(bS);
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(f, this.at[n], bS2, this.at[n].mi);
                } else {
                    this.setIteratorForAtom(atomIndexIterator, -1, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        atomIndexIterator.release();
        return bS2;
    }

    public BS getAtomsWithin(float f, P3 p3, BS bS, int n) {
        if (bS == null) {
            bS = new BS();
        }
        if (f < 0.0f) {
            f = -f;
            int n2 = this.ac;
            while (--n2 >= 0) {
                Atom atom = this.at[n2];
                if (n >= 0 && this.at[n2].mi != n || bS.get(n2) || !(atom.getFractionalUnitDistance(p3, this.ptTemp1, this.ptTemp2) <= f)) continue;
                bS.set(atom.i);
            }
            return bS;
        }
        BS bS2 = this.getIterativeModels(true);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        int n3 = this.mc;
        while (--n3 >= 0) {
            if (!bS2.get(n3) || this.am[n3].bsAtoms.isEmpty()) continue;
            this.setIteratorForAtom(atomIndexIterator, -1, this.am[n3].firstAtomIndex, -1.0f, null);
            atomIndexIterator.setCenter(p3, f);
            atomIndexIterator.addAtoms(bS);
        }
        atomIndexIterator.release();
        return bS;
    }

    public void deleteBonds(BS bS, boolean bl) {
        if (!bl) {
            BS bS2 = new BS();
            BS bS3 = new BS();
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.bo[n].atom1;
                if (!this.am[atom.mi].isModelKit) {
                    bS2.clearAll();
                    bS3.clearAll();
                    bS2.set(atom.i);
                    bS3.set(this.bo[n].getAtomIndex2());
                    this.addStateScript("connect ", null, bS2, bS3, "delete", false, true);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        this.dBb(bS, bl);
    }

    public int[] makeConnections2(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        boolean bl3;
        boolean bl4;
        if (bS3 == null) {
            bS3 = new BS();
        }
        boolean bl5 = n == 65535;
        boolean bl6 = bl4 = n == 131071;
        if (bl4) {
            n = 1;
        }
        boolean bl7 = Bond.isOrderH(n);
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        switch (n2) {
            case 12291: {
                return this.deleteConnections(f, f2, n, bS, bS2, bl, bl4);
            }
            case 603979873: 
            case 1073741852: {
                if (n != 515) {
                    if (bl) {
                        BS bS4 = bS;
                        bS = new BS();
                        bS2 = new BS();
                        int n3 = bS4.nextSetBit(0);
                        while (n3 >= 0) {
                            bS.set(this.bo[n3].atom1.i);
                            bS2.set(this.bo[n3].atom2.i);
                            n3 = bS4.nextSetBit(n3 + 1);
                        }
                    }
                    return new int[]{bl7 ? this.autoHbond(bS, bS2, false) : this.autoBondBs4(bS, bS2, null, bS3, this.vwr.getMadBond(), n2 == 603979873), 0};
                }
                bl11 = true;
                bl9 = true;
                break;
            }
            case 1086324745: {
                bl9 = true;
                bl8 = true;
                break;
            }
            case 1073742025: {
                bl9 = true;
                break;
            }
            case 0x40000050: {
                bl10 = true;
            }
        }
        boolean bl12 = !bl8 || bl5;
        boolean bl13 = !bl8 && !bl5;
        this.defaultCovalentMad = this.vwr.getMadBond();
        boolean bl14 = f < 0.0f;
        boolean bl15 = f2 < 0.0f;
        boolean bl16 = bl14 || bl15;
        boolean bl17 = bl3 = !bl || f != 0.1f || f2 != 1.0E8f;
        if (bl3) {
            f = this.fixD(f, bl14);
            f2 = this.fixD(f2, bl15);
        }
        short s = this.getDefaultMadFromOrder(n);
        int n4 = 0;
        int n5 = 0;
        Bond bond = null;
        Atom atom = null;
        Atom atom2 = null;
        char c = '\u0000';
        short s2 = (short)(n | 0x20000);
        boolean bl18 = (n & 0x200) != 0;
        try {
            int n6 = bS.nextSetBit(0);
            while (n6 >= 0) {
                block30: {
                    int n7;
                    block29: {
                        block28: {
                            if (!bl) break block28;
                            bond = this.bo[n6];
                            atom = bond.atom1;
                            atom2 = bond.atom2;
                            break block29;
                        }
                        atom = this.at[n6];
                        if (atom.isDeleted()) break block30;
                        c = this.isModulated(n6) ? (char)'\u0000' : atom.altloc;
                    }
                    int n8 = n7 = bl ? 0 : bS2.nextSetBit(0);
                    while (n7 >= 0) {
                        block33: {
                            block32: {
                                block31: {
                                    if (!bl) break block31;
                                    n7 = 0x7FFFFFFE;
                                    break block32;
                                }
                                if (n7 == n6) break block33;
                                atom2 = this.at[n7];
                                if (atom.mi != atom2.mi || atom2.isDeleted() || c != '\u0000' && c != atom2.altloc && atom2.altloc != '\u0000') break block33;
                                bond = atom.getBond(atom2);
                            }
                            if (!(bond != null ? bl10 : bl9)) {
                                if (!(bl3 && !this.isInRange(atom, atom2, f, f2, bl14, bl15, bl16) || bl18 && !this.allowAromaticBond(bond))) {
                                    if (bond == null) {
                                        bS3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BS)bS3, (float)f3, (boolean)bl2, (boolean)true).index);
                                        ++n4;
                                    } else {
                                        if (bl13) {
                                            bond.setOrder(n);
                                            this.bsAromatic.clear(bond.index);
                                        }
                                        if (bl12 || n == bond.order || s2 == bond.order || bl7 && bond.isHydrogen()) {
                                            bS3.set(bond.index);
                                            ++n5;
                                        }
                                    }
                                }
                            }
                        }
                        n7 = bS2.nextSetBit(n7 + 1);
                    }
                }
                n6 = bS.nextSetBit(n6 + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl11) {
            this.assignAromaticBondsBs(true, bS3);
        }
        if (!bl8) {
            this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS3);
        }
        return new int[]{n4, n5};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBondBs4(BS bS, BS bS2, BS bS3, BS bS4, short s, boolean bl) {
        BS bS5;
        int n;
        boolean bl2;
        if (bl) {
            return this.autoBond_Pre_11_9_24(bS, bS2, bS3, bS4, s);
        }
        if (this.ac == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.vwr.getFloat(0x22000004);
        float f2 = this.vwr.getFloat(570425364);
        float f3 = f2 * f2;
        int n2 = 0;
        if (this.showRebondTimes) {
            Logger.startTimer("autobond");
        }
        short s2 = -1;
        boolean bl3 = bl2 = bS == null;
        if (bl2) {
            n = 0;
            bS5 = null;
        } else {
            if (bS.equals(bS2)) {
                bS5 = bS;
            } else {
                bS5 = BSUtil.copy(bS);
                bS5.or(bS2);
            }
            n = bS5.nextSetBit(0);
        }
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, true, false);
        boolean bl4 = false;
        int n3 = n;
        while (true) {
            block13: {
                boolean bl5;
                float f4;
                Atom atom;
                boolean bl6;
                boolean bl7;
                block16: {
                    block12: {
                        block14: {
                            short s3;
                            block15: {
                                if (n3 < 0 || n3 >= this.ac) break block12;
                                bl7 = bl2 || bS.get(n3);
                                bl6 = bl2 || bS2.get(n3);
                                atom = this.at[n3];
                                if (atom.isDeleted()) break block13;
                                s3 = atom.mi;
                                if (s3 == s2) break block14;
                                s2 = s3;
                                if (!this.isJmolDataFrameForModel(s3)) break block15;
                                n3 = this.am[s3].firstAtomIndex + this.am[s3].act - 1;
                                break block13;
                            }
                            bl4 = this.getInfoB(s3, "autoBondUsingOccupation");
                        }
                        if ((f4 = atom.getBondingRadius()) == 0.0f) break block13;
                        bl5 = bS3 != null && bS3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        this.setIteratorForAtom(atomIndexIterator, -1, n3, f5, null);
                        break block16;
                    }
                    if (this.showRebondTimes) {
                        Logger.checkTimer("autoBond", false);
                    }
                    return n2;
                }
                while (atomIndexIterator.hasNext()) {
                    int n4;
                    boolean bl8;
                    Atom atom2 = this.at[atomIndexIterator.next()];
                    if (atom2.isDeleted()) continue;
                    int n5 = atom2.i;
                    boolean bl9 = bl2 || bS.get(n5);
                    boolean bl10 = bl8 = bl2 || bS2.get(n5);
                    if (!bl9 && !bl8 || (!bl7 || !bl8) && (!bl6 || !bl9) || bl5 && bS3.get(n5) || bl4 && this.occupancies != null && this.occupancies[n3] < 50.0f != this.occupancies[n5] < 50.0f || (n4 = this.isBondable(f4, atom2.getBondingRadius(), atomIndexIterator.foundDistance2(), f3, f) ? 1 : 0) <= 0 || !this.autoBondCheck(atom, atom2, n4, s, bS4)) continue;
                    ++n2;
                }
                atomIndexIterator.release();
            }
            n3 = bl2 ? n3 + 1 : bS5.nextSetBit(n3 + 1);
        }
    }

    public boolean isBondable(float f, float f2, float f3, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f || f3 < f4) {
            return false;
        }
        float f6 = f + f2 + f5;
        float f7 = f6 * f6;
        return f3 <= f7;
    }

    private boolean autoBondCheck(Atom atom, Atom atom2, int n, short s, BS bS) {
        if (atom.getCurrentBondCount() > 20 || atom2.getCurrentBondCount() > 20) {
            if (!this.maxBondWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.maxBondWarned = true;
            return false;
        }
        int n2 = atom.getFormalCharge();
        if (n2 != 0) {
            int n3 = atom2.getFormalCharge();
            if (n2 < 0 && n3 < 0 || n2 > 0 && n3 > 0) {
                return false;
            }
        }
        if (atom.altloc != atom2.altloc && atom.altloc != '\u0000' && atom2.altloc != '\u0000' && this.getModulation(atom.i) == null) {
            return false;
        }
        this.getOrAddBond(atom, atom2, n, s, bS, 0.0f, false);
        return true;
    }

    private int autoBond_Pre_11_9_24(BS bS, BS bS2, BS bS3, BS bS4, short s) {
        if (this.ac == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.vwr.getFloat(0x22000004);
        float f2 = this.vwr.getFloat(570425364);
        float f3 = f2 * f2;
        int n = 0;
        this.initializeBspf();
        short s2 = -1;
        int n2 = this.ac;
        while (--n2 >= 0) {
            float f4;
            Atom atom;
            boolean bl;
            boolean bl2 = bS == null || bS.get(n2);
            boolean bl3 = bl = bS2 == null || bS2.get(n2);
            if (!bl2 && !bl || (atom = this.at[n2]).isDeleted()) continue;
            short s3 = atom.mi;
            if (s3 != s2) {
                s2 = s3;
                if (this.isJmolDataFrameForModel(s3)) {
                    while (--n2 >= 0 && this.at[n2].mi == s3) {
                    }
                    ++n2;
                    continue;
                }
            }
            if ((f4 = atom.getBondingRadius()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            this.initializeBspt(s3);
            CubeIterator cubeIterator = this.bspf.getCubeIterator(s3);
            cubeIterator.initialize(atom, f5, true);
            while (cubeIterator.hasMoreElements()) {
                int n3;
                boolean bl4;
                Atom atom2 = (Atom)cubeIterator.nextElement();
                if (atom2 == atom || atom2.isDeleted()) continue;
                int n4 = atom2.i;
                boolean bl5 = bS == null || bS.get(n4);
                boolean bl6 = bl4 = bS2 == null || bS2.get(n4);
                if (!bl5 && !bl4 || bS3 != null && bS3.get(n4) && bS3.get(n2) || (!bl2 || !bl4) && (!bl || !bl5) || (n3 = this.isBondable(f4, atom2.getBondingRadius(), cubeIterator.foundDistance2(), f3, f) ? 1 : 0) <= 0 || !this.autoBondCheck(atom, atom2, n3, s, bS4)) continue;
                ++n;
            }
            cubeIterator.release();
        }
        return n;
    }

    public int autoHbond(BS bS, BS bS2, boolean bl) {
        int n;
        if (bl) {
            BS bS3 = this.getModelBS(bS, false);
            n = bS3.nextSetBit(0);
            while (n >= 0 && bl) {
                bl = !this.am[n].hasRasmolHBonds;
                n = bS3.nextSetBit(n + 1);
            }
            if (bl) {
                return 0;
            }
        }
        boolean bl2 = false;
        n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.at[n].getElementNumber() == 1) {
                bl2 = true;
                break;
            }
            n = bS.nextSetBit(n + 1);
        }
        BS bS4 = new BS();
        boolean bl3 = this.vwr.getBoolean(603979853);
        if (bS2 == null || bl3 && !bl2) {
            Logger.info((bS2 == null ? "DSSP/DSSR " : "RasMol") + " pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bS, bS2, null, false, Integer.MAX_VALUE, false, bS4);
            return -bS4.cardinality();
        }
        Logger.info(bl2 ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BS bS5 = null;
        if (!bl2) {
            bS5 = new BS();
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                byte by = this.at[n2].atomID;
                switch (by) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bS5.set(n2);
                    }
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        float f = this.vwr.getFloat(0x22000011);
        float f2 = (float)((double)this.vwr.getFloat(0x22000010) * Math.PI / 180.0);
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        float f5 = 1.0f;
        float f6 = f > hbondMin ? f4 : f3;
        float f7 = f > hbondMin ? hbondMin : f;
        int n3 = 0;
        float f8 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        if (this.showRebondTimes && Logger.debugging) {
            Logger.startTimer("hbond");
        }
        T3 t3 = null;
        P3 p3 = null;
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(bS2, false, false, false, false);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            block19: {
                boolean bl4;
                float f9;
                float f10;
                float f11;
                int n5;
                Object object;
                boolean bl5;
                Atom atom;
                block21: {
                    block20: {
                        atom = this.at[n4];
                        int n6 = atom.getElementNumber();
                        boolean bl6 = bl5 = n6 == 1;
                        if (!bl5 && (bl2 || n6 != 7 && n6 != 8) || bl5 && !bl2) break block19;
                        if (!bl5) break block20;
                        object = atom.bonds;
                        if (object == null) break block19;
                        n5 = 0;
                        for (int i = 0; i < ((Bond[])object).length && n5 == 0; ++i) {
                            Atom atom2 = object[i].getOtherAtom(atom);
                            int n7 = atom2.getElementNumber();
                            n5 = n7 == 7 || n7 == 8 ? 1 : 0;
                        }
                        if (n5 == 0) break block19;
                        f11 = f7;
                        f10 = f5;
                        f9 = f6;
                        bl4 = false;
                        break block21;
                    }
                    f11 = f;
                    f10 = f4;
                    f9 = f3;
                    bl4 = bS5.get(n4);
                }
                this.setIteratorForAtom(atomIndexIterator, -1, atom.i, f11, null);
                while (atomIndexIterator.hasNext()) {
                    int n8;
                    object = this.at[atomIndexIterator.next()];
                    n5 = ((Atom)object).getElementNumber();
                    if (object == atom || !bl5 && n5 != 7 && n5 != 8 || bl5 && n5 == 1 || (f8 = atomIndexIterator.foundDistance2()) < f10 || f8 > f9 || bl4 && bS5.get(((Atom)object).i) || atom.isBonded((Atom)object)) continue;
                    if (f2 > 0.0f) {
                        v3.sub2(atom, (T3)object);
                        p3 = ModelSet.checkMinAttachedAngle(atom, f2, v3, v32, bl2);
                        if (p3 == null) continue;
                        v3.scale(-1.0f);
                        t3 = ModelSet.checkMinAttachedAngle((Atom)object, f2, v3, v32, bl2);
                        if (t3 == null) continue;
                    }
                    float f12 = 0.0f;
                    if (bl5 && !Float.isNaN(((P3)t3).x) && !Float.isNaN(p3.x)) {
                        n8 = 4096;
                        f12 = (float)HBond.getEnergy((float)Math.sqrt(f8), t3.distance(atom), t3.distance(p3), ((T3)object).distance(p3)) / 1000.0f;
                    } else {
                        n8 = 2048;
                    }
                    bS4.set(this.addHBond(atom, (Atom)object, n8, f12));
                    ++n3;
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS4);
        if (this.showRebondTimes) {
            Logger.checkTimer("hbond", false);
        }
        return bl2 ? n3 : -n3;
    }

    private static P3 checkMinAttachedAngle(Atom atom, float f, V3 v3, V3 v32, boolean bl) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || bondArray.length == 0) {
            return P3.new3(Float.NaN, 0.0f, 0.0f);
        }
        Atom atom2 = null;
        float f2 = Float.MAX_VALUE;
        int n = bondArray.length;
        while (--n >= 0) {
            if (!bondArray[n].isCovalent()) continue;
            Atom atom3 = bondArray[n].getOtherAtom(atom);
            if (!bl && atom3.getElementNumber() == 1) continue;
            v32.sub2(atom, atom3);
            float f3 = v32.angle(v3);
            if (f3 < f) {
                return null;
            }
            if (!(f3 < f2)) continue;
            atom2 = atom3;
            f2 = f3;
        }
        return atom2;
    }

    public void setStructureIndexes() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.ac; ++i) {
            int n5;
            int n6 = this.at[i].mi;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.at[i].group.getStrucNo()) == n2 || n5 == 0) continue;
            this.at[i].group.setStrucNo(++n);
            n2 = n;
        }
    }

    public String getModelInfoAsString() {
        SB sB = new SB().append("<models count=\"");
        sB.appendI(this.mc).append("\" modelSetHasVibrationVectors=\"").append(this.modelSetHasVibrationVectors() + "\">\n<properties>");
        if (this.modelSetProperties != null) {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                sB.append("\n <property name=\"").append(string).append("\" value=").append(PT.esc(this.modelSetProperties.getProperty(string))).append(" />");
            }
            sB.append("\n</properties>");
        }
        for (int i = 0; i < this.mc; ++i) {
            sB.append("\n<model index=\"").appendI(i).append("\" n=\"").append(this.getModelNumberDotted(i)).append("\" id=").append(PT.esc("" + this.getInfo(i, "modelID")));
            int n = this.vwr.getJDXBaseModelIndex(i);
            if (n != i) {
                sB.append(" baseModelId=").append(PT.esc((String)this.getInfo(n, "jdxModelID")));
            }
            sB.append(" name=").append(PT.esc(this.getModelName(i))).append(" title=").append(PT.esc(this.getModelTitle(i))).append(" hasVibrationVectors=\"").appendB(this.vwr.modelHasVibrationVectors(i)).append("\" />");
        }
        sB.append("\n</models>");
        return sB.toString();
    }

    public String getSymmetryInfoAsString() {
        SB sB = new SB().append("Symmetry Information:");
        for (int i = 0; i < this.mc; ++i) {
            sB.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n");
            SymmetryInterface symmetryInterface = this.getUnitCell(i);
            sB.append(symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoStr());
        }
        return sB.toString();
    }

    public SymmetryInterface getSymTemp(boolean bl) {
        return this.symTemp == null || bl ? (this.symTemp = Interface.getSymmetry(this.vwr, "ms")) : this.symTemp;
    }

    public void createModels(int n) {
        int n2 = this.mc + n;
        Model[] modelArray = (Model[])AU.arrayCopyObject(this.am, n2);
        this.validateBspf(false);
        this.modelNumbers = AU.arrayCopyI(this.modelNumbers, n2);
        this.modelFileNumbers = AU.arrayCopyI(this.modelFileNumbers, n2);
        this.modelNumbersForAtomLabel = AU.arrayCopyS(this.modelNumbersForAtomLabel, n2);
        this.modelNames = AU.arrayCopyS(this.modelNames, n2);
        this.frameTitles = AU.arrayCopyS(this.frameTitles, n2);
        int n3 = this.modelFileNumbers[this.mc - 1] / 1000000 + 1;
        int n4 = 0;
        for (int i = this.mc; i < n2; ++i) {
            this.modelNumbers[i] = i + this.mc;
            this.modelFileNumbers[i] = n3 * 1000000 + ++n4;
            this.modelNumbersForAtomLabel[i] = this.modelNames[i] = n3 + "." + n4;
        }
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getInfoM("group3Lists");
        if (stringArray != null) {
            int[][] nArray = (int[][])this.getInfoM("group3Counts");
            stringArray = AU.arrayCopyS(stringArray, n2);
            nArray = AU.arrayCopyII(nArray, n2);
            this.msInfo.put("group3Lists", stringArray);
            this.msInfo.put("group3Counts", nArray);
        }
        this.unitCells = (SymmetryInterface[])AU.arrayCopyObject(this.unitCells, n2);
        for (n4 = this.mc; n4 < n2; ++n4) {
            modelArray[n4] = new Model().set(this, n4, -1, null, null, null);
            modelArray[n4].loadState = " model create #" + n4 + ";";
        }
        this.am = modelArray;
        this.mc = n2;
    }

    public void assignAtom(int n, String string, boolean bl) {
        JSONEncodable jSONEncodable;
        if (string == null) {
            string = "C";
        }
        Atom atom = this.at[n];
        BS bS = new BS();
        boolean bl2 = atom.getElementNumber() == 1;
        int n2 = Elements.elementNumberFromSymbol(string, true);
        boolean bl3 = false;
        if (n2 > 0) {
            this.setElement(atom, n2);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(n));
            this.setAtomName(n, string + atom.getAtomNumber());
            if (!this.am[atom.mi].isModelKit) {
                this.taintAtom(n, (byte)0);
            }
        } else if (string.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (string.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (string.equals("X")) {
            bl3 = true;
        } else if (!string.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, bl3);
        float f = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (bl2) {
                f = 1.5f;
            } else if (!bl2 && n2 == 1) {
                f = 1.0f;
            }
        }
        if (f != 0.0f) {
            jSONEncodable = V3.newVsub(atom, this.at[atom.getBondedAtomIndex(0)]);
            float f2 = ((T3)jSONEncodable).length();
            ((T3)jSONEncodable).normalize();
            ((T3)jSONEncodable).scale(f - f2);
            this.setAtomCoordRelative(n, ((V3)jSONEncodable).x, ((V3)jSONEncodable).y, ((V3)jSONEncodable).z);
        }
        jSONEncodable = BSUtil.newAndSetBit(n);
        if (n2 != 1 && bl) {
            this.validateBspf(false);
            bS = this.getAtomsWithinRadius(1.0f, (BS)jSONEncodable, false, null);
            bS.andNot((BS)jSONEncodable);
            if (bS.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bS, false);
            }
            bS = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bS.andNot(this.getAtomBitsMDa(1612709900, null, new BS()));
            this.makeConnections2(0.1f, 1.8f, 1, 0x40000050, (BS)jSONEncodable, bS, null, false, false, 0.0f);
        }
        this.vwr.addHydrogens((BS)jSONEncodable, false, true);
    }

    public void deleteAtoms(BS bS) {
        this.averageAtomPoint = null;
        if (bS == null) {
            return;
        }
        BS bS2 = new BS();
        int n = bS.nextSetBit(0);
        while (n >= 0 && n < this.ac) {
            this.at[n].delete(bS2);
            n = bS.nextSetBit(n + 1);
        }
        for (n = 0; n < this.mc; ++n) {
            this.am[n].bsAtomsDeleted.or(bS);
            this.am[n].bsAtomsDeleted.and(this.am[n].bsAtoms);
            this.am[n].dssrCache = null;
        }
        this.deleteBonds(bS2, false);
        this.validateBspf(false);
    }

    public void adjustAtomArrays(int[] nArray, int n, int n2) {
        Object object;
        int n3;
        this.ac = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.at[n3] = this.at[nArray[n3]];
            this.at[n3].i = n3;
            object = this.am[this.at[n3].mi];
            if (object.firstAtomIndex == nArray[n3]) {
                object.firstAtomIndex = n3;
            }
            object.bsAtoms.set(n3);
        }
        if (this.vibrations != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.vibrations[n3] = this.vibrations[nArray[n3]];
            }
        }
        if (this.atomTensorList != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTensorList[n3] = this.atomTensorList[nArray[n3]];
                object = this.atomTensorList[n3];
                if (object == null) continue;
                int n4 = ((Object[])object).length;
                while (--n4 >= 0) {
                    Tensor tensor = (Tensor)object[n4];
                    if (tensor == null) continue;
                    tensor.atomIndex1 = n3;
                }
            }
        }
        if (this.atomNames != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomNames[n3] = this.atomNames[nArray[n3]];
            }
        }
        if (this.atomTypes != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTypes[n3] = this.atomTypes[nArray[n3]];
            }
        }
        if (this.atomResnos != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomResnos[n3] = this.atomResnos[nArray[n3]];
            }
        }
        if (this.atomSerials != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomSerials[n3] = this.atomSerials[nArray[n3]];
            }
        }
        if (this.atomSeqIDs != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomSeqIDs[n3] = this.atomSeqIDs[nArray[n3]];
            }
        }
        if (this.bfactor100s != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.bfactor100s[n3] = this.bfactor100s[nArray[n3]];
            }
        }
        if (this.occupancies != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.occupancies[n3] = this.occupancies[nArray[n3]];
            }
        }
        if (this.partialCharges != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.partialCharges[n3] = this.partialCharges[nArray[n3]];
            }
        }
    }

    protected void growAtomArrays(int n) {
        this.at = (Atom[])AU.arrayCopyObject(this.at, n);
        if (this.vibrations != null) {
            this.vibrations = (Vibration[])AU.arrayCopyObject(this.vibrations, n);
        }
        if (this.occupancies != null) {
            this.occupancies = AU.arrayCopyF(this.occupancies, n);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = AU.arrayCopyShort(this.bfactor100s, n);
        }
        if (this.partialCharges != null) {
            this.partialCharges = AU.arrayCopyF(this.partialCharges, n);
        }
        if (this.atomTensorList != null) {
            this.atomTensorList = (Object[][])AU.arrayCopyObject(this.atomTensorList, n);
        }
        if (this.atomNames != null) {
            this.atomNames = AU.arrayCopyS(this.atomNames, n);
        }
        if (this.atomTypes != null) {
            this.atomTypes = AU.arrayCopyS(this.atomTypes, n);
        }
        if (this.atomResnos != null) {
            this.atomResnos = AU.arrayCopyI(this.atomResnos, n);
        }
        if (this.atomSerials != null) {
            this.atomSerials = AU.arrayCopyI(this.atomSerials, n);
        }
        if (this.atomSeqIDs != null) {
            this.atomSeqIDs = AU.arrayCopyI(this.atomSeqIDs, n);
        }
    }

    public Atom addAtom(int n, Group group, int n2, String string, String string2, int n3, int n4, int n5, P3 p3, float f, V3 v3, int n6, float f2, float f3, float f4, Lst<Object> lst, boolean bl, byte by, BS bS) {
        Atom atom = new Atom().setAtom(n, this.ac, p3, f, bS, n5, (short)n2, n6, bl);
        ++this.am[n].act;
        this.am[n].bsAtoms.set(this.ac);
        if (Elements.isElement(n2, 1)) {
            ++this.am[n].hydrogenCount;
        }
        if (this.ac >= this.at.length) {
            this.growAtomArrays(this.ac + 100);
        }
        this.at[this.ac] = atom;
        this.setBFactor(this.ac, f4);
        this.setOccupancy(this.ac, f3);
        this.setPartialCharge(this.ac, f2);
        if (lst != null) {
            this.setAtomTensors(this.ac, lst);
        }
        atom.group = group;
        atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
        if (string != null) {
            if (string2 != null) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.at.length];
                }
                this.atomTypes[this.ac] = string2;
            }
            atom.atomID = by;
            if (by == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.at.length];
                }
                this.atomNames[this.ac] = string.intern();
            }
        }
        if (n3 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.at.length];
            }
            this.atomSerials[this.ac] = n3;
        }
        if (n4 != 0) {
            if (this.atomSeqIDs == null) {
                this.atomSeqIDs = new int[this.at.length];
            }
            this.atomSeqIDs[this.ac] = n4;
        }
        if (v3 != null) {
            this.setVibrationVector(this.ac, v3);
        }
        ++this.ac;
        return atom;
    }

    public String getInlineData(int n) {
        SB sB = null;
        if (n >= 0) {
            sB = this.am[n].loadScript;
        } else {
            n = this.mc;
            while (--n >= 0 && (sB = this.am[n].loadScript).length() <= 0) {
            }
        }
        int n2 = sB.lastIndexOf("data \"");
        if (n2 < 0) {
            return null;
        }
        n2 = sB.indexOf2("\"", n2 + 7);
        int n3 = sB.lastIndexOf("end \"");
        if (n3 < n2 || n2 < 0) {
            return null;
        }
        return sB.substring2(n2 + 2, n3);
    }

    public boolean isAtomPDB(int n) {
        return n >= 0 && this.am[this.at[n].mi].isBioModel;
    }

    public boolean isAtomAssignable(int n) {
        return n >= 0 && this.at[n].mi == this.mc - 1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.mc; ++i) {
            if (!this.am[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BS getModelKitStateBitset(BS bS, BS bS2) {
        BS bS3 = BSUtil.copy(bS2);
        for (int i = 0; i < this.mc; ++i) {
            if (this.am[i].isModelKit) continue;
            bS3.andNot(this.am[i].bsAtoms);
        }
        return BSUtil.deleteBits(bS, bS3);
    }

    public void setAtomNamesAndNumbers(int n, int n2, AtomCollection atomCollection) {
        if (n2 < 0) {
            n = this.am[this.at[n].mi].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.ac];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.ac];
        }
        boolean bl = this.isXYZ && this.vwr.getBoolean(603979978);
        int s = Integer.MAX_VALUE;
        int n3 = 1;
        for (int i = n; i < this.ac; ++i) {
            short s2;
            Atom atom = this.at[i];
            if (atom.mi != s2) {
                s2 = atom.mi;
                int n4 = n3 = bl ? 0 : 1;
            }
            if (i >= -n2) {
                if (this.atomSerials[i] == 0 || n2 < 0) {
                    int n5 = this.atomSerials[i] = i < n2 ? atomCollection.atomSerials[i] : n3;
                }
                if (this.atomNames[i] == null || n2 < 0) {
                    this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
                }
            }
            if (this.am[s2].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++n3;
        }
    }

    public void setUnitCellOffset(SymmetryInterface symmetryInterface, T3 t3, int n) {
        if (symmetryInterface == null) {
            return;
        }
        if (t3 == null) {
            symmetryInterface.setOffset(n);
        } else {
            symmetryInterface.setOffsetPt(t3);
        }
    }

    public void connect(float[][] fArray) {
        this.resetMolecules();
        BS bS = new BS();
        for (int i = 0; i < fArray.length; ++i) {
            short s;
            int n;
            int n2;
            boolean bl;
            float[] fArray2 = fArray[i];
            if (fArray2 == null || fArray2.length < 2) continue;
            int n3 = (int)fArray2[0];
            boolean bl2 = bl = n3 < 0;
            if (bl) {
                n3 = -1 - n3;
            }
            if ((n2 = (int)fArray2[1]) < 0 || n3 >= this.ac || n2 >= this.ac) continue;
            int n4 = n = fArray2.length > 2 ? (int)fArray2[2] : 1;
            if (n < 0) {
                n &= 0xFFFF;
            }
            short s2 = s = fArray2.length > 3 ? (short)(1000.0f * fArray[i][3]) : this.getDefaultMadFromOrder(n);
            if (n == 0 || s == 0 && n != 32768 && !Bond.isOrderH(n)) {
                Bond bond = this.at[n3].getBond(this.at[n2]);
                if (bond == null) continue;
                bS.set(bond.index);
                continue;
            }
            float f = fArray2.length > 4 ? fArray2[4] : 0.0f;
            this.bondAtoms(this.at[n3], this.at[n2], n, s, null, f, bl, true);
        }
        if (bS.nextSetBit(0) >= 0) {
            this.deleteBonds(bS, false);
        }
    }

    public void setFrameDelayMs(long l, BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.am[this.am[n].trajectoryBaseIndex].frameDelay = l;
            n = bS.nextSetBit(n + 1);
        }
    }

    public long getFrameDelayMs(int n) {
        return n < this.am.length && n >= 0 ? this.am[this.am[n].trajectoryBaseIndex].frameDelay : 0L;
    }

    public int getModelIndexFromId(String string) {
        boolean bl = string.indexOf("#") >= 0;
        boolean bl2 = string.toLowerCase().endsWith(".basemodel");
        if (bl2) {
            string = string.substring(0, string.length() - 10);
        }
        int n = -1;
        String string2 = null;
        for (int i = 0; i < this.mc; ++i) {
            String string3;
            String string4 = (String)this.getInfo(i, "modelID");
            String string5 = string3 = string.startsWith("~") ? "~" + this.getModelNumberDotted(i) : null;
            if (string3 == null && string4 == null && (string4 = this.getModelTitle(i)) == null) continue;
            if (bl) {
                string2 = this.getModelFileName(i);
                if (string2.endsWith("#molfile")) {
                    string4 = string2;
                } else {
                    string2 = string2 + "#";
                    string4 = string2 + string4;
                }
            }
            if (string.equalsIgnoreCase(string4) || string.equalsIgnoreCase(string3)) {
                return bl2 ? this.vwr.getJDXBaseModelIndex(i) : i;
            }
            if (string2 == null || !string.startsWith(string2)) continue;
            n = -2;
        }
        return string2 == null && !bl ? -2 : n;
    }

    public Map<String, Object> getAuxiliaryInfo(BS bS) {
        Map<String, Object> map = this.msInfo;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        if (bS != null || !map.containsKey("models")) {
            Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
            for (int i = 0; i < this.mc; ++i) {
                if (bS != null && !bS.get(i)) continue;
                Map<String, Object> map2 = this.getModelAuxiliaryInfo(i);
                map2.put("modelIndex", i);
                lst.addLast(map2);
            }
            map.put("models", lst);
        }
        return map;
    }

    public int[][] getDihedralMap(int[] nArray) {
        int n;
        Lst<int[]> lst = new Lst<int[]>();
        int n2 = nArray.length;
        Atom atom = null;
        Atom atom2 = null;
        Atom atom3 = null;
        Atom atom4 = null;
        int n3 = n2 - 1;
        while (--n3 >= 0) {
            n = n2;
            while (--n > n3) {
                atom = this.at[nArray[n3]];
                atom2 = this.at[nArray[n]];
                if (!atom.isBonded(atom2)) continue;
                int n4 = n2;
                while (--n4 >= 0) {
                    if (n4 == n3 || n4 == n || !(atom3 = this.at[nArray[n4]]).isBonded(atom)) continue;
                    int n5 = n2;
                    while (--n5 >= 0) {
                        if (n5 == n3 || n5 == n || n5 == n4 || !(atom4 = this.at[nArray[n5]]).isBonded(atom2)) continue;
                        int[] nArray2 = new int[]{atom3.i, atom.i, atom2.i, atom4.i};
                        lst.addLast(nArray2);
                    }
                }
            }
        }
        n2 = lst.size();
        int[][] nArray3 = AU.newInt2(n2);
        n = n2;
        while (--n >= 0) {
            nArray3[n2 - n - 1] = (int[])lst.get(n);
        }
        return nArray3;
    }

    public void setModulation(BS bS, boolean bl, P3 p3, boolean bl2) {
        if (this.bsModulated == null) {
            if (bl) {
                this.bsModulated = new BS();
            } else if (bS == null) {
                return;
            }
        }
        if (bS == null) {
            bS = this.getModelAtomBitSetIncludingDeleted(-1, false);
        }
        float f = this.vwr.getFloat(1275072532);
        boolean bl3 = false;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            JmolModulationSet jmolModulationSet = this.getModulation(n);
            if (jmolModulationSet != null) {
                jmolModulationSet.setModTQ(this.at[n], bl, p3, bl2, f);
                if (this.bsModulated != null) {
                    this.bsModulated.setBitTo(n, bl);
                }
                bl3 = true;
            }
            n = bS.nextSetBit(n + 1);
        }
        if (!bl3) {
            this.bsModulated = null;
        }
    }

    public String getBoundBoxOrientation(int n, BS bS) {
        float f;
        Object object;
        int n2;
        int n3 = bS.nextSetBit(0);
        if (n3 < 0) {
            return "{0 0 0 1}";
        }
        int n4 = n2 = this.vOrientations == null ? 0 : this.vOrientations.length;
        if (n2 == 0) {
            int n5;
            object = new V3[3375];
            n2 = 0;
            P4 p4 = new P4();
            for (n5 = -7; n5 <= 7; ++n5) {
                for (int i = -7; i <= 7; ++i) {
                    int n6 = 0;
                    while (n6 <= 14) {
                        V3 v3;
                        object[n2] = V3.new3((float)n5 / 7.0f, (float)i / 7.0f, (float)n6 / 14.0f);
                        if (v3.length() > 1.0f) {
                            --n2;
                        }
                        ++n6;
                        ++n2;
                    }
                }
            }
            this.vOrientations = new Quat[n2];
            n5 = n2;
            while (--n5 >= 0) {
                float f2 = (float)Math.sqrt(1.0f - object[n5].lengthSquared());
                if (Float.isNaN(f2)) {
                    f2 = 0.0f;
                }
                p4.set4(object[n5].x, object[n5].y, object[n5].z, f2);
                this.vOrientations[n5] = Quat.newP4(p4);
            }
        }
        object = new P3();
        float f3 = Float.MAX_VALUE;
        Quat quat = null;
        BoxInfo boxInfo = null;
        for (int i = 0; i < n2; ++i) {
            float f4;
            Quat quat2 = this.vOrientations[i];
            BoxInfo boxInfo2 = new BoxInfo();
            boxInfo2.setMargin(0.0f);
            int n7 = n3;
            while (n7 >= 0) {
                boxInfo2.addBoundBoxPoint(quat2.transform2(this.at[n7], (T3)object));
                n7 = bS.nextSetBit(n7 + 1);
            }
            switch (n) {
                default: {
                    f4 = (boxInfo2.bbCorner1.x - boxInfo2.bbCorner0.x) * (boxInfo2.bbCorner1.y - boxInfo2.bbCorner0.y) * (boxInfo2.bbCorner1.z - boxInfo2.bbCorner0.z);
                    break;
                }
                case 1111492629: {
                    f4 = boxInfo2.bbCorner1.x - boxInfo2.bbCorner0.x;
                    break;
                }
                case 1111492630: {
                    f4 = boxInfo2.bbCorner1.y - boxInfo2.bbCorner0.y;
                    break;
                }
                case 1111492631: {
                    f4 = boxInfo2.bbCorner1.z - boxInfo2.bbCorner0.z;
                }
            }
            if (!(f4 < f3)) continue;
            quat = quat2;
            boxInfo = boxInfo2;
            f3 = f4;
        }
        if (n != 1312817669 && n != 1073741863) {
            return quat.toString();
        }
        Quat quat3 = Quat.newQ(quat);
        float f5 = boxInfo.bbCorner1.x - boxInfo.bbCorner0.x;
        float f6 = boxInfo.bbCorner1.y - boxInfo.bbCorner0.y;
        float f7 = boxInfo.bbCorner1.z - boxInfo.bbCorner0.z;
        if (f5 < f6) {
            ((T3)object).set(0.0f, 0.0f, 1.0f);
            quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
            f = f5;
            f5 = f6;
            f6 = f;
        }
        if (f6 < f7) {
            if (f7 > f5) {
                ((T3)object).set(0.0f, 1.0f, 0.0f);
                quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
                f = f5;
                f5 = f7;
                f7 = f;
            }
            ((T3)object).set(1.0f, 0.0f, 0.0f);
            quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
            f = f6;
            f6 = f7;
            f7 = f;
        }
        return n == 1312817669 ? f3 + "\t{" + f5 + " " + f6 + " " + f7 + "}" : (quat3.getTheta() == 0.0f ? "{0 0 0 1}" : quat3.toString());
    }

    public Lst<Object> intersectPlane(P4 p4, Lst<Object> lst, int n) {
        return (this.triangulator == null ? (this.triangulator = (Triangulator)Interface.getUtil("TriangleData", this.vwr, "ms")) : this.triangulator).intersectPlane(p4, lst, n);
    }

    public SymmetryInterface getUnitCellForAtom(int n) {
        if (n < 0 || n > this.ac) {
            return null;
        }
        if (this.bsModulated != null) {
            SymmetryInterface symmetryInterface;
            JmolModulationSet jmolModulationSet = this.getModulation(n);
            SymmetryInterface symmetryInterface2 = symmetryInterface = jmolModulationSet == null ? null : jmolModulationSet.getSubSystemUnitCell();
            if (symmetryInterface != null) {
                return symmetryInterface;
            }
        }
        return this.getUnitCell(this.at[n].mi);
    }

    public void clearCache() {
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].dssrCache = null;
        }
    }

    public M4[] getSymMatrices(int n) {
        int n2 = this.getModelSymmetryCount(n);
        if (n2 == 0) {
            return null;
        }
        M4[] m4Array = new M4[n2];
        SymmetryInterface symmetryInterface = this.am[n].biosymmetry;
        if (symmetryInterface == null) {
            symmetryInterface = this.getUnitCell(n);
        }
        int n3 = n2;
        while (--n3 >= 0) {
            m4Array[n3] = symmetryInterface.getSpaceGroupOperation(n3);
        }
        return m4Array;
    }

    public BS[] getBsBranches(float[] fArray) {
        int n = fArray.length / 6;
        BS[] bSArray = new BS[n];
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            float f = fArray[n3 + 5] - fArray[n3 + 4];
            if (!(Math.abs(f) < 1.0f)) {
                int n4 = (int)fArray[n3 + 1];
                int n5 = (int)fArray[n3 + 2];
                String string = "" + n4 + "_" + n5;
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, Boolean.TRUE);
                    BS bS = this.vwr.getBranchBitSet(n5, n4, true);
                    Bond[] bondArray = this.at[n4].bonds;
                    Atom atom = this.at[n4];
                    for (int i = 0; i < bondArray.length; ++i) {
                        int n6;
                        Bond bond = bondArray[i];
                        if (!bond.isCovalent() || (n6 = bond.getOtherAtom((Atom)atom).i) == n5 || !bS.get(n6)) continue;
                        bS = null;
                        break;
                    }
                    bSArray[n2] = bS;
                }
            }
            ++n2;
            n3 += 6;
        }
        return bSArray;
    }

    public void recalculatePositionDependentQuantities(BS bS, M4 m4) {
        if (this.vwr.shm.getShape(21) != null) {
            this.vwr.shm.getShapePropertyData(21, "move", new Object[]{bS, m4});
        }
        if (this.haveStraightness) {
            this.calculateStraightnessAll();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
        BS bS2 = this.getModelBS(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            Model model;
            this.sm.notifyAtomPositionsChanged(n, bS, m4);
            if (m4 != null && (model = this.am[n]).isContainedIn(bS)) {
                if (model.mat4 == null) {
                    model.mat4 = M4.newM4(null);
                }
                model.mat4.mul2(m4, model.mat4);
            }
            n = bS2.nextSetBit(n + 1);
        }
        this.averageAtomPoint = null;
    }

    public void moveAtoms(M4 m4, M3 m3, M3 m32, V3 v3, BS bS, P3 p3, boolean bl, boolean bl2) {
        int n;
        if (m4 != null) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                m4.rotTrans(this.at[n]);
                this.taintAtom(n, (byte)2);
                n = bS.nextSetBit(n + 1);
            }
            this.mat4.setM4(m4);
            v3 = null;
        } else if (!bl2) {
            if (m3 == null) {
                this.matTemp.setM3(m32);
            } else {
                this.ptTemp.set(0.0f, 0.0f, 0.0f);
                this.matInv.setM3(m32);
                this.matInv.invert();
                this.matTemp.mul2(m3, m32);
                this.matTemp.mul2(this.matInv, this.matTemp);
            }
            if (bl) {
                this.vTemp.setT(p3);
                this.mat4.setIdentity();
                this.mat4.setTranslation(this.vTemp);
                this.mat4t.setToM3(this.matTemp);
                this.mat4.mul(this.mat4t);
                this.mat4t.setIdentity();
                this.vTemp.scale(-1.0f);
                this.mat4t.setTranslation(this.vTemp);
                this.mat4.mul(this.mat4t);
            } else {
                this.mat4.setToM3(this.matTemp);
            }
            n = bS.nextSetBit(0);
            while (n >= 0) {
                if (bl) {
                    this.mat4.rotTrans(this.at[n]);
                } else {
                    this.ptTemp.add(this.at[n]);
                    this.mat4.rotTrans(this.at[n]);
                    this.ptTemp.sub(this.at[n]);
                }
                this.taintAtom(n, (byte)2);
                n = bS.nextSetBit(n + 1);
            }
            if (!bl) {
                this.ptTemp.scale(1.0f / (float)bS.cardinality());
                if (v3 == null) {
                    v3 = new V3();
                }
                v3.add(this.ptTemp);
            }
        }
        if (v3 != null) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                this.at[n].add(v3);
                this.taintAtom(n, (byte)2);
                n = bS.nextSetBit(n + 1);
            }
            if (!bl2) {
                this.mat4t.setIdentity();
                this.mat4t.setTranslation(v3);
                this.mat4.mul2(this.mat4t, this.mat4);
            }
        }
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void setDihedrals(float[] fArray, BS[] bSArray, float f) {
        int n = fArray.length / 6;
        if (f > 1.0f) {
            f = 1.0f;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            BS bS = bSArray[n2];
            if (bS != null && !bS.isEmpty()) {
                Atom atom = this.at[(int)fArray[n3 + 1]];
                V3 v3 = V3.newVsub(this.at[(int)fArray[n3 + 2]], atom);
                float f2 = (fArray[n3 + 5] - fArray[n3 + 4]) * f;
                A4 a4 = A4.newVA(v3, (float)((double)(-f2) / 57.29577951308232));
                this.matTemp.setAA(a4);
                this.ptTemp.setT(atom);
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0) {
                    this.at[n4].sub(this.ptTemp);
                    this.matTemp.rotate(this.at[n4]);
                    this.at[n4].add(this.ptTemp);
                    this.taintAtom(n4, (byte)2);
                    n4 = bS.nextSetBit(n4 + 1);
                }
            }
            ++n2;
            n3 += 6;
        }
    }

    public void setAtomCoordsRelative(T3 t3, BS bS) {
        this.setAtomsCoordRelative(bS, t3.x, t3.y, t3.z);
        this.mat4.setIdentity();
        this.vTemp.setT(t3);
        this.mat4.setTranslation(this.vTemp);
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void setAtomCoords(BS bS, int n, Object object) {
        this.setAtomCoord2(bS, n, object);
        switch (n) {
            case 1111492626: 
            case 1111492627: 
            case 1111492628: 
            case 1145047055: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities(bS, null);
            }
        }
    }

    public void invertSelected(P3 p3, P4 p4, int n, BS bS, BS bS2) {
        if (p3 != null) {
            int n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                float f = (p3.x - this.at[n2].x) * 2.0f;
                float f2 = (p3.y - this.at[n2].y) * 2.0f;
                float f3 = (p3.z - this.at[n2].z) * 2.0f;
                this.setAtomCoordRelative(n2, f, f2, f3);
                n2 = bS2.nextSetBit(n2 + 1);
            }
            return;
        }
        if (p4 != null) {
            V3 v3 = V3.new3(p4.x, p4.y, p4.z);
            v3.normalize();
            float f = (float)Math.sqrt(p4.x * p4.x + p4.y * p4.y + p4.z * p4.z);
            int n3 = bS2.nextSetBit(0);
            while (n3 >= 0) {
                float f4 = -Measure.distanceToPlaneD(p4, f, this.at[n3]) * 2.0f;
                float f5 = v3.x * f4;
                float f6 = v3.y * f4;
                float f7 = v3.z * f4;
                this.setAtomCoordRelative(n3, f5, f6, f7);
                n3 = bS2.nextSetBit(n3 + 1);
            }
            return;
        }
        if (n >= 0) {
            Object object;
            Atom atom = this.at[n];
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return;
            }
            BS bS3 = new BS();
            Lst<P3> lst = new Lst<P3>();
            BS bS4 = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            for (int i = 0; i < bondArray.length; ++i) {
                object = bondArray[i].getOtherAtom(atom);
                if (bS.get(((Atom)object).i)) {
                    bS3.or(JmolMolecule.getBranchBitSet(this.at, ((Atom)object).i, bS4, null, n, true, true));
                    continue;
                }
                lst.addLast((P3)object);
            }
            if (lst.size() == 0) {
                return;
            }
            p3 = Measure.getCenterAndPoints(lst)[0];
            V3 v3 = V3.newVsub(atom, p3);
            object = Quat.newVA(v3, 180.0f);
            this.moveAtoms(null, null, ((Quat)object).getMatrix(), null, bS3, atom, true, false);
        }
    }

    public float[] getCellWeights(BS bS) {
        float[] fArray = null;
        int n = bS.nextSetBit(0);
        int n2 = -1;
        if (n >= 0) {
            short s = this.at[n].mi;
            n2 = s;
            if (this.getUnitCell(s) != null) {
                P3 p3 = new P3();
                BS bS2 = this.getModelAtomBitSetIncludingDeleted(n2, true);
                bS2.and(bS);
                fArray = new float[bS.cardinality()];
                int n3 = 0;
                while (n >= 0) {
                    fArray[n3++] = SimpleUnitCell.getCellWeight(this.at[n].getFractionalUnitCoordPt(true, false, p3));
                    n = bS.nextSetBit(n + 1);
                }
            }
        }
        return fArray;
    }

    public Quat[] getAtomGroupQuaternions(BS bS, int n, char c) {
        int n2 = 0;
        Lst<Quat> lst = new Lst<Quat>();
        bS = BSUtil.copy(bS);
        BS bS2 = new BS();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block6: {
                Quat quat;
                block5: {
                    Group group = this.at[n3].group;
                    group.setAtomBits(bS2);
                    bS.andNot(bS2);
                    quat = group.getQuaternion(c);
                    if (quat != null) break block5;
                    if (!this.am[this.at[n3].mi].isBioModel) {
                        quat = group.getQuaternionFrame(this.at);
                    }
                    if (quat == null) break block6;
                }
                ++n2;
                lst.addLast(quat);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return lst.toArray(new Quat[lst.size()]);
    }

    public BS getConformation(int n, int n2, boolean bl, BS bS) {
        BS bS2 = new BS();
        if (n2 >= 0) {
            int n3 = this.mc;
            while (--n3 >= 0) {
                if (n3 != n && n >= 0) continue;
                Model model = this.am[n3];
                BS bS3 = this.vwr.getModelUndeletedAtomsBitSet(n);
                if (bS != null) {
                    bS3.and(bS);
                }
                if (bS3.nextSetBit(0) < 0) continue;
                if (n2 >= model.altLocCount) {
                    if (n2 != 0) continue;
                    bS2.or(bS3);
                    continue;
                }
                if (this.am[n3].isBioModel && ((BioModel)this.am[n3]).getConformation(n2, bl, bS3, bS2)) continue;
                int n4 = this.getAltLocCountInModel(n3);
                String string = this.getAltLocListInModel(n3);
                BS bS4 = new BS();
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bS3.andNot(this.getAtomBitsMDa(1073742355, string.substring(n5, n5 + 1), bS4));
                }
                if (bS3.nextSetBit(0) < 0) continue;
                bS2.or(bS3);
            }
        }
        return bS2;
    }

    public BS getSequenceBits(String string, BS bS, BS bS2) {
        return this.haveBioModels ? this.bioModelset.getAllSequenceBits(string, bS, bS2) : bS2;
    }

    public int getBioPolymerCountInModel(int n) {
        return this.haveBioModels ? this.bioModelset.getBioPolymerCountInModel(n) : 0;
    }

    public void getPolymerPointsAndVectors(BS bS, Lst<P3[]> lst, boolean bl, float f) {
        if (this.haveBioModels) {
            this.bioModelset.getAllPolymerPointsAndVectors(bS, lst, bl, f);
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (this.haveBioModels) {
            this.bioModelset.recalculatePoints(n);
        }
    }

    public void calcRasmolHydrogenBonds(BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3) {
        if (this.haveBioModels) {
            this.bioModelset.calcAllRasmolHydrogenBonds(bS, bS2, lst, bl, n, bl2, bS3);
        }
    }

    public void calculateStraightnessAll() {
        if (this.haveBioModels && !this.haveStraightness) {
            this.bioModelset.calculateStraightnessAll();
        }
    }

    public int calculateStruts(BS bS, BS bS2) {
        return this.haveBioModels ? this.bioModelset.calculateStruts(bS, bS2) : 0;
    }

    public BS getGroupsWithin(int n, BS bS) {
        return this.haveBioModels ? this.bioModelset.getGroupsWithinAll(n, bS) : new BS();
    }

    public String getProteinStructureState(BS bS, int n) {
        return this.haveBioModels ? this.bioModelset.getFullProteinStructureState(bS, n) : "";
    }

    public String calculateStructures(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.haveBioModels ? this.bioModelset.calculateAllStuctures(bS, bl, bl2, bl3, bl4) : "";
    }

    public String calculateStructuresAllExcept(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.freezeModels();
        return this.haveBioModels ? this.bioModelset.calculateAllStructuresExcept(bS, bl, bl2, bl3, bl4, bl5) : "";
    }

    public void recalculatePolymers(BS bS) {
        this.bioModelset.recalculateAllPolymers(bS, this.getGroups());
    }

    protected void calculatePolymers(Group[] groupArray, int n, int n2, BS bS) {
        if (this.bioModelset != null) {
            this.bioModelset.calculateAllPolymers(groupArray, n, n2, bS);
        }
    }

    public void calcSelectedMonomersCount() {
        if (this.haveBioModels) {
            this.bioModelset.calcSelectedMonomersCount();
        }
    }

    public void setProteinType(BS bS, STR sTR) {
        if (this.haveBioModels) {
            this.bioModelset.setAllProteinType(bS, sTR);
        }
    }

    public void setStructureList(Map<STR, float[]> map) {
        if (this.haveBioModels) {
            this.bioModelset.setAllStructureList(map);
        }
    }

    public BS setConformation(BS bS) {
        if (this.haveBioModels) {
            this.bioModelset.setAllConformation(bS);
        }
        return bS;
    }

    public Map<String, String> getHeteroList(int n) {
        Map<String, String> map = this.haveBioModels ? this.bioModelset.getAllHeteroList(n) : null;
        return map == null ? this.getInfoM("hetNames") : map;
    }

    public Object getUnitCellPointsWithin(float f, BS bS, P3 p3, boolean bl) {
        SymmetryInterface symmetryInterface;
        Lst<P3> lst = new Lst<P3>();
        Hashtable hashtable = null;
        Lst<Integer> lst2 = null;
        if (bl) {
            hashtable = new Hashtable();
            lst2 = new Lst<Integer>();
            hashtable.put("atoms", lst2);
            hashtable.put("points", lst);
        }
        int n = bS == null ? -1 : bS.nextSetBit(0);
        bS = this.vwr.getModelUndeletedAtomsBitSet(n < 0 ? this.vwr.am.cmi : (int)this.at[n].mi);
        if (n < 0) {
            n = bS.nextSetBit(0);
        }
        if (n >= 0 && (symmetryInterface = this.getUnitCellForAtom(n)) != null) {
            AtomIndexIterator atomIndexIterator = symmetryInterface.getIterator(this.vwr, this.at[n], this.at, bS, f);
            if (p3 != null) {
                atomIndexIterator.setCenter(p3, f);
            }
            while (atomIndexIterator.hasNext()) {
                n = atomIndexIterator.next();
                p3 = atomIndexIterator.getPosition();
                lst.addLast(p3);
                if (!bl) continue;
                lst2.addLast(n);
            }
        }
        return bl ? hashtable : lst;
    }
}

