/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class KinemageReader
extends PmeshReader {
    private static final int POINTS_ALL = 0;
    private static final int POINTS_MCMC = 1;
    private static final int POINTS_SCSC = 2;
    private static final int POINTS_MCSC = 3;
    private static final int POINTS_HETS = 4;
    private int nDots = 0;
    private float vMin = -3.4028235E38f;
    private float vMax = Float.MAX_VALUE;
    private int pointType;
    private String findString;
    private String lastAtom = "";

    KinemageReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PR(surfaceGenerator, bufferedReader);
        this.type = "kinemage";
        this.setHeader();
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        if (this.params.parameters != null && this.params.parameters.length >= 2) {
            this.vMin = this.params.parameters[1];
            this.vMax = this.params.parameters.length >= 3 ? this.params.parameters[2] : this.vMin;
            this.pointType = this.params.parameters.length >= 4 ? (int)this.params.parameters[3] : 0;
            this.findString = this.params.calculationType;
        }
        return true;
    }

    @Override
    protected boolean readVertices() throws Exception {
        this.rd();
        while (this.line != null) {
            if (this.line.length() != 0 && this.line.charAt(0) == '@') {
                Logger.info((String)this.line);
                if (this.line.indexOf("contact}") >= 0 || this.line.indexOf("overlap}") >= 0 || this.line.indexOf("H-bonds}") >= 0) {
                    int n;
                    if (this.line.indexOf("@dotlist") == 0) {
                        n = this.nDots;
                        this.readDots();
                        if (this.nDots <= n) continue;
                        Logger.info((String)("dots: " + (this.nDots - n) + "/" + this.nDots));
                        continue;
                    }
                    if (this.line.indexOf("@vectorlist") == 0) {
                        n = this.nPolygons;
                        this.readVectors();
                        if (this.nPolygons <= n) continue;
                        Logger.info((String)("lines: " + (this.nPolygons - n) + "/" + this.nPolygons));
                        continue;
                    }
                }
            }
            this.rd();
        }
        return true;
    }

    private void readDots() throws Exception {
        int[] nArray = new int[1];
        while (this.rd() != null && this.line.indexOf(64) < 0) {
            int n = this.getPoint(this.line, 2, nArray, true);
            if (n < 0) continue;
            ++this.nDots;
            this.nTriangles = this.addTriangleCheck(n, n, n, 7, 0, false, nArray[0]);
        }
    }

    private void readVectors() throws Exception {
        int[] nArray = new int[1];
        while (this.rd() != null && this.line.indexOf(64) < 0) {
            int n = this.getPoint(this.line, 3, nArray, true);
            int n2 = this.getPoint(this.line.substring(this.line.lastIndexOf(123)), 2, nArray, false);
            if (n < 0 || n2 < 0) continue;
            ++this.nPolygons;
            this.nTriangles = this.addTriangleCheck(n, n2, n2, 7, 0, false, nArray[0]);
        }
    }

    private int getPoint(String string, int n, int[] nArray, boolean bl) {
        float f;
        Object object;
        if (this.findString != null) {
            object = string.substring(0, string.indexOf("}") + 1);
            if (((String)object).length() < 4) {
                object = this.lastAtom;
            } else {
                this.lastAtom = object;
            }
            if (((String)object).indexOf(this.findString) < 0) {
                return -1;
            }
        }
        if (Float.isNaN(f = this.assignValueFromGapColorForKin((object = PT.getTokens((String)string.substring(string.indexOf("}") + 1)))[0]))) {
            return -1;
        }
        if (bl && this.pointType != 0) {
            switch (((String)object[n - 1]).charAt(1)) {
                case 'M': {
                    if (this.pointType == 1) break;
                    return -1;
                }
                case 'S': {
                    if (this.pointType == 2) break;
                    return -1;
                }
                case 'P': {
                    if (this.pointType == 3) break;
                    return -1;
                }
                case 'O': {
                    if (this.pointType == 4) break;
                    return -1;
                }
                default: {
                    return -1;
                }
            }
        }
        nArray[0] = this.getColor((String)object[0]);
        object = PT.getTokens((String)((String)object[n]).replace(',', ' '));
        P3 p3 = P3.new3((float)PT.parseFloat((String)object[0]), (float)PT.parseFloat((String)object[1]), (float)PT.parseFloat((String)object[2]));
        if (this.isAnisotropic) {
            this.setVertexAnisotropy((T3)p3);
        }
        return this.addVertexCopy((T3)p3, f, this.nVertices++, false);
    }

    private int getColor(String string) {
        if (string.equals("sky")) {
            string = "skyblue";
        } else if (string.equals("sea")) {
            string = "seagreen";
        }
        return CU.getArgbFromString((String)string);
    }

    private float assignValueFromGapColorForKin(String string) {
        float f = string.equals("greentint") ? 4.0f : (string.equals("blue") ? 0.35f : (string.equals("sky") ? 0.25f : (string.equals("sea") ? 0.15f : (string.equals("green") ? 0.0f : (string.equals("yellowtint") ? -0.1f : (string.equals("yellow") ? -0.2f : (string.equals("orange") ? -0.3f : (string.equals("red") ? -0.4f : -0.5f))))))));
        return f >= this.vMin && f <= this.vMax ? f : Float.NaN;
    }

    @Override
    protected boolean readPolygons() {
        return true;
    }
}

