/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String string, boolean bl) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch smilesSearch = SmilesParser.getMolecule("/nostereo/" + string, bl);
        smilesSearch.createTopoMap(null);
        smilesSearch.nodes = smilesSearch.jmolAtoms;
        return smilesSearch.getMolecularFormula(!bl, null, false);
    }

    public String getSmiles(Node[] nodeArray, int n, BS bS, String string, int n2) throws Exception {
        InvalidSmilesException.clear();
        return new SmilesGenerator().getSmiles(nodeArray, n, bS, string, n2);
    }

    public int areEqual(String string, String string2) throws Exception {
        InvalidSmilesException.clear();
        BS[] bSArray = (BS[])this.findPriv(string, SmilesParser.getMolecule(string2, false), (string.indexOf("*") >= 0 ? 2 : 1) | 0x20, 2);
        return bSArray == null ? -1 : bSArray.length;
    }

    public boolean areEqualTest(String string, SmilesSearch smilesSearch) throws Exception {
        BS[] bSArray = (BS[])this.findPriv(string, smilesSearch, 33, 2);
        return bSArray != null && bSArray.length == 1;
    }

    public int[][] find(String string, String string2, boolean bl, boolean bl2) throws Exception {
        InvalidSmilesException.clear();
        string2 = SmilesParser.cleanPattern(string2);
        string = SmilesParser.cleanPattern(string);
        SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
        int[][] nArray = (int[][])this.findPriv(string, smilesSearch, (bl ? 2 : 1) | (bl2 ? 32 : 0), 3);
        int n = nArray.length;
        while (--n >= 0) {
            int[] nArray2 = nArray[n];
            int n2 = nArray2.length;
            while (--n2 >= 0) {
                nArray2[n2] = ((SmilesAtom)smilesSearch.jmolAtoms[nArray2[n2]]).mapIndex;
            }
        }
        return nArray;
    }

    public String getRelationship(String string, String string2) throws Exception {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = PT.countChar((String)PT.rep((String)string, (String)"@@", (String)"@"), (char)'@');
        boolean bl2 = bl = n2 == (n = PT.countChar((String)PT.rep((String)string2, (String)"@@", (String)"@"), (char)'@')) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = string + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0 && string5.indexOf("@SP") < 0) {
                    boolean bl3 = bl = this.areEqual("/invertstereo/" + string2, string) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    public String reverseChirality(String string) {
        string = PT.rep((String)string, (String)"@@", (String)"!@");
        string = PT.rep((String)string, (String)"@", (String)"@@");
        string = PT.rep((String)string, (String)"!@@", (String)"@");
        return string;
    }

    public BS getSubstructureSet(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (BS)this.matchPriv(string, nodeArray, n, bS, null, true, n2, 1);
    }

    public void getMMFF94AtomTypes(String[] stringArray, Node[] nodeArray, int n, BS bS, Lst<BS> lst, Lst<BS>[] lstArray) throws Exception {
        InvalidSmilesException.clear();
        SmilesParser smilesParser = new SmilesParser(true);
        SmilesSearch smilesSearch = null;
        int n2 = 1794;
        smilesSearch = smilesParser.parse("");
        smilesSearch.exitFirstMatch = false;
        smilesSearch.jmolAtoms = nodeArray;
        smilesSearch.jmolAtomCount = Math.abs(n);
        smilesSearch.setSelected(bS);
        smilesSearch.flags = n2;
        smilesSearch.getRingData(lstArray, true, true);
        smilesSearch.asVector = false;
        smilesSearch.subSearches = new SmilesSearch[1];
        smilesSearch.getSelections();
        BS bS2 = new BS();
        for (int i = 0; i < stringArray.length; ++i) {
            SmilesSearch smilesSearch2;
            if (stringArray[i] == null || stringArray[i].length() == 0 || stringArray[i].startsWith("#")) {
                lst.addLast(null);
                continue;
            }
            smilesSearch.clear();
            smilesSearch.subSearches[0] = smilesSearch2 = smilesParser.getSearch(smilesSearch, SmilesParser.cleanPattern(stringArray[i]), n2);
            BS bS3 = BSUtil.copy((BS)((BS)smilesSearch.search()));
            lst.addLast((Object)bS3);
            bS2.or(bS3);
            if (bS2.cardinality() != n) continue;
            return;
        }
    }

    public BS[] getSubstructureSetArray(String string, Node[] nodeArray, int n, BS bS, BS bS2, int n2) throws Exception {
        return (BS[])this.matchPriv(string, nodeArray, n, bS, bS2, true, n2, 2);
    }

    public String polyhedronToSmiles(Node node, int[][] nArray, int n, P3[] p3Array, int n2, String string) throws Exception {
        int n3;
        SmilesAtom[] smilesAtomArray = new SmilesAtom[n];
        for (n3 = 0; n3 < n; ++n3) {
            P3 p3;
            smilesAtomArray[n3] = new SmilesAtom();
            P3 p32 = p3 = p3Array == null ? null : p3Array[n3];
            if (p3 instanceof Node) {
                smilesAtomArray[n3].elementNumber = ((Node)p3).getElementNumber();
                smilesAtomArray[n3].atomName = ((Node)p3).getAtomName();
                smilesAtomArray[n3].atomNumber = ((Node)p3).getAtomNumber();
                smilesAtomArray[n3].setT((T3)p3);
            } else {
                smilesAtomArray[n3].elementNumber = p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2;
            }
            smilesAtomArray[n3].index = n3;
        }
        n3 = 0;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5;
            int[] nArray2 = nArray[n4];
            int n6 = n5 = nArray2.length;
            while (--n6 >= 0) {
                int n7;
                int n8 = nArray2[n6];
                if (n8 >= n || (n7 = nArray2[(n6 + 1) % n5]) >= n || smilesAtomArray[n8].getBondTo(smilesAtomArray[n7]) != null) continue;
                SmilesBond smilesBond = new SmilesBond(smilesAtomArray[n8], smilesAtomArray[n7], 1, false);
                smilesBond.index = n3++;
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n9 = smilesAtomArray[n4].bondCount;
            if (n9 != 0 && n9 == smilesAtomArray[n4].bonds.length) continue;
            smilesAtomArray[n4].bonds = (SmilesBond[])AU.arrayCopyObject((Object)smilesAtomArray[n4].bonds, (int)n9);
        }
        String string2 = null;
        SmilesGenerator smilesGenerator = new SmilesGenerator();
        if (p3Array != null) {
            smilesGenerator.stereoReference = (P3)node;
        }
        InvalidSmilesException.clear();
        string2 = smilesGenerator.getSmiles((Node[])smilesAtomArray, n, BSUtil.newBitSet2((int)0, (int)n), null, n2 | 0x1000 | 0x4000 | 0x8000);
        if ((n2 & 0x10000) == 65536) {
            string2 = "//* " + node + " *//\t[" + Elements.elementSymbolFromNumber((int)node.getElementNumber()) + "@PH" + n + (string == null ? "" : "/" + string + "/") + "]." + string2;
        }
        return string2;
    }

    public int[][] getCorrelationMaps(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (int[][])this.matchPriv(string, nodeArray, n, bS, null, true, n2, 3);
    }

    private Object findPriv(String string, SmilesSearch smilesSearch, int n, int n2) throws Exception {
        BS bS = new BS();
        smilesSearch.setFlags(smilesSearch.flags | SmilesParser.getFlags(string));
        smilesSearch.createTopoMap(bS);
        return this.matchPriv(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bS, bS.isEmpty(), n, n2);
    }

    private Object matchPriv(String string, Node[] nodeArray, int n, BS bS, BS bS2, boolean bl, int n2, int n3) throws Exception {
        InvalidSmilesException.clear();
        try {
            boolean bl2;
            boolean bl3 = (n2 & 2) == 2;
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl3);
            if (smilesSearch.openSMILES && !bl3 && !smilesSearch.patternAromatic) {
                SmilesSearch.normalizeAromaticity(smilesSearch.patternAtoms, bS2, smilesSearch.flags);
            }
            smilesSearch.jmolAtoms = nodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            boolean bl4 = bl2 = !(nodeArray[0] instanceof SmilesAtom);
            if (nodeArray[0] instanceof BNode) {
                smilesSearch.bioAtoms = (BNode[])nodeArray;
            }
            smilesSearch.setSelected(bS);
            smilesSearch.getSelections();
            smilesSearch.bsRequired = null;
            if (!bl) {
                smilesSearch.bsAromatic = bS2;
            }
            smilesSearch.setRingData(null, null, bl2 || bl);
            smilesSearch.exitFirstMatch = (n2 & 0x20) == 32;
            switch (n3) {
                case 1: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search();
                }
                case 2: {
                    smilesSearch.asVector = true;
                    Lst lst = (Lst)smilesSearch.search();
                    return lst.toArray((Object[])new BS[lst.size()]);
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    Lst lst = (Lst)smilesSearch.search();
                    return lst.toArray((Object[])AU.newInt2((int)lst.size()));
                }
            }
        }
        catch (Exception exception) {
            if (Logger.debugging) {
                exception.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.clear();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    public String cleanSmiles(String string) {
        return SmilesParser.cleanPattern(string);
    }
}

