/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class XtalSymmetry {
    private AtomSetCollection asc;
    private AtomSetCollectionReader acr;
    public SymmetryInterface symmetry;
    private float[] unitCellParams = new float[6];
    private float[] baseUnitCell;
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private float packingError;
    private String filterSymop;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private P3 ptSupercell;
    private M4 matSupercell;
    private Lst<float[]> trajectoryUnitCells;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private SymmetryInterface baseSymmetry;
    private SymmetryInterface sym2;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3 unitCellOffset;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstSymmetryAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;
    private int nVib;

    public XtalSymmetry set(AtomSetCollectionReader atomSetCollectionReader) {
        this.acr = atomSetCollectionReader;
        this.asc = atomSetCollectionReader.asc;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = (Symmetry)this.acr.getInterface("org.jmol.symmetry.Symmetry")) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        this.symmetry = symmetryInterface;
        return this.symmetry;
    }

    private void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.asc.setInfo("symmetryRange", Float.valueOf(f));
    }

    private void setLatticeCells() {
        this.latticeCells = this.acr.latticeCells;
        boolean bl = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!bl || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell;
        this.doCentroidUnitCell = this.acr.doCentroidUnitCell;
        this.centroidPacked = this.acr.centroidPacked;
        this.filterSymop = this.acr.filterSymop;
        if (this.acr.strSupercell == null) {
            this.setSupercellFromPoint(this.acr.ptSupercell);
        }
    }

    public void setSupercellFromPoint(P3 p3) {
        this.ptSupercell = p3;
        if (p3 == null) {
            this.matSupercell = null;
            return;
        }
        this.matSupercell = new M4();
        this.matSupercell.m00 = p3.x;
        this.matSupercell.m11 = p3.y;
        this.matSupercell.m22 = p3.z;
        this.matSupercell.m33 = 1.0f;
        Logger.info("Using supercell \n" + this.matSupercell);
    }

    private void setUnitCell(float[] fArray, M3 m3, P3 p3) {
        this.unitCellParams = new float[fArray.length];
        this.unitCellOffset = p3;
        for (int i = 0; i < fArray.length; ++i) {
            this.unitCellParams[i] = fArray[i];
        }
        this.asc.haveUnitCell = true;
        this.asc.setCurrentModelInfo("unitCellParams", this.unitCellParams);
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.unitCellParams);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.unitCellParams, false);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.asc.setCurrentModelInfo("unitCellOffset", p3);
        }
        if (m3 != null) {
            this.symmetry.initializeOrientation(m3);
            this.asc.setCurrentModelInfo("matUnitCellOrientation", m3);
        }
    }

    int addSpaceGroupOperation(String string, boolean bl) {
        if (bl) {
            this.setLatticeCells();
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    SymmetryInterface applySymmetryFromReader(SymmetryInterface symmetryInterface) throws Exception {
        this.asc.setCoordinatesAreFractional(this.acr.iHaveFractionalCoordinates);
        this.setUnitCell(this.acr.unitCellParams, this.acr.matUnitCellOrientation, this.acr.unitCellOffset);
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.setSymmetryRange(this.acr.symmetryRange);
        if (this.acr.doConvertToFractional || this.acr.fileCoordinatesAreFractional) {
            this.setLatticeCells();
            boolean bl = true;
            if (this.acr.ignoreFileSpaceGroupName || !this.acr.iHaveSymmetryOperators) {
                if (!this.acr.merging || symmetryInterface == null) {
                    symmetryInterface = this.acr.getNewSymmetry();
                }
                bl = symmetryInterface.createSpaceGroup(this.acr.desiredSpaceGroupIndex, this.acr.sgName.indexOf("!") >= 0 ? "P1" : this.acr.sgName, this.acr.unitCellParams);
            } else {
                this.acr.doPreSymmetry();
                symmetryInterface = null;
            }
            this.packingError = this.acr.packingError;
            if (bl) {
                if (symmetryInterface != null) {
                    this.symmetry.setSpaceGroupFrom(symmetryInterface);
                }
                this.applySymmetryLattice();
                if (symmetryInterface != null && this.filterSymop == null) {
                    this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                }
            }
        }
        if (this.acr.iHaveFractionalCoordinates && this.acr.merging && symmetryInterface != null) {
            Atom[] atomArray = this.asc.atoms;
            int n = this.asc.ac;
            for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                symmetryInterface.toCartesian(atomArray[i], true);
            }
            this.asc.setCoordinatesAreFractional(false);
            this.acr.addVibrations = false;
        }
        return this.symmetry;
    }

    private void setAtomSetSpaceGroupName(String string) {
        this.asc.setCurrentModelInfo("spaceGroup", string + "");
    }

    private void applySymmetryLattice() throws Exception {
        int n;
        Atom[] atomArray;
        boolean bl;
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        this.sym2 = null;
        int n2 = this.latticeCells[0];
        int n3 = this.latticeCells[1];
        int n4 = Math.abs(this.latticeCells[2]);
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        BS bS = null;
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        P3 p3 = null;
        if (this.acr.fillRange != null) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            bS = this.asc.bsAtoms;
            bS.setBits(this.firstSymmetryAtom, this.asc.ac);
            this.doPackUnitCell = false;
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(1, 1, 1);
            T3[] t3Array = new P3[4];
            for (int i = 0; i < 4; ++i) {
                t3Array[i] = P3.newP(this.acr.fillRange[i]);
            }
            this.adjustRangeMinMax(t3Array);
            if (this.sym2 == null) {
                this.sym2 = new Symmetry();
                this.sym2.getUnitCell(this.acr.fillRange, false, null);
            }
            this.applyAllSymmetry(this.acr.ms, bS);
            p3 = new P3();
            Atom[] atomArray2 = this.asc.atoms;
            int n5 = this.asc.ac;
            while (--n5 >= this.firstSymmetryAtom) {
                p3.setT(atomArray2[n5]);
                this.symmetry.toCartesian(p3, false);
                this.sym2.toFractional(p3, false);
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(p3, 100000.0f);
                }
                if (this.isWithinCell(this.dtype, p3, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.packingError)) continue;
                bS.clear(n5);
            }
            return;
        }
        P3 p32 = null;
        this.nVib = 0;
        P3 p33 = null;
        P3 p34 = null;
        P3 p35 = null;
        this.baseSymmetry = this.symmetry;
        String string = this.acr.strSupercell;
        T3[] t3Array = null;
        boolean bl2 = bl = string != null && string.indexOf(",") >= 0;
        if (bl && (t3Array = this.symmetry.getV0abc(string)) != null) {
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(n2, n3, n4);
            this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
            p3 = P3.newP(t3Array[0]);
            p33 = P3.newP(t3Array[1]);
            p34 = P3.newP(t3Array[2]);
            p35 = P3.newP(t3Array[3]);
            this.adjustRangeMinMax(t3Array);
        }
        int n6 = this.asc.getLastAtomSetAtomIndex();
        if (this.rminx == Float.MAX_VALUE) {
            this.matSupercell = null;
            string = null;
            t3Array = null;
        } else {
            int n7;
            boolean bl3;
            this.doPackUnitCell = bl3 = this.doPackUnitCell;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            bS = this.asc.bsAtoms;
            this.applyAllSymmetry(this.acr.ms, null);
            this.doPackUnitCell = bl3;
            atomArray = this.asc.atoms;
            n = this.asc.ac;
            for (n7 = n6; n7 < n; ++n7) {
                this.symmetry.toCartesian(atomArray[n7], true);
                bS.set(n7);
            }
            this.symmetry = null;
            this.symmetry = this.getSymmetry();
            this.setUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p33.x, p33.y, p33.z, p34.x, p34.y, p34.z, p35.x, p35.y, p35.z}, null, p32);
            this.setAtomSetSpaceGroupName(t3Array == null || string == null ? "P1" : "cell=" + string);
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            if (p3 != null) {
                this.symmetry.toFractional(p3, true);
            }
            for (n7 = n6; n7 < n; ++n7) {
                this.symmetry.toFractional(atomArray[n7], true);
                if (p3 == null) continue;
                atomArray[n7].sub(p3);
            }
            this.asc.haveAnisou = false;
            this.asc.setCurrentModelInfo("matUnitCellOrientation", null);
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n2, n3, n4);
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (t3Array == null) {
            this.applyAllSymmetry(this.acr.ms, bS);
            return;
        }
        if (this.acr.forcePacked || this.doPackUnitCell) {
            BS bS2 = this.asc.bsAtoms;
            atomArray = this.asc.atoms;
            if (bS2 == null) {
                bS2 = this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            n = bS2.nextSetBit(n6);
            while (n >= 0) {
                if (!this.isWithinCell(this.dtype, atomArray[n], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingError)) {
                    bS2.clear(n);
                }
                n = bS2.nextSetBit(n + 1);
            }
        }
    }

    private void adjustRangeMinMax(T3[] t3Array) {
        P3 p3 = new P3();
        P3 p32 = new P3();
        P3 p33 = new P3();
        if (this.acr.forcePacked) {
            p3.setT(t3Array[1]);
            p32.setT(t3Array[2]);
            p33.setT(t3Array[3]);
            p3.scale(this.packingError);
            p32.scale(this.packingError);
            p33.scale(this.packingError);
        }
        t3Array[0].scaleAdd2(this.minXYZ.x, t3Array[1], t3Array[0]);
        t3Array[0].scaleAdd2(this.minXYZ.y, t3Array[2], t3Array[0]);
        t3Array[0].scaleAdd2(this.minXYZ.z, t3Array[3], t3Array[0]);
        t3Array[0].sub(p3);
        t3Array[0].sub(p32);
        t3Array[0].sub(p33);
        P3 p34 = P3.newP(t3Array[0]);
        this.symmetry.toFractional(p34, true);
        this.setSymmetryMinMax(p34);
        t3Array[1].scale(this.maxXYZ.x - this.minXYZ.x);
        t3Array[2].scale(this.maxXYZ.y - this.minXYZ.y);
        t3Array[3].scale(this.maxXYZ.z - this.minXYZ.z);
        t3Array[1].scaleAdd2(2.0f, p3, t3Array[1]);
        t3Array[2].scaleAdd2(2.0f, p32, t3Array[2]);
        t3Array[3].scaleAdd2(2.0f, p33, t3Array[3]);
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                p34.add2(t3Array[i], t3Array[j]);
                if (i != 0) {
                    p34.add(t3Array[0]);
                }
                this.symmetry.toFractional(p34, false);
                this.setSymmetryMinMax(p34);
            }
        }
        this.symmetry.toCartesian(p34, false);
        p34.add(t3Array[1]);
        this.symmetry.toFractional(p34, false);
        this.setSymmetryMinMax(p34);
        this.minXYZ = P3i.new3((int)Math.min(0.0, Math.floor(this.rminx + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminy + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminz + 0.001f)));
        this.maxXYZ = P3i.new3((int)Math.max(1.0, Math.ceil(this.rmaxx - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxy - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxz - 0.001f)));
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    public boolean isWithinCell(int n, P3 p3, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return p3.x > f - f7 && p3.x < f2 + f7 && (n < 2 || p3.y > f3 - f7 && p3.y < f4 + f7) && (n < 3 || p3.z > f5 - f7 && p3.z < f6 + f7);
    }

    private void applyAllSymmetry(MSInterface mSInterface, BS bS) throws Exception {
        int n;
        int n2;
        int n3;
        SymmetryInterface symmetryInterface;
        boolean bl;
        int n4;
        if (this.asc.ac == 0) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount == 0 ? this.asc.getLastAtomSetAtomCount() : this.asc.baseSymmetryAtomCount;
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        int n5 = this.symmetry.getSpaceGroupOperationCount();
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.asc.setCurrentModelInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (mSInterface != null) {
                mSInterface.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n6 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n7 = this.asc.checkSpecial ? this.noSymmetryCount * n5 * n6 : (this.symmetryRange > 0.0f ? this.noSymmetryCount * n5 : (this.symmetryRange < 0.0f ? 1 : 1));
        P3[] p3Array = new P3[n7];
        for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
            this.asc.atoms[n4 + this.firstSymmetryAtom].bsSymmetry = BS.newN(n5 * (n6 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n6];
        this.unitCellTranslations = new V3[n6];
        int n8 = 0;
        int n9 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminz = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminx = Float.MAX_VALUE;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        SymmetryInterface symmetryInterface2 = symmetryInterface = this.symmetry;
        this.latticeOp = symmetryInterface.getLatticeOp();
        this.checkAll = this.asc.atomSetCount == 1 && this.asc.checkSpecial && this.latticeOp >= 0;
        this.latticeOnly = this.asc.checkLatticeOnly && this.latticeOp >= 0;
        P3 p3 = null;
        M4 m4 = symmetryInterface.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            p3 = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n8] = V3.new3(n3, n2, n);
                    nArray[n8++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || p3Array.length == 0) continue;
                    for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
                        Atom atom = this.asc.atoms[this.firstSymmetryAtom + n4];
                        if (mSInterface != null && (symmetryInterface = mSInterface.getAtomSymmetry(atom, this.symmetry)) != symmetryInterface2) {
                            if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                                symmetryInterface2 = symmetryInterface;
                                this.finalizeSymmetry(symmetryInterface2);
                            }
                            m4 = symmetryInterface.getSpaceGroupOperation(0);
                        }
                        P3 p32 = P3.newP(atom);
                        m4.rotTrans(p32);
                        symmetryInterface.toCartesian(p32, false);
                        if (this.doPackUnitCell) {
                            symmetryInterface.toUnitCell(p32, this.ptOffset);
                            p3.setT(p32);
                            symmetryInterface.toFractional(p3, false);
                            if (this.acr.fixJavaFloat) {
                                PT.fixPtFloats(p3, 100000.0f);
                            }
                            if (bS == null) {
                                atom.setT(p3);
                            } else if (atom.distance(p3) < 1.0E-4f) {
                                bS.set(atom.index);
                            } else {
                                bS.clear(atom.index);
                                continue;
                            }
                        }
                        if (bS != null) {
                            atom.bsSymmetry.clearAll();
                        }
                        atom.bsSymmetry.set(n8 * n5);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(p32);
                        }
                        if (n4 >= n7) continue;
                        p3Array[n4] = p32;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n9 = n4 = this.symmetryAddAtoms(0, 0, 0, 0, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n8 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n8;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n3, n2, n, n9, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (n8 * this.noSymmetryCount == this.asc.ac - this.firstSymmetryAtom) {
            this.duplicateAtomProperties(n8);
        }
        this.setSymmetryOps();
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("latticeDesignation", symmetryInterface.getLatticeDesignation());
        this.asc.setCurrentModelInfo("unitCellRange", nArray);
        this.asc.setCurrentModelInfo("unitCellTranslations", this.unitCellTranslations);
        this.baseUnitCell = this.unitCellParams;
        this.unitCellParams = new float[6];
        this.reset();
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, P3[] p3Array, MSInterface mSInterface) throws Exception {
        int[] nArray;
        boolean bl = n4 == 0;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl2 ? new int[this.noSymmetryCount] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n, n2, n3);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = this.symmetryRange > 0.0f;
        boolean bl5 = bl && bl4;
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        boolean bl6 = n7 == 1 && !this.doPackUnitCell ? false : this.asc.checkSpecial;
        boolean bl7 = bl3 || (bl4 &= !bl);
        boolean bl8 = bl6 || bl7;
        boolean bl9 = bl6 || bl5;
        BS bS = this.acr.isMolecular ? null : this.asc.bsAtoms;
        SymmetryInterface symmetryInterface = this.symmetry;
        if (bl3) {
            n4 = this.noSymmetryCount;
        }
        int n8 = this.firstSymmetryAtom + this.noSymmetryCount;
        P3 p3 = new P3();
        String string = null;
        char c = '\u0000';
        for (int i = 0; i < n7; ++i) {
            int n9;
            Object object;
            Atom[] atomArray;
            if (bl && i == 0 || this.latticeOnly && i > 0 && i != this.latticeOp) continue;
            int n10 = bl6 ? n5 : (bl4 ? n4 : 0);
            float f2 = this.asc.vibScale == 0 ? symmetryInterface.getSpinOp(i) : (float)this.asc.vibScale;
            for (int j = this.firstSymmetryAtom; j < n8; ++j) {
                Object object2;
                atomArray = this.asc.atoms[j];
                if (atomArray.ignoreSymmetry || bS != null && !bS.get(j)) continue;
                if (mSInterface == null) {
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                } else {
                    symmetryInterface = mSInterface.getAtomSymmetry((Atom)atomArray, this.symmetry);
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                    string = symmetryInterface.getSpaceGroupOperationCode(i);
                    if (string != null) {
                        c = string.charAt(0);
                        symmetryInterface = mSInterface.getSymmetryFromCode(string);
                        if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(symmetryInterface);
                        }
                    }
                }
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(p3, 100000.0f);
                }
                P3 p32 = P3.newP(p3);
                symmetryInterface.toCartesian(p32, false);
                if (this.doPackUnitCell) {
                    symmetryInterface.toUnitCell(p32, this.ptOffset);
                    p3.setT(p32);
                    symmetryInterface.toFractional(p3, false);
                    if (this.acr.fixJavaFloat) {
                        PT.fixPtFloats(p3, 100000.0f);
                    }
                    if (!this.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingError)) continue;
                }
                if (bl5) {
                    this.setSymmetryMinMax(p32);
                }
                object = null;
                if (bl8) {
                    float f3 = Float.MAX_VALUE;
                    if (bl7 && (p32.x < this.rminx || p32.y < this.rminy || p32.z < this.rminz || p32.x > this.rmaxx || p32.y > this.rmaxy || p32.z > this.rmaxz)) continue;
                    int n11 = this.checkAll ? this.asc.ac : n10;
                    object2 = atomArray.atomName;
                    n9 = string == null ? atomArray.altLoc : c;
                    int n12 = n11;
                    while (--n12 >= 0) {
                        P3 p33 = p3Array[n12];
                        if (p33 == null) continue;
                        float f4 = p32.distanceSquared(p33);
                        if (bl6 && (double)f4 < 1.0E-4) {
                            object = this.asc.atoms[this.firstSymmetryAtom + n12];
                            if ((((Atom)object).atomName == null || ((Atom)object).atomName.equals(object2)) && ((Atom)object).altLoc == n9) break;
                            object = null;
                        }
                        if (!bl4 || n12 >= n4 || !(f4 < f3)) continue;
                        f3 = f4;
                    }
                    if (bl4 && f3 > f) continue;
                }
                int n13 = atomArray.atomSite;
                if (object != null) {
                    if (bl2) {
                        nArray[n13] = ((Atom)object).index;
                    }
                    ((Atom)object).bsSymmetry.set(n6 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl2) {
                    nArray[n13] = this.asc.ac;
                }
                Atom atom = this.asc.newCloneAtom((Atom)atomArray);
                if (this.asc.bsAtoms != null) {
                    this.asc.bsAtoms.set(atom.index);
                }
                atom.setT(p3);
                if (f2 != 0.0f && atom.vib != null) {
                    symmetryInterface.getSpaceGroupOperation(i).rotate(atom.vib);
                    atom.vib.scale(f2);
                }
                atom.atomSite = n13;
                if (string != null) {
                    atom.altLoc = c;
                }
                atom.bsSymmetry = BSUtil.newAndSetBit(n6 + i);
                atom.bsSymmetry.set(i);
                if (bl9) {
                    p3Array[n5++] = p32;
                }
                if ((object2 = atomArray.tensors) == null) continue;
                atom.tensors = null;
                n9 = ((ArrayList)object2).size();
                while (--n9 >= 0) {
                    Tensor tensor = (Tensor)((ArrayList)object2).get(n9);
                    if (tensor == null) continue;
                    if (n7 == 1) {
                        atom.addTensor(tensor.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom, tensor, i, false, symmetryInterface);
                }
            }
            if (!bl2) continue;
            Bond[] bondArray = this.asc.bonds;
            atomArray = this.asc.atoms;
            for (int j = this.asc.bondIndex0; j < this.bondCount0; ++j) {
                object = bondArray[j];
                Atom atom = atomArray[((Bond)object).atomIndex1];
                Atom atom2 = atomArray[((Bond)object).atomIndex2];
                if (atom == null || atom2 == null) continue;
                int n14 = nArray[atom.atomSite];
                n9 = nArray[atom2.atomSite];
                if (n14 < n8 && n9 < n8) continue;
                this.asc.addNewBondWithOrder(n14, n9, ((Bond)object).order);
            }
        }
        return n5;
    }

    private void duplicateAtomProperties(int n) {
        Map map = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                int n2;
                Object object;
                Object object2;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    object2 = (String)v;
                    object = new SB();
                    n2 = n;
                    while (--n2 >= 0) {
                        ((SB)object).append((String)object2);
                    }
                    map.put(string, ((SB)object).toString());
                    continue;
                }
                object2 = (float[])v;
                object = new float[((Object)object2).length * n];
                n2 = n;
                while (--n2 >= 0) {
                    System.arraycopy(object2, 0, object, n2 * ((Object)object2).length, ((Object)object2).length);
                }
            }
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetryInterface) {
        String string = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetryInterface.setFinalOperations(string, this.asc.atoms, this.firstSymmetryAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || string == null || string.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setCurrentModelInfo("symmetryOperations", stringArray);
            this.asc.setCurrentModelInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setCurrentModelInfo("symmetryCount", n);
        this.asc.setCurrentModelInfo("latticeType", this.symmetry.getLatticeType());
        this.asc.setCurrentModelInfo("intlTableNo", this.symmetry.getIntTableNumber());
        if (this.acr.sgName == null || this.acr.sgName.indexOf("?") >= 0 || this.acr.sgName.indexOf("!") >= 0) {
            this.acr.sgName = this.symmetry.getSpaceGroupName();
            this.setAtomSetSpaceGroupName(this.acr.sgName);
        }
    }

    public T3 getOverallSpan() {
        return this.maxXYZ0 == null ? V3.new3(this.maxXYZ.x - this.minXYZ.x, this.maxXYZ.y - this.minXYZ.y, this.maxXYZ.z - this.minXYZ.z) : V3.newVsub(this.maxXYZ0, this.minXYZ0);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> map, float[] fArray, boolean bl, String string) {
        void var18_29;
        boolean bl2;
        int n;
        BS bS;
        Object object;
        String string2;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        int n3 = string.indexOf("BYCHAIN") >= 0 ? 1 : (string.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst lst = (Lst)map.get("biomts");
        Lst lst2 = (Lst)map.get("chains");
        if (lst.size() < 2) {
            return;
        }
        if (((String)lst2.get(0)).equals(lst2.get(1))) {
            lst2 = null;
        }
        this.symmetry = null;
        if (!Float.isNaN(fArray[0])) {
            this.setUnitCell(fArray, null, this.unitCellOffset);
        }
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z", false);
        this.acr.sgName = string2 = (String)map.get("name");
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        int n4 = lst.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.asc.bondCount;
        boolean bl22 = this.bondCount0 > this.asc.bondIndex0 && bl;
        int[] nArray = bl22 ? new int[this.asc.ac] : null;
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        int n5 = this.asc.ac;
        Hashtable<Serializable, BS> hashtable = new Hashtable<Serializable, BS>();
        int n6 = 0;
        Atom[] atomArray = this.asc.atoms;
        switch (n3) {
            case 1: {
                Object object2;
                int n7 = n5;
                while (--n7 >= this.firstSymmetryAtom) {
                    void object3;
                    object2 = atomArray[n7].chainID;
                    BS n8 = (BS)hashtable.get(object2);
                    if (n8 == null) {
                        ++n6;
                        BS bS2 = new BS();
                        hashtable.put((Serializable)object2, bS2);
                    }
                    object3.set(n7);
                }
                this.asc.bsAtoms = new BS();
                for (n7 = 0; n7 < n6; ++n7) {
                    this.asc.bsAtoms.set(n5 + n7);
                    object2 = new Atom();
                    ((T3)object2).set(0.0f, 0.0f, 0.0f);
                    ((Atom)object2).radius = 16.0f;
                    this.asc.addAtom((Atom)object2);
                }
                n7 = 0;
                for (Map.Entry entry : hashtable.entrySet()) {
                    object = atomArray[n5 + n7++];
                    bS = (BS)entry.getValue();
                    n = bS.nextSetBit(0);
                    while (n >= 0) {
                        ((T3)object).add(atomArray[n]);
                        n = bS.nextSetBit(n + 1);
                    }
                    ((T3)object).scale(1.0f / (float)bS.cardinality());
                    ((Atom)object).atomName = "Pt" + n7;
                    ((Atom)object).chainID = (Integer)entry.getKey();
                }
                this.firstSymmetryAtom = n5;
                n5 += n6;
                break;
            }
            case 2: {
                void var18_27;
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(n5);
                atomArray[n5] = new Atom();
                Object object2 = atomArray[n5];
                ((T3)object2).set(0.0f, 0.0f, 0.0f);
                int n2 = n5;
                while (--var18_27 >= this.firstSymmetryAtom) {
                    ((T3)object2).add(atomArray[var18_27]);
                }
                ((T3)object2).scale(1.0f / (float)(n5 - this.firstSymmetryAtom));
                ((Atom)object2).atomName = "Pt";
                ((Atom)object2).radius = 16.0f;
                this.asc.addAtom((Atom)object2);
                this.firstSymmetryAtom = n5++;
            }
        }
        Map map2 = (Map)map.get("asemblyIdAtoms");
        if (string.indexOf("#<") >= 0) {
            n4 = Math.min(n4, PT.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = PT.rep(string, "#<", "_<");
        }
        for (int i = this.firstSymmetryAtom; i < n5; ++i) {
            atomArray[i].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        BS bS2 = this.asc.bsAtoms;
        boolean bl3 = bl2 = lst2 == null;
        while (var18_29 < n4) {
            if (!(string.indexOf("!#") >= 0 ? string.indexOf("!#" + (int)(var18_29 + true) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (int)(var18_29 + true) + ";") < 0)) {
                object = (M4)lst.get((int)var18_29);
                BS bS3 = bS = lst2 == null ? null : (String)lst2.get((int)var18_29);
                if (bS != null && map2 != null) {
                    bS2 = new BS();
                    for (Map.Entry entry : map2.entrySet()) {
                        if (((String)((Object)bS)).indexOf(":" + (String)entry.getKey() + ";") < 0) continue;
                        bS2.or((BS)entry.getValue());
                    }
                    if (this.asc.bsAtoms != null) {
                        bS2.and(this.asc.bsAtoms);
                    }
                    bS = null;
                }
                for (n = this.firstSymmetryAtom; n < n5; ++n) {
                    if (bS2 != null && !bS2.get(n) || bS != null && ((String)((Object)bS)).indexOf(":" + this.acr.vwr.getChainIDStr(atomArray[n].chainID) + ";") < 0) continue;
                    try {
                        int n7 = atomArray[n].atomSite;
                        if (bl22) {
                            nArray[n7] = this.asc.ac;
                        }
                        Atom atom = this.asc.newCloneAtom(atomArray[n]);
                        if (this.asc.bsAtoms != null) {
                            this.asc.bsAtoms.set(atom.index);
                        }
                        atom.atomSite = n7;
                        ((M4)object).rotTrans(atom);
                        atom.bsSymmetry = BSUtil.newAndSetBit((int)var18_29);
                        if (!bl22) continue;
                        for (int i = this.asc.bondIndex0; i < this.bondCount0; ++i) {
                            Bond bond = this.asc.bonds[i];
                            int n8 = nArray[atomArray[bond.atomIndex1].atomSite];
                            int n9 = nArray[atomArray[bond.atomIndex2].atomSite];
                            if (n8 < n5 && n9 < n5) continue;
                            this.asc.addNewBondWithOrder(n8, n9, bond.order);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        this.asc.errorMessage = "appendAtomCollection error: " + exception;
                    }
                }
                if (var18_29 > 0) {
                    this.symmetry.addBioMoleculeOperation((M4)object, false);
                }
            }
            ++var18_29;
        }
        if (lst2 != null) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            this.asc.bsAtoms.clearBits(this.firstSymmetryAtom, n5);
        }
        this.noSymmetryCount = n5 - this.firstSymmetryAtom;
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("biosymmetryCount", n4);
        this.asc.setCurrentModelInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setCurrentModelInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl, SymmetryInterface symmetryInterface) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return atom.addTensor(((Tensor)this.acr.getInterface("org.jmol.util.Tensor")).setFromEigenVectors(symmetryInterface.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id, tensor), null, bl);
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom atom = this.asc.atoms[i];
            if (atom.anisoBorU == null) continue;
            atom.addTensor(this.symmetry.getTensor(this.acr.vwr, atom.anisoBorU), null, false);
            if (Float.isNaN(atom.bfactor)) {
                atom.bfactor = atom.anisoBorU[7] * 100.0f;
            }
            atom.anisoBorU = null;
        }
    }

    public void setTimeReversal(int n, int n2) {
        this.symmetry.setTimeReversal(n, n2);
    }

    public void rotateToSuperCell(V3 v3) {
        if (this.matSupercell != null) {
            this.matSupercell.rotTrans(v3);
        }
    }

    public int setSpinVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.acr.vibsFractional) {
            return this.nVib;
        }
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        SymmetryInterface symmetryInterface = this.getBaseSymmetry();
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            if (vibration.modDim > 0) {
                ((JmolModulationSet)((Object)vibration)).setMoment();
            } else {
                vibration = (Vibration)vibration.clone();
                symmetryInterface.toCartesian(vibration, true);
                this.asc.atoms[n2].vib = vibration;
            }
            ++this.nVib;
        }
        return this.nVib;
    }

    public void scaleFractionalVibs() {
        float[] fArray = this.getBaseSymmetry().getUnitCellParams();
        P3 p3 = P3.new3(1.0f / fArray[0], 1.0f / fArray[1], 1.0f / fArray[2]);
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            vibration.scaleT(p3);
        }
    }

    public SymmetryInterface getBaseSymmetry() {
        return this.baseSymmetry == null ? this.symmetry : this.baseSymmetry;
    }

    public void finalizeUnitCell(P3 p3) {
        if (p3 != null && this.baseUnitCell != null) {
            this.baseUnitCell[22] = Math.max(1, (int)p3.x);
            this.baseUnitCell[23] = Math.max(1, (int)p3.y);
            this.baseUnitCell[24] = Math.max(1, (int)p3.z);
        }
    }
}

