/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.rendercgo;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.renderspecial.DrawRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapecgo.CGO;
import org.jmol.shapecgo.CGOMesh;
import org.jmol.util.C;
import org.jmol.util.Logger;

public class CGORenderer
extends DrawRenderer {
    private CGOMesh cgoMesh;
    private Lst<Object> cmds;
    private P3 pt3 = new P3();
    private short colix0;
    private short colix1;
    private short colix2;
    private short normix0;
    private short normix1;
    private short normix2;
    private short normix;
    private boolean doColor;
    private int ptNormal;
    private int ptColor;
    private P3 map0;
    private P3 vX;
    private P3 vY;
    private float x0;
    private float y0;
    private float dx;
    private float dy;
    private float scaleX;
    private float scaleY;
    private boolean is2D;
    private boolean is2DPercent;
    private boolean isMapped;
    private boolean isPS;
    private int screenZ;

    @Override
    protected boolean render() {
        this.isPrecision = true;
        this.needTranslucent = false;
        this.imageFontScaling = this.vwr.imageFontScaling;
        CGO cGO = (CGO)this.shape;
        int n = cGO.meshCount;
        while (--n >= 0) {
            this.cgoMesh = (CGOMesh)cGO.meshes[n];
            this.mesh = this.cgoMesh;
            this.render2(this.cgoMesh);
        }
        return this.needTranslucent;
    }

    private void render2(Mesh mesh) {
        int n;
        this.diameter = this.cgoMesh.diameter;
        this.width = this.cgoMesh.width;
        this.cmds = this.cgoMesh.cmds;
        if (this.cmds == null || !this.cgoMesh.visible || this.cgoMesh.visibilityFlags == 0) {
            return;
        }
        if (!this.g3d.setC(this.cgoMesh.colix)) {
            this.needTranslucent = true;
            return;
        }
        int n2 = this.cmds.size();
        int n3 = -1;
        int n4 = 0;
        this.ptNormal = 0;
        this.ptColor = 0;
        this.width = 0.0f;
        this.screenZ = Integer.MAX_VALUE;
        this.doColor = !mesh.useColix;
        this.g3d.addRenderer(1073742182);
        this.isMapped = false;
        this.is2D = false;
        this.scaleY = 1.0f;
        this.scaleX = 1.0f;
        for (int i = 0; i < n2 && (n = this.cgoMesh.getInt(i)) != 0; ++i) {
            int n5 = CGOMesh.getSize(n, this.is2D);
            if (n5 < 0) {
                Logger.error("CGO unknown type: " + n);
                return;
            }
            switch (n) {
                default: {
                    System.out.println("CGO ? " + n);
                    break;
                }
                case -111: {
                    break;
                }
                case -107: {
                    this.diameter = this.cgoMesh.getInt(i + 1);
                    break;
                }
                case -100: {
                    this.width = this.cgoMesh.getFloat(i + 1);
                    break;
                }
                case -101: {
                    this.isMapped = false;
                    float f = this.cgoMesh.getFloat(i + 1);
                    if (f == 0.0f) {
                        this.is2D = false;
                        break;
                    }
                    this.is2DPercent = f > 0.0f;
                    this.screenZ = this.is2DPercent ? this.tm.zValueFromPercent((int)f) : -((int)f);
                    this.is2D = true;
                    break;
                }
                case -103: {
                    this.isPS = true;
                }
                case -102: {
                    this.isMapped = true;
                    this.is2D = true;
                    this.map0 = new P3();
                    this.vX = new P3();
                    this.vY = new P3();
                    this.cgoMesh.getPoint(i + 1, this.map0);
                    this.cgoMesh.getPoint(i + 4, this.vX);
                    this.vX.sub(this.map0);
                    this.cgoMesh.getPoint(i + 7, this.vY);
                    this.vY.sub(this.map0);
                    this.x0 = this.cgoMesh.getFloat(i + 10);
                    this.y0 = this.cgoMesh.getFloat(i + 11);
                    this.dx = this.cgoMesh.getFloat(i + 12) - this.x0;
                    this.dy = this.cgoMesh.getFloat(i + 13) - this.y0;
                    if (this.isPS) break;
                }
                case -108: {
                    this.scaleX = this.cgoMesh.getFloat(this.isPS ? i + 1 : i + 14);
                    this.scaleY = this.cgoMesh.getFloat(this.isPS ? i + 2 : i + 15);
                    break;
                }
                case 28: {
                    break;
                }
                case 1: {
                    this.getPoint(i + 2, this.pt0, this.pt0i);
                    this.getPoint(i + (this.is2D ? 4 : 5), this.pt1, this.pt1i);
                    this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    break;
                }
                case 2: {
                    n3 = this.cgoMesh.getInt(i + 1);
                }
                case -104: {
                    n4 = 0;
                    break;
                }
                case -105: {
                    n3 = -105;
                    break;
                }
                case -106: {
                    if (n3 != -105) break;
                    n3 = 2;
                }
                case 3: {
                    if (n3 == 2 && n4 >= 3) {
                        this.drawEdge(1, 2, true, this.pt0, this.pt3, this.pt0i, this.pt3i);
                    }
                    n4 = 0;
                    break;
                }
                case 6: {
                    this.getColix(true);
                    break;
                }
                case 5: {
                    this.normix = this.getNormix();
                    break;
                }
                case -109: {
                    n4 = 0;
                }
                case -110: {
                    n3 = 2;
                }
                case 4: {
                    if (n4++ == 0) {
                        this.getPoint(i, this.pt0, this.pt0i);
                    }
                    block23 : switch (n3) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            this.drawEdge(1, 1, false, this.pt0, this.pt0, this.pt0i, this.pt0i);
                            break;
                        }
                        case 1: {
                            if (n4 != 2) break;
                            this.getPoint(i, this.pt1, this.pt1i);
                            this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                            n4 = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (n4 == 1) {
                                if (n3 != 2) break;
                                this.pt3.setT(this.pt0);
                                this.pt3i.setT(this.pt0i);
                                break;
                            }
                            this.getPoint(i, this.pt1, this.pt1i);
                            P3 p3 = this.pt0;
                            this.pt0 = this.pt1;
                            this.pt1 = p3;
                            P3i p3i = this.pt0i;
                            this.pt0i = this.pt1i;
                            this.pt1i = p3i;
                            this.drawEdge(1, 2, true, this.pt0, this.pt1, this.pt0i, this.pt1i);
                            break;
                        }
                        case 4: {
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt1, this.pt1i);
                                    break;
                                }
                                case 3: {
                                    this.getPoint(i, this.pt2, this.pt2i);
                                    this.fillTriangle();
                                    n4 = 0;
                                }
                            }
                            break;
                        }
                        case 5: {
                            P3i p3i;
                            P3 p3;
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break block23;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt2, this.pt2i);
                                    break block23;
                                }
                            }
                            if (n4 % 2 == 0) {
                                p3 = this.pt0;
                                this.pt0 = this.pt2;
                                p3i = this.pt0i;
                                this.pt0i = this.pt2i;
                            } else {
                                p3 = this.pt1;
                                this.pt1 = this.pt2;
                                p3i = this.pt1i;
                                this.pt1i = this.pt2i;
                            }
                            this.pt2 = p3;
                            this.pt2i = p3i;
                            this.getPoint(i, this.pt2, this.pt2i);
                            this.fillTriangle();
                            break;
                        }
                        case 6: {
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    this.pt1.setT(this.pt0);
                                    this.pt1i.setT(this.pt0i);
                                    break block23;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt0, this.pt0i);
                                    break block23;
                                }
                            }
                            this.pt2.setT(this.pt0);
                            this.pt2i.setT(this.pt0i);
                            this.getPoint(i, this.pt0, this.pt0i);
                            this.fillTriangle();
                        }
                    }
                    break;
                }
                case 14: {
                    this.getPoint(i, this.pt0, this.pt0i);
                    this.getPoint(i + (this.is2D ? 2 : 3), this.pt1, this.pt1i);
                    this.width = this.cgoMesh.getFloat(i + 7);
                    this.getColix(true);
                    this.getColix(false);
                    this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    this.width = 0.0f;
                    break;
                }
                case 8: {
                    this.getPoint(i, this.pt0, this.pt0i);
                    this.getPoint(i + (this.is2D ? 2 : 3), this.pt1, this.pt1i);
                    this.getPoint(i + (this.is2D ? 4 : 6), this.pt2, this.pt2i);
                    this.normix0 = this.getNormix();
                    this.normix1 = this.getNormix();
                    this.normix2 = this.getNormix();
                    this.colix0 = this.getColix(false);
                    this.colix1 = this.getColix(false);
                    this.colix2 = this.getColix(false);
                    this.fillTriangle();
                }
            }
            i += n5;
        }
    }

    private short getNormix() {
        return (Short)this.cgoMesh.nList.get(this.ptNormal++);
    }

    private short getColix(boolean bl) {
        if (this.doColor) {
            this.colix = C.copyColixTranslucency(this.cgoMesh.colix, (Short)this.cgoMesh.cList.get(this.ptColor++));
            if (bl) {
                this.g3d.setC(this.colix);
            }
        }
        return this.colix;
    }

    void getPoint(int n, P3 p3, P3i p3i) {
        this.cgoMesh.getPoint(n + 1, p3);
        if (this.isMapped) {
            float f = (p3.x * this.scaleX - this.x0) / this.dx;
            float f2 = (p3.y * this.scaleY - this.y0) / this.dy;
            p3.scaleAdd2(f, this.vX, this.map0);
            p3.scaleAdd2(f2, this.vY, p3);
        } else if (this.is2D) {
            p3i.x = this.is2DPercent ? this.tm.percentToPixels('x', p3.x) : (int)p3.x;
            p3i.y = this.is2DPercent ? this.tm.percentToPixels('y', p3.y) : (int)p3.y;
            p3i.z = this.screenZ;
            this.tm.unTransformPoint(p3, p3);
            return;
        }
        this.tm.transformPtScr(p3, p3i);
    }

    private void fillTriangle() {
        this.g3d.fillTriangle3CNBits(this.pt0, this.colix0, this.normix0, this.pt1, this.colix1, this.normix1, this.pt2, this.colix2, this.normix2);
    }
}

