/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.dssx.AnnotationParser;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSR1
extends AnnotationParser {
    private static final String DSSR_PATHS = "..bulges.nts_long..coaxstacks.stems.pairs.nt*..hairpins.nts_long..hbonds.atom1_id;atom2_id..helices.pairs.nt*..iloops.nts_long..isocanonpairs.nt*..junctions.nts_long..kissingloops.hairpins.nts_long..multiplets.nts_long..nonstack.nts_long..nts.nt_id..pairs.nt*..sssegments.nts_long..stacks.nts_long..stems.pairs.nt*..";

    @Override
    public String calculateDSSRStructure(Viewer viewer, BS bS) {
        BS bS2 = viewer.ms.getModelBS(bS == null ? viewer.bsA() : bS, true);
        String string = "";
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            string = string + this.getDSSRForModel(viewer, n) + "\n";
            n = bS2.nextSetBit(n + 1);
        }
        return string;
    }

    private String getDSSRForModel(Viewer viewer, int n) {
        Map map = null;
        String string = null;
        if (viewer.ms.am[n].isBioModel && !(map = viewer.ms.getModelAuxiliaryInfo(n)).containsKey("dssr")) {
            BS bS = viewer.getModelUndeletedAtomsBitSet(n);
            bS.and(viewer.ms.getAtoms(0x20000E, null));
            if (bS.nextClearBit(0) < 0) {
                map = null;
            } else {
                try {
                    String string2 = (String)viewer.setLoadFormat("=dssrModel/", '=', false);
                    string2 = PT.rep((String)string2, (String)"%20", (String)" ");
                    Logger.info((String)("fetching " + string2 + "[pdb data]"));
                    String string3 = viewer.getPdbAtomData(bS, null, false, false);
                    string3 = viewer.getFileAsString3(string2 + string3, false, null);
                    Map map2 = viewer.parseJSON(string3);
                    if (map2 != null) {
                        map.put("dssr", map2);
                        this.setGroup1(viewer.ms, n);
                        this.fixDSSRJSONMap(map2);
                        this.setBioPolymers((BioModel)viewer.ms.am[n], false);
                    }
                }
                catch (Exception exception) {
                    map = null;
                    string = "" + exception;
                }
            }
        }
        return map != null ? PT.rep((String)Escape.escapeMap((Map)((Map)((Map)map.get("dssr")).get("counts"))), (String)",", (String)",\n") : (string == null ? "model has no nucleotides" : string);
    }

    @Override
    public String fixDSSRJSONMap(Map<String, Object> map) {
        String string = "";
        try {
            this.fixIndices(map, "kissingLoops", "hairpin");
            this.fixIndices(map, "coaxStacks", "stem");
            if (map.containsKey("counts")) {
                string = string + "_M.dssr.counts = " + map.get("counts").toString() + "\n";
            }
            if (map.containsKey("dbn")) {
                string = string + "_M.dssr.dbn = " + map.get("dbn").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void fixIndices(Map<String, Object> map, String string, String string2) {
        String string3 = string2 + "_indices";
        String string4 = string2 + "s";
        Lst lst = (Lst)map.get(string);
        if (lst != null) {
            Lst lst2 = (Lst)map.get(string4);
            int n = lst.size();
            while (--n >= 0) {
                Map map2 = (Map)lst.get(n);
                Lst lst3 = (Lst)map2.get(string3);
                int n2 = lst3.size();
                if (n2 <= 0) continue;
                Lst lst4 = new Lst();
                map2.put(string4, lst4);
                int n3 = n2;
                while (--n3 >= 0) {
                    lst4.addLast(lst2.get((Integer)lst3.get(n3) - 1));
                }
            }
        }
    }

    @Override
    public void getBasePairs(Viewer viewer, int n) {
        Lst lst;
        ModelSet modelSet = viewer.ms;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        Lst lst2 = map == null ? null : (Lst)map.get("pairs");
        Lst lst3 = lst = map == null ? null : (Lst)map.get("ssSegments");
        if (lst2 == null && lst == null) {
            this.setBioPolymers((BioModel)viewer.ms.am[n], true);
            return;
        }
        BS bS = modelSet.am[n].bsAtoms;
        try {
            String string;
            Map map2;
            int n2;
            BS bS2 = new BS();
            Atom[] atomArray = modelSet.at;
            if (lst2 != null) {
                n2 = lst2.size();
                while (--n2 >= 0) {
                    map2 = (Map)lst2.get(n2);
                    string = (String)map2.get("nt1");
                    String string2 = (String)map2.get("nt2");
                    int n3 = modelSet.getSequenceBits(string, bS, bS2).nextSetBit(0);
                    bS2.clearAll();
                    int n4 = modelSet.getSequenceBits(string2, bS, bS2).nextSetBit(0);
                    bS2.clearAll();
                    BasePair.add(map2, this.setRes(atomArray[n3]), this.setRes(atomArray[n4]));
                }
            }
            if (lst != null) {
                n2 = lst.size();
                while (--n2 >= 0) {
                    map2 = (Map)lst.get(n2);
                    string = (String)map2.get("nts_long");
                    modelSet.getSequenceBits(string, bS, bS2);
                    int n5 = bS2.nextSetBit(0);
                    while (n5 >= 0) {
                        this.setRes(atomArray[n5]);
                        n5 = bS2.nextSetBit(n5 + 1);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Exception " + exception + " in DSSRParser.getBasePairs"));
        }
    }

    private void setBioPolymers(BioModel bioModel, boolean bl) {
        int n;
        int n2 = n = bioModel.getBioPolymerCount();
        while (--n2 >= 0) {
            BioPolymer bioPolymer = bioModel.bioPolymers[n2];
            if (!bioPolymer.isNucleic()) continue;
            ((NucleicPolymer)bioPolymer).isDssrSet = bl;
        }
    }

    private NucleicMonomer setRes(Atom atom) {
        NucleicMonomer nucleicMonomer = (NucleicMonomer)atom.group;
        ((NucleicPolymer)nucleicMonomer.bioPolymer).isDssrSet = true;
        return nucleicMonomer;
    }

    @Override
    public BS getAtomBits(Viewer viewer, String string, Object object, Map<String, Object> map, int n, int n2, BS bS) {
        BS bS2;
        boolean bl;
        if (object == null) {
            return new BS();
        }
        boolean bl2 = bl = !string.contains("NOCACHE");
        if (!bl) {
            string = PT.rep((String)string, (String)"NOCACHE", (String)"").trim();
        }
        BS bS3 = bS2 = bl ? (BS)map.get(string) : null;
        if (bS2 != null) {
            return bS2;
        }
        bS2 = new BS();
        if (bl) {
            map.put(string, bS2);
        }
        try {
            string = string.toLowerCase();
            int n3 = DSSR_PATHS.indexOf(".." + string) + 2;
            int n4 = string.length();
            while (n3 >= 2 && n4 > 0) {
                if (DSSR_PATHS.substring(n3 + n4, n3 + n4 + 2).equals("..")) {
                    string = "[select (" + string + ")]";
                }
                object = viewer.extractProperty(object, (Object)string, -1);
                int n5 = DSSR_PATHS.indexOf(".", n3 += n4 + 1);
                string = DSSR_PATHS.substring(n3, n5);
                n4 = string.length();
            }
            bS2.or(viewer.ms.getAtoms(1086324744, (Object)object.toString()));
            bS2.and(bS);
        }
        catch (Exception exception) {
            System.out.println(exception.toString() + " in AnnotationParser");
            bS2.clearAll();
        }
        return bS2;
    }

    @Override
    public String getHBonds(ModelSet modelSet, int n, Lst<Bond> lst, boolean bl) {
        Lst lst2;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        if (map == null || (lst2 = (Lst)map.get("hbonds")) == null) {
            return "no DSSR hydrogen-bond data";
        }
        BS bS = modelSet.am[n].bsAtoms;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        try {
            BS bS2 = new BS();
            int n4 = lst2.size();
            while (--n4 >= 0) {
                Map map2 = (Map)lst2.get(n4);
                string = (String)map2.get("atom1_id");
                n2 = modelSet.getSequenceBits(string, bS, bS2).nextSetBit(0);
                if (n2 < 0) {
                    Logger.error((String)("Atom " + string + " was not found"));
                    continue;
                }
                string2 = (String)map2.get("atom2_id");
                bS2.clearAll();
                n3 = modelSet.getSequenceBits(string2, bS, bS2).nextSetBit(0);
                if (n3 < 0) {
                    Logger.error((String)("Atom " + string2 + " was not found"));
                    continue;
                }
                bS2.clearAll();
                float f = 0.0f;
                lst.addLast((Object)new HBond(modelSet.at[n2], modelSet.at[n3], 2048, 1, 0, f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "DSSR reports " + lst2.size() + " hydrogen bonds";
    }

    @Override
    public void setGroup1(ModelSet modelSet, int n) {
        Lst lst;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        if (map == null || (lst = (Lst)map.get("nts")) == null) {
            return;
        }
        BioModel bioModel = (BioModel)modelSet.am[n];
        BS bS = bioModel.bsAtoms;
        Atom[] atomArray = modelSet.at;
        BS bS2 = new BS();
        int n2 = lst.size();
        while (--n2 >= 0) {
            Map map2 = (Map)lst.get(n2);
            char c = ((String)map2.get("nt_code")).charAt(0);
            if (!Character.isLowerCase(c)) continue;
            String string = (String)map2.get("nt_id");
            bioModel.getAllSequenceBits(string, bS, bS2);
            Logger.info((String)("" + c + " " + string + " " + bS2));
            atomArray[bS.nextSetBit((int)0)].group.group1 = c;
            bS2.clearAll();
        }
    }
}

