/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class MeasurementTable
extends JDialog {
    Viewer vwr;
    private JTable measurementTable;
    private MeasurementTableModel measurementTableModel;
    int selectedMeasurementRow = -1;
    JButton deleteButton;
    JButton deleteAllButton;
    final Class<? extends String> stringClass = "".getClass();

    public MeasurementTable(Viewer viewer, JFrame jFrame) {
        super(jFrame, GT._("Measurements"), false);
        this.vwr = viewer;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.constructMeasurementTable(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.constructMeasurementButtonPanel(), "West");
        jPanel2.add((Component)this.constructDismissButtonPanel(), "East");
        jPanel.add((Component)jPanel2, "South");
        this.addWindowListener(new MeasurementListWindowListener());
        this.getContentPane().add(jPanel);
        this.pack();
        this.centerDialog();
    }

    JComponent constructMeasurementTable() {
        this.measurementTableModel = new MeasurementTableModel();
        this.measurementTable = new JTable(this.measurementTableModel);
        this.measurementTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.measurementTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int n = 5;
        while (--n > 0) {
            this.measurementTable.getColumnModel().getColumn(n).setPreferredWidth(15);
        }
        this.measurementTable.setSelectionMode(0);
        this.measurementTable.setRowSelectionAllowed(true);
        this.measurementTable.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.measurementTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    MeasurementTable.this.selectedMeasurementRow = -1;
                    MeasurementTable.this.deleteButton.setEnabled(false);
                } else {
                    MeasurementTable.this.selectedMeasurementRow = listSelectionModel.getMinSelectionIndex();
                    MeasurementTable.this.deleteButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.measurementTable);
    }

    JComponent constructMeasurementButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.deleteButton = new JButton(GT._("Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.vwr.script("measures delete " + (MeasurementTable.this.selectedMeasurementRow + 1) + "\u0001## EDITOR_IGNORE ##");
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteAllButton = new JButton(GT._("DeleteAll"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.vwr.script("measures delete\u0001## EDITOR_IGNORE ##");
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteAllButton.setEnabled(false);
        jPanel.add(this.deleteAllButton);
        jPanel.add(this.deleteButton);
        return jPanel;
    }

    JComponent constructDismissButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(GT._("Dismiss"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.close();
            }
        });
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateMeasurementTableData();
        this.setVisible(true);
    }

    void updateMeasurementTableData() {
        this.deleteAllButton.setEnabled(this.vwr.getMeasurementCount() > 0);
        this.measurementTableModel.fireTableDataChanged();
    }

    public void updateTables() {
        this.updateMeasurementTableData();
    }

    class MeasurementTableModel
    extends AbstractTableModel {
        final String[] measurementHeaders = new String[]{GT._("Value"), "a", "b", "c", "d"};

        MeasurementTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return this.measurementHeaders[n];
        }

        @Override
        public int getRowCount() {
            return MeasurementTable.this.vwr.getMeasurementCount();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class<? extends String> getColumnClass(int n) {
            return MeasurementTable.this.stringClass;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                MeasurementTable.this.deleteAllButton.setEnabled(true);
                return MeasurementTable.this.vwr.getMeasurementStringValue(n);
            }
            int[] nArray = MeasurementTable.this.vwr.getMeasurementCountPlusIndices(n);
            if (nArray == null || n2 > nArray[0]) {
                return null;
            }
            int n3 = nArray[n2];
            return MeasurementTable.this.vwr.getAtomInfo(n3 >= 0 ? n3 : -n * 10 - n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class MeasurementListWindowListener
    extends WindowAdapter {
        MeasurementListWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            MeasurementTable.this.close();
        }
    }
}

