/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.DF;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.CBK;
import org.jmol.c.STR;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class GlobalSettings {
    private final Viewer vwr;
    Map<String, Object> htNonbooleanParameterValues;
    Map<String, Boolean> htBooleanParameterFlags;
    Map<String, Boolean> htPropertyFlagsRemoved;
    Map<String, SV> htUserVariables = new Hashtable<String, SV>();
    Map<String, String> databases;
    int zDepth = 0;
    int zShadePower = 3;
    int zSlab = 50;
    boolean slabByMolecule = false;
    boolean slabByAtom = false;
    boolean allowEmbeddedScripts = true;
    public boolean appendNew = true;
    String appletProxy = "";
    boolean applySymmetryToBonds = false;
    String atomTypes = "";
    boolean autoBond = true;
    boolean axesOrientationRasmol = false;
    short bondRadiusMilliAngstroms = (short)150;
    float bondTolerance = 0.45f;
    String defaultDirectory = "";
    boolean defaultStructureDSSP = true;
    final P3 ptDefaultLattice = new P3();
    public String defaultLoadScript = "";
    public String defaultLoadFilter = "";
    public String defaultDropScript = "zap; load SYNC \"%FILE\";if (%ALLOWCARTOONS && _loadScript == '' && defaultLoadScript == '' && _filetype == 'Pdb') {if ({(protein or nucleic)&*/1.1} && {*/1.1}[1].groupindex != {*/1.1}[0].groupindex){select protein or nucleic;cartoons only;}if ({visible}){color structure}else{wireframe -0.1};if (!{visible}){spacefill 23%};select *}";
    boolean forceAutoBond = false;
    boolean fractionalRelative = true;
    char inlineNewlineChar = (char)124;
    String loadFormat;
    String pdbLoadFormat;
    String pdbLoadFormat0;
    String pdbLoadLigandFormat;
    String nmrUrlFormat;
    String nmrPredictFormat;
    String smilesUrlFormat;
    String nihResolverFormat;
    String pubChemFormat;
    String edsUrlFormat = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file.omap";
    String edsUrlFormatDiff = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file_diff.omap";
    String edsUrlCutoff = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file.sfdat";
    float minBondDistance = 0.4f;
    int minPixelSelRadius = 6;
    boolean pdbAddHydrogens = false;
    boolean pdbGetHeader = false;
    boolean pdbSequential = false;
    int percentVdwAtom = 23;
    int smallMoleculeMaxAtoms = 40000;
    boolean smartAromatic = true;
    boolean zeroBasedXyzRasmol = false;
    boolean legacyAutoBonding = false;
    public boolean legacyHAddition = false;
    public boolean legacyJavaFloat = false;
    boolean modulateOccupancy = true;
    boolean allowRotateSelected = false;
    boolean allowMoveAtoms = false;
    boolean solventOn = false;
    String defaultAngleLabel = "%VALUE %UNITS";
    String defaultDistanceLabel = "%VALUE %UNITS";
    String defaultTorsionLabel = "%VALUE %UNITS";
    boolean justifyMeasurements = false;
    boolean measureAllModels = false;
    int minimizationSteps = 100;
    boolean minimizationRefresh = true;
    boolean minimizationSilent = false;
    float minimizationCriterion = 0.001f;
    boolean antialiasDisplay = false;
    boolean antialiasImages = true;
    boolean imageState = true;
    boolean antialiasTranslucent = true;
    boolean displayCellParameters = true;
    boolean dotsSelectedOnly = false;
    boolean dotSurface = true;
    int dotDensity = 3;
    int dotScale = 1;
    int meshScale = 1;
    boolean greyscaleRendering = false;
    boolean isosurfaceKey = false;
    boolean isosurfacePropertySmoothing = true;
    int isosurfacePropertySmoothingPower = 7;
    int platformSpeed = 10;
    public int repaintWaitMs = 1000;
    boolean showHiddenSelectionHalos = false;
    boolean showKeyStrokes = true;
    boolean showMeasurements = true;
    public boolean showTiming = false;
    boolean zoomLarge = true;
    boolean zoomHeight = false;
    String backgroundImageFileName;
    boolean partialDots = false;
    boolean bondModeOr = false;
    boolean hbondsBackbone = false;
    float hbondsAngleMinimum = 90.0f;
    float hbondsDistanceMaximum = 3.25f;
    boolean hbondsRasmol = true;
    boolean hbondsSolid = false;
    public byte modeMultipleBond = (byte)2;
    boolean showHydrogens = true;
    boolean showMultipleBonds = true;
    boolean ssbondsBackbone = false;
    float multipleBondSpacing = -1.0f;
    float multipleBondRadiusFactor = 0.0f;
    boolean multipleBondBananas = false;
    boolean cartoonBaseEdges = false;
    boolean cartoonRockets = false;
    boolean backboneSteps = false;
    boolean cartoonFancy = false;
    boolean cartoonLadders = false;
    boolean cartoonRibose = false;
    boolean chainCaseSensitive = false;
    int hermiteLevel = 0;
    boolean highResolutionFlag = false;
    public boolean rangeSelected = false;
    boolean rasmolHydrogenSetting = true;
    boolean rasmolHeteroSetting = true;
    int ribbonAspectRatio = 16;
    boolean ribbonBorder = false;
    boolean rocketBarrels = false;
    float sheetSmoothing = 1.0f;
    boolean traceAlpha = true;
    boolean translucent = true;
    boolean twistedSheets = false;
    boolean allowGestures = false;
    boolean allowModelkit = true;
    boolean allowMultiTouch = true;
    boolean allowKeyStrokes = false;
    int animationFps = 10;
    boolean atomPicking = true;
    boolean autoFps = false;
    public int axesMode = 0x24000022;
    float axesScale = 2.0f;
    float axesOffset = 0.0f;
    float starWidth = 0.05f;
    boolean bondPicking = false;
    String dataSeparator = "~~~";
    boolean debugScript = false;
    float defaultDrawArrowScale = 0.5f;
    String defaultLabelXYZ = "%a";
    String defaultLabelPDB = "%m%r";
    float defaultTranslucent = 0.5f;
    int delayMaximumMs = 0;
    float dipoleScale = 1.0f;
    float drawFontSize = 14.0f;
    boolean disablePopupMenu = false;
    boolean dragSelected = false;
    boolean drawHover = false;
    boolean drawPicking = false;
    boolean dsspCalcHydrogen = true;
    public String energyUnits = "kJ";
    float exportScale = 1.0f;
    String helpPath = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
    boolean fontScaling = false;
    boolean fontCaching = true;
    String forceField = "MMFF";
    int helixStep = 1;
    boolean hideNameInPopup = false;
    int hoverDelayMs = 500;
    float loadAtomDataTolerance = 0.01f;
    public boolean logCommands = false;
    public boolean logGestures = false;
    public String measureDistanceUnits = "nanometers";
    boolean measurementLabels = true;
    boolean messageStyleChime = false;
    boolean monitorEnergy = false;
    public float modulationScale = 1.0f;
    boolean multiProcessor = true;
    float particleRadius = 20.0f;
    int pickingSpinRate = 10;
    String pickLabel = "";
    float pointGroupDistanceTolerance = 0.2f;
    float pointGroupLinearTolerance = 8.0f;
    public boolean preserveState = true;
    String propertyColorScheme = "roygb";
    String quaternionFrame = "p";
    boolean saveProteinStructureState = true;
    boolean showModVecs = false;
    boolean showUnitCellDetails = true;
    float solventProbeRadius = 1.2f;
    int scriptDelay = 0;
    boolean selectAllModels = true;
    boolean statusReporting = true;
    int strandCountForStrands = 5;
    int strandCountForMeshRibbon = 7;
    int strutSpacing = 6;
    float strutLengthMaximum = 7.0f;
    float strutDefaultRadius = 0.3f;
    boolean strutsMultiple = false;
    boolean useMinimizationThread = true;
    boolean useNumberLocalization = true;
    public boolean useScriptQueue = true;
    public boolean waitForMoveTo = true;
    float vectorScale = 1.0f;
    boolean vectorSymmetry = false;
    boolean vectorsCentered = false;
    int vectorTrail = 0;
    float vibrationPeriod = 1.0f;
    float vibrationScale = 1.0f;
    boolean wireframeRotation = false;
    boolean hideNavigationPoint = false;
    boolean navigationMode = false;
    boolean navigationPeriodic = false;
    float navigationSpeed = 5.0f;
    boolean showNavigationPointAlways = false;
    String stereoState = null;
    boolean modelKitMode = false;
    int[] objColors = new int[7];
    boolean[] objStateOn = new boolean[7];
    int[] objMad10 = new int[7];
    boolean ellipsoidAxes = false;
    boolean ellipsoidDots = false;
    boolean ellipsoidArcs = false;
    boolean ellipsoidArrows = false;
    boolean ellipsoidFill = false;
    boolean ellipsoidBall = true;
    int ellipsoidDotCount = 200;
    float ellipsoidAxisDiameter = 0.02f;
    boolean testFlag1 = false;
    boolean testFlag2 = false;
    boolean testFlag3 = false;
    boolean testFlag4 = false;
    Map<STR, float[]> structureList = new Hashtable<STR, float[]>();
    boolean haveSetStructureList;
    private String[] userDatabases;
    public int bondingVersion;
    private static final String unreportedProperties = (";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;bondingversion;contextdepthmax;debug;debugscript;defaultlatttice;defaults;defaultdropscript;diffusepercent;;exportdrivers;exportscale;_filecaching;_filecache;fontcaching;fontscaling;forcefield;language;legacyautobonding;legacyhaddition;legacyjavafloat;loglevel;logfile;loggestures;logcommands;measurestylechime;loadformat;loadligandformat;smilesurlformat;pubchemformat;nihresolverformat;edsurlformat;edsurlcutoff;multiprocessor;navigationmode;;pathforallfiles;perspectivedepth;phongexponent;perspectivemodel;platformspeed;preservestate;refreshing;repaintwaitms;rotationradius;selectallmodels;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showtiming;showunitcell;slabenabled;slab;slabrange;depth;zshade;zshadepower;specular;specularexponent;specularpercent;celshading;celshadingpower;specularpower;stateversion;statusreporting;stereo;stereostate;vibrationperiod;unitcellcolor;visualrange;windowcentered;zerobasedxyzrasmol;zoomenabled;mousedragfactor;mousewheelfactor;scriptqueue;scriptreportinglevel;syncscript;syncmouse;syncstereo;defaultdirectory;currentlocalpath;defaultdirectorylocal;ambient;bonds;colorrasmol;diffuse;fractionalrelative;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;navx;navy;navz;navfps;" + CBK.getNameList() + ";undo;atompicking;drawpicking;bondpicking;pickspinrate;picklabel" + ";modelkitmode;allowgestures;allowkeystrokes;allowmultitouch;allowmodelkit" + ";dodrop;hovered;historylevel;imagestate;iskiosk;useminimizationthread" + ";showkeystrokes;saveproteinstructurestate;testflag1;testflag2;testflag3;testflag4" + ";").toLowerCase();

    GlobalSettings(Viewer viewer, GlobalSettings globalSettings, boolean bl) {
        this.structureList.put(STR.TURN, new float[]{30.0f, 90.0f, -15.0f, 95.0f});
        this.structureList.put(STR.SHEET, new float[]{-180.0f, -10.0f, 70.0f, 180.0f, -180.0f, -45.0f, -180.0f, -130.0f, 140.0f, 180.0f, 90.0f, 180.0f});
        this.structureList.put(STR.HELIX, new float[]{-160.0f, 0.0f, -100.0f, 45.0f});
        this.bondingVersion = 0;
        this.vwr = viewer;
        this.htNonbooleanParameterValues = new Hashtable<String, Object>();
        this.htBooleanParameterFlags = new Hashtable<String, Boolean>();
        this.htPropertyFlagsRemoved = new Hashtable<String, Boolean>();
        if (globalSettings != null) {
            if (!bl) {
                this.htUserVariables = globalSettings.htUserVariables;
            }
            this.debugScript = globalSettings.debugScript;
            this.disablePopupMenu = globalSettings.disablePopupMenu;
            this.messageStyleChime = globalSettings.messageStyleChime;
            this.defaultDirectory = globalSettings.defaultDirectory;
            this.allowGestures = globalSettings.allowGestures;
            this.allowModelkit = globalSettings.allowModelkit;
            this.allowMultiTouch = globalSettings.allowMultiTouch;
            this.allowKeyStrokes = globalSettings.allowKeyStrokes;
            this.legacyAutoBonding = globalSettings.legacyAutoBonding;
            this.legacyHAddition = globalSettings.legacyHAddition;
            this.legacyJavaFloat = globalSettings.legacyJavaFloat;
            this.bondingVersion = globalSettings.bondingVersion;
            this.platformSpeed = globalSettings.platformSpeed;
            this.useScriptQueue = globalSettings.useScriptQueue;
            this.databases = globalSettings.databases;
            this.showTiming = globalSettings.showTiming;
            this.wireframeRotation = globalSettings.wireframeRotation;
            this.testFlag1 = globalSettings.testFlag1;
            this.testFlag2 = globalSettings.testFlag2;
            this.testFlag3 = globalSettings.testFlag3;
            this.testFlag4 = globalSettings.testFlag4;
        }
        if (this.databases == null) {
            this.databases = new Hashtable<String, String>();
            this.getDataBaseList(JC.databases);
            this.getDataBaseList(this.userDatabases);
        }
        this.loadFormat = this.pdbLoadFormat = this.databases.get("pdb");
        this.pdbLoadFormat0 = this.databases.get("pdb0");
        this.pdbLoadLigandFormat = this.databases.get("ligand");
        this.nmrUrlFormat = this.databases.get("nmr");
        this.nmrPredictFormat = this.databases.get("nmrdb");
        this.smilesUrlFormat = this.databases.get("nci") + "/file?format=sdf&get3d=True";
        this.nihResolverFormat = this.databases.get("nci");
        this.pubChemFormat = this.databases.get("pubchem");
        for (CBK cBK : CBK.values()) {
            this.resetValue(cBK.name() + "Callback", globalSettings);
        }
        this.setF("cameraDepth", 3.0f);
        this.setI("contextDepthMax", 100);
        this.setI("depth", 0);
        this.setF("gestureSwipeFactor", 1.0f);
        this.setB("hideNotSelected", false);
        this.setI("historyLevel", 0);
        this.setO("hoverLabel", "");
        this.setB("isKiosk", viewer.isKiosk());
        this.setO("logFile", viewer.getLogFileName());
        this.setI("logLevel", Logger.getLogLevel());
        this.setF("mouseWheelFactor", 1.15f);
        this.setF("mouseDragFactor", 1.0f);
        this.setI("navFps", 10);
        this.setI("navigationDepth", 0);
        this.setI("navigationSlab", 0);
        this.setI("navX", 0);
        this.setI("navY", 0);
        this.setI("navZ", 0);
        this.setO("pathForAllFiles", "");
        this.setB("perspectiveDepth", true);
        this.setI("perspectiveModel", 11);
        this.setO("picking", "identify");
        this.setO("pickingStyle", "toggle");
        this.setB("refreshing", true);
        this.setI("rotationRadius", 0);
        this.setI("scaleAngstromsPerInch", 0);
        this.setI("scriptReportingLevel", 0);
        this.setB("selectionHalos", false);
        this.setB("showaxes", false);
        this.setB("showboundbox", false);
        this.setB("showfrank", false);
        this.setB("showUnitcell", false);
        this.setI("slab", 100);
        this.setB("slabEnabled", false);
        this.setF("slabrange", 0.0f);
        this.setI("spinX", 0);
        this.setI("spinY", 30);
        this.setI("spinZ", 0);
        this.setI("spinFps", 30);
        this.setF("visualRange", 5.0f);
        this.setI("stereoDegrees", -5);
        this.setB("syncScript", viewer.sm.syncingScripts);
        this.setB("syncMouse", viewer.sm.syncingMouse);
        this.setB("syncStereo", viewer.sm.stereoSync);
        this.setB("windowCentered", true);
        this.setB("zoomEnabled", true);
        this.setI("_version", JC.versionInt);
        this.setO("_versionDate", Viewer.getJmolVersion());
        this.setB("axesWindow", true);
        this.setB("axesMolecular", false);
        this.setB("axesPosition", false);
        this.setB("axesUnitcell", false);
        this.setI("backgroundModel", 0);
        this.setB("colorRasmol", false);
        this.setO("currentLocalPath", "");
        this.setO("defaultLattice", "{0 0 0}");
        this.setO("defaultColorScheme", "Jmol");
        this.setO("defaultDirectoryLocal", "");
        this.setO("defaults", "Jmol");
        this.setO("defaultVDW", "Jmol");
        this.setO("exportDrivers", "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj");
        this.setI("propertyAtomNumberColumnCount", 0);
        this.setI("propertyAtomNumberField", 0);
        this.setI("propertyDataColumnCount", 0);
        this.setI("propertyDataField", 0);
        this.setB("undo", true);
        this.setB("allowEmbeddedScripts", this.allowEmbeddedScripts);
        this.setB("allowGestures", this.allowGestures);
        this.setB("allowKeyStrokes", this.allowKeyStrokes);
        this.setB("allowModelkit", this.allowModelkit);
        this.setB("allowMultiTouch", this.allowMultiTouch);
        this.setB("allowRotateSelected", this.allowRotateSelected);
        this.setB("allowMoveAtoms", this.allowMoveAtoms);
        this.setI("animationFps", this.animationFps);
        this.setB("antialiasImages", this.antialiasImages);
        this.setB("antialiasDisplay", this.antialiasDisplay);
        this.setB("antialiasTranslucent", this.antialiasTranslucent);
        this.setB("appendNew", this.appendNew);
        this.setO("appletProxy", this.appletProxy);
        this.setB("applySymmetryToBonds", this.applySymmetryToBonds);
        this.setB("atomPicking", this.atomPicking);
        this.setO("atomTypes", this.atomTypes);
        this.setB("autoBond", this.autoBond);
        this.setB("autoFps", this.autoFps);
        this.setI("axesMode", this.axesMode == 0x24000020 ? 2 : (this.axesMode == 603979804 ? 1 : 0));
        this.setF("axesScale", this.axesScale);
        this.setF("axesOffset", this.axesOffset);
        this.setB("axesOrientationRasmol", this.axesOrientationRasmol);
        this.setB("backboneSteps", this.backboneSteps);
        this.setB("bondModeOr", this.bondModeOr);
        this.setB("bondPicking", this.bondPicking);
        this.setI("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
        this.setF("bondTolerance", this.bondTolerance);
        this.setB("cartoonBaseEdges", this.cartoonBaseEdges);
        this.setB("cartoonFancy", this.cartoonFancy);
        this.setB("cartoonLadders", this.cartoonLadders);
        this.setB("cartoonLadders", this.cartoonRibose);
        this.setB("cartoonRockets", this.cartoonRockets);
        this.setB("chainCaseSensitive", this.chainCaseSensitive);
        this.setI("bondingVersion", this.bondingVersion);
        this.setO("dataSeparator", this.dataSeparator);
        this.setB("debugScript", this.debugScript);
        this.setO("defaultAngleLabel", this.defaultAngleLabel);
        this.setF("defaultDrawArrowScale", this.defaultDrawArrowScale);
        this.setO("defaultDirectory", this.defaultDirectory);
        this.setO("defaultDistanceLabel", this.defaultDistanceLabel);
        this.setO("defaultDropScript", this.defaultDropScript);
        this.setO("defaultLabelPDB", this.defaultLabelPDB);
        this.setO("defaultLabelXYZ", this.defaultLabelXYZ);
        this.setO("defaultLoadFilter", this.defaultLoadFilter);
        this.setO("defaultLoadScript", this.defaultLoadScript);
        this.setB("defaultStructureDSSP", this.defaultStructureDSSP);
        this.setO("defaultTorsionLabel", this.defaultTorsionLabel);
        this.setF("defaultTranslucent", this.defaultTranslucent);
        this.setI("delayMaximumMs", this.delayMaximumMs);
        this.setF("dipoleScale", this.dipoleScale);
        this.setB("disablePopupMenu", this.disablePopupMenu);
        this.setB("displayCellParameters", this.displayCellParameters);
        this.setI("dotDensity", this.dotDensity);
        this.setI("dotScale", this.dotScale);
        this.setB("dotsSelectedOnly", this.dotsSelectedOnly);
        this.setB("dotSurface", this.dotSurface);
        this.setB("dragSelected", this.dragSelected);
        this.setB("drawHover", this.drawHover);
        this.setF("drawFontSize", this.drawFontSize);
        this.setB("drawPicking", this.drawPicking);
        this.setB("dsspCalculateHydrogenAlways", this.dsspCalcHydrogen);
        this.setO("edsUrlFormat", this.edsUrlFormat);
        this.setO("edsUrlFormatDiff", this.edsUrlFormatDiff);
        this.setO("edsUrlCutoff", this.edsUrlCutoff);
        this.setB("ellipsoidArcs", this.ellipsoidArcs);
        this.setB("ellipsoidArrows", this.ellipsoidArrows);
        this.setB("ellipsoidAxes", this.ellipsoidAxes);
        this.setF("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
        this.setB("ellipsoidBall", this.ellipsoidBall);
        this.setI("ellipsoidDotCount", this.ellipsoidDotCount);
        this.setB("ellipsoidDots", this.ellipsoidDots);
        this.setB("ellipsoidFill", this.ellipsoidFill);
        this.setO("energyUnits", this.energyUnits);
        this.setF("exportScale", this.exportScale);
        this.setB("fontScaling", this.fontScaling);
        this.setB("fontCaching", this.fontCaching);
        this.setB("forceAutoBond", this.forceAutoBond);
        this.setO("forceField", this.forceField);
        this.setB("fractionalRelative", this.fractionalRelative);
        this.setF("particleRadius", this.particleRadius);
        this.setB("greyscaleRendering", this.greyscaleRendering);
        this.setF("hbondsAngleMinimum", this.hbondsAngleMinimum);
        this.setF("hbondsDistanceMaximum", this.hbondsDistanceMaximum);
        this.setB("hbondsBackbone", this.hbondsBackbone);
        this.setB("hbondsRasmol", this.hbondsRasmol);
        this.setB("hbondsSolid", this.hbondsSolid);
        this.setI("helixStep", this.helixStep);
        this.setO("helpPath", this.helpPath);
        this.setI("hermiteLevel", this.hermiteLevel);
        this.setB("hideNameInPopup", this.hideNameInPopup);
        this.setB("hideNavigationPoint", this.hideNavigationPoint);
        this.setB("highResolution", this.highResolutionFlag);
        this.setF("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
        this.setB("imageState", this.imageState);
        this.setB("isosurfaceKey", this.isosurfaceKey);
        this.setB("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
        this.setI("isosurfacePropertySmoothingPower", this.isosurfacePropertySmoothingPower);
        this.setB("justifyMeasurements", this.justifyMeasurements);
        this.setB("legacyAutoBonding", this.legacyAutoBonding);
        this.setB("legacyHAddition", this.legacyHAddition);
        this.setB("legacyJavaFloat", this.legacyJavaFloat);
        this.setF("loadAtomDataTolerance", this.loadAtomDataTolerance);
        this.setO("loadFormat", this.loadFormat);
        this.setO("loadLigandFormat", this.pdbLoadLigandFormat);
        this.setB("logCommands", this.logCommands);
        this.setB("logGestures", this.logGestures);
        this.setB("measureAllModels", this.measureAllModels);
        this.setB("measurementLabels", this.measurementLabels);
        this.setO("measurementUnits", this.measureDistanceUnits);
        this.setI("meshScale", this.meshScale);
        this.setB("messageStyleChime", this.messageStyleChime);
        this.setF("minBondDistance", this.minBondDistance);
        this.setI("minPixelSelRadius", this.minPixelSelRadius);
        this.setI("minimizationSteps", this.minimizationSteps);
        this.setB("minimizationRefresh", this.minimizationRefresh);
        this.setB("minimizationSilent", this.minimizationSilent);
        this.setF("minimizationCriterion", this.minimizationCriterion);
        this.setB("modelKitMode", this.modelKitMode);
        this.setF("modulationScale", this.modulationScale);
        this.setB("monitorEnergy", this.monitorEnergy);
        this.setF("multipleBondRadiusFactor", this.multipleBondRadiusFactor);
        this.setB("multipleBondBananas", this.multipleBondBananas);
        this.setF("multipleBondSpacing", this.multipleBondSpacing);
        this.setB("multiProcessor", this.multiProcessor && Viewer.nProcessors > 1);
        this.setB("navigationMode", this.navigationMode);
        this.setB("navigationPeriodic", this.navigationPeriodic);
        this.setF("navigationSpeed", this.navigationSpeed);
        this.setO("nmrPredictFormat", this.nmrPredictFormat);
        this.setO("nmrUrlFormat", this.nmrUrlFormat);
        this.setB("partialDots", this.partialDots);
        this.setB("pdbAddHydrogens", this.pdbAddHydrogens);
        this.setB("pdbGetHeader", this.pdbGetHeader);
        this.setB("pdbSequential", this.pdbSequential);
        this.setI("percentVdwAtom", this.percentVdwAtom);
        this.setI("pickingSpinRate", this.pickingSpinRate);
        this.setO("pickLabel", this.pickLabel);
        this.setI("platformSpeed", this.platformSpeed);
        this.setF("pointGroupLinearTolerance", this.pointGroupLinearTolerance);
        this.setF("pointGroupDistanceTolerance", this.pointGroupDistanceTolerance);
        this.setB("preserveState", this.preserveState);
        this.setO("propertyColorScheme", this.propertyColorScheme);
        this.setO("quaternionFrame", this.quaternionFrame);
        this.setB("rangeSelected", this.rangeSelected);
        this.setI("repaintWaitMs", this.repaintWaitMs);
        this.setI("ribbonAspectRatio", this.ribbonAspectRatio);
        this.setB("ribbonBorder", this.ribbonBorder);
        this.setB("rocketBarrels", this.rocketBarrels);
        this.setB("saveProteinStructureState", this.saveProteinStructureState);
        this.setB("scriptqueue", this.useScriptQueue);
        this.setB("selectAllModels", this.selectAllModels);
        this.setB("selectHetero", this.rasmolHeteroSetting);
        this.setB("selectHydrogen", this.rasmolHydrogenSetting);
        this.setF("sheetSmoothing", this.sheetSmoothing);
        this.setB("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
        this.setB("showHydrogens", this.showHydrogens);
        this.setB("showKeyStrokes", this.showKeyStrokes);
        this.setB("showMeasurements", this.showMeasurements);
        this.setB("showModulationVectors", this.showModVecs);
        this.setB("showMultipleBonds", this.showMultipleBonds);
        this.setB("showNavigationPointAlways", this.showNavigationPointAlways);
        this.setI("showScript", this.scriptDelay);
        this.setB("showtiming", this.showTiming);
        this.setB("slabByMolecule", this.slabByMolecule);
        this.setB("slabByAtom", this.slabByAtom);
        this.setB("smartAromatic", this.smartAromatic);
        this.setI("smallMoleculeMaxAtoms", this.smallMoleculeMaxAtoms);
        this.setO("smilesUrlFormat", this.smilesUrlFormat);
        this.setO("nihResolverFormat", this.nihResolverFormat);
        this.setO("pubChemFormat", this.pubChemFormat);
        this.setB("showUnitCellDetails", this.showUnitCellDetails);
        this.setB("solventProbe", this.solventOn);
        this.setF("solventProbeRadius", this.solventProbeRadius);
        this.setB("ssbondsBackbone", this.ssbondsBackbone);
        this.setF("starWidth", this.starWidth);
        this.setB("statusReporting", this.statusReporting);
        this.setI("strandCount", this.strandCountForStrands);
        this.setI("strandCountForStrands", this.strandCountForStrands);
        this.setI("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
        this.setF("strutDefaultRadius", this.strutDefaultRadius);
        this.setF("strutLengthMaximum", this.strutLengthMaximum);
        this.setI("strutSpacing", this.strutSpacing);
        this.setB("strutsMultiple", this.strutsMultiple);
        this.setB("testFlag1", this.testFlag1);
        this.setB("testFlag2", this.testFlag2);
        this.setB("testFlag3", this.testFlag3);
        this.setB("testFlag4", this.testFlag4);
        this.setB("traceAlpha", this.traceAlpha);
        this.setB("translucent", this.translucent);
        this.setB("twistedSheets", this.twistedSheets);
        this.setB("useMinimizationThread", this.useMinimizationThread);
        this.setB("useNumberLocalization", this.useNumberLocalization);
        this.setB("vectorsCentered", this.vectorsCentered);
        this.setF("vectorScale", this.vectorScale);
        this.setB("vectorSymmetry", this.vectorSymmetry);
        this.setI("vectorTrail", this.vectorTrail);
        this.setF("vibrationPeriod", this.vibrationPeriod);
        this.setF("vibrationScale", this.vibrationScale);
        this.setB("waitForMoveTo", this.waitForMoveTo);
        this.setB("wireframeRotation", this.wireframeRotation);
        this.setI("zDepth", this.zDepth);
        this.setB("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
        this.setB("zoomHeight", this.zoomHeight);
        this.setB("zoomLarge", this.zoomLarge);
        this.setI("zShadePower", this.zShadePower);
        this.setI("zSlab", this.zSlab);
    }

    void clear() {
        Iterator<String> iterator = this.htUserVariables.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.charAt(0) != '@' && !string.startsWith("site_")) continue;
            iterator.remove();
        }
        this.vwr.setPicked(-1);
        this.setI("_atomhovered", -1);
        this.setO("_pickinfo", "");
        this.setB("selectionhalos", false);
        this.setB("hidenotselected", false);
        this.measurementLabels = true;
        this.setB("measurementlabels", true);
        this.drawHover = false;
        this.setB("drawHover", false);
        this.vwr.stm.saveScene("DELETE", null);
    }

    void setUnits(String string) {
        String string2 = this.measureDistanceUnits;
        String string3 = this.energyUnits;
        if (string.equalsIgnoreCase("angstroms")) {
            this.measureDistanceUnits = "angstroms";
        } else if (string.equalsIgnoreCase("nanometers") || string.equalsIgnoreCase("nm")) {
            this.measureDistanceUnits = "nanometers";
        } else if (string.equalsIgnoreCase("picometers") || string.equalsIgnoreCase("pm")) {
            this.measureDistanceUnits = "picometers";
        } else if (string.equalsIgnoreCase("bohr") || string.equalsIgnoreCase("au")) {
            this.measureDistanceUnits = "au";
        } else if (string.equalsIgnoreCase("vanderwaals") || string.equalsIgnoreCase("vdw")) {
            this.measureDistanceUnits = "vdw";
        } else if (string.toLowerCase().endsWith("hz") || string.toLowerCase().endsWith("khz")) {
            this.measureDistanceUnits = string.toLowerCase();
        } else if (string.equalsIgnoreCase("kj")) {
            this.energyUnits = "kJ";
        } else if (string.equalsIgnoreCase("kcal")) {
            this.energyUnits = "kcal";
        }
        if (!string2.equalsIgnoreCase(this.measureDistanceUnits)) {
            this.setO("measurementUnits", this.measureDistanceUnits);
        } else if (!string3.equalsIgnoreCase(this.energyUnits)) {
            this.setO("energyUnits", this.energyUnits);
        }
    }

    boolean isJmolVariable(String string) {
        return string.charAt(0) == '_' || this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase()) || this.htBooleanParameterFlags.containsKey(string) || unreportedProperties.indexOf(";" + string + ";") >= 0;
    }

    private void resetValue(String string, GlobalSettings globalSettings) {
        this.setO(string, globalSettings == null ? "" : (String)globalSettings.getParameter(string, true));
    }

    public void setB(String string, boolean bl) {
        if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
            return;
        }
        this.htBooleanParameterFlags.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    void setI(String string, int n) {
        if (n != Integer.MAX_VALUE) {
            this.setO(string, n);
        }
    }

    public void setF(String string, float f) {
        if (!Float.isNaN(f)) {
            this.setO(string, Float.valueOf(f));
        }
    }

    void setO(String string, Object object) {
        string = string.toLowerCase();
        if (object == null || this.htBooleanParameterFlags.containsKey(string)) {
            return;
        }
        this.htNonbooleanParameterValues.put(string, object);
    }

    public void removeParam(String string) {
        if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
            this.htBooleanParameterFlags.remove(string);
            if (!this.htPropertyFlagsRemoved.containsKey(string)) {
                this.htPropertyFlagsRemoved.put(string, Boolean.FALSE);
            }
            return;
        }
        if (this.htNonbooleanParameterValues.containsKey(string)) {
            this.htNonbooleanParameterValues.remove(string);
        }
    }

    public SV setUserVariable(String string, SV sV) {
        if (sV != null) {
            string = string.toLowerCase();
            this.htUserVariables.put(string, sV.setName(string));
        }
        return sV;
    }

    void unsetUserVariable(String string) {
        if (string.equals("all") || string.equals("variables")) {
            this.htUserVariables.clear();
            Logger.info("all user-defined variables deleted");
        } else if (this.htUserVariables.containsKey(string)) {
            Logger.info("variable " + string + " deleted");
            this.htUserVariables.remove(string);
        }
    }

    void removeUserVariable(String string) {
        this.htUserVariables.remove(string);
    }

    SV getUserVariable(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase();
        return this.htUserVariables.get(string);
    }

    String getParameterEscaped(String string, int n) {
        if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
            Object object = this.htNonbooleanParameterValues.get(string);
            return StateManager.varClip(string, Escape.e(object), n);
        }
        if (this.htBooleanParameterFlags.containsKey(string)) {
            return this.htBooleanParameterFlags.get(string).toString();
        }
        if (this.htUserVariables.containsKey(string)) {
            return this.htUserVariables.get(string).escape();
        }
        if (this.htPropertyFlagsRemoved.containsKey(string)) {
            return "false";
        }
        return "<not defined>";
    }

    Object getParameter(String string, boolean bl) {
        Object object = this.getParam(string, false);
        return object == null && bl ? "" : object;
    }

    public SV getAndSetNewVariable(String string, boolean bl) {
        Object object;
        if (string == null || string.length() == 0) {
            string = "x";
        }
        return (object = this.getParam(string, true)) == null && bl && string.charAt(0) != '_' ? this.setUserVariable(string, SV.newV(4, "")) : SV.getVariable(object);
    }

    Object getParam(String string, boolean bl) {
        if ((string = string.toLowerCase()).equals("_memory")) {
            float f = 0.0f;
            float f2 = 0.0f;
            Object object = Runtime.getRuntime();
            f = (float)((Runtime)object).totalMemory() / 1000000.0f;
            f2 = (float)((Runtime)object).freeMemory() / 1000000.0f;
            object = DF.formatDecimal(f - f2, 1) + "/" + DF.formatDecimal(f, 1);
            this.htNonbooleanParameterValues.put("_memory", object);
        }
        if (this.htNonbooleanParameterValues.containsKey(string)) {
            return this.htNonbooleanParameterValues.get(string);
        }
        if (this.htBooleanParameterFlags.containsKey(string)) {
            return this.htBooleanParameterFlags.get(string);
        }
        if (this.htPropertyFlagsRemoved.containsKey(string)) {
            return Boolean.FALSE;
        }
        if (this.htUserVariables.containsKey(string)) {
            SV sV = this.htUserVariables.get(string);
            return bl ? sV : SV.oValue(sV);
        }
        return null;
    }

    public String getVariableList() {
        return StateManager.getVariableList(this.htUserVariables, 0, true, false);
    }

    public void setStructureList(float[] fArray, STR sTR) {
        this.haveSetStructureList = true;
        this.structureList.put(sTR, fArray);
    }

    public Map<STR, float[]> getStructureList() {
        return this.structureList;
    }

    String resolveDataBase(String string, String string2, String string3) {
        int n;
        int n2;
        if (string3 == null) {
            string3 = this.databases.get(string.toLowerCase());
            if (string3 == null) {
                return null;
            }
            n2 = string2.indexOf("/");
            if (n2 < 0) {
                if (string.equals("pubchem")) {
                    string2 = "name/" + string2;
                } else if (string.equals("nci")) {
                    string2 = string2 + "/file?format=sdf&get3d=True";
                }
            }
            if (string3.startsWith("'")) {
                n2 = string2.indexOf(".");
                int n3 = n = n2 > 0 ? PT.parseInt(string2.substring(n2 + 1)) : 0;
                if (n2 > 0) {
                    string2 = string2.substring(0, n2);
                }
                string3 = PT.rep(string3, "%n", "" + n);
            }
        } else if (string2.indexOf(".") >= 0 && string3.indexOf("%FILE.") >= 0) {
            string3 = string3.substring(0, string3.indexOf("%FILE"));
        }
        if (string3.indexOf("%c") >= 0) {
            n = string2.length();
            for (n2 = 1; n2 <= n; ++n2) {
                if (string3.indexOf("%c" + n2) < 0) continue;
                string3 = PT.rep(string3, "%c" + n2, string2.substring(n2 - 1, n2).toLowerCase());
            }
        }
        return string3.indexOf("%FILE") >= 0 ? PT.rep(string3, "%FILE", string2) : (string3.indexOf("%file") >= 0 ? PT.rep(string3, "%file", string2.toLowerCase()) : string3 + string2);
    }

    public String[] fixSurfaceFileNameVariables(String string) {
        boolean bl = string.startsWith("=");
        if (bl) {
            string = string.substring(1);
        }
        String string2 = this.resolveDataBase(null, string, bl ? this.edsUrlFormatDiff : this.edsUrlFormat);
        String string3 = this.resolveDataBase(null, string, this.edsUrlCutoff);
        return new String[]{string2, string3, bl ? "diff" : null};
    }

    static boolean doReportProperty(String string) {
        return string.charAt(0) != '_' && unreportedProperties.indexOf(";" + string + ";") < 0;
    }

    private void getDataBaseList(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            this.databases.put(stringArray[i].toLowerCase(), stringArray[i + 1]);
        }
    }

    Object getAllVariables() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.putAll(this.htBooleanParameterFlags);
        hashtable.putAll(this.htNonbooleanParameterValues);
        hashtable.putAll(this.htUserVariables);
        return hashtable;
    }

    String getLoadState(Map<String, Object> map) {
        SB sB = new SB();
        this.app(sB, "set allowEmbeddedScripts false");
        if (this.allowEmbeddedScripts) {
            this.setB("allowEmbeddedScripts", true);
        }
        this.app(sB, "set appendNew " + this.appendNew);
        this.app(sB, "set appletProxy " + PT.esc(this.appletProxy));
        this.app(sB, "set applySymmetryToBonds " + this.applySymmetryToBonds);
        if (this.atomTypes.length() > 0) {
            this.app(sB, "set atomTypes " + PT.esc(this.atomTypes));
        }
        this.app(sB, "set autoBond " + this.autoBond);
        if (this.axesOrientationRasmol) {
            this.app(sB, "set axesOrientationRasmol true");
        }
        this.app(sB, "set bondRadiusMilliAngstroms " + this.bondRadiusMilliAngstroms);
        this.app(sB, "set bondTolerance " + this.bondTolerance);
        this.app(sB, "set defaultLattice " + Escape.eP(this.ptDefaultLattice));
        this.app(sB, "set defaultLoadFilter " + PT.esc(this.defaultLoadFilter));
        this.app(sB, "set defaultLoadScript \"\"");
        if (this.defaultLoadScript.length() > 0) {
            this.setO("defaultLoadScript", this.defaultLoadScript);
        }
        this.app(sB, "set defaultStructureDssp " + this.defaultStructureDSSP);
        String string = this.vwr.getDefaultVdwNameOrData(Integer.MIN_VALUE, null, null);
        this.app(sB, "set defaultVDW " + string);
        if (string.equals("User")) {
            this.app(sB, this.vwr.getDefaultVdwNameOrData(Integer.MAX_VALUE, null, null));
        }
        this.app(sB, "set forceAutoBond " + this.forceAutoBond);
        this.app(sB, "#set defaultDirectory " + PT.esc(this.defaultDirectory));
        this.app(sB, "#set loadFormat " + PT.esc(this.loadFormat));
        this.app(sB, "#set loadLigandFormat " + PT.esc(this.pdbLoadLigandFormat));
        this.app(sB, "#set smilesUrlFormat " + PT.esc(this.smilesUrlFormat));
        this.app(sB, "#set nihResolverFormat " + PT.esc(this.nihResolverFormat));
        this.app(sB, "#set pubChemFormat " + PT.esc(this.pubChemFormat));
        this.app(sB, "#set edsUrlFormat " + PT.esc(this.edsUrlFormat));
        this.app(sB, "#set edsUrlFormatDiff " + PT.esc(this.edsUrlFormatDiff));
        this.app(sB, "#set edsUrlCutoff " + PT.esc(this.edsUrlCutoff));
        this.app(sB, "set bondingVersion " + this.bondingVersion);
        this.app(sB, "set legacyAutoBonding " + this.legacyAutoBonding);
        this.app(sB, "set legacyHAddition " + this.legacyHAddition);
        this.app(sB, "set legacyJavaFloat " + this.legacyJavaFloat);
        this.app(sB, "set minBondDistance " + this.minBondDistance);
        this.app(sB, "set minimizationCriterion  " + this.minimizationCriterion);
        this.app(sB, "set minimizationSteps  " + this.minimizationSteps);
        this.app(sB, "set multipleBondBananas false");
        this.app(sB, "set pdbAddHydrogens " + (map != null && map.get("pdbNoHydrogens") != Boolean.TRUE ? this.pdbAddHydrogens : false));
        this.app(sB, "set pdbGetHeader " + this.pdbGetHeader);
        this.app(sB, "set pdbSequential " + this.pdbSequential);
        this.app(sB, "set percentVdwAtom " + this.percentVdwAtom);
        this.app(sB, "set smallMoleculeMaxAtoms " + this.smallMoleculeMaxAtoms);
        this.app(sB, "set smartAromatic " + this.smartAromatic);
        if (this.zeroBasedXyzRasmol) {
            this.app(sB, "set zeroBasedXyzRasmol true");
        }
        return sB.toString();
    }

    private void app(SB sB, String string) {
        if (string.length() == 0) {
            return;
        }
        sB.append("  ").append(string).append(";\n");
    }
}

