/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadSelectionDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class UploadSelectionAction
extends JosmAction {
    public UploadSelectionAction() {
        super(I18n.tr("Upload selection", new Object[0]), "uploadselection", I18n.tr("Upload all changes in the current selection to the OSM server.", new Object[0]), Shortcut.registerShortcut("file:uploadSelection", I18n.tr("File: {0}", I18n.tr("Upload selection", new Object[0])), 85, 5010), true);
        this.putValue("help", HelpUtil.ht("/Action/UploadSelection"));
    }

    @Override
    protected void updateEnabledState() {
        if (UploadSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UploadSelectionAction.getCurrentDataSet().getAllSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    protected Set<OsmPrimitive> getDeletedPrimitives(DataSet dataSet) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isVisible() || !osmPrimitive.isModified()) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    protected Set<OsmPrimitive> getModifiedPrimitives(Collection<OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isNewOrUndeleted()) {
                hashSet.add(osmPrimitive);
                continue;
            }
            if (!osmPrimitive.isModified() || osmPrimitive.isIncomplete()) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (UploadSelectionAction.getEditLayer().isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(UploadSelectionAction.getEditLayer())) {
            return;
        }
        Set<OsmPrimitive> set = this.getModifiedPrimitives(UploadSelectionAction.getEditLayer().data.getAllSelected());
        Set<OsmPrimitive> set2 = this.getDeletedPrimitives(UploadSelectionAction.getEditLayer().data);
        if (set.isEmpty() && set2.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        UploadSelectionDialog uploadSelectionDialog = new UploadSelectionDialog();
        uploadSelectionDialog.populate(set, set2);
        uploadSelectionDialog.setVisible(true);
        if (uploadSelectionDialog.isCanceled()) {
            return;
        }
        Set<OsmPrimitive> set3 = new UploadHullBuilder().build(uploadSelectionDialog.getSelectedPrimitives());
        if (set3.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        this.uploadPrimitives(UploadSelectionAction.getEditLayer(), set3);
    }

    protected boolean hasPrimitivesToDelete(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isDeleted() || !osmPrimitive.isModified() || osmPrimitive.isNew()) continue;
            return true;
        }
        return false;
    }

    public void uploadPrimitives(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        UploadHullBuilder uploadHullBuilder = new UploadHullBuilder();
        if (this.hasPrimitivesToDelete(collection = uploadHullBuilder.build(collection))) {
            Main.worker.submit(new DeletedParentsChecker(osmDataLayer, collection));
        } else {
            this.processPostParentChecker(osmDataLayer, collection);
        }
    }

    protected void processPostParentChecker(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        APIDataSet aPIDataSet = new APIDataSet(collection);
        UploadAction uploadAction = new UploadAction();
        uploadAction.uploadData(osmDataLayer, aPIDataSet);
    }

    class DeletedParentsChecker
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Exception lastException;
        private final Collection<OsmPrimitive> toUpload;
        private final OsmDataLayer layer;
        private OsmServerBackreferenceReader reader;

        DeletedParentsChecker(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
            super(I18n.tr("Checking parents for deleted objects", new Object[0]));
            this.toUpload = collection;
            this.layer = osmDataLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            DeletedParentsChecker deletedParentsChecker = this;
            synchronized (deletedParentsChecker) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionUtil.explainException(this.lastException);
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UploadSelectionAction.this.processPostParentChecker(DeletedParentsChecker.this.layer, DeletedParentsChecker.this.toUpload);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected Set<OsmPrimitive> getPrimitivesToCheckForParents() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : this.toUpload) {
                if (!osmPrimitive.isDeleted() || osmPrimitive.isNewOrUndeleted()) continue;
                hashSet.add(osmPrimitive);
            }
            return hashSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Stack<OsmPrimitive> stack = new Stack<OsmPrimitive>();
                stack.addAll(this.getPrimitivesToCheckForParents());
                HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
                while (!stack.isEmpty()) {
                    if (this.canceled) {
                        return;
                    }
                    OsmPrimitive osmPrimitive = (OsmPrimitive)stack.pop();
                    Object object = this;
                    synchronized (object) {
                        this.reader = new OsmServerBackreferenceReader(osmPrimitive);
                    }
                    this.getProgressMonitor().subTask(I18n.tr("Reading parents of ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
                    object = this.reader.parseOsm(this.getProgressMonitor().createSubTaskMonitor(1, false));
                    DeletedParentsChecker deletedParentsChecker = this;
                    synchronized (deletedParentsChecker) {
                        this.reader = null;
                    }
                    hashSet.add(osmPrimitive);
                    this.getProgressMonitor().subTask(I18n.tr("Checking for deleted parents in the local dataset", new Object[0]));
                    for (OsmPrimitive osmPrimitive2 : ((DataSet)object).allPrimitives()) {
                        if (this.canceled) {
                            return;
                        }
                        OsmPrimitive osmPrimitive3 = this.layer.data.getPrimitiveById(osmPrimitive2);
                        if (osmPrimitive3 == null || !osmPrimitive3.isDeleted()) continue;
                        if (!this.toUpload.contains(osmPrimitive3)) {
                            this.toUpload.add(osmPrimitive3);
                        }
                        if (hashSet.contains(osmPrimitive3)) continue;
                        stack.push(osmPrimitive3);
                    }
                }
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                this.lastException = exception;
            }
        }
    }

    static class UploadHullBuilder
    implements Visitor {
        private Set<OsmPrimitive> hull = new HashSet<OsmPrimitive>();

        UploadHullBuilder() {
        }

        @Override
        public void visit(Node node) {
            if (node.isNewOrUndeleted() || node.isModified() || node.isDeleted()) {
                this.hull.add(node);
            }
        }

        @Override
        public void visit(Way way) {
            if (way.isNewOrUndeleted() || way.isModified() || way.isDeleted()) {
                this.hull.add(way);
                for (Node node : way.getNodes()) {
                    node.accept(this);
                }
            }
        }

        @Override
        public void visit(Relation relation) {
            if (relation.isNewOrUndeleted() || relation.isModified() || relation.isDeleted()) {
                this.hull.add(relation);
                for (OsmPrimitive osmPrimitive : relation.getMemberPrimitives()) {
                    if (!osmPrimitive.isNewOrUndeleted()) continue;
                    osmPrimitive.accept(this);
                }
            }
        }

        @Override
        public void visit(Changeset changeset) {
        }

        public Set<OsmPrimitive> build(Collection<OsmPrimitive> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "base");
            this.hull = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : collection) {
                osmPrimitive.accept(this);
            }
            return this.hull;
        }
    }
}

