/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;

public final class Shortcut {
    private final String shortText;
    private String longText;
    private final int requestedKey;
    private final int requestedGroup;
    private int assignedKey;
    private int assignedModifier;
    private boolean assignedDefault;
    private boolean assignedUser;
    private boolean automatic;
    private boolean reset;
    private static Map<String, Shortcut> shortcuts = new LinkedHashMap<String, Shortcut>();
    private static Map<Integer, Integer> groups = new HashMap<Integer, Integer>();
    public static final int NONE = 5000;
    public static final int MNEMONIC = 5001;
    public static final int RESERVED = 5002;
    public static final int DIRECT = 5003;
    public static final int ALT = 5004;
    public static final int SHIFT = 5005;
    public static final int CTRL = 5006;
    public static final int ALT_SHIFT = 5007;
    public static final int ALT_CTRL = 5008;
    public static final int CTRL_SHIFT = 5009;
    public static final int ALT_CTRL_SHIFT = 5010;
    private static int[] mods = new int[]{5008, 5007, 5009, 5010};
    private static int[] keys = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123};
    private static boolean initdone;

    private Shortcut(String string, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.shortText = string;
        this.longText = string2;
        this.requestedKey = n;
        this.requestedGroup = n2;
        this.assignedKey = n3;
        this.assignedModifier = n4;
        this.assignedDefault = bl;
        this.assignedUser = bl2;
        this.automatic = false;
        this.reset = false;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    private void setLongText(String string) {
        this.longText = string;
    }

    public int getAssignedKey() {
        return this.assignedKey;
    }

    public int getAssignedModifier() {
        return this.assignedModifier;
    }

    public boolean isAssignedDefault() {
        return this.assignedDefault;
    }

    public boolean isAssignedUser() {
        return this.assignedUser;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isChangeable() {
        return !this.automatic && !"core:none".equals(this.shortText);
    }

    private boolean isReset() {
        return this.reset;
    }

    public void setAutomatic() {
        this.automatic = true;
    }

    public void setAssignedModifier(int n) {
        this.assignedModifier = n;
    }

    public void setAssignedKey(int n) {
        this.assignedKey = n;
    }

    public void setAssignedUser(boolean bl) {
        boolean bl2 = this.reset = (this.assignedUser || this.reset) && !bl;
        if (bl) {
            this.assignedDefault = false;
        } else if (this.reset) {
            this.assignedKey = this.requestedKey;
            this.assignedModifier = Shortcut.findModifier(this.requestedGroup, null);
        }
        this.assignedUser = bl;
    }

    public KeyStroke getKeyStroke() {
        if (this.assignedModifier != -1) {
            return KeyStroke.getKeyStroke(this.assignedKey, this.assignedModifier);
        }
        return null;
    }

    private Shortcut(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Main.pref.getCollection(string));
        this.shortText = string.substring(15);
        this.longText = (String)arrayList.get(0);
        this.requestedKey = Integer.parseInt((String)arrayList.get(1));
        this.requestedGroup = Integer.parseInt((String)arrayList.get(2));
        this.assignedKey = Integer.parseInt((String)arrayList.get(3));
        this.assignedModifier = Integer.parseInt((String)arrayList.get(4));
        this.assignedDefault = Boolean.parseBoolean((String)arrayList.get(5));
        this.assignedUser = Boolean.parseBoolean((String)arrayList.get(6));
    }

    private void saveDefault() {
        Main.pref.getCollection("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.requestedKey), String.valueOf(Shortcut.getGroupModifier(this.requestedGroup)), String.valueOf(true), String.valueOf(false)));
    }

    private boolean save() {
        if (this.isAutomatic() || this.isReset() || !this.isAssignedUser()) {
            return Main.pref.putCollection("shortcut.entry." + this.shortText, null);
        }
        return Main.pref.putCollection("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.assignedKey), String.valueOf(this.assignedModifier), String.valueOf(this.assignedDefault), String.valueOf(this.assignedUser)));
    }

    private boolean isSame(int n, int n2) {
        return n == this.assignedKey && n2 == this.assignedModifier && this.assignedModifier != Shortcut.getGroupModifier(5000);
    }

    public boolean isEvent(KeyEvent keyEvent) {
        return this.getKeyStroke() != null && this.getKeyStroke().equals(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()));
    }

    public void setMnemonic(JMenu jMenu) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            jMenu.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setMnemonic(AbstractButton abstractButton) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            abstractButton.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setFocusAccelerator(JTextComponent jTextComponent) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            jTextComponent.setFocusAccelerator(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setAccelerator(AbstractAction abstractAction) {
        if (this.getKeyStroke() != null) {
            abstractAction.putValue("AcceleratorKey", this.getKeyStroke());
        }
    }

    public String getKeyText() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + '+' + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public String toString() {
        return this.getKeyText();
    }

    public static Shortcut findShortcut(int n, int n2) {
        if (n2 == Shortcut.getGroupModifier(5000)) {
            return null;
        }
        for (Shortcut shortcut : shortcuts.values()) {
            if (!shortcut.isSame(n, n2)) continue;
            return shortcut;
        }
        return null;
    }

    public static List<Shortcut> listAll() {
        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
        for (Shortcut shortcut : shortcuts.values()) {
            if ("core:none".equals(shortcut.shortText)) continue;
            arrayList.add(shortcut);
        }
        return arrayList;
    }

    private static void doInit() {
        if (initdone) {
            return;
        }
        initdone = true;
        int n = GuiHelper.getMenuShortcutKeyMaskEx();
        groups.put(5000, -1);
        groups.put(5001, 512);
        groups.put(5003, 0);
        groups.put(5004, 512);
        groups.put(5005, 64);
        groups.put(5006, n);
        groups.put(5007, 576);
        groups.put(5008, 0x200 | n);
        groups.put(5009, n | 0x40);
        groups.put(5010, 0x200 | n | 0x40);
        Main.platform.initSystemShortcuts();
        LinkedList<Shortcut> linkedList = new LinkedList<Shortcut>();
        for (String object : Main.pref.getAllPrefixCollectionKeys("shortcut.entry.")) {
            linkedList.add(new Shortcut(object));
        }
        for (Shortcut shortcut : linkedList) {
            if (!shortcut.isAssignedUser() || Shortcut.findShortcut(shortcut.getAssignedKey(), shortcut.getAssignedModifier()) != null) continue;
            shortcuts.put(shortcut.getShortText(), shortcut);
        }
        for (Shortcut shortcut : linkedList) {
            if (shortcut.isAssignedUser() || !shortcut.isAssignedDefault() || Shortcut.findShortcut(shortcut.getAssignedKey(), shortcut.getAssignedModifier()) != null) continue;
            shortcuts.put(shortcut.getShortText(), shortcut);
        }
        for (Shortcut shortcut : linkedList) {
            if (shortcut.isAssignedUser() || shortcut.isAssignedDefault() || Shortcut.findShortcut(shortcut.getAssignedKey(), shortcut.getAssignedModifier()) != null) continue;
            shortcuts.put(shortcut.getShortText(), shortcut);
        }
    }

    private static int getGroupModifier(int n) {
        Integer n2 = groups.get(n);
        if (n2 == null) {
            n2 = -1;
        }
        return n2;
    }

    private static int findModifier(int n, Integer n2) {
        if (n2 == null && (n2 = Integer.valueOf(Shortcut.getGroupModifier(n))) == null) {
            n2 = Shortcut.getGroupModifier(5000);
        }
        return n2;
    }

    public static boolean savePrefs() {
        boolean bl = false;
        for (Shortcut shortcut : shortcuts.values()) {
            bl |= shortcut.save();
        }
        return bl;
    }

    public static Shortcut registerSystemShortcut(String string, String string2, int n, int n2) {
        if (shortcuts.containsKey(string)) {
            return shortcuts.get(string);
        }
        Shortcut shortcut = Shortcut.findShortcut(n, n2);
        if (shortcut != null) {
            Main.error("CONFLICT WITH SYSTEM KEY " + string);
            return null;
        }
        shortcut = new Shortcut(string, string2, n, 5002, n, n2, true, false);
        shortcuts.put(string, shortcut);
        return shortcut;
    }

    public static Shortcut registerShortcut(String string, String string2, int n, int n2) {
        return Shortcut.registerShortcut(string, string2, n, n2, null);
    }

    private static Shortcut registerShortcut(String string, String string2, int n, int n2, Integer n3) {
        Shortcut.doInit();
        if (shortcuts.containsKey(string)) {
            Shortcut shortcut = shortcuts.get(string);
            shortcut.setLongText(string2);
            shortcut.saveDefault();
            return shortcut;
        }
        Integer n4 = Shortcut.findModifier(n2, n3);
        Shortcut shortcut = Shortcut.findShortcut(n, n4);
        if (shortcut != null) {
            int n5;
            if (Main.isPlatformOsx() && Shortcut.findShortcut(n, n5 = Shortcut.findNewOsxModifier(n2)) == null) {
                Main.info("Reassigning OSX shortcut '" + string + "' from Meta to Ctrl because of conflict with " + shortcut);
                return Shortcut.reassignShortcut(string, string2, n, shortcut, n2, n, n5);
            }
            for (int n6 : mods) {
                for (int n7 : keys) {
                    int n8 = Shortcut.getGroupModifier(n6);
                    if (Shortcut.findShortcut(n7, n8) != null) continue;
                    Main.info("Reassigning shortcut '" + string + "' from " + n3 + " to " + n8 + " because of conflict with " + shortcut);
                    return Shortcut.reassignShortcut(string, string2, n, shortcut, n6, n7, n8);
                }
            }
        } else {
            Shortcut shortcut2 = new Shortcut(string, string2, n, n2, n, n4, true, false);
            shortcut2.saveDefault();
            shortcuts.put(string, shortcut2);
            return shortcut2;
        }
        return null;
    }

    private static int findNewOsxModifier(int n) {
        switch (n) {
            case 5006: {
                return 128;
            }
            case 5008: {
                return 640;
            }
            case 5009: {
                return 192;
            }
            case 5010: {
                return 704;
            }
        }
        return 0;
    }

    private static Shortcut reassignShortcut(String string, String string2, int n, Shortcut shortcut, int n2, int n3, int n4) {
        Shortcut shortcut2 = new Shortcut(string, string2, n, n2, n3, n4, false, false);
        Main.info(I18n.tr("Silent shortcut conflict: ''{0}'' moved by ''{1}'' to ''{2}''.", string, shortcut.getShortText(), shortcut2.getKeyText()));
        shortcut2.saveDefault();
        shortcuts.put(string, shortcut2);
        return shortcut2;
    }

    public static KeyStroke getCopyKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:copy");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }

    public static KeyStroke getPasteKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:paste");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }

    public static KeyStroke getCutKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:cut");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }
}

