/*
 * This declarations of the PIC12F1571 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-09-15 14:38:45 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC12F1571_H__
#define __PIC12F1571_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DACCON0_ADDR            0x0118
#define DACCON1_ADDR            0x0119
#define APFCON_ADDR             0x011D
#define APFCON0_ADDR            0x011D
#define ANSELA_ADDR             0x018C
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define WPUA_ADDR               0x020C
#define ODCONA_ADDR             0x028C
#define SLRCONA_ADDR            0x030C
#define INLVLA_ADDR             0x038C
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define CWG1DBR_ADDR            0x0691
#define CWG1DBF_ADDR            0x0692
#define CWG1CON0_ADDR           0x0693
#define CWG1CON1_ADDR           0x0694
#define CWG1CON2_ADDR           0x0695
#define PWMEN_ADDR              0x0D8E
#define PWMLD_ADDR              0x0D8F
#define PWMOUT_ADDR             0x0D90
#define PWM1PH_ADDR             0x0D91
#define PWM1PHL_ADDR            0x0D91
#define PWM1PHH_ADDR            0x0D92
#define PWM1DC_ADDR             0x0D93
#define PWM1DCL_ADDR            0x0D93
#define PWM1DCH_ADDR            0x0D94
#define PWM1PR_ADDR             0x0D95
#define PWM1PRL_ADDR            0x0D95
#define PWM1PRH_ADDR            0x0D96
#define PWM1OF_ADDR             0x0D97
#define PWM1OFL_ADDR            0x0D97
#define PWM1OFH_ADDR            0x0D98
#define PWM1TMR_ADDR            0x0D99
#define PWM1TMRL_ADDR           0x0D99
#define PWM1TMRH_ADDR           0x0D9A
#define PWM1CON_ADDR            0x0D9B
#define PWM1INTCON_ADDR         0x0D9C
#define PWM1INTE_ADDR           0x0D9C
#define PWM1INTF_ADDR           0x0D9D
#define PWM1INTFLG_ADDR         0x0D9D
#define PWM1CLKCON_ADDR         0x0D9E
#define PWM1LDCON_ADDR          0x0D9F
#define PWM1OFCON_ADDR          0x0DA0
#define PWM2PH_ADDR             0x0DA1
#define PWM2PHL_ADDR            0x0DA1
#define PWM2PHH_ADDR            0x0DA2
#define PWM2DC_ADDR             0x0DA3
#define PWM2DCL_ADDR            0x0DA3
#define PWM2DCH_ADDR            0x0DA4
#define PWM2PR_ADDR             0x0DA5
#define PWM2PRL_ADDR            0x0DA5
#define PWM2PRH_ADDR            0x0DA6
#define PWM2OF_ADDR             0x0DA7
#define PWM2OFL_ADDR            0x0DA7
#define PWM2OFH_ADDR            0x0DA8
#define PWM2TMR_ADDR            0x0DA9
#define PWM2TMRL_ADDR           0x0DA9
#define PWM2TMRH_ADDR           0x0DAA
#define PWM2CON_ADDR            0x0DAB
#define PWM2INTE_ADDR           0x0DAC
#define PWM2INTF_ADDR           0x0DAD
#define PWM2CLKCON_ADDR         0x0DAE
#define PWM2LDCON_ADDR          0x0DAF
#define PWM2OFCON_ADDR          0x0DB0
#define PWM3PH_ADDR             0x0DB1
#define PWM3PHL_ADDR            0x0DB1
#define PWM3PHH_ADDR            0x0DB2
#define PWM3DC_ADDR             0x0DB3
#define PWM3DCL_ADDR            0x0DB3
#define PWM3DCH_ADDR            0x0DB4
#define PWM3PR_ADDR             0x0DB5
#define PWM3PRL_ADDR            0x0DB5
#define PWM3PRH_ADDR            0x0DB6
#define PWM3OF_ADDR             0x0DB7
#define PWM3OFL_ADDR            0x0DB7
#define PWM3OFH_ADDR            0x0DB8
#define PWM3TMR_ADDR            0x0DB9
#define PWM3TMRL_ADDR           0x0DB9
#define PWM3TMRH_ADDR           0x0DBA
#define PWM3CON_ADDR            0x0DBB
#define PWM3INTE_ADDR           0x0DBC
#define PWM3INTF_ADDR           0x0DBD
#define PWM3CLKCON_ADDR         0x0DBE
#define PWM3LDCON_ADDR          0x0DBF
#define PWM3OFCON_ADDR          0x0DC0
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0_SHAD_ADDR          0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1_SHAD_ADDR          0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOS_ADDR                0x0FEE
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _C1IF                   0x20

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1IF               : 1;
  unsigned PWM2IF               : 1;
  unsigned PWM3IF               : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _PWM1IF                 0x10
#define _PWM2IF                 0x20
#define _PWM3IF                 0x40

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _C1IE                   0x20

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1IE               : 1;
  unsigned PWM2IE               : 1;
  unsigned PWM3IE               : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _PWM1IE                 0x10
#define _PWM2IE                 0x20
#define _PWM3IE                 0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned                      : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned                    : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C1PCH              : 2;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x10
#define _C1PCH1                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0118) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0118) volatile __DACCON0bits_t DACCON0bits;

#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0119) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0119) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned P1SEL                : 1;
  unsigned P2SEL                : 1;
  unsigned                      : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned CWGBSEL              : 1;
  unsigned CWGASEL              : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _P1SEL                  0x01
#define _P2SEL                  0x02
#define _T1GSEL                 0x08
#define _CWGBSEL                0x20
#define _CWGASEL                0x40

//==============================================================================


//==============================================================================
//        APFCON0 Bits

extern __at(0x011D) __sfr APFCON0;

typedef struct
  {
  unsigned P1SEL                : 1;
  unsigned P2SEL                : 1;
  unsigned                      : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned CWGBSEL              : 1;
  unsigned CWGASEL              : 1;
  unsigned                      : 1;
  } __APFCON0bits_t;

extern __at(0x011D) volatile __APFCON0bits_t APFCON0bits;

#define _APFCON0_P1SEL          0x01
#define _APFCON0_P2SEL          0x02
#define _APFCON0_T1GSEL         0x08
#define _APFCON0_CWGBSEL        0x20
#define _APFCON0_CWGASEL        0x40

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef union
  {
  struct
    {
    unsigned VREGPM0            : 1;
    unsigned VREGPM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned VREGPM             : 2;
    unsigned                    : 6;
    };
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM0                0x01
#define _VREGPM1                0x02

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned                      : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA4                   0x10
#define _ODA5                   0x20

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x0691) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x0691) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _CWG1DBR0               0x01
#define _CWG1DBR1               0x02
#define _CWG1DBR2               0x04
#define _CWG1DBR3               0x08
#define _CWG1DBR4               0x10
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x0692) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x0692) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _CWG1DBF0               0x01
#define _CWG1DBF1               0x02
#define _CWG1DBF2               0x04
#define _CWG1DBF3               0x08
#define _CWG1DBF4               0x10
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0693) __sfr CWG1CON0;

typedef struct
  {
  unsigned G1CS0                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1POLA               : 1;
  unsigned G1POLB               : 1;
  unsigned G1OEA                : 1;
  unsigned G1OEB                : 1;
  unsigned G1EN                 : 1;
  } __CWG1CON0bits_t;

extern __at(0x0693) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _G1CS0                  0x01
#define _G1POLA                 0x08
#define _G1POLB                 0x10
#define _G1OEA                  0x20
#define _G1OEB                  0x40
#define _G1EN                   0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0694) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned G1IS0              : 1;
    unsigned G1IS1              : 1;
    unsigned G1IS2              : 1;
    unsigned                    : 1;
    unsigned G1ASDLA0           : 1;
    unsigned G1ASDLA1           : 1;
    unsigned G1ASDLB0           : 1;
    unsigned G1ASDLB1           : 1;
    };

  struct
    {
    unsigned G1IS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDLA            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned G1ASDLB            : 2;
    };
  } __CWG1CON1bits_t;

extern __at(0x0694) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _G1IS0                  0x01
#define _G1IS1                  0x02
#define _G1IS2                  0x04
#define _G1ASDLA0               0x10
#define _G1ASDLA1               0x20
#define _G1ASDLB0               0x40
#define _G1ASDLB1               0x80

//==============================================================================


//==============================================================================
//        CWG1CON2 Bits

extern __at(0x0695) __sfr CWG1CON2;

typedef struct
  {
  unsigned                      : 1;
  unsigned G1ASDSFLT            : 1;
  unsigned G1ASDSC1             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1ARSEN              : 1;
  unsigned G1ASE                : 1;
  } __CWG1CON2bits_t;

extern __at(0x0695) volatile __CWG1CON2bits_t CWG1CON2bits;

#define _G1ASDSFLT              0x02
#define _G1ASDSC1               0x04
#define _G1ARSEN                0x40
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        PWMEN Bits

extern __at(0x0D8E) __sfr PWMEN;

typedef union
  {
  struct
    {
    unsigned PWM1EN_A           : 1;
    unsigned PWM2EN_A           : 1;
    unsigned PWM3EN_A           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MPWM1EN            : 1;
    unsigned MPWM2EN            : 1;
    unsigned MPWM3EN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWMENbits_t;

extern __at(0x0D8E) volatile __PWMENbits_t PWMENbits;

#define _PWM1EN_A               0x01
#define _MPWM1EN                0x01
#define _PWM2EN_A               0x02
#define _MPWM2EN                0x02
#define _PWM3EN_A               0x04
#define _MPWM3EN                0x04

//==============================================================================


//==============================================================================
//        PWMLD Bits

extern __at(0x0D8F) __sfr PWMLD;

typedef union
  {
  struct
    {
    unsigned PWM1LDA_A          : 1;
    unsigned PWM2LDA_A          : 1;
    unsigned PWM3LDA_A          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MPWM1LD            : 1;
    unsigned MPWM2LD            : 1;
    unsigned MPWM3LD            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWMLDbits_t;

extern __at(0x0D8F) volatile __PWMLDbits_t PWMLDbits;

#define _PWM1LDA_A              0x01
#define _MPWM1LD                0x01
#define _PWM2LDA_A              0x02
#define _MPWM2LD                0x02
#define _PWM3LDA_A              0x04
#define _MPWM3LD                0x04

//==============================================================================


//==============================================================================
//        PWMOUT Bits

extern __at(0x0D90) __sfr PWMOUT;

typedef union
  {
  struct
    {
    unsigned PWM1OUT_A          : 1;
    unsigned PWM2OUT_A          : 1;
    unsigned PWM3OUT_A          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MPWM1OUT           : 1;
    unsigned MPWM2OUT           : 1;
    unsigned MPWM3OUT           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWMOUTbits_t;

extern __at(0x0D90) volatile __PWMOUTbits_t PWMOUTbits;

#define _PWM1OUT_A              0x01
#define _MPWM1OUT               0x01
#define _PWM2OUT_A              0x02
#define _MPWM2OUT               0x02
#define _PWM3OUT_A              0x04
#define _MPWM3OUT               0x04

//==============================================================================

extern __at(0x0D91) __sfr PWM1PH;

//==============================================================================
//        PWM1PHL Bits

extern __at(0x0D91) __sfr PWM1PHL;

typedef struct
  {
  unsigned PWM1PHL0             : 1;
  unsigned PWM1PHL1             : 1;
  unsigned PWM1PHL2             : 1;
  unsigned PWM1PHL3             : 1;
  unsigned PWM1PHL4             : 1;
  unsigned PWM1PHL5             : 1;
  unsigned PWM1PHL6             : 1;
  unsigned PWM1PHL7             : 1;
  } __PWM1PHLbits_t;

extern __at(0x0D91) volatile __PWM1PHLbits_t PWM1PHLbits;

#define _PWM1PHL0               0x01
#define _PWM1PHL1               0x02
#define _PWM1PHL2               0x04
#define _PWM1PHL3               0x08
#define _PWM1PHL4               0x10
#define _PWM1PHL5               0x20
#define _PWM1PHL6               0x40
#define _PWM1PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM1PHH Bits

extern __at(0x0D92) __sfr PWM1PHH;

typedef struct
  {
  unsigned PWM1PHH0             : 1;
  unsigned PWM1PHH1             : 1;
  unsigned PWM1PHH2             : 1;
  unsigned PWM1PHH3             : 1;
  unsigned PWM1PHH4             : 1;
  unsigned PWM1PHH5             : 1;
  unsigned PWM1PHH6             : 1;
  unsigned PWM1PHH7             : 1;
  } __PWM1PHHbits_t;

extern __at(0x0D92) volatile __PWM1PHHbits_t PWM1PHHbits;

#define _PWM1PHH0               0x01
#define _PWM1PHH1               0x02
#define _PWM1PHH2               0x04
#define _PWM1PHH3               0x08
#define _PWM1PHH4               0x10
#define _PWM1PHH5               0x20
#define _PWM1PHH6               0x40
#define _PWM1PHH7               0x80

//==============================================================================

extern __at(0x0D93) __sfr PWM1DC;

//==============================================================================
//        PWM1DCL Bits

extern __at(0x0D93) __sfr PWM1DCL;

typedef struct
  {
  unsigned PWM1DCL0             : 1;
  unsigned PWM1DCL1             : 1;
  unsigned PWM1DCL2             : 1;
  unsigned PWM1DCL3             : 1;
  unsigned PWM1DCL4             : 1;
  unsigned PWM1DCL5             : 1;
  unsigned PWM1DCL6             : 1;
  unsigned PWM1DCL7             : 1;
  } __PWM1DCLbits_t;

extern __at(0x0D93) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x01
#define _PWM1DCL1               0x02
#define _PWM1DCL2               0x04
#define _PWM1DCL3               0x08
#define _PWM1DCL4               0x10
#define _PWM1DCL5               0x20
#define _PWM1DCL6               0x40
#define _PWM1DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0D94) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0D94) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================

extern __at(0x0D95) __sfr PWM1PR;

//==============================================================================
//        PWM1PRL Bits

extern __at(0x0D95) __sfr PWM1PRL;

typedef struct
  {
  unsigned PWM1PRL0             : 1;
  unsigned PWM1PRL1             : 1;
  unsigned PWM1PRL2             : 1;
  unsigned PWM1PRL3             : 1;
  unsigned PWM1PRL4             : 1;
  unsigned PWM1PRL5             : 1;
  unsigned PWM1PRL6             : 1;
  unsigned PWM1PRL7             : 1;
  } __PWM1PRLbits_t;

extern __at(0x0D95) volatile __PWM1PRLbits_t PWM1PRLbits;

#define _PWM1PRL0               0x01
#define _PWM1PRL1               0x02
#define _PWM1PRL2               0x04
#define _PWM1PRL3               0x08
#define _PWM1PRL4               0x10
#define _PWM1PRL5               0x20
#define _PWM1PRL6               0x40
#define _PWM1PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM1PRH Bits

extern __at(0x0D96) __sfr PWM1PRH;

typedef struct
  {
  unsigned PWM1PRH0             : 1;
  unsigned PWM1PRH1             : 1;
  unsigned PWM1PRH2             : 1;
  unsigned PWM1PRH3             : 1;
  unsigned PWM1PRH4             : 1;
  unsigned PWM1PRH5             : 1;
  unsigned PWM1PRH6             : 1;
  unsigned PWM1PRH7             : 1;
  } __PWM1PRHbits_t;

extern __at(0x0D96) volatile __PWM1PRHbits_t PWM1PRHbits;

#define _PWM1PRH0               0x01
#define _PWM1PRH1               0x02
#define _PWM1PRH2               0x04
#define _PWM1PRH3               0x08
#define _PWM1PRH4               0x10
#define _PWM1PRH5               0x20
#define _PWM1PRH6               0x40
#define _PWM1PRH7               0x80

//==============================================================================

extern __at(0x0D97) __sfr PWM1OF;

//==============================================================================
//        PWM1OFL Bits

extern __at(0x0D97) __sfr PWM1OFL;

typedef struct
  {
  unsigned PWM1OFL0             : 1;
  unsigned PWM1OFL1             : 1;
  unsigned PWM1OFL2             : 1;
  unsigned PWM1OFL3             : 1;
  unsigned PWM1OFL4             : 1;
  unsigned PWM1OFL5             : 1;
  unsigned PWM1OFL6             : 1;
  unsigned PWM1OFL7             : 1;
  } __PWM1OFLbits_t;

extern __at(0x0D97) volatile __PWM1OFLbits_t PWM1OFLbits;

#define _PWM1OFL0               0x01
#define _PWM1OFL1               0x02
#define _PWM1OFL2               0x04
#define _PWM1OFL3               0x08
#define _PWM1OFL4               0x10
#define _PWM1OFL5               0x20
#define _PWM1OFL6               0x40
#define _PWM1OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM1OFH Bits

extern __at(0x0D98) __sfr PWM1OFH;

typedef struct
  {
  unsigned PWM1OFH0             : 1;
  unsigned PWM1OFH1             : 1;
  unsigned PWM1OFH2             : 1;
  unsigned PWM1OFH3             : 1;
  unsigned PWM1OFH4             : 1;
  unsigned PWM1OFH5             : 1;
  unsigned PWM1OFH6             : 1;
  unsigned PWM1OFH7             : 1;
  } __PWM1OFHbits_t;

extern __at(0x0D98) volatile __PWM1OFHbits_t PWM1OFHbits;

#define _PWM1OFH0               0x01
#define _PWM1OFH1               0x02
#define _PWM1OFH2               0x04
#define _PWM1OFH3               0x08
#define _PWM1OFH4               0x10
#define _PWM1OFH5               0x20
#define _PWM1OFH6               0x40
#define _PWM1OFH7               0x80

//==============================================================================

extern __at(0x0D99) __sfr PWM1TMR;

//==============================================================================
//        PWM1TMRL Bits

extern __at(0x0D99) __sfr PWM1TMRL;

typedef struct
  {
  unsigned PWM1TMRL0            : 1;
  unsigned PWM1TMRL1            : 1;
  unsigned PWM1TMRL2            : 1;
  unsigned PWM1TMRL3            : 1;
  unsigned PWM1TMRL4            : 1;
  unsigned PWM1TMRL5            : 1;
  unsigned PWM1TMRL6            : 1;
  unsigned PWM1TMRL7            : 1;
  } __PWM1TMRLbits_t;

extern __at(0x0D99) volatile __PWM1TMRLbits_t PWM1TMRLbits;

#define _PWM1TMRL0              0x01
#define _PWM1TMRL1              0x02
#define _PWM1TMRL2              0x04
#define _PWM1TMRL3              0x08
#define _PWM1TMRL4              0x10
#define _PWM1TMRL5              0x20
#define _PWM1TMRL6              0x40
#define _PWM1TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM1TMRH Bits

extern __at(0x0D9A) __sfr PWM1TMRH;

typedef struct
  {
  unsigned PWM1TMRH0            : 1;
  unsigned PWM1TMRH1            : 1;
  unsigned PWM1TMRH2            : 1;
  unsigned PWM1TMRH3            : 1;
  unsigned PWM1TMRH4            : 1;
  unsigned PWM1TMRH5            : 1;
  unsigned PWM1TMRH6            : 1;
  unsigned PWM1TMRH7            : 1;
  } __PWM1TMRHbits_t;

extern __at(0x0D9A) volatile __PWM1TMRHbits_t PWM1TMRHbits;

#define _PWM1TMRH0              0x01
#define _PWM1TMRH1              0x02
#define _PWM1TMRH2              0x04
#define _PWM1TMRH3              0x08
#define _PWM1TMRH4              0x10
#define _PWM1TMRH5              0x20
#define _PWM1TMRH6              0x40
#define _PWM1TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0D9B) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1MODE0          : 1;
    unsigned PWM1MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM1POL            : 1;
    unsigned PWM1OUT            : 1;
    unsigned PWM1OE             : 1;
    unsigned PWM1EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM1MODE           : 2;
    unsigned                    : 4;
    };
  } __PWM1CONbits_t;

extern __at(0x0D9B) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1MODE0              0x04
#define _MODE0                  0x04
#define _PWM1MODE1              0x08
#define _MODE1                  0x08
#define _POL                    0x10
#define _PWM1POL                0x10
#define _OUT                    0x20
#define _PWM1OUT                0x20
#define _OE                     0x40
#define _PWM1OE                 0x40
#define _EN                     0x80
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1INTCON Bits

extern __at(0x0D9C) __sfr PWM1INTCON;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1PRIE           : 1;
    unsigned PWM1DCIE           : 1;
    unsigned PWM1PHIE           : 1;
    unsigned PWM1OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM1INTCONbits_t;

extern __at(0x0D9C) volatile __PWM1INTCONbits_t PWM1INTCONbits;

#define _PRIE                   0x01
#define _PWM1PRIE               0x01
#define _DCIE                   0x02
#define _PWM1DCIE               0x02
#define _PHIE                   0x04
#define _PWM1PHIE               0x04
#define _OFIE                   0x08
#define _PWM1OFIE               0x08

//==============================================================================


//==============================================================================
//        PWM1INTE Bits

extern __at(0x0D9C) __sfr PWM1INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1PRIE           : 1;
    unsigned PWM1DCIE           : 1;
    unsigned PWM1PHIE           : 1;
    unsigned PWM1OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM1INTEbits_t;

extern __at(0x0D9C) volatile __PWM1INTEbits_t PWM1INTEbits;

#define _PWM1INTE_PRIE          0x01
#define _PWM1INTE_PWM1PRIE      0x01
#define _PWM1INTE_DCIE          0x02
#define _PWM1INTE_PWM1DCIE      0x02
#define _PWM1INTE_PHIE          0x04
#define _PWM1INTE_PWM1PHIE      0x04
#define _PWM1INTE_OFIE          0x08
#define _PWM1INTE_PWM1OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM1INTF Bits

extern __at(0x0D9D) __sfr PWM1INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1PRIF           : 1;
    unsigned PWM1DCIF           : 1;
    unsigned PWM1PHIF           : 1;
    unsigned PWM1OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM1INTFbits_t;

extern __at(0x0D9D) volatile __PWM1INTFbits_t PWM1INTFbits;

#define _PRIF                   0x01
#define _PWM1PRIF               0x01
#define _DCIF                   0x02
#define _PWM1DCIF               0x02
#define _PHIF                   0x04
#define _PWM1PHIF               0x04
#define _OFIF                   0x08
#define _PWM1OFIF               0x08

//==============================================================================


//==============================================================================
//        PWM1INTFLG Bits

extern __at(0x0D9D) __sfr PWM1INTFLG;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1PRIF           : 1;
    unsigned PWM1DCIF           : 1;
    unsigned PWM1PHIF           : 1;
    unsigned PWM1OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM1INTFLGbits_t;

extern __at(0x0D9D) volatile __PWM1INTFLGbits_t PWM1INTFLGbits;

#define _PWM1INTFLG_PRIF        0x01
#define _PWM1INTFLG_PWM1PRIF    0x01
#define _PWM1INTFLG_DCIF        0x02
#define _PWM1INTFLG_PWM1DCIF    0x02
#define _PWM1INTFLG_PHIF        0x04
#define _PWM1INTFLG_PWM1PHIF    0x04
#define _PWM1INTFLG_OFIF        0x08
#define _PWM1INTFLG_PWM1OFIF    0x08

//==============================================================================


//==============================================================================
//        PWM1CLKCON Bits

extern __at(0x0D9E) __sfr PWM1CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM1CS0            : 1;
    unsigned PWM1CS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1PS0            : 1;
    unsigned PWM1PS1            : 1;
    unsigned PWM1PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1CS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned CS                 : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM1PS             : 3;
    unsigned                    : 1;
    };
  } __PWM1CLKCONbits_t;

extern __at(0x0D9E) volatile __PWM1CLKCONbits_t PWM1CLKCONbits;

#define _PWM1CLKCON_PWM1CS0     0x01
#define _PWM1CLKCON_CS0         0x01
#define _PWM1CLKCON_PWM1CS1     0x02
#define _PWM1CLKCON_CS1         0x02
#define _PWM1CLKCON_PWM1PS0     0x10
#define _PWM1CLKCON_PS0         0x10
#define _PWM1CLKCON_PWM1PS1     0x20
#define _PWM1CLKCON_PS1         0x20
#define _PWM1CLKCON_PWM1PS2     0x40
#define _PWM1CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM1LDCON Bits

extern __at(0x0D9F) __sfr PWM1LDCON;

typedef union
  {
  struct
    {
    unsigned PWM1LDS0           : 1;
    unsigned PWM1LDS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1LDM            : 1;
    unsigned PWM1LD             : 1;
    };

  struct
    {
    unsigned PWM1LDS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };
  } __PWM1LDCONbits_t;

extern __at(0x0D9F) volatile __PWM1LDCONbits_t PWM1LDCONbits;

#define _PWM1LDS0               0x01
#define _LDS0                   0x01
#define _PWM1LDS1               0x02
#define _LDS1                   0x02
#define _LDT                    0x40
#define _PWM1LDM                0x40
#define _LDA                    0x80
#define _PWM1LD                 0x80

//==============================================================================


//==============================================================================
//        PWM1OFCON Bits

extern __at(0x0DA0) __sfr PWM1OFCON;

typedef union
  {
  struct
    {
    unsigned PWM1OFS0           : 1;
    unsigned PWM1OFS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM1OFM0           : 1;
    unsigned PWM1OFM1           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1OFMC           : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1OFS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM1OFM            : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };
  } __PWM1OFCONbits_t;

extern __at(0x0DA0) volatile __PWM1OFCONbits_t PWM1OFCONbits;

#define _PWM1OFS0               0x01
#define _OFS0                   0x01
#define _PWM1OFS1               0x02
#define _OFS1                   0x02
#define _OFO                    0x10
#define _PWM1OFMC               0x10
#define _PWM1OFM0               0x20
#define _OFM0                   0x20
#define _PWM1OFM1               0x40
#define _OFM1                   0x40

//==============================================================================

extern __at(0x0DA1) __sfr PWM2PH;

//==============================================================================
//        PWM2PHL Bits

extern __at(0x0DA1) __sfr PWM2PHL;

typedef struct
  {
  unsigned PWM2PHL0             : 1;
  unsigned PWM2PHL1             : 1;
  unsigned PWM2PHL2             : 1;
  unsigned PWM2PHL3             : 1;
  unsigned PWM2PHL4             : 1;
  unsigned PWM2PHL5             : 1;
  unsigned PWM2PHL6             : 1;
  unsigned PWM2PHL7             : 1;
  } __PWM2PHLbits_t;

extern __at(0x0DA1) volatile __PWM2PHLbits_t PWM2PHLbits;

#define _PWM2PHL0               0x01
#define _PWM2PHL1               0x02
#define _PWM2PHL2               0x04
#define _PWM2PHL3               0x08
#define _PWM2PHL4               0x10
#define _PWM2PHL5               0x20
#define _PWM2PHL6               0x40
#define _PWM2PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM2PHH Bits

extern __at(0x0DA2) __sfr PWM2PHH;

typedef struct
  {
  unsigned PWM2PHH0             : 1;
  unsigned PWM2PHH1             : 1;
  unsigned PWM2PHH2             : 1;
  unsigned PWM2PHH3             : 1;
  unsigned PWM2PHH4             : 1;
  unsigned PWM2PHH5             : 1;
  unsigned PWM2PHH6             : 1;
  unsigned PWM2PHH7             : 1;
  } __PWM2PHHbits_t;

extern __at(0x0DA2) volatile __PWM2PHHbits_t PWM2PHHbits;

#define _PWM2PHH0               0x01
#define _PWM2PHH1               0x02
#define _PWM2PHH2               0x04
#define _PWM2PHH3               0x08
#define _PWM2PHH4               0x10
#define _PWM2PHH5               0x20
#define _PWM2PHH6               0x40
#define _PWM2PHH7               0x80

//==============================================================================

extern __at(0x0DA3) __sfr PWM2DC;

//==============================================================================
//        PWM2DCL Bits

extern __at(0x0DA3) __sfr PWM2DCL;

typedef struct
  {
  unsigned PWM2DCL0             : 1;
  unsigned PWM2DCL1             : 1;
  unsigned PWM2DCL2             : 1;
  unsigned PWM2DCL3             : 1;
  unsigned PWM2DCL4             : 1;
  unsigned PWM2DCL5             : 1;
  unsigned PWM2DCL6             : 1;
  unsigned PWM2DCL7             : 1;
  } __PWM2DCLbits_t;

extern __at(0x0DA3) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x01
#define _PWM2DCL1               0x02
#define _PWM2DCL2               0x04
#define _PWM2DCL3               0x08
#define _PWM2DCL4               0x10
#define _PWM2DCL5               0x20
#define _PWM2DCL6               0x40
#define _PWM2DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0DA4) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0DA4) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================

extern __at(0x0DA5) __sfr PWM2PR;

//==============================================================================
//        PWM2PRL Bits

extern __at(0x0DA5) __sfr PWM2PRL;

typedef struct
  {
  unsigned PWM2PRL0             : 1;
  unsigned PWM2PRL1             : 1;
  unsigned PWM2PRL2             : 1;
  unsigned PWM2PRL3             : 1;
  unsigned PWM2PRL4             : 1;
  unsigned PWM2PRL5             : 1;
  unsigned PWM2PRL6             : 1;
  unsigned PWM2PRL7             : 1;
  } __PWM2PRLbits_t;

extern __at(0x0DA5) volatile __PWM2PRLbits_t PWM2PRLbits;

#define _PWM2PRL0               0x01
#define _PWM2PRL1               0x02
#define _PWM2PRL2               0x04
#define _PWM2PRL3               0x08
#define _PWM2PRL4               0x10
#define _PWM2PRL5               0x20
#define _PWM2PRL6               0x40
#define _PWM2PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM2PRH Bits

extern __at(0x0DA6) __sfr PWM2PRH;

typedef struct
  {
  unsigned PWM2PRH0             : 1;
  unsigned PWM2PRH1             : 1;
  unsigned PWM2PRH2             : 1;
  unsigned PWM2PRH3             : 1;
  unsigned PWM2PRH4             : 1;
  unsigned PWM2PRH5             : 1;
  unsigned PWM2PRH6             : 1;
  unsigned PWM2PRH7             : 1;
  } __PWM2PRHbits_t;

extern __at(0x0DA6) volatile __PWM2PRHbits_t PWM2PRHbits;

#define _PWM2PRH0               0x01
#define _PWM2PRH1               0x02
#define _PWM2PRH2               0x04
#define _PWM2PRH3               0x08
#define _PWM2PRH4               0x10
#define _PWM2PRH5               0x20
#define _PWM2PRH6               0x40
#define _PWM2PRH7               0x80

//==============================================================================

extern __at(0x0DA7) __sfr PWM2OF;

//==============================================================================
//        PWM2OFL Bits

extern __at(0x0DA7) __sfr PWM2OFL;

typedef struct
  {
  unsigned PWM2OFL0             : 1;
  unsigned PWM2OFL1             : 1;
  unsigned PWM2OFL2             : 1;
  unsigned PWM2OFL3             : 1;
  unsigned PWM2OFL4             : 1;
  unsigned PWM2OFL5             : 1;
  unsigned PWM2OFL6             : 1;
  unsigned PWM2OFL7             : 1;
  } __PWM2OFLbits_t;

extern __at(0x0DA7) volatile __PWM2OFLbits_t PWM2OFLbits;

#define _PWM2OFL0               0x01
#define _PWM2OFL1               0x02
#define _PWM2OFL2               0x04
#define _PWM2OFL3               0x08
#define _PWM2OFL4               0x10
#define _PWM2OFL5               0x20
#define _PWM2OFL6               0x40
#define _PWM2OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM2OFH Bits

extern __at(0x0DA8) __sfr PWM2OFH;

typedef struct
  {
  unsigned PWM2OFH0             : 1;
  unsigned PWM2OFH1             : 1;
  unsigned PWM2OFH2             : 1;
  unsigned PWM2OFH3             : 1;
  unsigned PWM2OFH4             : 1;
  unsigned PWM2OFH5             : 1;
  unsigned PWM2OFH6             : 1;
  unsigned PWM2OFH7             : 1;
  } __PWM2OFHbits_t;

extern __at(0x0DA8) volatile __PWM2OFHbits_t PWM2OFHbits;

#define _PWM2OFH0               0x01
#define _PWM2OFH1               0x02
#define _PWM2OFH2               0x04
#define _PWM2OFH3               0x08
#define _PWM2OFH4               0x10
#define _PWM2OFH5               0x20
#define _PWM2OFH6               0x40
#define _PWM2OFH7               0x80

//==============================================================================

extern __at(0x0DA9) __sfr PWM2TMR;

//==============================================================================
//        PWM2TMRL Bits

extern __at(0x0DA9) __sfr PWM2TMRL;

typedef struct
  {
  unsigned PWM2TMRL0            : 1;
  unsigned PWM2TMRL1            : 1;
  unsigned PWM2TMRL2            : 1;
  unsigned PWM2TMRL3            : 1;
  unsigned PWM2TMRL4            : 1;
  unsigned PWM2TMRL5            : 1;
  unsigned PWM2TMRL6            : 1;
  unsigned PWM2TMRL7            : 1;
  } __PWM2TMRLbits_t;

extern __at(0x0DA9) volatile __PWM2TMRLbits_t PWM2TMRLbits;

#define _PWM2TMRL0              0x01
#define _PWM2TMRL1              0x02
#define _PWM2TMRL2              0x04
#define _PWM2TMRL3              0x08
#define _PWM2TMRL4              0x10
#define _PWM2TMRL5              0x20
#define _PWM2TMRL6              0x40
#define _PWM2TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM2TMRH Bits

extern __at(0x0DAA) __sfr PWM2TMRH;

typedef struct
  {
  unsigned PWM2TMRH0            : 1;
  unsigned PWM2TMRH1            : 1;
  unsigned PWM2TMRH2            : 1;
  unsigned PWM2TMRH3            : 1;
  unsigned PWM2TMRH4            : 1;
  unsigned PWM2TMRH5            : 1;
  unsigned PWM2TMRH6            : 1;
  unsigned PWM2TMRH7            : 1;
  } __PWM2TMRHbits_t;

extern __at(0x0DAA) volatile __PWM2TMRHbits_t PWM2TMRHbits;

#define _PWM2TMRH0              0x01
#define _PWM2TMRH1              0x02
#define _PWM2TMRH2              0x04
#define _PWM2TMRH3              0x08
#define _PWM2TMRH4              0x10
#define _PWM2TMRH5              0x20
#define _PWM2TMRH6              0x40
#define _PWM2TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0DAB) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2MODE0          : 1;
    unsigned PWM2MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM2POL            : 1;
    unsigned PWM2OUT            : 1;
    unsigned PWM2OE             : 1;
    unsigned PWM2EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM2MODE           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PWM2CONbits_t;

extern __at(0x0DAB) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2CON_PWM2MODE0      0x04
#define _PWM2CON_MODE0          0x04
#define _PWM2CON_PWM2MODE1      0x08
#define _PWM2CON_MODE1          0x08
#define _PWM2CON_POL            0x10
#define _PWM2CON_PWM2POL        0x10
#define _PWM2CON_OUT            0x20
#define _PWM2CON_PWM2OUT        0x20
#define _PWM2CON_OE             0x40
#define _PWM2CON_PWM2OE         0x40
#define _PWM2CON_EN             0x80
#define _PWM2CON_PWM2EN         0x80

//==============================================================================


//==============================================================================
//        PWM2INTE Bits

extern __at(0x0DAC) __sfr PWM2INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM2PRIE           : 1;
    unsigned PWM2DCIE           : 1;
    unsigned PWM2PHIE           : 1;
    unsigned PWM2OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM2INTEbits_t;

extern __at(0x0DAC) volatile __PWM2INTEbits_t PWM2INTEbits;

#define _PWM2INTE_PRIE          0x01
#define _PWM2INTE_PWM2PRIE      0x01
#define _PWM2INTE_DCIE          0x02
#define _PWM2INTE_PWM2DCIE      0x02
#define _PWM2INTE_PHIE          0x04
#define _PWM2INTE_PWM2PHIE      0x04
#define _PWM2INTE_OFIE          0x08
#define _PWM2INTE_PWM2OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM2INTF Bits

extern __at(0x0DAD) __sfr PWM2INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM2PRIF           : 1;
    unsigned PWM2DCIF           : 1;
    unsigned PWM2PHIF           : 1;
    unsigned PWM2OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM2INTFbits_t;

extern __at(0x0DAD) volatile __PWM2INTFbits_t PWM2INTFbits;

#define _PWM2INTF_PRIF          0x01
#define _PWM2INTF_PWM2PRIF      0x01
#define _PWM2INTF_DCIF          0x02
#define _PWM2INTF_PWM2DCIF      0x02
#define _PWM2INTF_PHIF          0x04
#define _PWM2INTF_PWM2PHIF      0x04
#define _PWM2INTF_OFIF          0x08
#define _PWM2INTF_PWM2OFIF      0x08

//==============================================================================


//==============================================================================
//        PWM2CLKCON Bits

extern __at(0x0DAE) __sfr PWM2CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM2CS0            : 1;
    unsigned PWM2CS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2PS0            : 1;
    unsigned PWM2PS1            : 1;
    unsigned PWM2PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM2CS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM2PS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };
  } __PWM2CLKCONbits_t;

extern __at(0x0DAE) volatile __PWM2CLKCONbits_t PWM2CLKCONbits;

#define _PWM2CLKCON_PWM2CS0     0x01
#define _PWM2CLKCON_CS0         0x01
#define _PWM2CLKCON_PWM2CS1     0x02
#define _PWM2CLKCON_CS1         0x02
#define _PWM2CLKCON_PWM2PS0     0x10
#define _PWM2CLKCON_PS0         0x10
#define _PWM2CLKCON_PWM2PS1     0x20
#define _PWM2CLKCON_PS1         0x20
#define _PWM2CLKCON_PWM2PS2     0x40
#define _PWM2CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM2LDCON Bits

extern __at(0x0DAF) __sfr PWM2LDCON;

typedef union
  {
  struct
    {
    unsigned PWM2LDS0           : 1;
    unsigned PWM2LDS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2LDM            : 1;
    unsigned PWM2LD             : 1;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM2LDS            : 2;
    unsigned                    : 6;
    };
  } __PWM2LDCONbits_t;

extern __at(0x0DAF) volatile __PWM2LDCONbits_t PWM2LDCONbits;

#define _PWM2LDCON_PWM2LDS0     0x01
#define _PWM2LDCON_LDS0         0x01
#define _PWM2LDCON_PWM2LDS1     0x02
#define _PWM2LDCON_LDS1         0x02
#define _PWM2LDCON_LDT          0x40
#define _PWM2LDCON_PWM2LDM      0x40
#define _PWM2LDCON_LDA          0x80
#define _PWM2LDCON_PWM2LD       0x80

//==============================================================================


//==============================================================================
//        PWM2OFCON Bits

extern __at(0x0DB0) __sfr PWM2OFCON;

typedef union
  {
  struct
    {
    unsigned PWM2OFS0           : 1;
    unsigned PWM2OFS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM2OFM0           : 1;
    unsigned PWM2OFM1           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2OFMC           : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM2OFS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM2OFM            : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };
  } __PWM2OFCONbits_t;

extern __at(0x0DB0) volatile __PWM2OFCONbits_t PWM2OFCONbits;

#define _PWM2OFCON_PWM2OFS0     0x01
#define _PWM2OFCON_OFS0         0x01
#define _PWM2OFCON_PWM2OFS1     0x02
#define _PWM2OFCON_OFS1         0x02
#define _PWM2OFCON_OFO          0x10
#define _PWM2OFCON_PWM2OFMC     0x10
#define _PWM2OFCON_PWM2OFM0     0x20
#define _PWM2OFCON_OFM0         0x20
#define _PWM2OFCON_PWM2OFM1     0x40
#define _PWM2OFCON_OFM1         0x40

//==============================================================================

extern __at(0x0DB1) __sfr PWM3PH;

//==============================================================================
//        PWM3PHL Bits

extern __at(0x0DB1) __sfr PWM3PHL;

typedef struct
  {
  unsigned PWM3PHL0             : 1;
  unsigned PWM3PHL1             : 1;
  unsigned PWM3PHL2             : 1;
  unsigned PWM3PHL3             : 1;
  unsigned PWM3PHL4             : 1;
  unsigned PWM3PHL5             : 1;
  unsigned PWM3PHL6             : 1;
  unsigned PWM3PHL7             : 1;
  } __PWM3PHLbits_t;

extern __at(0x0DB1) volatile __PWM3PHLbits_t PWM3PHLbits;

#define _PWM3PHL0               0x01
#define _PWM3PHL1               0x02
#define _PWM3PHL2               0x04
#define _PWM3PHL3               0x08
#define _PWM3PHL4               0x10
#define _PWM3PHL5               0x20
#define _PWM3PHL6               0x40
#define _PWM3PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM3PHH Bits

extern __at(0x0DB2) __sfr PWM3PHH;

typedef struct
  {
  unsigned PWM3PHH0             : 1;
  unsigned PWM3PHH1             : 1;
  unsigned PWM3PHH2             : 1;
  unsigned PWM3PHH3             : 1;
  unsigned PWM3PHH4             : 1;
  unsigned PWM3PHH5             : 1;
  unsigned PWM3PHH6             : 1;
  unsigned PWM3PHH7             : 1;
  } __PWM3PHHbits_t;

extern __at(0x0DB2) volatile __PWM3PHHbits_t PWM3PHHbits;

#define _PWM3PHH0               0x01
#define _PWM3PHH1               0x02
#define _PWM3PHH2               0x04
#define _PWM3PHH3               0x08
#define _PWM3PHH4               0x10
#define _PWM3PHH5               0x20
#define _PWM3PHH6               0x40
#define _PWM3PHH7               0x80

//==============================================================================

extern __at(0x0DB3) __sfr PWM3DC;

//==============================================================================
//        PWM3DCL Bits

extern __at(0x0DB3) __sfr PWM3DCL;

typedef struct
  {
  unsigned PWM3DCL0             : 1;
  unsigned PWM3DCL1             : 1;
  unsigned PWM3DCL2             : 1;
  unsigned PWM3DCL3             : 1;
  unsigned PWM3DCL4             : 1;
  unsigned PWM3DCL5             : 1;
  unsigned PWM3DCL6             : 1;
  unsigned PWM3DCL7             : 1;
  } __PWM3DCLbits_t;

extern __at(0x0DB3) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _PWM3DCL0               0x01
#define _PWM3DCL1               0x02
#define _PWM3DCL2               0x04
#define _PWM3DCL3               0x08
#define _PWM3DCL4               0x10
#define _PWM3DCL5               0x20
#define _PWM3DCL6               0x40
#define _PWM3DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0DB4) __sfr PWM3DCH;

typedef struct
  {
  unsigned PWM3DCH0             : 1;
  unsigned PWM3DCH1             : 1;
  unsigned PWM3DCH2             : 1;
  unsigned PWM3DCH3             : 1;
  unsigned PWM3DCH4             : 1;
  unsigned PWM3DCH5             : 1;
  unsigned PWM3DCH6             : 1;
  unsigned PWM3DCH7             : 1;
  } __PWM3DCHbits_t;

extern __at(0x0DB4) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _PWM3DCH0               0x01
#define _PWM3DCH1               0x02
#define _PWM3DCH2               0x04
#define _PWM3DCH3               0x08
#define _PWM3DCH4               0x10
#define _PWM3DCH5               0x20
#define _PWM3DCH6               0x40
#define _PWM3DCH7               0x80

//==============================================================================

extern __at(0x0DB5) __sfr PWM3PR;

//==============================================================================
//        PWM3PRL Bits

extern __at(0x0DB5) __sfr PWM3PRL;

typedef struct
  {
  unsigned PWM3PRL0             : 1;
  unsigned PWM3PRL1             : 1;
  unsigned PWM3PRL2             : 1;
  unsigned PWM3PRL3             : 1;
  unsigned PWM3PRL4             : 1;
  unsigned PWM3PRL5             : 1;
  unsigned PWM3PRL6             : 1;
  unsigned PWM3PRL7             : 1;
  } __PWM3PRLbits_t;

extern __at(0x0DB5) volatile __PWM3PRLbits_t PWM3PRLbits;

#define _PWM3PRL0               0x01
#define _PWM3PRL1               0x02
#define _PWM3PRL2               0x04
#define _PWM3PRL3               0x08
#define _PWM3PRL4               0x10
#define _PWM3PRL5               0x20
#define _PWM3PRL6               0x40
#define _PWM3PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM3PRH Bits

extern __at(0x0DB6) __sfr PWM3PRH;

typedef struct
  {
  unsigned PWM3PRH0             : 1;
  unsigned PWM3PRH1             : 1;
  unsigned PWM3PRH2             : 1;
  unsigned PWM3PRH3             : 1;
  unsigned PWM3PRH4             : 1;
  unsigned PWM3PRH5             : 1;
  unsigned PWM3PRH6             : 1;
  unsigned PWM3PRH7             : 1;
  } __PWM3PRHbits_t;

extern __at(0x0DB6) volatile __PWM3PRHbits_t PWM3PRHbits;

#define _PWM3PRH0               0x01
#define _PWM3PRH1               0x02
#define _PWM3PRH2               0x04
#define _PWM3PRH3               0x08
#define _PWM3PRH4               0x10
#define _PWM3PRH5               0x20
#define _PWM3PRH6               0x40
#define _PWM3PRH7               0x80

//==============================================================================

extern __at(0x0DB7) __sfr PWM3OF;

//==============================================================================
//        PWM3OFL Bits

extern __at(0x0DB7) __sfr PWM3OFL;

typedef struct
  {
  unsigned PWM3OFL0             : 1;
  unsigned PWM3OFL1             : 1;
  unsigned PWM3OFL2             : 1;
  unsigned PWM3OFL3             : 1;
  unsigned PWM3OFL4             : 1;
  unsigned PWM3OFL5             : 1;
  unsigned PWM3OFL6             : 1;
  unsigned PWM3OFL7             : 1;
  } __PWM3OFLbits_t;

extern __at(0x0DB7) volatile __PWM3OFLbits_t PWM3OFLbits;

#define _PWM3OFL0               0x01
#define _PWM3OFL1               0x02
#define _PWM3OFL2               0x04
#define _PWM3OFL3               0x08
#define _PWM3OFL4               0x10
#define _PWM3OFL5               0x20
#define _PWM3OFL6               0x40
#define _PWM3OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM3OFH Bits

extern __at(0x0DB8) __sfr PWM3OFH;

typedef struct
  {
  unsigned PWM3OFH0             : 1;
  unsigned PWM3OFH1             : 1;
  unsigned PWM3OFH2             : 1;
  unsigned PWM3OFH3             : 1;
  unsigned PWM3OFH4             : 1;
  unsigned PWM3OFH5             : 1;
  unsigned PWM3OFH6             : 1;
  unsigned PWM3OFH7             : 1;
  } __PWM3OFHbits_t;

extern __at(0x0DB8) volatile __PWM3OFHbits_t PWM3OFHbits;

#define _PWM3OFH0               0x01
#define _PWM3OFH1               0x02
#define _PWM3OFH2               0x04
#define _PWM3OFH3               0x08
#define _PWM3OFH4               0x10
#define _PWM3OFH5               0x20
#define _PWM3OFH6               0x40
#define _PWM3OFH7               0x80

//==============================================================================

extern __at(0x0DB9) __sfr PWM3TMR;

//==============================================================================
//        PWM3TMRL Bits

extern __at(0x0DB9) __sfr PWM3TMRL;

typedef struct
  {
  unsigned PWM3TMRL0            : 1;
  unsigned PWM3TMRL1            : 1;
  unsigned PWM3TMRL2            : 1;
  unsigned PWM3TMRL3            : 1;
  unsigned PWM3TMRL4            : 1;
  unsigned PWM3TMRL5            : 1;
  unsigned PWM3TMRL6            : 1;
  unsigned PWM3TMRL7            : 1;
  } __PWM3TMRLbits_t;

extern __at(0x0DB9) volatile __PWM3TMRLbits_t PWM3TMRLbits;

#define _PWM3TMRL0              0x01
#define _PWM3TMRL1              0x02
#define _PWM3TMRL2              0x04
#define _PWM3TMRL3              0x08
#define _PWM3TMRL4              0x10
#define _PWM3TMRL5              0x20
#define _PWM3TMRL6              0x40
#define _PWM3TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM3TMRH Bits

extern __at(0x0DBA) __sfr PWM3TMRH;

typedef struct
  {
  unsigned PWM3TMRH0            : 1;
  unsigned PWM3TMRH1            : 1;
  unsigned PWM3TMRH2            : 1;
  unsigned PWM3TMRH3            : 1;
  unsigned PWM3TMRH4            : 1;
  unsigned PWM3TMRH5            : 1;
  unsigned PWM3TMRH6            : 1;
  unsigned PWM3TMRH7            : 1;
  } __PWM3TMRHbits_t;

extern __at(0x0DBA) volatile __PWM3TMRHbits_t PWM3TMRHbits;

#define _PWM3TMRH0              0x01
#define _PWM3TMRH1              0x02
#define _PWM3TMRH2              0x04
#define _PWM3TMRH3              0x08
#define _PWM3TMRH4              0x10
#define _PWM3TMRH5              0x20
#define _PWM3TMRH6              0x40
#define _PWM3TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0DBB) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3MODE0          : 1;
    unsigned PWM3MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM3POL            : 1;
    unsigned PWM3OUT            : 1;
    unsigned PWM3OE             : 1;
    unsigned PWM3EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM3MODE           : 2;
    unsigned                    : 4;
    };
  } __PWM3CONbits_t;

extern __at(0x0DBB) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3CON_PWM3MODE0      0x04
#define _PWM3CON_MODE0          0x04
#define _PWM3CON_PWM3MODE1      0x08
#define _PWM3CON_MODE1          0x08
#define _PWM3CON_POL            0x10
#define _PWM3CON_PWM3POL        0x10
#define _PWM3CON_OUT            0x20
#define _PWM3CON_PWM3OUT        0x20
#define _PWM3CON_OE             0x40
#define _PWM3CON_PWM3OE         0x40
#define _PWM3CON_EN             0x80
#define _PWM3CON_PWM3EN         0x80

//==============================================================================


//==============================================================================
//        PWM3INTE Bits

extern __at(0x0DBC) __sfr PWM3INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM3PRIE           : 1;
    unsigned PWM3DCIE           : 1;
    unsigned PWM3PHIE           : 1;
    unsigned PWM3OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM3INTEbits_t;

extern __at(0x0DBC) volatile __PWM3INTEbits_t PWM3INTEbits;

#define _PWM3INTE_PRIE          0x01
#define _PWM3INTE_PWM3PRIE      0x01
#define _PWM3INTE_DCIE          0x02
#define _PWM3INTE_PWM3DCIE      0x02
#define _PWM3INTE_PHIE          0x04
#define _PWM3INTE_PWM3PHIE      0x04
#define _PWM3INTE_OFIE          0x08
#define _PWM3INTE_PWM3OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM3INTF Bits

extern __at(0x0DBD) __sfr PWM3INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM3PRIF           : 1;
    unsigned PWM3DCIF           : 1;
    unsigned PWM3PHIF           : 1;
    unsigned PWM3OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM3INTFbits_t;

extern __at(0x0DBD) volatile __PWM3INTFbits_t PWM3INTFbits;

#define _PWM3INTF_PRIF          0x01
#define _PWM3INTF_PWM3PRIF      0x01
#define _PWM3INTF_DCIF          0x02
#define _PWM3INTF_PWM3DCIF      0x02
#define _PWM3INTF_PHIF          0x04
#define _PWM3INTF_PWM3PHIF      0x04
#define _PWM3INTF_OFIF          0x08
#define _PWM3INTF_PWM3OFIF      0x08

//==============================================================================


//==============================================================================
//        PWM3CLKCON Bits

extern __at(0x0DBE) __sfr PWM3CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM3CS0            : 1;
    unsigned PWM3CS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3PS0            : 1;
    unsigned PWM3PS1            : 1;
    unsigned PWM3PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM3CS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned CS                 : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM3PS             : 3;
    unsigned                    : 1;
    };
  } __PWM3CLKCONbits_t;

extern __at(0x0DBE) volatile __PWM3CLKCONbits_t PWM3CLKCONbits;

#define _PWM3CLKCON_PWM3CS0     0x01
#define _PWM3CLKCON_CS0         0x01
#define _PWM3CLKCON_PWM3CS1     0x02
#define _PWM3CLKCON_CS1         0x02
#define _PWM3CLKCON_PWM3PS0     0x10
#define _PWM3CLKCON_PS0         0x10
#define _PWM3CLKCON_PWM3PS1     0x20
#define _PWM3CLKCON_PS1         0x20
#define _PWM3CLKCON_PWM3PS2     0x40
#define _PWM3CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM3LDCON Bits

extern __at(0x0DBF) __sfr PWM3LDCON;

typedef union
  {
  struct
    {
    unsigned PWM3LDS0           : 1;
    unsigned PWM3LDS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3LDM            : 1;
    unsigned PWM3LD             : 1;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM3LDS            : 2;
    unsigned                    : 6;
    };
  } __PWM3LDCONbits_t;

extern __at(0x0DBF) volatile __PWM3LDCONbits_t PWM3LDCONbits;

#define _PWM3LDCON_PWM3LDS0     0x01
#define _PWM3LDCON_LDS0         0x01
#define _PWM3LDCON_PWM3LDS1     0x02
#define _PWM3LDCON_LDS1         0x02
#define _PWM3LDCON_LDT          0x40
#define _PWM3LDCON_PWM3LDM      0x40
#define _PWM3LDCON_LDA          0x80
#define _PWM3LDCON_PWM3LD       0x80

//==============================================================================


//==============================================================================
//        PWM3OFCON Bits

extern __at(0x0DC0) __sfr PWM3OFCON;

typedef union
  {
  struct
    {
    unsigned PWM3OFS0           : 1;
    unsigned PWM3OFS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM3OFM0           : 1;
    unsigned PWM3OFM1           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3OFMC           : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM3OFS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM3OFM            : 2;
    unsigned                    : 1;
    };
  } __PWM3OFCONbits_t;

extern __at(0x0DC0) volatile __PWM3OFCONbits_t PWM3OFCONbits;

#define _PWM3OFCON_PWM3OFS0     0x01
#define _PWM3OFCON_OFS0         0x01
#define _PWM3OFCON_PWM3OFS1     0x02
#define _PWM3OFCON_OFS1         0x02
#define _PWM3OFCON_OFO          0x10
#define _PWM3OFCON_PWM3OFMC     0x10
#define _PWM3OFCON_PWM3OFM0     0x20
#define _PWM3OFCON_OFM0         0x20
#define _PWM3OFCON_PWM3OFM1     0x40
#define _PWM3OFCON_OFM1         0x40

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE8) __sfr FSR0_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEA) __sfr FSR1_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOS;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator; I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz); device clock supplied to CLKIN pin.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz); device clock supplied to CLKIN pin.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-32 MHz); device clock supplied to CLKIN pin.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 7FFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to 1FFh write protected, 200h to 3FFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 0FFh write protected, 100h to 3FFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PLLEN_OFF              0x3EFF  // 4x PLL disabled.
#define _PLLEN_ON               0x3FFF  // 4x PLL enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_19                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOREN_ON             0x37FF  // LPBOR is enabled.
#define _LPBOREN_OFF            0x3FFF  // LPBOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define P1SEL                   APFCONbits.P1SEL                // bit 0
#define P2SEL                   APFCONbits.P2SEL                // bit 1
#define T1GSEL                  APFCONbits.T1GSEL               // bit 3
#define CWGBSEL                 APFCONbits.CWGBSEL              // bit 5
#define CWGASEL                 APFCONbits.CWGASEL              // bit 6

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 4
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0

#define G1CS0                   CWG1CON0bits.G1CS0              // bit 0
#define G1POLA                  CWG1CON0bits.G1POLA             // bit 3
#define G1POLB                  CWG1CON0bits.G1POLB             // bit 4
#define G1OEA                   CWG1CON0bits.G1OEA              // bit 5
#define G1OEB                   CWG1CON0bits.G1OEB              // bit 6
#define G1EN                    CWG1CON0bits.G1EN               // bit 7

#define G1IS0                   CWG1CON1bits.G1IS0              // bit 0
#define G1IS1                   CWG1CON1bits.G1IS1              // bit 1
#define G1IS2                   CWG1CON1bits.G1IS2              // bit 2
#define G1ASDLA0                CWG1CON1bits.G1ASDLA0           // bit 4
#define G1ASDLA1                CWG1CON1bits.G1ASDLA1           // bit 5
#define G1ASDLB0                CWG1CON1bits.G1ASDLB0           // bit 6
#define G1ASDLB1                CWG1CON1bits.G1ASDLB1           // bit 7

#define G1ASDSFLT               CWG1CON2bits.G1ASDSFLT          // bit 1
#define G1ASDSC1                CWG1CON2bits.G1ASDSC1           // bit 2
#define G1ARSEN                 CWG1CON2bits.G1ARSEN            // bit 6
#define G1ASE                   CWG1CON2bits.G1ASE              // bit 7

#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5

#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5

#define DACPSS0                 DACCON0bits.DACPSS0             // bit 2
#define DACPSS1                 DACCON0bits.DACPSS1             // bit 3
#define DACOE                   DACCON0bits.DACOE               // bit 5
#define DACLPS                  DACCON0bits.DACLPS              // bit 6
#define DACEN                   DACCON0bits.DACEN               // bit 7

#define DACR0                   DACCON1bits.DACR0               // bit 0
#define DACR1                   DACCON1bits.DACR1               // bit 1
#define DACR2                   DACCON1bits.DACR2               // bit 2
#define DACR3                   DACCON1bits.DACR3               // bit 3
#define DACR4                   DACCON1bits.DACR4               // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define C1IE                    PIE2bits.C1IE                   // bit 5

#define PWM1IE                  PIE3bits.PWM1IE                 // bit 4
#define PWM2IE                  PIE3bits.PWM2IE                 // bit 5
#define PWM3IE                  PIE3bits.PWM3IE                 // bit 6

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define C1IF                    PIR2bits.C1IF                   // bit 5

#define PWM1IF                  PIR3bits.PWM1IF                 // bit 4
#define PWM2IF                  PIR3bits.PWM2IF                 // bit 5
#define PWM3IF                  PIR3bits.PWM3IF                 // bit 6

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define PWM1MODE0               PWM1CONbits.PWM1MODE0           // bit 2, shadows bit in PWM1CONbits
#define MODE0                   PWM1CONbits.MODE0               // bit 2, shadows bit in PWM1CONbits
#define PWM1MODE1               PWM1CONbits.PWM1MODE1           // bit 3, shadows bit in PWM1CONbits
#define MODE1                   PWM1CONbits.MODE1               // bit 3, shadows bit in PWM1CONbits
#define POL                     PWM1CONbits.POL                 // bit 4, shadows bit in PWM1CONbits
#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4, shadows bit in PWM1CONbits
#define OUT                     PWM1CONbits.OUT                 // bit 5, shadows bit in PWM1CONbits
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5, shadows bit in PWM1CONbits
#define OE                      PWM1CONbits.OE                  // bit 6, shadows bit in PWM1CONbits
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6, shadows bit in PWM1CONbits
#define EN                      PWM1CONbits.EN                  // bit 7, shadows bit in PWM1CONbits
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7, shadows bit in PWM1CONbits

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 0
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 1
#define PWM1DCL2                PWM1DCLbits.PWM1DCL2            // bit 2
#define PWM1DCL3                PWM1DCLbits.PWM1DCL3            // bit 3
#define PWM1DCL4                PWM1DCLbits.PWM1DCL4            // bit 4
#define PWM1DCL5                PWM1DCLbits.PWM1DCL5            // bit 5
#define PWM1DCL6                PWM1DCLbits.PWM1DCL6            // bit 6
#define PWM1DCL7                PWM1DCLbits.PWM1DCL7            // bit 7

#define PRIE                    PWM1INTCONbits.PRIE             // bit 0, shadows bit in PWM1INTCONbits
#define PWM1PRIE                PWM1INTCONbits.PWM1PRIE         // bit 0, shadows bit in PWM1INTCONbits
#define DCIE                    PWM1INTCONbits.DCIE             // bit 1, shadows bit in PWM1INTCONbits
#define PWM1DCIE                PWM1INTCONbits.PWM1DCIE         // bit 1, shadows bit in PWM1INTCONbits
#define PHIE                    PWM1INTCONbits.PHIE             // bit 2, shadows bit in PWM1INTCONbits
#define PWM1PHIE                PWM1INTCONbits.PWM1PHIE         // bit 2, shadows bit in PWM1INTCONbits
#define OFIE                    PWM1INTCONbits.OFIE             // bit 3, shadows bit in PWM1INTCONbits
#define PWM1OFIE                PWM1INTCONbits.PWM1OFIE         // bit 3, shadows bit in PWM1INTCONbits

#define PRIF                    PWM1INTFbits.PRIF               // bit 0, shadows bit in PWM1INTFbits
#define PWM1PRIF                PWM1INTFbits.PWM1PRIF           // bit 0, shadows bit in PWM1INTFbits
#define DCIF                    PWM1INTFbits.DCIF               // bit 1, shadows bit in PWM1INTFbits
#define PWM1DCIF                PWM1INTFbits.PWM1DCIF           // bit 1, shadows bit in PWM1INTFbits
#define PHIF                    PWM1INTFbits.PHIF               // bit 2, shadows bit in PWM1INTFbits
#define PWM1PHIF                PWM1INTFbits.PWM1PHIF           // bit 2, shadows bit in PWM1INTFbits
#define OFIF                    PWM1INTFbits.OFIF               // bit 3, shadows bit in PWM1INTFbits
#define PWM1OFIF                PWM1INTFbits.PWM1OFIF           // bit 3, shadows bit in PWM1INTFbits

#define PWM1LDS0                PWM1LDCONbits.PWM1LDS0          // bit 0, shadows bit in PWM1LDCONbits
#define LDS0                    PWM1LDCONbits.LDS0              // bit 0, shadows bit in PWM1LDCONbits
#define PWM1LDS1                PWM1LDCONbits.PWM1LDS1          // bit 1, shadows bit in PWM1LDCONbits
#define LDS1                    PWM1LDCONbits.LDS1              // bit 1, shadows bit in PWM1LDCONbits
#define LDT                     PWM1LDCONbits.LDT               // bit 6, shadows bit in PWM1LDCONbits
#define PWM1LDM                 PWM1LDCONbits.PWM1LDM           // bit 6, shadows bit in PWM1LDCONbits
#define LDA                     PWM1LDCONbits.LDA               // bit 7, shadows bit in PWM1LDCONbits
#define PWM1LD                  PWM1LDCONbits.PWM1LD            // bit 7, shadows bit in PWM1LDCONbits

#define PWM1OFS0                PWM1OFCONbits.PWM1OFS0          // bit 0, shadows bit in PWM1OFCONbits
#define OFS0                    PWM1OFCONbits.OFS0              // bit 0, shadows bit in PWM1OFCONbits
#define PWM1OFS1                PWM1OFCONbits.PWM1OFS1          // bit 1, shadows bit in PWM1OFCONbits
#define OFS1                    PWM1OFCONbits.OFS1              // bit 1, shadows bit in PWM1OFCONbits
#define OFO                     PWM1OFCONbits.OFO               // bit 4, shadows bit in PWM1OFCONbits
#define PWM1OFMC                PWM1OFCONbits.PWM1OFMC          // bit 4, shadows bit in PWM1OFCONbits
#define PWM1OFM0                PWM1OFCONbits.PWM1OFM0          // bit 5, shadows bit in PWM1OFCONbits
#define OFM0                    PWM1OFCONbits.OFM0              // bit 5, shadows bit in PWM1OFCONbits
#define PWM1OFM1                PWM1OFCONbits.PWM1OFM1          // bit 6, shadows bit in PWM1OFCONbits
#define OFM1                    PWM1OFCONbits.OFM1              // bit 6, shadows bit in PWM1OFCONbits

#define PWM1OFH0                PWM1OFHbits.PWM1OFH0            // bit 0
#define PWM1OFH1                PWM1OFHbits.PWM1OFH1            // bit 1
#define PWM1OFH2                PWM1OFHbits.PWM1OFH2            // bit 2
#define PWM1OFH3                PWM1OFHbits.PWM1OFH3            // bit 3
#define PWM1OFH4                PWM1OFHbits.PWM1OFH4            // bit 4
#define PWM1OFH5                PWM1OFHbits.PWM1OFH5            // bit 5
#define PWM1OFH6                PWM1OFHbits.PWM1OFH6            // bit 6
#define PWM1OFH7                PWM1OFHbits.PWM1OFH7            // bit 7

#define PWM1OFL0                PWM1OFLbits.PWM1OFL0            // bit 0
#define PWM1OFL1                PWM1OFLbits.PWM1OFL1            // bit 1
#define PWM1OFL2                PWM1OFLbits.PWM1OFL2            // bit 2
#define PWM1OFL3                PWM1OFLbits.PWM1OFL3            // bit 3
#define PWM1OFL4                PWM1OFLbits.PWM1OFL4            // bit 4
#define PWM1OFL5                PWM1OFLbits.PWM1OFL5            // bit 5
#define PWM1OFL6                PWM1OFLbits.PWM1OFL6            // bit 6
#define PWM1OFL7                PWM1OFLbits.PWM1OFL7            // bit 7

#define PWM1PHH0                PWM1PHHbits.PWM1PHH0            // bit 0
#define PWM1PHH1                PWM1PHHbits.PWM1PHH1            // bit 1
#define PWM1PHH2                PWM1PHHbits.PWM1PHH2            // bit 2
#define PWM1PHH3                PWM1PHHbits.PWM1PHH3            // bit 3
#define PWM1PHH4                PWM1PHHbits.PWM1PHH4            // bit 4
#define PWM1PHH5                PWM1PHHbits.PWM1PHH5            // bit 5
#define PWM1PHH6                PWM1PHHbits.PWM1PHH6            // bit 6
#define PWM1PHH7                PWM1PHHbits.PWM1PHH7            // bit 7

#define PWM1PHL0                PWM1PHLbits.PWM1PHL0            // bit 0
#define PWM1PHL1                PWM1PHLbits.PWM1PHL1            // bit 1
#define PWM1PHL2                PWM1PHLbits.PWM1PHL2            // bit 2
#define PWM1PHL3                PWM1PHLbits.PWM1PHL3            // bit 3
#define PWM1PHL4                PWM1PHLbits.PWM1PHL4            // bit 4
#define PWM1PHL5                PWM1PHLbits.PWM1PHL5            // bit 5
#define PWM1PHL6                PWM1PHLbits.PWM1PHL6            // bit 6
#define PWM1PHL7                PWM1PHLbits.PWM1PHL7            // bit 7

#define PWM1PRH0                PWM1PRHbits.PWM1PRH0            // bit 0
#define PWM1PRH1                PWM1PRHbits.PWM1PRH1            // bit 1
#define PWM1PRH2                PWM1PRHbits.PWM1PRH2            // bit 2
#define PWM1PRH3                PWM1PRHbits.PWM1PRH3            // bit 3
#define PWM1PRH4                PWM1PRHbits.PWM1PRH4            // bit 4
#define PWM1PRH5                PWM1PRHbits.PWM1PRH5            // bit 5
#define PWM1PRH6                PWM1PRHbits.PWM1PRH6            // bit 6
#define PWM1PRH7                PWM1PRHbits.PWM1PRH7            // bit 7

#define PWM1PRL0                PWM1PRLbits.PWM1PRL0            // bit 0
#define PWM1PRL1                PWM1PRLbits.PWM1PRL1            // bit 1
#define PWM1PRL2                PWM1PRLbits.PWM1PRL2            // bit 2
#define PWM1PRL3                PWM1PRLbits.PWM1PRL3            // bit 3
#define PWM1PRL4                PWM1PRLbits.PWM1PRL4            // bit 4
#define PWM1PRL5                PWM1PRLbits.PWM1PRL5            // bit 5
#define PWM1PRL6                PWM1PRLbits.PWM1PRL6            // bit 6
#define PWM1PRL7                PWM1PRLbits.PWM1PRL7            // bit 7

#define PWM1TMRH0               PWM1TMRHbits.PWM1TMRH0          // bit 0
#define PWM1TMRH1               PWM1TMRHbits.PWM1TMRH1          // bit 1
#define PWM1TMRH2               PWM1TMRHbits.PWM1TMRH2          // bit 2
#define PWM1TMRH3               PWM1TMRHbits.PWM1TMRH3          // bit 3
#define PWM1TMRH4               PWM1TMRHbits.PWM1TMRH4          // bit 4
#define PWM1TMRH5               PWM1TMRHbits.PWM1TMRH5          // bit 5
#define PWM1TMRH6               PWM1TMRHbits.PWM1TMRH6          // bit 6
#define PWM1TMRH7               PWM1TMRHbits.PWM1TMRH7          // bit 7

#define PWM1TMRL0               PWM1TMRLbits.PWM1TMRL0          // bit 0
#define PWM1TMRL1               PWM1TMRLbits.PWM1TMRL1          // bit 1
#define PWM1TMRL2               PWM1TMRLbits.PWM1TMRL2          // bit 2
#define PWM1TMRL3               PWM1TMRLbits.PWM1TMRL3          // bit 3
#define PWM1TMRL4               PWM1TMRLbits.PWM1TMRL4          // bit 4
#define PWM1TMRL5               PWM1TMRLbits.PWM1TMRL5          // bit 5
#define PWM1TMRL6               PWM1TMRLbits.PWM1TMRL6          // bit 6
#define PWM1TMRL7               PWM1TMRLbits.PWM1TMRL7          // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 0
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 1
#define PWM2DCL2                PWM2DCLbits.PWM2DCL2            // bit 2
#define PWM2DCL3                PWM2DCLbits.PWM2DCL3            // bit 3
#define PWM2DCL4                PWM2DCLbits.PWM2DCL4            // bit 4
#define PWM2DCL5                PWM2DCLbits.PWM2DCL5            // bit 5
#define PWM2DCL6                PWM2DCLbits.PWM2DCL6            // bit 6
#define PWM2DCL7                PWM2DCLbits.PWM2DCL7            // bit 7

#define PWM2OFH0                PWM2OFHbits.PWM2OFH0            // bit 0
#define PWM2OFH1                PWM2OFHbits.PWM2OFH1            // bit 1
#define PWM2OFH2                PWM2OFHbits.PWM2OFH2            // bit 2
#define PWM2OFH3                PWM2OFHbits.PWM2OFH3            // bit 3
#define PWM2OFH4                PWM2OFHbits.PWM2OFH4            // bit 4
#define PWM2OFH5                PWM2OFHbits.PWM2OFH5            // bit 5
#define PWM2OFH6                PWM2OFHbits.PWM2OFH6            // bit 6
#define PWM2OFH7                PWM2OFHbits.PWM2OFH7            // bit 7

#define PWM2OFL0                PWM2OFLbits.PWM2OFL0            // bit 0
#define PWM2OFL1                PWM2OFLbits.PWM2OFL1            // bit 1
#define PWM2OFL2                PWM2OFLbits.PWM2OFL2            // bit 2
#define PWM2OFL3                PWM2OFLbits.PWM2OFL3            // bit 3
#define PWM2OFL4                PWM2OFLbits.PWM2OFL4            // bit 4
#define PWM2OFL5                PWM2OFLbits.PWM2OFL5            // bit 5
#define PWM2OFL6                PWM2OFLbits.PWM2OFL6            // bit 6
#define PWM2OFL7                PWM2OFLbits.PWM2OFL7            // bit 7

#define PWM2PHH0                PWM2PHHbits.PWM2PHH0            // bit 0
#define PWM2PHH1                PWM2PHHbits.PWM2PHH1            // bit 1
#define PWM2PHH2                PWM2PHHbits.PWM2PHH2            // bit 2
#define PWM2PHH3                PWM2PHHbits.PWM2PHH3            // bit 3
#define PWM2PHH4                PWM2PHHbits.PWM2PHH4            // bit 4
#define PWM2PHH5                PWM2PHHbits.PWM2PHH5            // bit 5
#define PWM2PHH6                PWM2PHHbits.PWM2PHH6            // bit 6
#define PWM2PHH7                PWM2PHHbits.PWM2PHH7            // bit 7

#define PWM2PHL0                PWM2PHLbits.PWM2PHL0            // bit 0
#define PWM2PHL1                PWM2PHLbits.PWM2PHL1            // bit 1
#define PWM2PHL2                PWM2PHLbits.PWM2PHL2            // bit 2
#define PWM2PHL3                PWM2PHLbits.PWM2PHL3            // bit 3
#define PWM2PHL4                PWM2PHLbits.PWM2PHL4            // bit 4
#define PWM2PHL5                PWM2PHLbits.PWM2PHL5            // bit 5
#define PWM2PHL6                PWM2PHLbits.PWM2PHL6            // bit 6
#define PWM2PHL7                PWM2PHLbits.PWM2PHL7            // bit 7

#define PWM2PRH0                PWM2PRHbits.PWM2PRH0            // bit 0
#define PWM2PRH1                PWM2PRHbits.PWM2PRH1            // bit 1
#define PWM2PRH2                PWM2PRHbits.PWM2PRH2            // bit 2
#define PWM2PRH3                PWM2PRHbits.PWM2PRH3            // bit 3
#define PWM2PRH4                PWM2PRHbits.PWM2PRH4            // bit 4
#define PWM2PRH5                PWM2PRHbits.PWM2PRH5            // bit 5
#define PWM2PRH6                PWM2PRHbits.PWM2PRH6            // bit 6
#define PWM2PRH7                PWM2PRHbits.PWM2PRH7            // bit 7

#define PWM2PRL0                PWM2PRLbits.PWM2PRL0            // bit 0
#define PWM2PRL1                PWM2PRLbits.PWM2PRL1            // bit 1
#define PWM2PRL2                PWM2PRLbits.PWM2PRL2            // bit 2
#define PWM2PRL3                PWM2PRLbits.PWM2PRL3            // bit 3
#define PWM2PRL4                PWM2PRLbits.PWM2PRL4            // bit 4
#define PWM2PRL5                PWM2PRLbits.PWM2PRL5            // bit 5
#define PWM2PRL6                PWM2PRLbits.PWM2PRL6            // bit 6
#define PWM2PRL7                PWM2PRLbits.PWM2PRL7            // bit 7

#define PWM2TMRH0               PWM2TMRHbits.PWM2TMRH0          // bit 0
#define PWM2TMRH1               PWM2TMRHbits.PWM2TMRH1          // bit 1
#define PWM2TMRH2               PWM2TMRHbits.PWM2TMRH2          // bit 2
#define PWM2TMRH3               PWM2TMRHbits.PWM2TMRH3          // bit 3
#define PWM2TMRH4               PWM2TMRHbits.PWM2TMRH4          // bit 4
#define PWM2TMRH5               PWM2TMRHbits.PWM2TMRH5          // bit 5
#define PWM2TMRH6               PWM2TMRHbits.PWM2TMRH6          // bit 6
#define PWM2TMRH7               PWM2TMRHbits.PWM2TMRH7          // bit 7

#define PWM2TMRL0               PWM2TMRLbits.PWM2TMRL0          // bit 0
#define PWM2TMRL1               PWM2TMRLbits.PWM2TMRL1          // bit 1
#define PWM2TMRL2               PWM2TMRLbits.PWM2TMRL2          // bit 2
#define PWM2TMRL3               PWM2TMRLbits.PWM2TMRL3          // bit 3
#define PWM2TMRL4               PWM2TMRLbits.PWM2TMRL4          // bit 4
#define PWM2TMRL5               PWM2TMRLbits.PWM2TMRL5          // bit 5
#define PWM2TMRL6               PWM2TMRLbits.PWM2TMRL6          // bit 6
#define PWM2TMRL7               PWM2TMRLbits.PWM2TMRL7          // bit 7

#define PWM3DCH0                PWM3DCHbits.PWM3DCH0            // bit 0
#define PWM3DCH1                PWM3DCHbits.PWM3DCH1            // bit 1
#define PWM3DCH2                PWM3DCHbits.PWM3DCH2            // bit 2
#define PWM3DCH3                PWM3DCHbits.PWM3DCH3            // bit 3
#define PWM3DCH4                PWM3DCHbits.PWM3DCH4            // bit 4
#define PWM3DCH5                PWM3DCHbits.PWM3DCH5            // bit 5
#define PWM3DCH6                PWM3DCHbits.PWM3DCH6            // bit 6
#define PWM3DCH7                PWM3DCHbits.PWM3DCH7            // bit 7

#define PWM3DCL0                PWM3DCLbits.PWM3DCL0            // bit 0
#define PWM3DCL1                PWM3DCLbits.PWM3DCL1            // bit 1
#define PWM3DCL2                PWM3DCLbits.PWM3DCL2            // bit 2
#define PWM3DCL3                PWM3DCLbits.PWM3DCL3            // bit 3
#define PWM3DCL4                PWM3DCLbits.PWM3DCL4            // bit 4
#define PWM3DCL5                PWM3DCLbits.PWM3DCL5            // bit 5
#define PWM3DCL6                PWM3DCLbits.PWM3DCL6            // bit 6
#define PWM3DCL7                PWM3DCLbits.PWM3DCL7            // bit 7

#define PWM3OFH0                PWM3OFHbits.PWM3OFH0            // bit 0
#define PWM3OFH1                PWM3OFHbits.PWM3OFH1            // bit 1
#define PWM3OFH2                PWM3OFHbits.PWM3OFH2            // bit 2
#define PWM3OFH3                PWM3OFHbits.PWM3OFH3            // bit 3
#define PWM3OFH4                PWM3OFHbits.PWM3OFH4            // bit 4
#define PWM3OFH5                PWM3OFHbits.PWM3OFH5            // bit 5
#define PWM3OFH6                PWM3OFHbits.PWM3OFH6            // bit 6
#define PWM3OFH7                PWM3OFHbits.PWM3OFH7            // bit 7

#define PWM3OFL0                PWM3OFLbits.PWM3OFL0            // bit 0
#define PWM3OFL1                PWM3OFLbits.PWM3OFL1            // bit 1
#define PWM3OFL2                PWM3OFLbits.PWM3OFL2            // bit 2
#define PWM3OFL3                PWM3OFLbits.PWM3OFL3            // bit 3
#define PWM3OFL4                PWM3OFLbits.PWM3OFL4            // bit 4
#define PWM3OFL5                PWM3OFLbits.PWM3OFL5            // bit 5
#define PWM3OFL6                PWM3OFLbits.PWM3OFL6            // bit 6
#define PWM3OFL7                PWM3OFLbits.PWM3OFL7            // bit 7

#define PWM3PHH0                PWM3PHHbits.PWM3PHH0            // bit 0
#define PWM3PHH1                PWM3PHHbits.PWM3PHH1            // bit 1
#define PWM3PHH2                PWM3PHHbits.PWM3PHH2            // bit 2
#define PWM3PHH3                PWM3PHHbits.PWM3PHH3            // bit 3
#define PWM3PHH4                PWM3PHHbits.PWM3PHH4            // bit 4
#define PWM3PHH5                PWM3PHHbits.PWM3PHH5            // bit 5
#define PWM3PHH6                PWM3PHHbits.PWM3PHH6            // bit 6
#define PWM3PHH7                PWM3PHHbits.PWM3PHH7            // bit 7

#define PWM3PHL0                PWM3PHLbits.PWM3PHL0            // bit 0
#define PWM3PHL1                PWM3PHLbits.PWM3PHL1            // bit 1
#define PWM3PHL2                PWM3PHLbits.PWM3PHL2            // bit 2
#define PWM3PHL3                PWM3PHLbits.PWM3PHL3            // bit 3
#define PWM3PHL4                PWM3PHLbits.PWM3PHL4            // bit 4
#define PWM3PHL5                PWM3PHLbits.PWM3PHL5            // bit 5
#define PWM3PHL6                PWM3PHLbits.PWM3PHL6            // bit 6
#define PWM3PHL7                PWM3PHLbits.PWM3PHL7            // bit 7

#define PWM3PRH0                PWM3PRHbits.PWM3PRH0            // bit 0
#define PWM3PRH1                PWM3PRHbits.PWM3PRH1            // bit 1
#define PWM3PRH2                PWM3PRHbits.PWM3PRH2            // bit 2
#define PWM3PRH3                PWM3PRHbits.PWM3PRH3            // bit 3
#define PWM3PRH4                PWM3PRHbits.PWM3PRH4            // bit 4
#define PWM3PRH5                PWM3PRHbits.PWM3PRH5            // bit 5
#define PWM3PRH6                PWM3PRHbits.PWM3PRH6            // bit 6
#define PWM3PRH7                PWM3PRHbits.PWM3PRH7            // bit 7

#define PWM3PRL0                PWM3PRLbits.PWM3PRL0            // bit 0
#define PWM3PRL1                PWM3PRLbits.PWM3PRL1            // bit 1
#define PWM3PRL2                PWM3PRLbits.PWM3PRL2            // bit 2
#define PWM3PRL3                PWM3PRLbits.PWM3PRL3            // bit 3
#define PWM3PRL4                PWM3PRLbits.PWM3PRL4            // bit 4
#define PWM3PRL5                PWM3PRLbits.PWM3PRL5            // bit 5
#define PWM3PRL6                PWM3PRLbits.PWM3PRL6            // bit 6
#define PWM3PRL7                PWM3PRLbits.PWM3PRL7            // bit 7

#define PWM3TMRH0               PWM3TMRHbits.PWM3TMRH0          // bit 0
#define PWM3TMRH1               PWM3TMRHbits.PWM3TMRH1          // bit 1
#define PWM3TMRH2               PWM3TMRHbits.PWM3TMRH2          // bit 2
#define PWM3TMRH3               PWM3TMRHbits.PWM3TMRH3          // bit 3
#define PWM3TMRH4               PWM3TMRHbits.PWM3TMRH4          // bit 4
#define PWM3TMRH5               PWM3TMRHbits.PWM3TMRH5          // bit 5
#define PWM3TMRH6               PWM3TMRHbits.PWM3TMRH6          // bit 6
#define PWM3TMRH7               PWM3TMRHbits.PWM3TMRH7          // bit 7

#define PWM3TMRL0               PWM3TMRLbits.PWM3TMRL0          // bit 0
#define PWM3TMRL1               PWM3TMRLbits.PWM3TMRL1          // bit 1
#define PWM3TMRL2               PWM3TMRLbits.PWM3TMRL2          // bit 2
#define PWM3TMRL3               PWM3TMRLbits.PWM3TMRL3          // bit 3
#define PWM3TMRL4               PWM3TMRLbits.PWM3TMRL4          // bit 4
#define PWM3TMRL5               PWM3TMRLbits.PWM3TMRL5          // bit 5
#define PWM3TMRL6               PWM3TMRLbits.PWM3TMRL6          // bit 6
#define PWM3TMRL7               PWM3TMRLbits.PWM3TMRL7          // bit 7

#define PWM1EN_A                PWMENbits.PWM1EN_A              // bit 0, shadows bit in PWMENbits
#define MPWM1EN                 PWMENbits.MPWM1EN               // bit 0, shadows bit in PWMENbits
#define PWM2EN_A                PWMENbits.PWM2EN_A              // bit 1, shadows bit in PWMENbits
#define MPWM2EN                 PWMENbits.MPWM2EN               // bit 1, shadows bit in PWMENbits
#define PWM3EN_A                PWMENbits.PWM3EN_A              // bit 2, shadows bit in PWMENbits
#define MPWM3EN                 PWMENbits.MPWM3EN               // bit 2, shadows bit in PWMENbits

#define PWM1LDA_A               PWMLDbits.PWM1LDA_A             // bit 0, shadows bit in PWMLDbits
#define MPWM1LD                 PWMLDbits.MPWM1LD               // bit 0, shadows bit in PWMLDbits
#define PWM2LDA_A               PWMLDbits.PWM2LDA_A             // bit 1, shadows bit in PWMLDbits
#define MPWM2LD                 PWMLDbits.MPWM2LD               // bit 1, shadows bit in PWMLDbits
#define PWM3LDA_A               PWMLDbits.PWM3LDA_A             // bit 2, shadows bit in PWMLDbits
#define MPWM3LD                 PWMLDbits.MPWM3LD               // bit 2, shadows bit in PWMLDbits

#define PWM1OUT_A               PWMOUTbits.PWM1OUT_A            // bit 0, shadows bit in PWMOUTbits
#define MPWM1OUT                PWMOUTbits.MPWM1OUT             // bit 0, shadows bit in PWMOUTbits
#define PWM2OUT_A               PWMOUTbits.PWM2OUT_A            // bit 1, shadows bit in PWMOUTbits
#define MPWM2OUT                PWMOUTbits.MPWM2OUT             // bit 1, shadows bit in PWMOUTbits
#define PWM3OUT_A               PWMOUTbits.PWM3OUT_A            // bit 2, shadows bit in PWMOUTbits
#define MPWM3OUT                PWMOUTbits.MPWM3OUT             // bit 2, shadows bit in PWMOUTbits

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define T1GGO                   T1GCONbits.T1GGO                // bit 3, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define VREGPM0                 VREGCONbits.VREGPM0             // bit 0
#define VREGPM1                 VREGCONbits.VREGPM1             // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC12F1571_H__
