/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import org.gjt.sp.jedit.jEdit;

public class ListModelEditor {
    public void open(DefaultListModel defaultListModel) {
        final DefaultTableModel defaultTableModel = this.createTableModel(defaultListModel);
        final JTable jTable = new JTable(defaultTableModel);
        jTable.setToolTipText("Move: PgUp/PgDown; Edit: Double-Click or Insert/Delete");
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                int n = nArray[0];
                int n2 = keyEvent.getKeyCode();
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                switch (n2) {
                    case 127: {
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            defaultTableModel.removeRow(nArray[i]);
                        }
                        if (n >= 0 && n < defaultTableModel.getRowCount()) {
                            listSelectionModel.addSelectionInterval(n, n);
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 155: {
                        defaultTableModel.insertRow(n + 1, new String[]{""});
                        keyEvent.consume();
                        break;
                    }
                    case 33: 
                    case 34: {
                        boolean bl = n2 == 33;
                        int n3 = bl ? -1 : 1;
                        int n4 = listSelectionModel.getMinSelectionIndex() + n3;
                        int n5 = listSelectionModel.getMaxSelectionIndex() + n3;
                        if (n4 < 0 || n5 >= defaultTableModel.getRowCount()) {
                            return;
                        }
                        for (int i = 0; i < nArray.length; ++i) {
                            int n6 = nArray[bl ? i : nArray.length - 1 - i];
                            int n7 = n6 + n3;
                            listSelectionModel.removeSelectionInterval(n6, n6);
                            listSelectionModel.addSelectionInterval(n7, n7);
                            defaultTableModel.moveRow(n6, n6, n7);
                        }
                        break;
                    }
                }
            }
        });
        int n = JOptionPane.showConfirmDialog(null, jTable, "Change " + jEdit.getProperty("history.caption"), 2);
        if (n == 0) {
            this.updatelistModel(defaultListModel, defaultTableModel);
        }
    }

    private DefaultTableModel createTableModel(DefaultListModel defaultListModel) {
        Object[][] objectArray = new String[defaultListModel.size()][1];
        for (int i = 0; i < defaultListModel.size(); ++i) {
            objectArray[i][0] = defaultListModel.get(i);
        }
        return new DefaultTableModel(objectArray, new String[]{""});
    }

    private void updatelistModel(DefaultListModel defaultListModel, DefaultTableModel defaultTableModel) {
        defaultListModel.removeAllElements();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            Object object = defaultTableModel.getValueAt(i, 0);
            if (object == null || object.equals("")) continue;
            defaultListModel.addElement(object);
        }
    }
}

