/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.SettingVisitor;

public class MapListSetting
extends AbstractSetting<List<Map<String, String>>> {
    public MapListSetting(List<Map<String, String>> list) {
        super(list);
        this.consistencyTest();
    }

    @Override
    public boolean equalVal(List<Map<String, String>> list) {
        if (this.value == null) {
            return list == null;
        }
        if (list == null) {
            return false;
        }
        if (((List)this.value).size() != list.size()) {
            return false;
        }
        Iterator iterator = ((List)this.value).iterator();
        Iterator<Map<String, String>> iterator2 = list.iterator();
        while (iterator.hasNext()) {
            if (MapListSetting.equalMap((Map)iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equalMap(Map<String, String> map, Map<String, String> map2) {
        if (map == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (Objects.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public MapListSetting copy() {
        if (this.value == null) {
            return new MapListSetting(null);
        }
        ArrayList arrayList = new ArrayList(((List)this.value).size());
        for (Map map : (List)this.value) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map);
            arrayList.add(Collections.unmodifiableMap(linkedHashMap));
        }
        return new MapListSetting(Collections.unmodifiableList(arrayList));
    }

    private void consistencyTest() {
        if (this.value == null) {
            return;
        }
        if (((List)this.value).contains(null)) {
            throw new RuntimeException("Error: Null as list element in preference setting");
        }
        for (Map map : (List)this.value) {
            if (map.keySet().contains(null)) {
                throw new RuntimeException("Error: Null as map key in preference setting");
            }
            if (!map.values().contains(null)) continue;
            throw new RuntimeException("Error: Null as map value in preference setting");
        }
    }

    @Override
    public void visit(SettingVisitor settingVisitor) {
        settingVisitor.visit(this);
    }

    public MapListSetting getNullInstance() {
        return new MapListSetting(null);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MapListSetting)) {
            return false;
        }
        return this.equalVal((List)((MapListSetting)object).getValue());
    }
}

