/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.OsmPrimitiveAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class PopupMenuHandler {
    private final Set<OsmPrimitiveAction> primitiveActions = new HashSet<OsmPrimitiveAction>();
    private final JPopupMenu menu;

    public PopupMenuHandler(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public JMenuItem addAction(Action action) {
        if (action != null) {
            if (action instanceof OsmPrimitiveAction) {
                this.primitiveActions.add((OsmPrimitiveAction)action);
            }
            return this.menu.add(action);
        }
        return null;
    }

    public void removeAction(Action action) {
        if (action != null) {
            if (action instanceof OsmPrimitiveAction) {
                this.primitiveActions.remove(action);
            }
            MenuElement[] menuElementArray = this.menu.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (!(menuElementArray[i] instanceof JMenuItem) || ((JMenuItem)menuElementArray[i]).getAction() != action) continue;
                this.menu.remove(i);
                return;
            }
        }
    }

    public void addListener(PopupMenuListener popupMenuListener) {
        this.menu.addPopupMenuListener(popupMenuListener);
    }

    public void removeListener(PopupMenuListener popupMenuListener) {
        this.menu.removePopupMenuListener(popupMenuListener);
    }

    public Collection<OsmPrimitiveAction> getPrimitiveActions() {
        return Collections.unmodifiableCollection(this.primitiveActions);
    }

    public void setPrimitives(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitiveAction osmPrimitiveAction : this.primitiveActions) {
            osmPrimitiveAction.setPrimitives(collection);
        }
    }
}

