/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.write;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteOrder;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteBitStringNode
extends PackNode {
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public WriteBitStringNode(RubyContext context, ByteOrder byteOrder, boolean star, int length) {
        super(context);
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    public Object write(VirtualFrame frame, ByteList bytes) {
        ByteList lCurElemString = bytes;
        int occurrences = this.star ? lCurElemString.length() : this.length;
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > lCurElemString.length()) {
            padLength = (occurrences - lCurElemString.length()) / 2 + (occurrences + lCurElemString.length()) % 2;
            occurrences = lCurElemString.length();
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            int i = 0;
            while (i < occurrences) {
                if ((lCurElemString.charAt(i++) & '\u0001') != 0) {
                    currentByte |= 0x80;
                }
                if ((i & 7) == 0) {
                    this.writeByte(frame, (byte)(currentByte & 0xFF));
                    currentByte = 0;
                    continue;
                }
                currentByte >>= 1;
            }
            if ((occurrences & 7) != 0) {
                this.writeByte(frame, (byte)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
            }
        } else {
            int i = 0;
            while (i < occurrences) {
                currentByte |= lCurElemString.charAt(i++) & '\u0001';
                if ((i & 7) == 0) {
                    this.writeByte(frame, (byte)(currentByte & 0xFF));
                    currentByte = 0;
                    continue;
                }
                currentByte <<= 1;
            }
            if ((occurrences & 7) != 0) {
                this.writeByte(frame, (byte)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
            }
        }
        this.writeNullBytes(frame, padLength);
        return null;
    }
}

