/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BalanceStrategy;
import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.LoadBalancingConnectionProxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BestResponseTimeBalanceStrategy
implements BalanceStrategy {
    public void destroy() {
    }

    public void init(Connection conn, Properties props) throws SQLException {
    }

    public Connection pickConnection(LoadBalancingConnectionProxy proxy, List configuredHosts, Map liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        long minResponseTime = Long.MAX_VALUE;
        int bestHostIndex = 0;
        HashMap blackList = new HashMap(configuredHosts.size());
        SQLException ex = null;
        for (int attempts = 0; attempts < numRetries; ++attempts) {
            String bestHost;
            Connection conn;
            if (blackList.size() == configuredHosts.size()) {
                blackList.clear();
            }
            for (int i = 0; i < responseTimes.length; ++i) {
                long candidateResponseTime = responseTimes[i];
                if (candidateResponseTime >= minResponseTime || blackList.containsKey(configuredHosts.get(i))) continue;
                if (candidateResponseTime == 0L) {
                    bestHostIndex = i;
                    break;
                }
                bestHostIndex = i;
                minResponseTime = candidateResponseTime;
            }
            if ((conn = (Connection)liveConnections.get(bestHost = (String)configuredHosts.get(bestHostIndex))) == null) {
                try {
                    conn = proxy.createConnectionForHost(bestHost);
                }
                catch (SQLException sqlEx) {
                    ex = sqlEx;
                    if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                        blackList.put(bestHost, null);
                        if (blackList.size() != configuredHosts.size()) continue;
                        blackList.clear();
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    throw sqlEx;
                }
            }
            return conn;
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }
}

