/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.flow.ConditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

public abstract class FlowInfo {
    public int tagBits;
    public static final int REACHABLE = 0;
    public static final int UNREACHABLE_OR_DEAD = 1;
    public static final int UNREACHABLE_BY_NULLANALYSIS = 2;
    public static final int UNREACHABLE = 3;
    public static final int NULL_FLAG_MASK = 4;
    public static final int UNKNOWN = 1;
    public static final int NULL = 2;
    public static final int NON_NULL = 4;
    public static final int POTENTIALLY_UNKNOWN = 8;
    public static final int POTENTIALLY_NULL = 16;
    public static final int POTENTIALLY_NON_NULL = 32;
    public static final UnconditionalFlowInfo DEAD_END = new UnconditionalFlowInfo();

    public abstract FlowInfo addInitializationsFrom(FlowInfo var1);

    public abstract FlowInfo addNullInfoFrom(FlowInfo var1);

    public abstract FlowInfo addPotentialInitializationsFrom(FlowInfo var1);

    public FlowInfo asNegatedCondition() {
        return this;
    }

    public static FlowInfo conditional(FlowInfo flowInfo, FlowInfo flowInfo2) {
        if (flowInfo == flowInfo2) {
            return flowInfo;
        }
        return new ConditionalFlowInfo(flowInfo, flowInfo2);
    }

    public boolean cannotBeDefinitelyNullOrNonNull(LocalVariableBinding localVariableBinding) {
        return this.isPotentiallyUnknown(localVariableBinding) || this.isPotentiallyNonNull(localVariableBinding) && this.isPotentiallyNull(localVariableBinding);
    }

    public boolean cannotBeNull(LocalVariableBinding localVariableBinding) {
        return this.isDefinitelyNonNull(localVariableBinding) || this.isProtectedNonNull(localVariableBinding);
    }

    public boolean canOnlyBeNull(LocalVariableBinding localVariableBinding) {
        return this.isDefinitelyNull(localVariableBinding) || this.isProtectedNull(localVariableBinding);
    }

    public abstract FlowInfo copy();

    public static UnconditionalFlowInfo initial(int n) {
        UnconditionalFlowInfo unconditionalFlowInfo = new UnconditionalFlowInfo();
        unconditionalFlowInfo.maxFieldCount = n;
        return unconditionalFlowInfo;
    }

    public abstract FlowInfo initsWhenFalse();

    public abstract FlowInfo initsWhenTrue();

    public abstract boolean isDefinitelyAssigned(FieldBinding var1);

    public abstract boolean isDefinitelyAssigned(LocalVariableBinding var1);

    public abstract boolean isDefinitelyNonNull(LocalVariableBinding var1);

    public abstract boolean isDefinitelyNull(LocalVariableBinding var1);

    public abstract boolean isDefinitelyUnknown(LocalVariableBinding var1);

    public abstract boolean hasNullInfoFor(LocalVariableBinding var1);

    public abstract boolean isPotentiallyAssigned(FieldBinding var1);

    public abstract boolean isPotentiallyAssigned(LocalVariableBinding var1);

    public abstract boolean isPotentiallyNonNull(LocalVariableBinding var1);

    public abstract boolean isPotentiallyNull(LocalVariableBinding var1);

    public abstract boolean isPotentiallyUnknown(LocalVariableBinding var1);

    public abstract boolean isProtectedNonNull(LocalVariableBinding var1);

    public abstract boolean isProtectedNull(LocalVariableBinding var1);

    public abstract void markAsComparedEqualToNonNull(LocalVariableBinding var1);

    public abstract void markAsComparedEqualToNull(LocalVariableBinding var1);

    public abstract void markAsDefinitelyAssigned(FieldBinding var1);

    public abstract void markAsDefinitelyNonNull(LocalVariableBinding var1);

    public abstract void markAsDefinitelyNull(LocalVariableBinding var1);

    public abstract void resetNullInfo(LocalVariableBinding var1);

    public abstract void markPotentiallyUnknownBit(LocalVariableBinding var1);

    public abstract void markPotentiallyNullBit(LocalVariableBinding var1);

    public abstract void markPotentiallyNonNullBit(LocalVariableBinding var1);

    public abstract void markAsDefinitelyAssigned(LocalVariableBinding var1);

    public abstract void markAsDefinitelyUnknown(LocalVariableBinding var1);

    public void markNullStatus(LocalVariableBinding localVariableBinding, int n) {
        switch (n) {
            case 1: {
                this.markAsDefinitelyUnknown(localVariableBinding);
                break;
            }
            case 2: {
                this.markAsDefinitelyNull(localVariableBinding);
                break;
            }
            case 4: {
                this.markAsDefinitelyNonNull(localVariableBinding);
                break;
            }
            default: {
                this.resetNullInfo(localVariableBinding);
                if ((n & 8) != 0) {
                    this.markPotentiallyUnknownBit(localVariableBinding);
                }
                if ((n & 0x10) != 0) {
                    this.markPotentiallyNullBit(localVariableBinding);
                }
                if ((n & 0x20) != 0) {
                    this.markPotentiallyNonNullBit(localVariableBinding);
                }
                if ((n & 0x38) != 0) break;
                this.markAsDefinitelyUnknown(localVariableBinding);
            }
        }
    }

    public int nullStatus(LocalVariableBinding localVariableBinding) {
        if (this.isDefinitelyUnknown(localVariableBinding)) {
            return 1;
        }
        if (this.isDefinitelyNull(localVariableBinding)) {
            return 2;
        }
        if (this.isDefinitelyNonNull(localVariableBinding)) {
            return 4;
        }
        int n = 0;
        if (this.isPotentiallyUnknown(localVariableBinding)) {
            n |= 8;
        }
        if (this.isPotentiallyNull(localVariableBinding)) {
            n |= 0x10;
        }
        if (this.isPotentiallyNonNull(localVariableBinding)) {
            n |= 0x20;
        }
        if (n > 0) {
            return n;
        }
        return 1;
    }

    public static int mergeNullStatus(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 16: {
                bl2 = true;
            }
            case 2: {
                bl = true;
                break;
            }
            case 32: {
                bl = true;
            }
            case 4: {
                bl2 = true;
            }
        }
        switch (n2) {
            case 16: {
                bl2 = true;
            }
            case 2: {
                bl = true;
                break;
            }
            case 32: {
                bl = true;
            }
            case 4: {
                bl2 = true;
            }
        }
        if (bl) {
            if (bl2) {
                return 16;
            }
            return 2;
        }
        if (bl2) {
            return 4;
        }
        return 1;
    }

    public static UnconditionalFlowInfo mergedOptimizedBranches(FlowInfo flowInfo, boolean bl, FlowInfo flowInfo2, boolean bl2, boolean bl3) {
        UnconditionalFlowInfo unconditionalFlowInfo = bl ? (flowInfo == DEAD_END && bl3 ? flowInfo2.setReachMode(1).unconditionalInits() : flowInfo.addPotentialInitializationsFrom(flowInfo2.nullInfoLessUnconditionalCopy()).unconditionalInits()) : (bl2 ? (flowInfo2 == DEAD_END && bl3 ? flowInfo.setReachMode(1).unconditionalInits() : flowInfo2.addPotentialInitializationsFrom(flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits()) : flowInfo.mergedWith(flowInfo2.unconditionalInits()));
        return unconditionalFlowInfo;
    }

    public static UnconditionalFlowInfo mergedOptimizedBranchesIfElse(FlowInfo flowInfo, boolean bl, FlowInfo flowInfo2, boolean bl2, boolean bl3, FlowInfo flowInfo3, IfStatement ifStatement, boolean bl4) {
        UnconditionalFlowInfo unconditionalFlowInfo;
        if (bl) {
            if (flowInfo == DEAD_END && bl3) {
                if (!bl4) {
                    if (ifStatement.elseStatement == null) {
                        unconditionalFlowInfo = flowInfo3.unconditionalInits();
                    } else {
                        unconditionalFlowInfo = flowInfo2.unconditionalInits();
                        if (flowInfo2 != DEAD_END) {
                            unconditionalFlowInfo.setReachMode(flowInfo3.reachMode());
                        }
                    }
                } else {
                    unconditionalFlowInfo = flowInfo2.setReachMode(1).unconditionalInits();
                }
            } else {
                unconditionalFlowInfo = flowInfo.addPotentialInitializationsFrom(flowInfo2.nullInfoLessUnconditionalCopy()).unconditionalInits();
            }
        } else if (bl2) {
            if (flowInfo2 == DEAD_END && bl3) {
                if (!bl4) {
                    if (ifStatement.thenStatement == null) {
                        unconditionalFlowInfo = flowInfo3.unconditionalInits();
                    } else {
                        unconditionalFlowInfo = flowInfo.unconditionalInits();
                        if (flowInfo != DEAD_END) {
                            unconditionalFlowInfo.setReachMode(flowInfo3.reachMode());
                        }
                    }
                } else {
                    unconditionalFlowInfo = flowInfo.setReachMode(1).unconditionalInits();
                }
            } else {
                unconditionalFlowInfo = flowInfo2.addPotentialInitializationsFrom(flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
            }
        } else if ((flowInfo3.tagBits & 3) == 0 && (ifStatement.bits & 0x80) != 0 && flowInfo != DEAD_END && flowInfo2 != DEAD_END) {
            unconditionalFlowInfo = flowInfo.addPotentialInitializationsFrom(flowInfo2.nullInfoLessUnconditionalCopy()).unconditionalInits();
            unconditionalFlowInfo.definiteInits &= flowInfo2.unconditionalCopy().definiteInits;
            if ((unconditionalFlowInfo.tagBits & 1) != 0 && (flowInfo2.tagBits & 3) == 2) {
                unconditionalFlowInfo.tagBits &= 0xFFFFFFFE;
                unconditionalFlowInfo.tagBits |= 2;
            }
        } else if ((flowInfo3.tagBits & 3) == 0 && (ifStatement.bits & 0x100) != 0 && flowInfo != DEAD_END && flowInfo2 != DEAD_END) {
            unconditionalFlowInfo = flowInfo2.addPotentialInitializationsFrom(flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
            unconditionalFlowInfo.definiteInits &= flowInfo.unconditionalCopy().definiteInits;
            if ((unconditionalFlowInfo.tagBits & 1) != 0 && (flowInfo.tagBits & 3) == 2) {
                unconditionalFlowInfo.tagBits &= 0xFFFFFFFE;
                unconditionalFlowInfo.tagBits |= 2;
            }
        } else {
            unconditionalFlowInfo = flowInfo.mergedWith(flowInfo2.unconditionalInits());
        }
        return unconditionalFlowInfo;
    }

    public int reachMode() {
        return this.tagBits & 3;
    }

    public abstract FlowInfo safeInitsWhenTrue();

    public abstract FlowInfo setReachMode(int var1);

    public abstract UnconditionalFlowInfo mergedWith(UnconditionalFlowInfo var1);

    public abstract UnconditionalFlowInfo nullInfoLessUnconditionalCopy();

    public String toString() {
        if (this == DEAD_END) {
            return "FlowInfo.DEAD_END";
        }
        return super.toString();
    }

    public abstract UnconditionalFlowInfo unconditionalCopy();

    public abstract UnconditionalFlowInfo unconditionalFieldLessCopy();

    public abstract UnconditionalFlowInfo unconditionalInits();

    public abstract UnconditionalFlowInfo unconditionalInitsWithoutSideEffect();

    public abstract void resetAssignmentInfo(LocalVariableBinding var1);

    public static int tagBitsToNullStatus(long l) {
        if ((l & 0x100000000000000L) != 0L) {
            return 4;
        }
        if ((l & 0x80000000000000L) != 0L) {
            return 48;
        }
        return 1;
    }

    static {
        FlowInfo.DEAD_END.tagBits = 3;
    }
}

