/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel<Object>
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector<File> fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector<File> files = null;
    private Vector<File> directories = null;
    private int fetchID = 0;
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public BasicDirectoryModel(JFileChooser filechooser) {
        this.filechooser = filechooser;
        this.validateFileCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "directoryChanged" || prop == "fileViewChanged" || prop == "fileFilterChanged" || prop == "FileHidingChanged" || prop == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(prop)) {
            BasicFileChooserUI ui;
            BasicDirectoryModel model;
            Object old = e.getOldValue();
            if (old instanceof BasicFileChooserUI && (model = (ui = (BasicFileChooserUI)old).getModel()) != null) {
                model.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(prop)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector<File> fls = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i = 0; i < this.getSize(); ++i) {
                File f = this.fileCache.get(i);
                if (this.filechooser.isTraversable(f)) {
                    this.directories.add(f);
                    continue;
                }
                this.files.add(f);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File currentDirectory = this.filechooser.getCurrentDirectory();
        if (currentDirectory == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        this.setBusy(true, ++this.fetchID);
        this.loadThread = new LoadFilesThread(currentDirectory, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File oldFile, File newFile) {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (oldFile.renameTo(newFile)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object o) {
        return this.fileCache.contains(o);
    }

    public int indexOf(Object o) {
        return this.fileCache.indexOf(o);
    }

    @Override
    public Object getElementAt(int index) {
        return this.fileCache.get(index);
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    protected void sort(Vector<? extends File> v) {
        ShellFolder.sort(v);
    }

    protected boolean lt(File a, File b) {
        int diff = a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
        if (diff != 0) {
            return diff < 0;
        }
        return a.getName().compareTo(b.getName()) < 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private synchronized void setBusy(final boolean busy, int fid) {
        if (fid == this.fetchID) {
            boolean oldValue = this.busy;
            this.busy = busy;
            if (this.changeSupport != null && busy != oldValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicDirectoryModel.this.firePropertyChange("busy", !busy, busy);
                    }
                });
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private List<File> addFiles;
        private List<File> remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;

        public DoChangeContents(List<File> addFiles, int addStart, List<File> remFiles, int remStart, int fid) {
            this.addFiles = addFiles;
            this.addStart = addStart;
            this.remFiles = remFiles;
            this.remStart = remStart;
            this.fid = fid;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int remSize = this.remFiles == null ? 0 : this.remFiles.size();
                int addSize = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (remSize > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (addSize > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (remSize > 0 && addSize == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + remSize - 1);
                } else if (addSize > 0 && remSize == 0 && this.addStart + addSize <= BasicDirectoryModel.this.fileCache.size()) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + addSize - 1);
                } else {
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector<DoChangeContents> runnables;

        public LoadFilesThread(File currentDirectory, int fid) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = currentDirectory;
            this.fid = fid;
        }

        @Override
        public void run() {
            this.run0();
            BasicDirectoryModel.this.setBusy(false, this.fid);
        }

        public void run0() {
            FileSystemView fileSystem = BasicDirectoryModel.this.filechooser.getFileSystemView();
            if (this.isInterrupted()) {
                return;
            }
            File[] list = fileSystem.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            if (this.isInterrupted()) {
                return;
            }
            final Vector<File> newFileCache = new Vector<File>();
            Vector<File> newFiles = new Vector<File>();
            for (File file : list) {
                if (!BasicDirectoryModel.this.filechooser.accept(file)) continue;
                boolean isTraversable = BasicDirectoryModel.this.filechooser.isTraversable(file);
                if (isTraversable) {
                    newFileCache.addElement(file);
                } else if (BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    newFiles.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            BasicDirectoryModel.this.sort(newFileCache);
            BasicDirectoryModel.this.sort(newFiles);
            newFileCache.addAll(newFiles);
            DoChangeContents doChangeContents = ShellFolder.invoke(new Callable<DoChangeContents>(){

                @Override
                public DoChangeContents call() {
                    int oldSize;
                    int newSize = newFileCache.size();
                    if (newSize > (oldSize = BasicDirectoryModel.this.fileCache.size())) {
                        int start = oldSize;
                        int end = newSize;
                        block0: for (int i = 0; i < oldSize; ++i) {
                            if (((File)newFileCache.get(i)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            start = i;
                            for (int j = i; j < newSize; ++j) {
                                if (!((File)newFileCache.get(j)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                                end = j;
                                break block0;
                            }
                            break;
                        }
                        if (start >= 0 && end > start && newFileCache.subList(end, newSize).equals(BasicDirectoryModel.this.fileCache.subList(start, oldSize))) {
                            if (LoadFilesThread.this.isInterrupted()) {
                                return null;
                            }
                            return new DoChangeContents(newFileCache.subList(start, end), start, null, 0, LoadFilesThread.this.fid);
                        }
                    } else if (newSize < oldSize) {
                        int start = -1;
                        int end = -1;
                        for (int i = 0; i < newSize; ++i) {
                            if (((File)newFileCache.get(i)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            start = i;
                            end = i + oldSize - newSize;
                            break;
                        }
                        if (start >= 0 && end > start && BasicDirectoryModel.this.fileCache.subList(end, oldSize).equals(newFileCache.subList(start, newSize))) {
                            if (LoadFilesThread.this.isInterrupted()) {
                                return null;
                            }
                            return new DoChangeContents(null, 0, new Vector<File>(BasicDirectoryModel.this.fileCache.subList(start, end)), start, LoadFilesThread.this.fid);
                        }
                    }
                    if (!BasicDirectoryModel.this.fileCache.equals(newFileCache)) {
                        if (LoadFilesThread.this.isInterrupted()) {
                            LoadFilesThread.this.cancelRunnables(LoadFilesThread.this.runnables);
                        }
                        return new DoChangeContents(newFileCache, 0, BasicDirectoryModel.this.fileCache, 0, LoadFilesThread.this.fid);
                    }
                    return null;
                }
            });
            if (doChangeContents != null) {
                this.runnables.addElement(doChangeContents);
                SwingUtilities.invokeLater(doChangeContents);
            }
        }

        public void cancelRunnables(Vector<DoChangeContents> runnables) {
            for (DoChangeContents runnable : runnables) {
                runnable.cancel();
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

