/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.actions.NewTemplateAction;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public final class SaveAsTemplateAction
extends NodeAction {
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAsTemplateAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(DataObject.class, (String)"SaveAsTemplate");
    }

    @Deprecated
    public String iconResource() {
        return super.iconResource();
    }

    protected boolean surviveFocusChange() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (dataObject != null && dataObject.isCopyAllowed()) continue;
            return false;
        }
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        Node[] nodeArray2;
        FolderNodeAcceptor folderNodeAcceptor = FolderNodeAcceptor.getInstance();
        String string = NbBundle.getMessage(DataObject.class, (String)"Title_SaveAsTemplate");
        String string2 = NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate");
        Node node = NewTemplateAction.getTemplateRoot();
        node.setDisplayName(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate_TemplatesRoot"));
        try {
            nodeArray2 = NodeOperation.getDefault().select(string, string2, node, (NodeAcceptor)folderNodeAcceptor, null);
        }
        catch (UserCancelException userCancelException) {
            return;
        }
        DataFolder dataFolder = (DataFolder)nodeArray2[0].getCookie(DataFolder.class);
        for (int i = 0; i < nodeArray.length; ++i) {
            this.createNewTemplate((DataObject)nodeArray[i].getCookie(DataObject.class), dataFolder);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private void createNewTemplate(DataObject dataObject, DataFolder dataFolder) {
        try {
            SaveCookie saveCookie = dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            DataObject dataObject2 = dataObject.copy(dataFolder);
            DataObject dataObject3 = null;
            for (DataObject dataObject4 : dataFolder.getChildren()) {
                if (!dataObject4.isTemplate()) continue;
                dataObject3 = dataObject4;
                break;
            }
            dataObject2.setTemplate(true);
            if (dataObject3 == null) {
                dataObject2.getPrimaryFile().setAttribute("javax.script.ScriptEngine", (Object)"freemarker");
            } else {
                SaveAsTemplateAction.setTemplateAttributes(dataObject2.getPrimaryFile(), SaveAsTemplateAction.getAttributes(dataObject3.getPrimaryFile()));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void setTemplateAttributes(FileObject fileObject, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("SystemFileSystem.localizingBundle".equals(entry.getKey())) continue;
            fileObject.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, Object> getAttributes(FileObject fileObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string == null || (object = fileObject.getAttribute(string)) == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    static final class FolderNodeAcceptor
    implements NodeAcceptor {
        private static FolderNodeAcceptor instance;
        private DataFolder rootFolder;

        private FolderNodeAcceptor(DataFolder dataFolder) {
            this.rootFolder = dataFolder;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            boolean bl = false;
            if (nodeArray == null || nodeArray.length != 1) {
                bl = false;
            } else {
                Node node = nodeArray[0];
                DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
                if (dataFolder != null) {
                    bl = !this.rootFolder.equals(dataFolder);
                }
            }
            return bl;
        }

        static FolderNodeAcceptor getInstance() {
            DataFolder dataFolder = (DataFolder)NewTemplateAction.getTemplateRoot().getCookie(DataFolder.class);
            if (instance == null) {
                instance = new FolderNodeAcceptor(dataFolder);
            }
            return instance;
        }
    }
}

