If you install fzf using Cygwin's setup-*.exe package manager, you shouldn't have any of the below problems, but you may not be getting the latest code.

See also https://github.com/junegunn/fzf/issues/89

### Source code in dos format

If you see `line 2: $'\r': command not found` message when you run install script, it is likely that your git installation automatically converted the source to dos format. Please reinstall your git so that it does not clone source in dos format, or you can just use `curl` or `wget` instead to download the source.

```sh
mkdir -p ~/.fzf
curl -L https://github.com/junegunn/fzf/archive/master.tar.gz |
    tar xz --strip-components 1 -C ~/.fzf
~/.fzf/install
```

### `No such file or directory`

You may have trouble running fzf with Ruby for Windows. Try to run it with the Ruby bundled with Cygwin.

#### References

- http://stackoverflow.com/questions/3831131/rubygems-cygwin-posix-path-not-found-by-ruby-exe
- http://blog.mmediasys.com/2008/10/27/handy-tip-dont-mix-one-click-installer-with-cygwin/
- http://www.question-defense.com/2009/03/27/rubyexe-no-such-file-or-directory-cygdrivecrubybingem-loaderror
- http://stackoverflow.com/questions/3831131/rubygems-cygwin-posix-path-not-found-by-ruby-exe
