/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXFont;

public class TeXEnvironment {
    private Color background = null;
    private Color color = null;
    private int style = 0;
    private TeXFont tf;
    private int lastFontId = -1;
    private float textwidth = Float.POSITIVE_INFINITY;
    private String textStyle;
    private boolean smallCap;
    private float scaleFactor = 1.0f;
    private int interlineUnit;
    private float interline;
    public boolean isColored = false;

    public TeXEnvironment(int n, TeXFont teXFont) {
        this(n, teXFont, null, null);
    }

    public TeXEnvironment(int n, TeXFont teXFont, int n2, float f) {
        this(n, teXFont, null, null);
        this.textwidth = f * SpaceAtom.getFactor(n2, this);
    }

    private TeXEnvironment(int n, TeXFont teXFont, Color color, Color color2) {
        this.style = n;
        this.tf = teXFont;
        this.background = color;
        this.color = color2;
        this.setInterline(1, 1.0f);
    }

    private TeXEnvironment(int n, float f, TeXFont teXFont, Color color, Color color2, String string, boolean bl) {
        this.style = n;
        this.scaleFactor = f;
        this.tf = teXFont;
        this.textStyle = string;
        this.smallCap = bl;
        this.background = color;
        this.color = color2;
        this.setInterline(1, 1.0f);
    }

    public void setInterline(int n, float f) {
        this.interline = f;
        this.interlineUnit = n;
    }

    public float getInterline() {
        return this.interline * SpaceAtom.getFactor(this.interlineUnit, this);
    }

    public void setTextwidth(int n, float f) {
        this.textwidth = f * SpaceAtom.getFactor(n, this);
    }

    public float getTextwidth() {
        return this.textwidth;
    }

    public void setScaleFactor(float f) {
        this.scaleFactor = f;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    protected TeXEnvironment copy() {
        return new TeXEnvironment(this.style, this.scaleFactor, this.tf, this.background, this.color, this.textStyle, this.smallCap);
    }

    protected TeXEnvironment copy(TeXFont teXFont) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(this.style, this.scaleFactor, teXFont, this.background, this.color, this.textStyle, this.smallCap);
        teXEnvironment.textwidth = this.textwidth;
        teXEnvironment.interline = this.interline;
        teXEnvironment.interlineUnit = this.interlineUnit;
        return teXEnvironment;
    }

    public TeXEnvironment crampStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = this.style % 2 == 1 ? this.style : this.style + 1;
        return teXEnvironment;
    }

    public TeXEnvironment denomStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = 2 * (this.style / 2) + 1 + 2 - 2 * (this.style / 6);
        return teXEnvironment;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.color;
    }

    public float getSize() {
        return this.tf.getSize();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String string) {
        this.textStyle = string;
    }

    public boolean getSmallCap() {
        return this.smallCap;
    }

    public void setSmallCap(boolean bl) {
        this.smallCap = bl;
    }

    public TeXFont getTeXFont() {
        return this.tf;
    }

    public TeXEnvironment numStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = this.style + 2 - 2 * (this.style / 6);
        return teXEnvironment;
    }

    public void reset() {
        this.color = null;
        this.background = null;
    }

    public TeXEnvironment rootStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = 6;
        return teXEnvironment;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public TeXEnvironment subStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = 2 * (this.style / 4) + 4 + 1;
        return teXEnvironment;
    }

    public TeXEnvironment supStyle() {
        TeXEnvironment teXEnvironment = this.copy();
        teXEnvironment.style = 2 * (this.style / 4) + 4 + this.style % 2;
        return teXEnvironment;
    }

    public float getSpace() {
        return this.tf.getSpace(this.style) * this.tf.getScaleFactor();
    }

    public void setLastFontId(int n) {
        this.lastFontId = n;
    }

    public int getLastFontId() {
        return this.lastFontId == -1 ? this.tf.getMuFontId() : this.lastFontId;
    }
}

