/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.File;
import java.security.AccessControlException;
import java.util.Objects;
import javax.security.auth.kerberos.JavaxSecurityAuthKerberosAccessImpl;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.misc.SharedSecrets;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;

public final class KeyTab {
    private final File file;

    private KeyTab(File file) {
        this.file = file;
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(file);
    }

    public static KeyTab getInstance() {
        return new KeyTab(null);
    }

    private sun.security.krb5.internal.ktab.KeyTab takeSnapshot() {
        try {
            return sun.security.krb5.internal.ktab.KeyTab.getInstance(this.file);
        }
        catch (AccessControlException ace) {
            if (this.file != null) {
                throw ace;
            }
            AccessControlException ace2 = new AccessControlException("Access to default keytab denied (modified exception)");
            ace2.setStackTrace(ace.getStackTrace());
            throw ace2;
        }
    }

    public KerberosKey[] getKeys(KerberosPrincipal principal) {
        try {
            EncryptionKey[] keys = this.takeSnapshot().readServiceKeys(new PrincipalName(principal.getName()));
            KerberosKey[] kks = new KerberosKey[keys.length];
            for (int i = 0; i < kks.length; ++i) {
                Integer tmp = keys[i].getKeyVersionNumber();
                kks[i] = new KerberosKey(principal, keys[i].getBytes(), keys[i].getEType(), tmp == null ? 0 : tmp);
                keys[i].destroy();
            }
            return kks;
        }
        catch (RealmException re) {
            return new KerberosKey[0];
        }
    }

    EncryptionKey[] getEncryptionKeys(PrincipalName principal) {
        return this.takeSnapshot().readServiceKeys(principal);
    }

    public boolean exists() {
        return !this.takeSnapshot().isMissing();
    }

    public String toString() {
        return this.file == null ? "Default keytab" : this.file.toString();
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KeyTab)) {
            return false;
        }
        KeyTab otherKtab = (KeyTab)other;
        return Objects.equals(otherKtab.file, this.file);
    }

    static {
        SharedSecrets.setJavaxSecurityAuthKerberosAccess(new JavaxSecurityAuthKerberosAccessImpl());
    }
}

