/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;

abstract class MessageToken
extends Krb5Token {
    private static final int TOKEN_NO_CKSUM_SIZE = 16;
    private static final int FILLER = 65535;
    static final int SGN_ALG_DES_MAC_MD5 = 0;
    static final int SGN_ALG_DES_MAC = 512;
    static final int SGN_ALG_HMAC_SHA1_DES3_KD = 1024;
    static final int SEAL_ALG_NONE = 65535;
    static final int SEAL_ALG_DES = 0;
    static final int SEAL_ALG_DES3_KD = 512;
    static final int SEAL_ALG_ARCFOUR_HMAC = 4096;
    static final int SGN_ALG_HMAC_MD5_ARCFOUR = 4352;
    private static final int TOKEN_ID_POS = 0;
    private static final int SIGN_ALG_POS = 2;
    private static final int SEAL_ALG_POS = 4;
    private int seqNumber;
    private boolean confState = true;
    private boolean initiator = true;
    private int tokenId = 0;
    private GSSHeader gssHeader = null;
    private MessageTokenHeader tokenHeader = null;
    private byte[] checksum = null;
    private byte[] encSeqNumber = null;
    private byte[] seqNumberData = null;
    CipherHelper cipherHelper = null;

    MessageToken(int tokenId, Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        this(tokenId, context, new ByteArrayInputStream(tokenBytes, tokenOffset, tokenLen), prop);
    }

    MessageToken(int tokenId, Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        this.init(tokenId, context);
        try {
            this.gssHeader = new GSSHeader(is);
            if (!this.gssHeader.getOid().equals(OID)) {
                throw new GSSException(10, -1, MessageToken.getTokenName(tokenId));
            }
            if (!this.confState) {
                prop.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(is, prop);
            this.encSeqNumber = new byte[8];
            MessageToken.readFully(is, this.encSeqNumber);
            this.checksum = new byte[this.cipherHelper.getChecksumLength()];
            MessageToken.readFully(is, this.checksum);
        }
        catch (IOException e) {
            throw new GSSException(10, -1, MessageToken.getTokenName(tokenId) + ":" + e.getMessage());
        }
    }

    public final GSSHeader getGSSHeader() {
        return this.gssHeader;
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final byte[] getEncSeqNumber() {
        return this.encSeqNumber;
    }

    public final byte[] getChecksum() {
        return this.checksum;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public void genSignAndSeqNumber(MessageProp prop, byte[] optionalHeader, byte[] data, int offset, int len, byte[] optionalTrailer) throws GSSException {
        int qop = prop.getQOP();
        if (qop != 0) {
            qop = 0;
            prop.setQOP(qop);
        }
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, prop.getPrivacy(), qop);
        this.checksum = this.getChecksum(optionalHeader, data, offset, len, optionalTrailer);
        this.seqNumberData = new byte[8];
        if (this.cipherHelper.isArcFour()) {
            MessageToken.writeBigEndian(this.seqNumber, this.seqNumberData);
        } else {
            MessageToken.writeLittleEndian(this.seqNumber, this.seqNumberData);
        }
        if (!this.initiator) {
            this.seqNumberData[4] = -1;
            this.seqNumberData[5] = -1;
            this.seqNumberData[6] = -1;
            this.seqNumberData[7] = -1;
        }
        this.encSeqNumber = this.cipherHelper.encryptSeq(this.checksum, this.seqNumberData, 0, 8);
    }

    public final boolean verifySignAndSeqNumber(byte[] optionalHeader, byte[] data, int offset, int len, byte[] optionalTrailer) throws GSSException {
        byte[] myChecksum = this.getChecksum(optionalHeader, data, offset, len, optionalTrailer);
        if (MessageDigest.isEqual(this.checksum, myChecksum)) {
            this.seqNumberData = this.cipherHelper.decryptSeq(this.checksum, this.encSeqNumber, 0, 8);
            byte directionByte = 0;
            if (this.initiator) {
                directionByte = -1;
            }
            if (this.seqNumberData[4] == directionByte && this.seqNumberData[5] == directionByte && this.seqNumberData[6] == directionByte && this.seqNumberData[7] == directionByte) {
                return true;
            }
        }
        return false;
    }

    public final int getSequenceNumber() {
        int sequenceNum = 0;
        sequenceNum = this.cipherHelper.isArcFour() ? MessageToken.readBigEndian(this.seqNumberData, 0, 4) : MessageToken.readLittleEndian(this.seqNumberData, 0, 4);
        return sequenceNum;
    }

    private byte[] getChecksum(byte[] optionalHeader, byte[] data, int offset, int len, byte[] optionalTrailer) throws GSSException {
        byte[] tokenHeaderBytes = this.tokenHeader.getBytes();
        byte[] existingHeader = optionalHeader;
        byte[] checksumDataHeader = tokenHeaderBytes;
        if (existingHeader != null) {
            checksumDataHeader = new byte[tokenHeaderBytes.length + existingHeader.length];
            System.arraycopy(tokenHeaderBytes, 0, checksumDataHeader, 0, tokenHeaderBytes.length);
            System.arraycopy(existingHeader, 0, checksumDataHeader, tokenHeaderBytes.length, existingHeader.length);
        }
        return this.cipherHelper.calculateChecksum(this.tokenHeader.getSignAlg(), checksumDataHeader, optionalTrailer, data, offset, len, this.tokenId);
    }

    MessageToken(int tokenId, Krb5Context context) throws GSSException {
        this.init(tokenId, context);
        this.seqNumber = context.incrementMySequenceNumber();
    }

    private void init(int tokenId, Krb5Context context) throws GSSException {
        this.tokenId = tokenId;
        this.confState = context.getConfState();
        this.initiator = context.isInitiator();
        this.cipherHelper = context.getCipherHelper(null);
    }

    public void encode(OutputStream os) throws IOException, GSSException {
        this.gssHeader = new GSSHeader(OID, this.getKrb5TokenSize());
        this.gssHeader.encode(os);
        this.tokenHeader.encode(os);
        os.write(this.encSeqNumber);
        os.write(this.checksum);
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize();
    }

    protected final int getTokenSize() throws GSSException {
        return 16 + this.cipherHelper.getChecksumLength();
    }

    protected static final int getTokenSize(CipherHelper ch) throws GSSException {
        return 16 + ch.getChecksumLength();
    }

    protected abstract int getSealAlg(boolean var1, int var2) throws GSSException;

    protected int getSgnAlg(int qop) throws GSSException {
        return this.cipherHelper.getSgnAlg();
    }

    class MessageTokenHeader {
        private int tokenId;
        private int signAlg;
        private int sealAlg;
        private byte[] bytes = new byte[8];

        public MessageTokenHeader(int tokenId, boolean conf, int qop) throws GSSException {
            this.tokenId = tokenId;
            this.signAlg = MessageToken.this.getSgnAlg(qop);
            this.sealAlg = MessageToken.this.getSealAlg(conf, qop);
            this.bytes[0] = (byte)(tokenId >>> 8);
            this.bytes[1] = (byte)tokenId;
            this.bytes[2] = (byte)(this.signAlg >>> 8);
            this.bytes[3] = (byte)this.signAlg;
            this.bytes[4] = (byte)(this.sealAlg >>> 8);
            this.bytes[5] = (byte)this.sealAlg;
            this.bytes[6] = -1;
            this.bytes[7] = -1;
        }

        public MessageTokenHeader(InputStream is, MessageProp prop) throws IOException {
            GSSToken.readFully(is, this.bytes);
            this.tokenId = GSSToken.readInt(this.bytes, 0);
            this.signAlg = GSSToken.readInt(this.bytes, 2);
            this.sealAlg = GSSToken.readInt(this.bytes, 4);
            int temp = GSSToken.readInt(this.bytes, 6);
            switch (this.sealAlg) {
                case 0: 
                case 512: 
                case 4096: {
                    prop.setPrivacy(true);
                    break;
                }
                default: {
                    prop.setPrivacy(false);
                }
            }
            prop.setQOP(0);
        }

        public final void encode(OutputStream os) throws IOException {
            os.write(this.bytes);
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final int getSignAlg() {
            return this.signAlg;
        }

        public final int getSealAlg() {
            return this.sealAlg;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }
    }
}

