/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetaData;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.component.local.model.LocalConfigurationMetaData;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetaData;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalComponentMetaData
implements LocalComponentMetaData,
BuildableLocalComponentMetaData {
    private final Map<String, DefaultLocalConfigurationMetaData> allConfigurations = Maps.newHashMap();
    private final Map<String, Iterable<? extends PublishArtifact>> allArtifacts = Maps.newHashMap();
    private final List<DependencyMetaData> allDependencies = Lists.newArrayList();
    private final List<ExcludeRule> allExcludeRules = Lists.newArrayList();
    private final ModuleVersionIdentifier id;
    private final ComponentIdentifier componentIdentifier;
    private final String status;

    public DefaultLocalComponentMetaData(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, String status) {
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.status = status;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void addArtifacts(String configuration, Iterable<? extends PublishArtifact> artifacts) {
        this.allArtifacts.put(configuration, artifacts);
    }

    @Override
    public void addConfiguration(String name, String description, Set<String> extendsFrom, Set<String> hierarchy, boolean visible, boolean transitive, TaskDependency buildDependencies) {
        DefaultLocalConfigurationMetaData conf = new DefaultLocalConfigurationMetaData(name, description, visible, transitive, extendsFrom, hierarchy, buildDependencies);
        this.allConfigurations.put(name, conf);
    }

    @Override
    public void addDependency(DependencyMetaData dependency) {
        this.allDependencies.add(dependency);
    }

    @Override
    public void addExcludeRule(ExcludeRule excludeRule) {
        this.allExcludeRules.add(excludeRule);
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleSource getSource() {
        return null;
    }

    @Override
    public ComponentResolveMetaData withSource(ModuleSource source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public List<DependencyMetaData> getDependencies() {
        return this.allDependencies;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public DefaultLocalConfigurationMetaData getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    static Set<ComponentArtifactMetaData> getArtifacts(ComponentIdentifier componentIdentifier, Set<String> configurationHierarchy, Map<String, Iterable<? extends PublishArtifact>> allArtifacts) {
        HashSet seen = Sets.newHashSet();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (String config : configurationHierarchy) {
            Iterable<? extends PublishArtifact> publishArtifacts = allArtifacts.get(config);
            if (publishArtifacts == null) continue;
            for (PublishArtifact publishArtifact : publishArtifacts) {
                if (!seen.add(publishArtifact)) continue;
                artifacts.add(new PublishArtifactLocalArtifactMetaData(componentIdentifier, componentIdentifier.getDisplayName(), publishArtifact));
            }
        }
        return artifacts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultLocalConfigurationMetaData
    implements LocalConfigurationMetaData {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final Set<String> hierarchy;
        private final Set<String> extendsFrom;
        private final TaskDependency buildDependencies;
        private List<DependencyMetaData> configurationDependencies;
        private LinkedHashSet<ExcludeRule> configurationExcludeRules;

        private DefaultLocalConfigurationMetaData(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, Set<String> hierarchy, TaskDependency buildDependencies) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.buildDependencies = buildDependencies;
        }

        public String toString() {
            return String.format("%s:%s", DefaultLocalComponentMetaData.this.componentIdentifier.getDisplayName(), this.name);
        }

        @Override
        public ComponentResolveMetaData getComponent() {
            return DefaultLocalComponentMetaData.this;
        }

        @Override
        public TaskDependency getDirectBuildDependencies() {
            return this.buildDependencies;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public List<DependencyMetaData> getDependencies() {
            if (this.configurationDependencies == null) {
                this.configurationDependencies = new ArrayList<DependencyMetaData>();
                for (DependencyMetaData dependency : DefaultLocalComponentMetaData.this.allDependencies) {
                    if (!this.include(dependency)) continue;
                    this.configurationDependencies.add(dependency);
                }
            }
            return this.configurationDependencies;
        }

        private boolean include(DependencyMetaData dependency) {
            String[] moduleConfigurations = dependency.getModuleConfigurations();
            for (int i = 0; i < moduleConfigurations.length; ++i) {
                String moduleConfiguration = moduleConfigurations[i];
                if (moduleConfiguration.equals("%") || this.hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (int j = i + 1; j < moduleConfigurations.length && moduleConfigurations[j].startsWith("!"); ++j) {
                    if (!moduleConfigurations[j].substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<ExcludeRule> getExcludeRules() {
            if (this.configurationExcludeRules == null) {
                this.configurationExcludeRules = new LinkedHashSet();
                block0: for (ExcludeRule excludeRule : DefaultLocalComponentMetaData.this.allExcludeRules) {
                    for (String config : excludeRule.getConfigurations()) {
                        if (!this.hierarchy.contains(config)) continue;
                        this.configurationExcludeRules.add(excludeRule);
                        continue block0;
                    }
                }
            }
            return this.configurationExcludeRules;
        }

        @Override
        public Set<ComponentArtifactMetaData> getArtifacts() {
            return DefaultLocalComponentMetaData.getArtifacts(DefaultLocalComponentMetaData.this.componentIdentifier, this.getHierarchy(), DefaultLocalComponentMetaData.this.allArtifacts);
        }

        @Override
        public ComponentArtifactMetaData artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetaData candidate : this.getArtifacts()) {
                if (!candidate.getName().equals(ivyArtifactName)) continue;
                return candidate;
            }
            return new MissingLocalArtifactMetaData(DefaultLocalComponentMetaData.this.componentIdentifier, DefaultLocalComponentMetaData.this.id.toString(), ivyArtifactName);
        }
    }
}

