/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino.worker.internal;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.gradle.internal.UncheckedException;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandle;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoClientWorkerProtocol;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerClientProtocol;
import org.gradle.process.internal.WorkerProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRhinoWorkerHandle<R extends Serializable, P extends Serializable>
implements RhinoWorkerHandle<R, P> {
    private final Class<R> resultType;
    private final WorkerProcess workerProcess;

    public DefaultRhinoWorkerHandle(Class<R> resultType, WorkerProcess workerProcess) {
        this.resultType = resultType;
        this.workerProcess = workerProcess;
    }

    @Override
    public R process(P payload) {
        CountDownLatch latch = new CountDownLatch(1);
        Receiver receiver = new Receiver(latch);
        this.workerProcess.start();
        this.workerProcess.getConnection().addIncoming(RhinoWorkerClientProtocol.class, (Object)receiver);
        RhinoClientWorkerProtocol worker = (RhinoClientWorkerProtocol)this.workerProcess.getConnection().addOutgoing(RhinoClientWorkerProtocol.class);
        this.workerProcess.getConnection().connect();
        worker.process(payload);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.workerProcess.waitForStop();
        if (receiver.initialisationError != null) {
            throw UncheckedException.throwAsUncheckedException((Throwable)receiver.initialisationError);
        }
        if (receiver.executionError != null) {
            throw UncheckedException.throwAsUncheckedException((Throwable)receiver.executionError);
        }
        Serializable result = receiver.result;
        if (result == null) {
            return null;
        }
        if (this.resultType.isInstance(result)) {
            return (R)((Serializable)this.resultType.cast(result));
        }
        throw new IllegalStateException(String.format("Was expecting result of type %s, received %s", this.resultType, result.getClass()));
    }

    private static class Receiver
    implements RhinoWorkerClientProtocol {
        private final CountDownLatch latch;
        Exception initialisationError;
        Serializable result;
        Exception executionError;

        private Receiver(CountDownLatch latch) {
            this.latch = latch;
        }

        public void initialisationError(Exception e) {
            this.initialisationError = e;
            this.latch.countDown();
        }

        public void receiveResult(Serializable result) {
            this.result = result;
            this.latch.countDown();
        }

        public void executionError(Exception e) {
            this.executionError = e;
            this.latch.countDown();
        }
    }
}

