/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation;

import java.util.Iterator;
import java.util.List;
import org.gradle.foundation.TaskView;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.util.internal.ArgumentsSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineAssistant {
    private final LoggingCommandLineConverter loggingCommandLineConverter = new LoggingCommandLineConverter();

    public LoggingCommandLineConverter getLoggingCommandLineConverter() {
        return this.loggingCommandLineConverter;
    }

    public static String[] breakUpCommandLine(String fullCommandLine) {
        List commandLineArguments = ArgumentsSplitter.split((String)fullCommandLine);
        return commandLineArguments.toArray(new String[0]);
    }

    public boolean hasLogLevelDefined(String[] commandLineArguments) {
        return this.hasCommandLineOptionsDefined(commandLineArguments, new CommandLineSearch(){

            public boolean contains(String commandLine) {
                return CommandLineAssistant.this.loggingCommandLineConverter.getLogLevel(commandLine) != null;
            }
        });
    }

    public boolean hasShowStacktraceDefined(String[] commandLineArguments) {
        return this.hasCommandLineOptionsDefined(commandLineArguments, new CommandLineSearch(){

            public boolean contains(String commandLine) {
                return CommandLineAssistant.this.loggingCommandLineConverter.getShowStacktrace(commandLine) != null;
            }
        });
    }

    private boolean hasCommandLineOptionsDefined(String[] commandLineOptions, CommandLineSearch commandLineSearch) {
        for (int commandLineOptionsIndex = 0; commandLineOptionsIndex < commandLineOptions.length; ++commandLineOptionsIndex) {
            String remainder;
            String commandLineOption = commandLineOptions[commandLineOptionsIndex];
            if (commandLineOption == null || commandLineOption.length() <= 1 || commandLineOption.charAt(0) != '-' || !commandLineSearch.contains(remainder = commandLineOption.substring(1))) continue;
            return true;
        }
        return false;
    }

    public static String appendAdditionalCommandLineOptions(TaskView task, String ... additionCommandLineOptions) {
        if (additionCommandLineOptions == null || additionCommandLineOptions.length == 0) {
            return task.getFullTaskName();
        }
        StringBuilder builder = new StringBuilder(task.getFullTaskName());
        builder.append(' ');
        CommandLineAssistant.appendAdditionalCommandLineOptions(builder, additionCommandLineOptions);
        return builder.toString();
    }

    public static String combineTasks(List<TaskView> tasks, String ... additionCommandLineOptions) {
        if (tasks == null || tasks.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<TaskView> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TaskView taskView = iterator.next();
            builder.append(taskView.getFullTaskName());
            if (!iterator.hasNext()) continue;
            builder.append(' ');
        }
        CommandLineAssistant.appendAdditionalCommandLineOptions(builder, additionCommandLineOptions);
        return builder.toString();
    }

    public static void appendAdditionalCommandLineOptions(StringBuilder builder, String ... additionCommandLineOptions) {
        if (additionCommandLineOptions != null) {
            for (int index = 0; index < additionCommandLineOptions.length; ++index) {
                String additionCommandLineOption = additionCommandLineOptions[index];
                builder.append(additionCommandLineOption);
                if (index + 1 >= additionCommandLineOptions.length) continue;
                builder.append(' ');
            }
        }
    }

    public static interface CommandLineSearch {
        public boolean contains(String var1);
    }
}

