/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;

class LoggingMavenTransferListener
extends AbstractTransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMavenTransferListener.class);
    private static final int KILO = 1024;

    LoggingMavenTransferListener() {
    }

    public void transferFailed(TransferEvent event) {
        LOGGER.error(event.getException().getMessage());
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading: {} to repository {} at {}" : "Downloading: {} from repository {} at {}";
        LOGGER.info(message, new Object[]{event.getResource().getResourceName(), "remote", event.getResource().getRepositoryUrl()});
    }

    public void transferStarted(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L) {
            LOGGER.info("Transferring {}K from remote", (Object)((contentLength + 512L) / 1024L));
        }
    }

    public void transferSucceeded(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L && event.getRequestType() == TransferEvent.RequestType.PUT) {
            LOGGER.info("Uploaded {}K", (Object)((contentLength + 512L) / 1024L));
        }
    }
}

