/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import java.io.PrintWriter;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.operations.logging.BuildOperationLogInfo;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.logging.ConsoleRenderer;

class DefaultBuildOperationLogger
implements BuildOperationLogger {
    private final BuildOperationLogInfo configuration;
    private final Logger logger;
    private final PrintWriter logWriter;
    private boolean started;
    private int numberOfFailedOperationsSeen;

    DefaultBuildOperationLogger(BuildOperationLogInfo configuration, Logger logger, PrintWriter logWriter) {
        this.configuration = configuration;
        this.logger = logger;
        this.logWriter = logWriter;
        this.numberOfFailedOperationsSeen = 0;
        this.started = false;
    }

    public void start() {
        assert (!this.started);
        this.logInBoth(LogLevel.INFO, String.format("See %s for all output for %s.", this.getLogLocation(), this.configuration.getTaskName()));
        this.started = true;
    }

    public synchronized void operationSuccess(String description, String output) {
        assert (this.started);
        this.logInBoth(LogLevel.DEBUG, description.concat(" successful."));
        this.maybeShowSuccess(output);
    }

    public synchronized void operationFailed(String description, String output) {
        assert (this.started);
        this.logInBoth(LogLevel.DEBUG, description.concat(" failed."));
        this.maybeShowFailure(output);
    }

    public void done() {
        assert (this.started);
        int suppressedCount = this.numberOfFailedOperationsSeen - this.configuration.getMaximumFailedOperationsShown();
        if (suppressedCount > 0) {
            this.logger.log(LogLevel.ERROR, String.format("...output for %d more failed operation(s) continued in %s.", suppressedCount, this.getLogLocation()));
        }
        this.logInBoth(LogLevel.INFO, String.format("Finished %s, see full log %s.", this.configuration.getTaskName(), this.getLogLocation()));
        this.logWriter.close();
        this.started = false;
    }

    private void maybeShowSuccess(String output) {
        this.logger.log(LogLevel.INFO, output);
        this.logWriter.println(output);
    }

    private void maybeShowFailure(String output) {
        if (this.numberOfFailedOperationsSeen < this.configuration.getMaximumFailedOperationsShown()) {
            this.logger.log(LogLevel.ERROR, output);
        }
        this.logWriter.println(output);
        ++this.numberOfFailedOperationsSeen;
    }

    private void logInBoth(LogLevel logLevel, String message) {
        this.logger.log(logLevel, message);
        this.logWriter.println(message);
    }

    public String getLogLocation() {
        return new ConsoleRenderer().asClickableFileUrl(this.configuration.getOutputFile());
    }
}

