/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.internal.JavaScriptSourceCode;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.tasks.JavaScriptMinify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayJavaScriptPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaScript
    implements LanguageTransform<JavaScriptSourceSet, JavaScriptSourceCode> {
        private JavaScript() {
        }

        public String getLanguageName() {
            return "javaScript";
        }

        public Class<JavaScriptSourceSet> getSourceSetType() {
            return JavaScriptSourceSet.class;
        }

        public Class<JavaScriptSourceCode> getOutputType() {
            return JavaScriptSourceCode.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "minify";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return JavaScriptMinify.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    PlayApplicationBinarySpecInternal binary = (PlayApplicationBinarySpecInternal)binarySpec;
                    JavaScriptSourceSet javaScriptSourceSet = (JavaScriptSourceSet)sourceSet;
                    JavaScriptMinify javaScriptMinify = (JavaScriptMinify)task;
                    javaScriptMinify.setDescription("Minifies javascript for the " + javaScriptSourceSet.getDisplayName() + ".");
                    File generatedSourceDir = binary.getNamingScheme().getOutputDirectory(task.getProject().getBuildDir(), "src");
                    File outputDirectory = new File(generatedSourceDir, javaScriptMinify.getName());
                    javaScriptMinify.setDestinationDir(outputDirectory);
                    javaScriptMinify.setSource(javaScriptSourceSet.getSource());
                    javaScriptMinify.setPlayPlatform(binary.getTargetPlatform());
                    javaScriptMinify.dependsOn(new Object[]{javaScriptSourceSet});
                    binary.getAssets().addAssetDir(outputDirectory);
                    binary.getAssets().builtBy(new Object[]{javaScriptMinify});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof PlayApplicationBinarySpecInternal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerJavascript(TypeBuilder<JavaScriptSourceSet> builder) {
            builder.defaultImplementation(DefaultJavaScriptSourceSet.class);
        }

        @Finalize
        void createJavascriptSourceSets(@Each PlayApplicationSpec playComponent) {
            playComponent.getSources().create("javaScript", JavaScriptSourceSet.class, (Action)new Action<JavaScriptSourceSet>(){

                public void execute(JavaScriptSourceSet javaScriptSourceSet) {
                    javaScriptSourceSet.getSource().srcDir((Object)"app/assets");
                    javaScriptSourceSet.getSource().include(new String[]{"**/*.js"});
                }
            });
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages) {
            languages.add((Object)new JavaScript());
        }
    }
}

