/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageSerializer<T>
implements MessageSerializer<T> {
    private final ClassLoader classLoader;

    public DefaultMessageSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ObjectReader<T> newReader(InputStream inputStream, Address localAddress, Address remoteAddress) {
        return new MessageReader(inputStream, this.classLoader);
    }

    @Override
    public ObjectWriter<T> newWriter(OutputStream outputStream) {
        return new MessageWriter(outputStream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageWriter<T>
    implements ObjectWriter<T> {
        private final OutputStream outputStream;

        public MessageWriter(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(T value) throws Exception {
            Message.send(value, this.outputStream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageReader<T>
    implements ObjectReader<T> {
        private final InputStream inputStream;
        private final ClassLoader classLoader;

        public MessageReader(InputStream inputStream, ClassLoader classLoader) {
            this.inputStream = inputStream;
            this.classLoader = classLoader;
        }

        @Override
        public T read() throws Exception {
            return (T)Message.receive(this.inputStream, this.classLoader);
        }
    }
}

