/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class LocalFileStandInExternalResource
extends AbstractExternalResource {
    private final File localFile;
    private final URI source;
    private ExternalResourceMetaData metaData;

    public LocalFileStandInExternalResource(URI source, File localFile, ExternalResourceMetaData metaData) {
        this.source = source;
        this.localFile = localFile;
        this.metaData = metaData;
    }

    public URI getURI() {
        return this.source;
    }

    public long getLastModifiedTime() {
        return this.localFile.lastModified();
    }

    public long getContentLength() {
        return this.localFile.length();
    }

    public boolean isLocal() {
        return true;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.localFile);
    }

    public ExternalResourceMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new DefaultExternalResourceMetaData(this.source, this.getLastModifiedTime(), this.getContentLength());
        }
        return this.metaData;
    }
}

