/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import org.gradle.api.InvalidUserDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PublicationFieldValidator<T extends PublicationFieldValidator> {
    private final Class<T> type;
    protected final String publicationName;
    protected final String name;
    protected final String value;

    public PublicationFieldValidator(Class<T> type, String publicationName, String name, String value) {
        this.type = type;
        this.publicationName = publicationName;
        this.name = name;
        this.value = value;
    }

    public T notNull() {
        if (this.value == null) {
            String message = String.format("%s cannot be null.", this.name);
            throw this.failure(message);
        }
        return (T)((PublicationFieldValidator)this.type.cast(this));
    }

    public T notEmpty() {
        this.notNull();
        if (this.value.length() == 0) {
            throw this.failure(String.format("%s cannot be empty.", this.name));
        }
        return (T)((PublicationFieldValidator)this.type.cast(this));
    }

    public T validInFileName() {
        if (this.value == null || this.value.length() == 0) {
            return (T)((PublicationFieldValidator)this.type.cast(this));
        }
        this.doesNotContainSpecialCharacters(false);
        return (T)((PublicationFieldValidator)this.type.cast(this));
    }

    public T doesNotContainSpecialCharacters(boolean allowSlash) {
        int unicodeChar;
        if (this.value == null || this.value.length() == 0) {
            return (T)((PublicationFieldValidator)this.type.cast(this));
        }
        for (int offset = 0; offset < this.value.length(); offset += Character.charCount(unicodeChar)) {
            unicodeChar = this.value.codePointAt(offset);
            if (Character.isISOControl(unicodeChar)) {
                throw this.failure(String.format("%s cannot contain ISO control character '\\u%04x'.", this.name, unicodeChar));
            }
            if (92 != unicodeChar && (47 != unicodeChar || allowSlash)) continue;
            throw this.failure(String.format("%s cannot contain '%c'.", this.name, Character.valueOf((char)unicodeChar)));
        }
        return (T)((PublicationFieldValidator)this.type.cast(this));
    }

    public T optionalNotEmpty() {
        if (this.value != null && this.value.length() == 0) {
            throw this.failure(String.format("%s cannot be an empty string. Use null instead.", this.name));
        }
        return (T)((PublicationFieldValidator)this.type.cast(this));
    }

    protected abstract InvalidUserDataException failure(String var1);
}

