/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import jadx.api.IJadxArgs;
import jadx.api.JadxDecompiler;
import jadx.core.utils.exceptions.JadxException;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.LoggerFactory;

public class JadxCLIArgs
implements IJadxArgs {
    @Parameter(description="<input file> (.dex, .apk, .jar or .class)")
    protected List<String> files;
    @Parameter(names={"-d", "--output-dir"}, description="output directory")
    protected String outDirName;
    @Parameter(names={"-j", "--threads-count"}, description="processing threads count")
    protected int threadsCount = Runtime.getRuntime().availableProcessors();
    @Parameter(names={"-f", "--fallback"}, description="make simple dump (using goto instead of 'if', 'for', etc)")
    protected boolean fallbackMode = false;
    @Parameter(names={"-r", "--no-res"}, description="do not decode resources")
    protected boolean skipResources = false;
    @Parameter(names={"-s", "--no-src"}, description="do not decompile source code")
    protected boolean skipSources = false;
    @Parameter(names={"--show-bad-code"}, description="show inconsistent code (incorrectly decompiled)")
    protected boolean showInconsistentCode = false;
    @Parameter(names={"--cfg"}, description="save methods control flow graph to dot file")
    protected boolean cfgOutput = false;
    @Parameter(names={"--raw-cfg"}, description="save methods control flow graph (use raw instructions)")
    protected boolean rawCfgOutput = false;
    @Parameter(names={"-v", "--verbose"}, description="verbose output")
    protected boolean verbose = false;
    @Parameter(names={"--deobf"}, description="activate deobfuscation")
    protected boolean deobfuscationOn = false;
    @Parameter(names={"--deobf-min"}, description="min length of name")
    protected int deobfuscationMinLength = 2;
    @Parameter(names={"--deobf-max"}, description="max length of name")
    protected int deobfuscationMaxLength = 64;
    @Parameter(names={"--deobf-rewrite-cfg"}, description="force to save deobfuscation map")
    protected boolean deobfuscationForceSave = false;
    @Parameter(names={"-h", "--help"}, description="print this help", help=true)
    protected boolean printHelp = false;
    private final List<File> input = new ArrayList<File>(1);
    private File outputDir;

    public boolean processArgs(String[] args) {
        return this.parse(args) && this.process();
    }

    private boolean parse(String[] args) {
        try {
            new JCommander((Object)this, args);
            return true;
        }
        catch (ParameterException e) {
            System.err.println("Arguments parse error: " + e.getMessage());
            this.printUsage();
            return false;
        }
    }

    private boolean process() {
        if (this.isPrintHelp()) {
            this.printUsage();
            return false;
        }
        try {
            if (this.threadsCount <= 0) {
                throw new JadxException("Threads count must be positive");
            }
            if (this.files != null) {
                for (String fileName : this.files) {
                    File file = new File(fileName);
                    if (file.exists()) {
                        this.input.add(file);
                        continue;
                    }
                    throw new JadxException("File not found: " + file);
                }
            }
            if (this.input.size() > 1) {
                throw new JadxException("Only one input file is supported");
            }
            if (this.outDirName != null) {
                this.outputDir = new File(this.outDirName);
            }
            if (this.isVerbose()) {
                Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
                rootLogger.setLevel(Level.DEBUG);
            }
        }
        catch (JadxException e) {
            System.err.println("ERROR: " + e.getMessage());
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        Field[] fields;
        JCommander jc = new JCommander((Object)this);
        PrintStream out = System.out;
        out.println();
        out.println("jadx - dex to java decompiler, version: " + JadxDecompiler.getVersion());
        out.println();
        out.println("usage: jadx [options] " + jc.getMainParameterDescription());
        out.println("options:");
        List params = jc.getParameters();
        LinkedHashMap<String, ParameterDescription> paramsMap = new LinkedHashMap<String, ParameterDescription>(params.size());
        int maxNamesLen = 0;
        for (ParameterDescription p : params) {
            paramsMap.put(p.getParameterized().getName(), p);
            int len = p.getNames().length();
            if (len <= maxNamesLen) continue;
            maxNamesLen = len;
        }
        for (Field f : fields = JadxCLIArgs.class.getDeclaredFields()) {
            String name = f.getName();
            ParameterDescription p = (ParameterDescription)paramsMap.get(name);
            if (p == null) continue;
            StringBuilder opt = new StringBuilder();
            opt.append(' ').append(p.getNames());
            JadxCLIArgs.addSpaces(opt, maxNamesLen - opt.length() + 2);
            opt.append("- ").append(p.getDescription());
            out.println(opt);
        }
        out.println("Example:");
        out.println(" jadx -d out classes.dex");
    }

    private static void addSpaces(StringBuilder str, int count) {
        for (int i = 0; i < count; ++i) {
            str.append(' ');
        }
    }

    public List<File> getInput() {
        return this.input;
    }

    public File getOutDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public boolean isCFGOutput() {
        return this.cfgOutput;
    }

    public boolean isRawCFGOutput() {
        return this.rawCfgOutput;
    }

    public boolean isFallbackMode() {
        return this.fallbackMode;
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public boolean isDeobfuscationForceSave() {
        return this.deobfuscationForceSave;
    }
}

