/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.element.facet.specific.sequence_aio.LifelineHorizontalDrawingInfo;

public class LifelineHorizontalDrawingInfoImpl
implements LifelineHorizontalDrawingInfo {
    private final double[] leftPaddings;
    private final double[] rightPaddings;
    private final double startX;
    private final double endX;

    public LifelineHorizontalDrawingInfoImpl(double[] leftPaddings, double[] rightPaddings, double startX, double endX) {
        this.leftPaddings = leftPaddings;
        this.rightPaddings = rightPaddings;
        this.startX = startX;
        this.endX = endX;
    }

    @Override
    public double getHorizontalStart() {
        return this.startX;
    }

    @Override
    public double getHorizontalEnd() {
        return this.endX;
    }

    @Override
    public double getHorizontalStart(int tick) {
        return this.getHorizontalStart() + this.leftPaddings[tick];
    }

    @Override
    public double getHorizontalEnd(int tick) {
        return this.getHorizontalEnd() - this.rightPaddings[tick];
    }

    @Override
    public double getHorizontalCenter() {
        return (this.startX + this.endX) / 2.0;
    }

    @Override
    public double getWidth() {
        return this.endX - this.startX;
    }

    @Override
    public double getWidth(int tick) {
        return this.getHorizontalEnd(tick) - this.getHorizontalStart(tick);
    }

    @Override
    public double getSymmetricHorizontalStart(int tick) {
        return this.getHorizontalStart() + Math.max(this.leftPaddings[tick], this.rightPaddings[tick]);
    }

    @Override
    public double getSymmetricHorizontalEnd(int tick) {
        return this.getHorizontalEnd() - Math.max(this.leftPaddings[tick], this.rightPaddings[tick]);
    }

    @Override
    public double getSymmetricWidth(int tick) {
        return this.getWidth() - Math.max(this.leftPaddings[tick], this.rightPaddings[tick]) * 2.0;
    }
}

