/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.text.UserQuestionExceptionHandler;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class CloneableEditorInitializer
implements Runnable {
    private static final Logger EDITOR_LOG = CloneableEditor.LOG;
    private static final Logger LOG = Logger.getLogger(CloneableEditorInitializer.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Editor Initialization");
    static final Logger TIMER = Logger.getLogger("TIMER");
    static boolean modalDialog;
    static final List<Runnable> edtRequests;
    static final Runnable processPendingEDTRequestsRunnable;
    final CloneableEditor editor;
    final CloneableEditorSupport ces;
    final JEditorPane pane;
    StyledDocument doc;
    private Phase phase;
    private RequestProcessor.Task task;
    private EditorKit kit;
    private JLabel loadingLabel;
    private UserQuestionException uqe;
    boolean provideUnfinishedPane;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForFinishedInitialization(CloneableEditor cloneableEditor) {
        assert (SwingUtilities.isEventDispatchThread()) : "Method should only be called from EDT";
        while (true) {
            List<Runnable> list = edtRequests;
            synchronized (list) {
                if (!cloneableEditor.isInitializationRunning()) {
                    return;
                }
            }
            if (cloneableEditor.isProvideUnfinishedPane()) {
                return;
            }
            CloneableEditorInitializer.processPendingEDTRequests();
            list = edtRequests;
            synchronized (list) {
                if (!cloneableEditor.isInitializationRunning()) {
                    return;
                }
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("CEI:Will wait() editor=" + System.identityHashCode(cloneableEditor) + '\n');
                    }
                    edtRequests.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processPendingEDTRequests() {
        while (true) {
            Runnable runnable;
            List<Runnable> list = edtRequests;
            synchronized (list) {
                if (edtRequests.isEmpty()) {
                    break;
                }
                runnable = edtRequests.remove(0);
            }
            if (runnable == null) continue;
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEDTRequest(Runnable runnable) {
        List<Runnable> list = edtRequests;
        synchronized (list) {
            edtRequests.add(runnable);
            CloneableEditorInitializer.notifyEDTRequestsMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyEDTRequestsMonitor() {
        List<Runnable> list = edtRequests;
        synchronized (list) {
            edtRequests.notifyAll();
        }
    }

    CloneableEditorInitializer(CloneableEditor cloneableEditor, CloneableEditorSupport cloneableEditorSupport, JEditorPane jEditorPane) {
        this.editor = cloneableEditor;
        this.ces = cloneableEditorSupport;
        this.pane = jEditorPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        boolean bl = false;
        try {
            this.kit = this.ces.createEditorKit();
            this.addLoadingLabel();
            this.task = RP.create((Runnable)this);
            this.task.setPriority(3);
            this.nextPhase();
            bl = true;
        }
        finally {
            if (!bl) {
                this.cancelInitialization();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean nextPhase() {
        int n;
        if (this.phase == null) {
            this.phase = Phase.DOCUMENT_OPEN;
        } else {
            n = this.phase.ordinal() + 1;
            if (n < Phase.values().length) {
                this.phase = Phase.values()[n];
            } else {
                return false;
            }
        }
        n = 0;
        try {
            if (this.phase.isRunInEDT()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CEI:addEDTRequest(): " + this + '\n');
                }
                CloneableEditorInitializer.addEDTRequest(this);
                WindowManager.getDefault().invokeWhenUIReady(processPendingEDTRequestsRunnable);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CEI:task.schedule(): " + this + '\n');
                }
                this.task.schedule(0);
            }
            n = 1;
        }
        finally {
            if (n == 0) {
                this.cancelInitialization();
            }
        }
        return true;
    }

    boolean isProvideUnfinishedPane() {
        return this.provideUnfinishedPane;
    }

    void cancelInitialization() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CEI:cancelInitialization(): " + this + '\n');
        }
        this.editor.markInitializationFinished(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object object = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)((Object)CloneableEditorInitializer.this.editor));
                if (null == object) {
                    object = CloneableEditorInitializer.this.editor;
                }
                object.close();
            }
        });
    }

    void finishInitialization() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CEI:finishInitialization(): " + this + '\n');
        }
        this.editor.markInitializationFinished(true);
    }

    private void addLoadingLabel() {
        this.editor.setLayout(new BorderLayout());
        this.loadingLabel = new JLabel(NbBundle.getMessage(CloneableEditor.class, (String)"LBL_EditorLoading"));
        this.loadingLabel.setOpaque(true);
        this.loadingLabel.setHorizontalAlignment(0);
        this.loadingLabel.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
        this.loadingLabel.setVisible(false);
        this.editor.add(this.loadingLabel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var1_1 = System.currentTimeMillis();
        var3_2 = false;
        try {
            switch (5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[this.phase.ordinal()]) {
                case 1: {
                    var3_2 = this.initDocument();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    var3_2 = this.handleUserQuestionExceptionInEDT();
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 3: {
                    var3_2 = this.initActionMapInEDT();
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 4: {
                    var3_2 = this.initKit();
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 5: {
                    var3_2 = this.setKitAndDocumentToPaneInEDT();
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 6: {
                    var3_2 = this.initCustomEditorAndDecorationsInEDT();
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 7: {
                    var3_2 = this.firePaneReadyInEDT();
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 8: {
                    this.initAnnotations();
                    var3_2 = true;
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong state: " + (Object)this.phase + " for " + (Object)this.ces);
                }
            }
        }
        catch (RuntimeException var4_3) {
            Exceptions.printStackTrace((Throwable)var4_3);
            throw var4_3;
        }
        finally {
            if (!var3_2) {
                this.cancelInitialization();
                return;
            }
        }
        var3_2 = false;
        try {
            var4_4 = System.currentTimeMillis() - var1_1;
            if (CloneableEditorInitializer.TIMER.isLoggable(Level.FINE)) {
                var6_6 = SwingUtilities.isEventDispatchThread() != false ? "EDT" : "RP";
                var7_7 = this.doc;
                v0 = var8_8 = var7_7 == null ? null : var7_7.getProperty("stream");
                if (var8_8 == null) {
                    var8_8 = this.ces.messageName();
                }
                CloneableEditorInitializer.TIMER.log(Level.FINE, "Open Editor, phase " + (Object)this.phase + ", " + var6_6 + " [ms]", new Object[]{var8_8, var4_4});
            }
            var3_2 = true;
        }
        finally {
            if (!var3_2) {
                this.cancelInitialization();
            }
        }
        var3_2 = false;
        try {
            this.nextPhase();
            var3_2 = true;
        }
        finally {
            if (!var3_2) {
                this.cancelInitialization();
            }
        }
    }

    private boolean initDocument() {
        if (EDITOR_LOG.isLoggable(Level.FINE)) {
            EDITOR_LOG.log(Level.FINE, "CloneableEditorInitializer.initDocument() Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(this.editor)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)this.ces)) + "]" + " Name:" + this.editor.getName());
        }
        try {
            this.setDocument(this.ces.openDocument());
            this.ces.getPositionManager().documentOpened(new WeakReference<StyledDocument>(this.doc));
            assert (this.doc != null) : "ces.openDocument() returned null";
            return true;
        }
        catch (UserQuestionException userQuestionException) {
            this.uqe = userQuestionException;
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException.getCause());
            return false;
        }
    }

    boolean handleUserQuestionExceptionInEDT() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not EDT";
        if (this.uqe != null) {
            UserQuestionExceptionHandler userQuestionExceptionHandler;
            if (EDITOR_LOG.isLoggable(Level.FINE)) {
                EDITOR_LOG.fine("CEI:handleUserQuestionExceptionInEDT: uqe=" + (Object)((Object)this.uqe) + "\n");
            }
            if ((userQuestionExceptionHandler = new UserQuestionExceptionHandler(this.ces, this.uqe){

                @Override
                protected void opened(StyledDocument styledDocument) {
                    CloneableEditorInitializer.this.setDocument(styledDocument);
                }

                @Override
                protected void handleStart() {
                    modalDialog = true;
                }

                @Override
                protected void handleEnd() {
                    modalDialog = false;
                }
            }).handleUserQuestionException()) {
                this.uqe = null;
            } else {
                this.cancelInitialization();
            }
        }
        if (this.doc == null && this.editor.isInitializationRunning()) {
            throw new IllegalStateException("Null document for non-cancelled initialization. uqe=" + (Object)((Object)this.uqe));
        }
        return this.uqe == null;
    }

    private void setDocument(StyledDocument styledDocument) {
        this.doc = styledDocument;
    }

    private boolean initActionMapInEDT() {
        ActionMap actionMap = this.editor.getActionMap();
        ActionMap actionMap2 = this.pane.getActionMap();
        actionMap.setParent(actionMap2);
        actionMap2.put("cut-to-clipboard", this.getAction("cut-to-clipboard"));
        actionMap2.put("copy-to-clipboard", this.getAction("copy-to-clipboard"));
        actionMap2.put("delete", this.getAction("delete-next"));
        actionMap2.put("paste-from-clipboard", this.getAction("paste-from-clipboard"));
        return true;
    }

    private boolean initKit() {
        if (this.kit instanceof Callable) {
            try {
                ((Callable)((Object)this.kit)).call();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return true;
    }

    private Action getAction(String string) {
        if (string == null) {
            return null;
        }
        if (this.kit == null) {
            return null;
        }
        Action[] actionArray = this.kit.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!string.equals(actionArray[i].getValue("Name"))) continue;
            return actionArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCustomEditor() {
        if (this.doc instanceof NbDocument.CustomEditor) {
            Component component;
            NbDocument.CustomEditor customEditor = (NbDocument.CustomEditor)((Object)this.doc);
            this.provideUnfinishedPane = true;
            try {
                component = customEditor.createEditor(this.pane);
            }
            finally {
                this.provideUnfinishedPane = false;
            }
            if (component == null) {
                throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomEditor may not" + " return null component");
            }
            this.editor.setCustomComponent(component);
            this.editor.add(this.ces.wrapEditorComponent(component), "Center");
        } else {
            JScrollPane jScrollPane = new JScrollPane(this.pane);
            this.pane.setBorder(null);
            this.editor.add(this.ces.wrapEditorComponent(jScrollPane), "Center");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDecoration() {
        if (this.doc instanceof NbDocument.CustomToolbar) {
            JToolBar jToolBar;
            NbDocument.CustomToolbar customToolbar = (NbDocument.CustomToolbar)((Object)this.doc);
            this.provideUnfinishedPane = true;
            try {
                jToolBar = customToolbar.createToolbar(this.pane);
            }
            finally {
                this.provideUnfinishedPane = false;
            }
            if (jToolBar == null) {
                throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
            }
            Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
            jToolBar.setBorder(border);
            this.editor.add(jToolBar, "North");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setKitAndDocumentToPaneInEDT() {
        this.provideUnfinishedPane = true;
        try {
            this.pane.setEditorKit(this.kit);
            ((QuietEditorPane)this.pane).setWorking(1);
            this.pane.setDocument(this.doc);
        }
        finally {
            this.provideUnfinishedPane = false;
        }
        return true;
    }

    private boolean initCustomEditorAndDecorationsInEDT() {
        Object object;
        this.initCustomEditor();
        this.initDecoration();
        this.editor.remove(this.loadingLabel);
        ((QuietEditorPane)this.pane).setWorking(3);
        int n = this.editor.getCursorPosition();
        if (n != -1 && (object = this.pane.getCaret()) != null) {
            object.setDot(n);
        }
        object = this.editor.getActionMap();
        ActionMap actionMap = ((ActionMap)object).getParent();
        ((ActionMap)object).setParent(null);
        ((ActionMap)object).setParent(actionMap);
        if (this.shouldRequestFocus(this.pane)) {
            EDITOR_LOG.log(Level.FINE, "requestFocusInWindow {0}", this.pane);
            this.editor.requestFocusInWindow();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloneableEditorInitializer.this.editor.revalidate();
            }
        });
        this.finishInitialization();
        return true;
    }

    private boolean firePaneReadyInEDT() {
        this.ces.firePropertyChange("openedPanes", null, null);
        return true;
    }

    private void initAnnotations() {
        this.ces.ensureAnnotationsLoaded();
    }

    private boolean shouldRequestFocus(Component component) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        while (component != null) {
            if (component == topComponent) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public String toString() {
        return "phase=" + (Object)((Object)this.phase) + ", editor=" + System.identityHashCode(this.editor);
    }

    static {
        edtRequests = new ArrayList<Runnable>(2);
        processPendingEDTRequestsRunnable = new Runnable(){

            @Override
            public void run() {
                CloneableEditorInitializer.processPendingEDTRequests();
            }
        };
    }

    static class 5 {
        static final /* synthetic */ int[] $SwitchMap$org$openide$text$CloneableEditorInitializer$Phase;

        static {
            $SwitchMap$org$openide$text$CloneableEditorInitializer$Phase = new int[Phase.values().length];
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.DOCUMENT_OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.HANDLE_USER_QUESTION_EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.ACTION_MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.INIT_KIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.KIT_AND_DOCUMENT_TO_PANE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.CUSTOM_EDITOR_AND_DECORATIONS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.FIRE_PANE_READY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[Phase.ANNOTATIONS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum Phase {
        DOCUMENT_OPEN(false),
        HANDLE_USER_QUESTION_EXCEPTION(true),
        ACTION_MAP(true),
        INIT_KIT(false),
        KIT_AND_DOCUMENT_TO_PANE(true),
        CUSTOM_EDITOR_AND_DECORATIONS(true),
        FIRE_PANE_READY(true),
        ANNOTATIONS(false);

        private final boolean runInEDT;

        private Phase(boolean bl) {
            this.runInEDT = bl;
        }

        public boolean isRunInEDT() {
            return this.runInEDT;
        }
    }
}

