/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new FunctionWeight(searcher);
    }

    public String toString(String field) {
        return this.func.toString() + ToStringUtils.boost((float)this.getBoost());
    }

    public boolean equals(Object o) {
        if (!FunctionQuery.class.isInstance(o)) {
            return false;
        }
        FunctionQuery other = (FunctionQuery)((Object)o);
        return super.equals(o) && this.func.equals(other.func);
    }

    public int hashCode() {
        return super.hashCode() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float qWeight;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float qWeight) throws IOException {
            super((Weight)w);
            this.weight = w;
            this.qWeight = qWeight;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all((int)context.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        public int docID() {
            return this.iterator.docID();
        }

        public float score() throws IOException {
            float score = this.qWeight * this.vals.floatVal(this.docID());
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        public int freq() throws IOException {
            return 1;
        }

        public Explanation explain(int doc, float queryNorm) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            Explanation[] explanationArray = new Explanation[3];
            explanationArray[0] = this.vals.explain(doc);
            explanationArray[1] = Explanation.match((float)queryNorm, (String)"boost", (Explanation[])new Explanation[0]);
            this.weight.queryNorm = 1.0f;
            explanationArray[2] = Explanation.match((float)1.0f, (String)"queryNorm", (Explanation[])new Explanation[0]);
            return Explanation.match((float)sc, (String)("FunctionQuery(" + FunctionQuery.this.func + "), product of:"), (Explanation[])explanationArray);
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected float queryNorm;
        protected final Map context;

        public FunctionWeight(IndexSearcher searcher) throws IOException {
            super((Query)FunctionQuery.this);
            this.queryNorm = 1.0f;
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
        }

        public void extractTerms(Set<Term> terms) {
        }

        public float getValueForNormalization() throws IOException {
            return this.queryNorm * this.queryNorm;
        }

        public void normalize(float norm, float boost) {
            this.queryNorm = norm * boost;
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new AllScorer(context, this, this.queryNorm);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc, this.queryNorm);
        }
    }
}

