/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.source;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.rest.RestRequest;

public class FetchSourceContext
implements Streamable {
    public static final FetchSourceContext FETCH_SOURCE = new FetchSourceContext(true);
    public static final FetchSourceContext DO_NOT_FETCH_SOURCE = new FetchSourceContext(false);
    private boolean fetchSource;
    private boolean transformSource;
    private String[] includes;
    private String[] excludes;

    FetchSourceContext() {
    }

    public FetchSourceContext(boolean fetchSource) {
        this(fetchSource, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false);
    }

    public FetchSourceContext(String include) {
        this(include, null);
    }

    public FetchSourceContext(String include, String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        this(true, stringArray2, stringArray, false);
    }

    public FetchSourceContext(String[] includes) {
        this(true, includes, Strings.EMPTY_ARRAY, false);
    }

    public FetchSourceContext(String[] includes, String[] excludes) {
        this(true, includes, excludes, false);
    }

    public FetchSourceContext(boolean fetchSource, String[] includes, String[] excludes, boolean transform) {
        this.fetchSource = fetchSource;
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
        this.transformSource = transform;
    }

    public boolean fetchSource() {
        return this.fetchSource;
    }

    public FetchSourceContext fetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
        return this;
    }

    public boolean transformSource() {
        return this.transformSource;
    }

    public FetchSourceContext transformSource(boolean transformSource) {
        this.transformSource = transformSource;
        return this;
    }

    public String[] includes() {
        return this.includes;
    }

    public FetchSourceContext includes(String[] includes) {
        this.includes = includes;
        return this;
    }

    public String[] excludes() {
        return this.excludes;
    }

    public FetchSourceContext excludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }

    public static FetchSourceContext optionalReadFromStream(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        FetchSourceContext context = new FetchSourceContext();
        context.readFrom(in);
        return context;
    }

    public static void optionalWriteToStream(FetchSourceContext context, StreamOutput out) throws IOException {
        if (context == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        context.writeTo(out);
    }

    public static FetchSourceContext parseFromRestRequest(RestRequest request) {
        Boolean fetchSource = null;
        String[] source_excludes = null;
        String[] source_includes = null;
        String source = request.param("_source");
        if (source != null) {
            if (Booleans.isExplicitTrue(source)) {
                fetchSource = true;
            } else if (Booleans.isExplicitFalse(source)) {
                fetchSource = false;
            } else {
                source_includes = Strings.splitStringByCommaToArray(source);
            }
        }
        String sIncludes = request.param("_source_includes");
        if ((sIncludes = request.param("_source_include", sIncludes)) != null) {
            source_includes = Strings.splitStringByCommaToArray(sIncludes);
        }
        String sExcludes = request.param("_source_excludes");
        if ((sExcludes = request.param("_source_exclude", sExcludes)) != null) {
            source_excludes = Strings.splitStringByCommaToArray(sExcludes);
        }
        boolean transform = request.paramAsBoolean("_source_transform", false);
        if (fetchSource != null || source_includes != null || source_excludes != null || transform) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, source_includes, source_excludes, transform);
        }
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.fetchSource = in.readBoolean();
        this.includes = in.readStringArray();
        this.excludes = in.readStringArray();
        this.transformSource = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fetchSource);
        out.writeStringArray(this.includes);
        out.writeStringArray(this.excludes);
        out.writeBoolean(this.transformSource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchSourceContext that = (FetchSourceContext)o;
        if (this.fetchSource != that.fetchSource) {
            return false;
        }
        if (!Arrays.equals(this.excludes, that.excludes)) {
            return false;
        }
        return Arrays.equals(this.includes, that.includes);
    }

    public int hashCode() {
        int result = this.fetchSource ? 1 : 0;
        result = 31 * result + (this.includes != null ? Arrays.hashCode(this.includes) : 0);
        result = 31 * result + (this.excludes != null ? Arrays.hashCode(this.excludes) : 0);
        return result;
    }
}

