/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.search.profile.CollectorResult;
import org.elasticsearch.search.profile.InternalProfileCollector;
import org.elasticsearch.search.profile.InternalProfileTree;
import org.elasticsearch.search.profile.ProfileBreakdown;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.ProfileShardResult;

public final class Profiler {
    private final InternalProfileTree queryTree = new InternalProfileTree();
    private InternalProfileCollector collector;

    public void setCollector(InternalProfileCollector collector) {
        if (this.collector != null) {
            throw new IllegalStateException("The collector can only be set once.");
        }
        this.collector = Objects.requireNonNull(collector);
    }

    public ProfileBreakdown getQueryBreakdown(Query query) {
        return this.queryTree.getQueryBreakdown(query);
    }

    public void startRewriteTime() {
        this.queryTree.startRewriteTime();
    }

    public long stopAndAddRewriteTime() {
        return this.queryTree.stopAndAddRewriteTime();
    }

    public void pollLastQuery() {
        this.queryTree.pollLast();
    }

    public List<ProfileResult> getQueryTree() {
        return this.queryTree.getQueryTree();
    }

    public long getRewriteTime() {
        return this.queryTree.getRewriteTime();
    }

    public CollectorResult getCollector() {
        return this.collector.getCollectorTree();
    }

    public static List<ProfileShardResult> buildShardResults(List<Profiler> profilers) {
        ArrayList<ProfileShardResult> results = new ArrayList<ProfileShardResult>(profilers.size());
        for (Profiler profiler : profilers) {
            ProfileShardResult result = new ProfileShardResult(profiler.getQueryTree(), profiler.getRewriteTime(), profiler.getCollector());
            results.add(result);
        }
        return results;
    }
}

