/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.query.support.NestedInnerQueryParseSupport;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class ScriptSortParser
implements SortParser {
    private static final String STRING_SORT_TYPE = "string";
    private static final String NUMBER_SORT_TYPE = "number";

    @Override
    public String[] names() {
        return new String[]{"_script"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        IndexFieldData.XFieldComparatorSource fieldComparatorSource;
        IndexFieldData.XFieldComparatorSource.Nested nested;
        XContentParser.Token token;
        ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
        Script script = null;
        String type = null;
        Map<Object, Object> params = null;
        boolean reverse = false;
        MultiValueMode sortMode = null;
        NestedInnerQueryParseSupport nestedHelper = null;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.parseFieldMatcher().match(currentName, Script.ScriptField.SCRIPT)) {
                    script = Script.parse(parser, context.parseFieldMatcher());
                    continue;
                }
                if ("params".equals(currentName)) {
                    params = parser.map();
                    continue;
                }
                if (!"nested_filter".equals(currentName) && !"nestedFilter".equals(currentName)) continue;
                if (nestedHelper == null) {
                    nestedHelper = new NestedInnerQueryParseSupport(parser, context);
                }
                nestedHelper.filter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse = "desc".equals(parser.text());
                continue;
            }
            if (scriptParameterParser.token(currentName, token, parser, context.parseFieldMatcher())) continue;
            if ("type".equals(currentName)) {
                type = parser.text();
                continue;
            }
            if ("mode".equals(currentName)) {
                sortMode = MultiValueMode.fromString(parser.text());
                continue;
            }
            if (!"nested_path".equals(currentName) && !"nestedPath".equals(currentName)) continue;
            if (nestedHelper == null) {
                nestedHelper = new NestedInnerQueryParseSupport(parser, context);
            }
            nestedHelper.setPath(parser.text());
        }
        if (script == null) {
            ScriptParameterParser.ScriptParameterValue scriptValue = scriptParameterParser.getDefaultScriptParameterValue();
            if (scriptValue != null) {
                if (params == null) {
                    params = Maps.newHashMap();
                }
                script = new Script(scriptValue.script(), scriptValue.scriptType(), scriptParameterParser.lang(), params);
            }
        } else if (params != null) {
            throw new SearchParseException(context, "script params must be specified inside script object", parser.getTokenLocation());
        }
        if (script == null) {
            throw new SearchParseException(context, "_script sorting requires setting the script to sort by", parser.getTokenLocation());
        }
        if (type == null) {
            throw new SearchParseException(context, "_script sorting requires setting the type of the script", parser.getTokenLocation());
        }
        final SearchScript searchScript = context.scriptService().search(context.lookup(), script, ScriptContext.Standard.SEARCH, Collections.emptyMap());
        if (STRING_SORT_TYPE.equals(type) && (sortMode == MultiValueMode.SUM || sortMode == MultiValueMode.AVG)) {
            throw new SearchParseException(context, "type [string] doesn't support mode [" + (Object)((Object)sortMode) + "]", parser.getTokenLocation());
        }
        if (sortMode == null) {
            MultiValueMode multiValueMode = sortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (nestedHelper != null && nestedHelper.getPath() != null) {
            BitSetProducer rootDocumentsFilter = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter());
            Query innerDocumentsFilter = nestedHelper.filterFound() ? nestedHelper.getInnerFilter() : nestedHelper.getNestedObjectMapper().nestedTypeFilter();
            nested = new IndexFieldData.XFieldComparatorSource.Nested(rootDocumentsFilter, context.searcher().createNormalizedWeight(innerDocumentsFilter, false));
        } else {
            nested = null;
        }
        switch (type) {
            case "string": {
                fieldComparatorSource = new BytesRefFieldComparatorSource(null, null, sortMode, nested){
                    LeafSearchScript leafScript;

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = searchScript.getLeafSearchScript(context);
                        BinaryDocValues values = new BinaryDocValues(){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            public BytesRef get(int docID) {
                                leafScript.setDocument(docID);
                                this.spare.copyChars((CharSequence)leafScript.run().toString());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        this.leafScript.setScorer(scorer);
                    }
                };
                break;
            }
            case "number": {
                fieldComparatorSource = new DoubleValuesComparatorSource(null, Double.MAX_VALUE, sortMode, nested){
                    LeafSearchScript leafScript;

                    @Override
                    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = searchScript.getLeafSearchScript(context);
                        NumericDoubleValues values = new NumericDoubleValues(){

                            @Override
                            public double get(int docID) {
                                leafScript.setDocument(docID);
                                return leafScript.runAsDouble();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        this.leafScript.setScorer(scorer);
                    }
                };
                break;
            }
            default: {
                throw new SearchParseException(context, "custom script sort type [" + type + "] not supported", parser.getTokenLocation());
            }
        }
        return new SortField("_script", (FieldComparatorSource)fieldComparatorSource, reverse);
    }
}

