/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.encoding.CFFEncoding;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OTFFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTFSubSetFile
extends OTFFile {
    protected byte[] output;
    protected int currentPos;
    private int realSize;
    protected LinkedHashMap<Integer, Integer> subsetGlyphs = new LinkedHashMap();
    protected LinkedHashMap<Integer, Integer> gidToSID;
    protected CFFDataReader.CFFIndexData localIndexSubr;
    protected CFFDataReader.CFFIndexData globalIndexSubr;
    protected List<byte[]> subsetLocalIndexSubr;
    protected List<byte[]> subsetGlobalIndexSubr;
    private ArrayList<List<byte[]>> fdSubrs;
    private LinkedHashMap<Integer, FDIndexReference> subsetFDSelect;
    protected List<Integer> localUniques;
    protected List<Integer> globalUniques;
    protected int subsetLocalSubrCount;
    protected int subsetGlobalSubrCount;
    protected List<byte[]> subsetCharStringsIndex;
    protected String embeddedName;
    protected List<byte[]> stringIndexData = new ArrayList<byte[]>();
    protected CFFDataReader cffReader;
    private MultiByteFont mbFont;
    public static final int NUM_STANDARD_STRINGS = 391;
    private static final int LOCAL_SUBROUTINE = 10;
    private static final int GLOBAL_SUBROUTINE = 29;

    public void readFont(FontFileReader in, String embeddedName, String header, MultiByteFont mbFont) throws IOException {
        this.mbFont = mbFont;
        this.readFont(in, embeddedName, header, mbFont.getUsedGlyphs());
    }

    void readFont(FontFileReader in, String embeddedName, String header, Map<Integer, Integer> usedGlyphs) throws IOException {
        this.fontFile = in;
        this.currentPos = 0;
        this.realSize = 0;
        this.embeddedName = embeddedName;
        this.subsetGlyphs = this.sortByValue(usedGlyphs);
        this.output = new byte[in.getFileSize()];
        this.initializeFont(in);
        this.cffReader = new CFFDataReader(this.fontFile);
        this.createCFF();
    }

    private LinkedHashMap<Integer, Integer> sortByValue(Map<Integer, Integer> map) {
        ArrayList<Map.Entry<Integer, Integer>> list = new ArrayList<Map.Entry<Integer, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry entry : list) {
            result.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    protected void createCFF() throws IOException {
        this.writeBytes(this.cffReader.getHeader());
        this.writeIndex(Arrays.asList(new byte[][]{this.embeddedName.getBytes()}));
        int topDictOffset = this.currentPos;
        byte[] topDictIndex = this.cffReader.getTopDictIndex().getByteData();
        byte offSize = topDictIndex[2];
        this.writeBytes(topDictIndex, 0, 3 + offSize * 2);
        int topDictDataOffset = this.currentPos;
        this.writeTopDICT();
        if (this.cffReader.getFDSelect() == null) {
            this.createCharStringData();
        } else {
            this.createCharStringDataCID();
        }
        List<Integer> fontNameSIDs = null;
        List<Integer> subsetFDFonts = null;
        if (this.cffReader.getFDSelect() != null) {
            subsetFDFonts = this.getUsedFDFonts();
            fontNameSIDs = this.storeFDStrings(subsetFDFonts);
        }
        this.writeStringIndex();
        this.writeIndex(this.subsetGlobalIndexSubr);
        int encodingOffset = this.currentPos;
        this.writeEncoding(this.fileFont.getEncoding());
        int charsetOffset = this.currentPos;
        this.writeCharsetTable(this.cffReader.getFDSelect() != null);
        int fdSelectOffset = this.currentPos;
        if (this.cffReader.getFDSelect() != null) {
            this.writeFDSelect();
        }
        int charStringOffset = this.currentPos;
        this.writeIndex(this.subsetCharStringsIndex);
        if (this.cffReader.getFDSelect() == null) {
            int privateDictOffset = this.currentPos;
            this.writePrivateDict();
            int localIndexOffset = this.currentPos;
            this.writeIndex(this.subsetLocalIndexSubr);
            this.updateOffsets(topDictOffset, charsetOffset, charStringOffset, privateDictOffset, localIndexOffset, encodingOffset);
        } else {
            List<Integer> privateDictOffsets = this.writeCIDDictsAndSubrs(subsetFDFonts);
            int fdArrayOffset = this.writeFDArray(subsetFDFonts, privateDictOffsets, fontNameSIDs);
            this.updateCIDOffsets(topDictDataOffset, fdArrayOffset, fdSelectOffset, charsetOffset, charStringOffset, encodingOffset);
        }
    }

    protected List<Integer> storeFDStrings(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> fontNameSIDs = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        for (int i = 0; i < uniqueNewRefs.size(); ++i) {
            CFFDataReader.FontDict fdFont = fdFonts.get(uniqueNewRefs.get(i));
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            fontNameSIDs.add(this.stringIndexData.size() + 391);
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperands().get(0).intValue() - 391));
        }
        return fontNameSIDs;
    }

    protected void writeBytes(byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            this.writeByte(out[i]);
        }
    }

    protected void writeBytes(byte[] out, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.output[this.currentPos++] = out[i];
            ++this.realSize;
        }
    }

    private void writeEncoding(CFFEncoding encoding) throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry encodingEntry = topDICT.get("Encoding");
        if (encodingEntry != null && encodingEntry.getOperands().get(0).intValue() != 0 && encodingEntry.getOperands().get(0).intValue() != 1) {
            this.writeByte(0);
            this.writeByte(this.gidToSID.size());
            for (int gid : this.gidToSID.keySet()) {
                int code = encoding.getCode(this.gidToSID.get(gid).intValue());
                this.writeByte(code);
            }
        }
    }

    protected void writeTopDICT() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        List<String> topDictStringEntries = Arrays.asList("version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "PostScript");
        for (Map.Entry<String, CFFDataReader.DICTEntry> dictEntry : topDICT.entrySet()) {
            String dictKey = dictEntry.getKey();
            CFFDataReader.DICTEntry entry = dictEntry.getValue();
            if (dictKey.equals("ROS")) {
                this.writeROSEntry(entry);
                continue;
            }
            if (dictKey.equals("CIDCount")) {
                this.writeCIDCount(entry);
                continue;
            }
            if (topDictStringEntries.contains(dictKey)) {
                this.writeTopDictStringEntry(entry);
                continue;
            }
            this.writeBytes(entry.getByteData());
        }
    }

    private void writeROSEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sidA = dictEntry.getOperands().get(0).intValue();
        if (sidA > 390) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sidA - 391));
        }
        int sidAStringIndex = this.stringIndexData.size() + 390;
        int sidB = dictEntry.getOperands().get(1).intValue();
        if (sidB > 390) {
            this.stringIndexData.add("Identity".getBytes());
        }
        int sidBStringIndex = this.stringIndexData.size() + 390;
        byte[] cidEntryByteData = dictEntry.getByteData();
        cidEntryByteData = this.updateOffset(cidEntryByteData, 0, dictEntry.getOperandLengths().get(0), sidAStringIndex);
        cidEntryByteData = this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0), dictEntry.getOperandLengths().get(1), sidBStringIndex);
        cidEntryByteData = this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0) + dictEntry.getOperandLengths().get(1), dictEntry.getOperandLengths().get(2), 139);
        this.writeBytes(cidEntryByteData);
    }

    protected void writeCIDCount(CFFDataReader.DICTEntry dictEntry) throws IOException {
        byte[] cidCountByteData = dictEntry.getByteData();
        cidCountByteData = this.updateOffset(cidCountByteData, 0, dictEntry.getOperandLengths().get(0), this.subsetGlyphs.size());
        this.writeBytes(cidCountByteData);
    }

    private void writeTopDictStringEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sid = dictEntry.getOperands().get(0).intValue();
        if (sid > 391) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sid - 391));
        }
        byte[] newDictEntry = OTFSubSetFile.createNewRef(this.stringIndexData.size() + 390, dictEntry.getOperator(), dictEntry.getOperandLength());
        this.writeBytes(newDictEntry);
    }

    private void writeStringIndex() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        int charsetOffset = ((CFFDataReader.DICTEntry)topDICT.get("charset")).getOperands().get(0).intValue();
        this.gidToSID = new LinkedHashMap();
        for (int gid : this.subsetGlyphs.keySet()) {
            int sid = this.cffReader.getSIDFromGID(charsetOffset, gid);
            if (sid < 391) {
                this.gidToSID.put(this.subsetGlyphs.get(gid), sid);
                if (this.mbFont == null) continue;
                this.mbFont.mapUsedGlyphName(this.subsetGlyphs.get(gid), CFFStandardString.getName((int)sid));
                continue;
            }
            int index = sid - 391;
            if (index <= this.cffReader.getStringIndex().getNumObjects()) {
                if (this.mbFont != null) {
                    this.mbFont.mapUsedGlyphName(this.subsetGlyphs.get(gid), new String(this.cffReader.getStringIndex().getValue(index)));
                }
                this.gidToSID.put(this.subsetGlyphs.get(gid), this.stringIndexData.size() + 391);
                this.stringIndexData.add(this.cffReader.getStringIndex().getValue(index));
                continue;
            }
            if (this.mbFont != null) {
                this.mbFont.mapUsedGlyphName(this.subsetGlyphs.get(gid), ".notdef");
            }
            this.gidToSID.put(this.subsetGlyphs.get(gid), index);
        }
        this.writeIndex(this.stringIndexData);
    }

    protected void createCharStringDataCID() throws IOException {
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.FDSelect fontDictionary = this.cffReader.getFDSelect();
        if (fontDictionary instanceof CFFDataReader.Format0FDSelect) {
            throw new UnsupportedOperationException("OTF CFF CID Format0 currently not implemented");
        }
        if (fontDictionary instanceof CFFDataReader.Format3FDSelect) {
            CFFDataReader.Format3FDSelect fdSelect = (CFFDataReader.Format3FDSelect)fontDictionary;
            HashMap<Integer, Integer> subsetGroups = new HashMap<Integer, Integer>();
            ArrayList<Integer> uniqueGroups = new ArrayList<Integer>();
            for (int gid : this.subsetGlyphs.keySet()) {
                Set<Integer> rangeKeys = fdSelect.getRanges().keySet();
                Integer[] ranges = rangeKeys.toArray(new Integer[rangeKeys.size()]);
                for (int i = 0; i < ranges.length; ++i) {
                    int nextRange = -1;
                    nextRange = i < ranges.length - 1 ? ranges[i + 1].intValue() : fdSelect.getSentinelGID();
                    if (gid < ranges[i] || gid >= nextRange) continue;
                    subsetGroups.put(gid, fdSelect.getRanges().get(ranges[i]));
                    if (uniqueGroups.contains(fdSelect.getRanges().get(ranges[i]))) continue;
                    uniqueGroups.add(fdSelect.getRanges().get(ranges[i]));
                }
            }
            this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
            this.subsetCharStringsIndex = new ArrayList<byte[]>();
            this.globalUniques = new ArrayList<Integer>();
            this.subsetFDSelect = new LinkedHashMap();
            ArrayList foundLocalUniques = new ArrayList();
            for (int i = 0; i < uniqueGroups.size(); ++i) {
                foundLocalUniques.add(new ArrayList());
            }
            for (int gid : this.subsetGlyphs.keySet()) {
                int group = (Integer)subsetGroups.get(gid);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                this.localUniques = (List)foundLocalUniques.get(uniqueGroups.indexOf(subsetGroups.get(gid)));
                FDIndexReference newFDReference = new FDIndexReference(uniqueGroups.indexOf(subsetGroups.get(gid)), (Integer)subsetGroups.get(gid));
                this.subsetFDSelect.put(this.subsetGlyphs.get(gid), newFDReference);
                byte[] data = charStringsIndex.getValue(gid);
                this.preScanForSubsetIndexSize(data);
            }
            this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
            this.fdSubrs = new ArrayList();
            this.subsetGlobalSubrCount = this.globalUniques.size();
            this.globalUniques.clear();
            this.localUniques = null;
            for (int l = 0; l < foundLocalUniques.size(); ++l) {
                this.fdSubrs.add(new ArrayList());
            }
            ArrayList foundLocalUniquesB = new ArrayList();
            for (int k = 0; k < uniqueGroups.size(); ++k) {
                foundLocalUniquesB.add(new ArrayList());
            }
            for (Integer gid : this.subsetGlyphs.keySet()) {
                int group = (Integer)subsetGroups.get(gid);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                this.localUniques = (List)foundLocalUniquesB.get(this.subsetFDSelect.get(this.subsetGlyphs.get(gid)).getNewFDIndex());
                byte[] data = charStringsIndex.getValue(gid);
                this.subsetLocalIndexSubr = this.fdSubrs.get(this.subsetFDSelect.get(this.subsetGlyphs.get(gid)).getNewFDIndex());
                this.subsetLocalSubrCount = ((List)foundLocalUniques.get(this.subsetFDSelect.get(this.subsetGlyphs.get(gid)).getNewFDIndex())).size();
                data = this.readCharStringData(data, this.subsetLocalSubrCount);
                this.subsetCharStringsIndex.add(data);
            }
        }
    }

    protected void writeFDSelect() {
        this.writeByte(0);
        for (Integer gid : this.subsetFDSelect.keySet()) {
            this.writeByte(this.subsetFDSelect.get(gid).getNewFDIndex());
        }
    }

    protected List<Integer> getUsedFDFonts() {
        ArrayList<Integer> uniqueNewRefs = new ArrayList<Integer>();
        for (int gid : this.subsetFDSelect.keySet()) {
            int fdIndex = this.subsetFDSelect.get(gid).getOldFDIndex();
            if (uniqueNewRefs.contains(fdIndex)) continue;
            uniqueNewRefs.add(fdIndex);
        }
        return uniqueNewRefs;
    }

    protected List<Integer> writeCIDDictsAndSubrs(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> privateDictOffsets = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        for (int i = 0; i < uniqueNewRefs.size(); ++i) {
            CFFDataReader.FontDict curFDFont = fdFonts.get(uniqueNewRefs.get(i));
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdPrivateDict = this.cffReader.parseDictData(curFDFont.getPrivateDictData());
            int privateDictOffset = this.currentPos;
            privateDictOffsets.add(privateDictOffset);
            byte[] fdPrivateDictByteData = curFDFont.getPrivateDictData();
            if (((HashMap)fdPrivateDict).get("Subrs") != null) {
                int encodingValue = 0;
                if (((CFFDataReader.DICTEntry)((HashMap)fdPrivateDict).get("Subrs")).getOperandLength() == 1) {
                    encodingValue = 139;
                }
                fdPrivateDictByteData = this.updateOffset(fdPrivateDictByteData, ((CFFDataReader.DICTEntry)((HashMap)fdPrivateDict).get("Subrs")).getOffset(), ((CFFDataReader.DICTEntry)((HashMap)fdPrivateDict).get("Subrs")).getOperandLength(), fdPrivateDictByteData.length + encodingValue);
            }
            this.writeBytes(fdPrivateDictByteData);
            this.writeIndex(this.fdSubrs.get(i));
        }
        return privateDictOffsets;
    }

    protected int writeFDArray(List<Integer> uniqueNewRefs, List<Integer> privateDictOffsets, List<Integer> fontNameSIDs) throws IOException {
        CFFDataReader.FontDict fdFont;
        int i;
        int offset = this.currentPos;
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        this.writeCard16(uniqueNewRefs.size());
        this.writeByte(1);
        this.writeByte(1);
        int count = 1;
        for (i = 0; i < uniqueNewRefs.size(); ++i) {
            fdFont = fdFonts.get(uniqueNewRefs.get(i));
            this.writeByte(count += fdFont.getByteData().length);
        }
        for (i = 0; i < uniqueNewRefs.size(); ++i) {
            fdFont = fdFonts.get(uniqueNewRefs.get(i));
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            fdFontByteData = this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOffset() - 1, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperandLengths().get(0), fontNameSIDs.get(i));
            fdFontByteData = this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOffset() + ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(0), ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(1), privateDictOffsets.get(i));
            this.writeBytes(fdFontByteData);
        }
        return offset;
    }

    private void createCharStringData() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            int privateOffset = privateEntry.getOperands().get(1).intValue();
            Map<String, CFFDataReader.DICTEntry> privateDICT = this.cffReader.getPrivateDict(privateEntry);
            if (privateDICT.get("Subrs") != null) {
                int localSubrOffset = privateOffset + privateDICT.get("Subrs").getOperands().get(0).intValue();
                this.localIndexSubr = this.cffReader.readIndex(localSubrOffset);
            } else {
                this.localIndexSubr = this.cffReader.readIndex(null);
            }
        }
        this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
        this.subsetLocalIndexSubr = new ArrayList<byte[]>();
        this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
        this.subsetCharStringsIndex = new ArrayList<byte[]>();
        this.localUniques = new ArrayList<Integer>();
        this.globalUniques = new ArrayList<Integer>();
        for (int gid : this.subsetGlyphs.keySet()) {
            byte[] data = charStringsIndex.getValue(gid);
            this.preScanForSubsetIndexSize(data);
        }
        this.subsetLocalSubrCount = this.localUniques.size();
        this.subsetGlobalSubrCount = this.globalUniques.size();
        this.localUniques.clear();
        this.globalUniques.clear();
        for (int gid : this.subsetGlyphs.keySet()) {
            byte[] data = charStringsIndex.getValue(gid);
            data = this.readCharStringData(data, this.subsetLocalSubrCount);
            this.subsetCharStringsIndex.add(data);
        }
    }

    private void preScanForSubsetIndexSize(byte[] data) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        BytesNumber operand = new BytesNumber(-1, -1);
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            byte[] subr;
            int subrNumber;
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                subrNumber = this.getSubrNumber(this.localIndexSubr.getNumObjects(), operand.getNumber());
                if (!this.localUniques.contains(subrNumber) && subrNumber < this.localIndexSubr.getNumObjects()) {
                    this.localUniques.add(subrNumber);
                    subr = this.localIndexSubr.getValue(subrNumber);
                    this.preScanForSubsetIndexSize(subr);
                }
                operand.clearNumber();
                continue;
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                subrNumber = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), operand.getNumber());
                if (!this.globalUniques.contains(subrNumber) && subrNumber < this.globalIndexSubr.getNumObjects()) {
                    this.globalUniques.add(subrNumber);
                    subr = this.globalIndexSubr.getValue(subrNumber);
                    this.preScanForSubsetIndexSize(subr);
                }
                operand.clearNumber();
                continue;
            }
            if (b0 >= 0 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                operand.clearNumber();
                if (b0 != 19 && b0 != 20) continue;
                ++dataPos;
                continue;
            }
            if (b0 != 28 && (b0 < 32 || b0 > 255)) continue;
            operand = this.readNumber(b0, data, dataPos);
            dataPos += operand.getNumBytes() - 1;
        }
    }

    private int getSubrNumber(int numSubroutines, int operand) {
        int bias = this.getBias(numSubroutines);
        return bias + operand;
    }

    private byte[] readCharStringData(byte[] data, int subsetLocalSubrCount) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        BytesNumber operand = new BytesNumber(-1, -1);
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            byte[] newData;
            int newRef;
            int subrNumber;
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                subrNumber = this.getSubrNumber(this.localIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.localUniques, this.localIndexSubr, this.subsetLocalIndexSubr, subsetLocalSubrCount);
                if (newRef != -1) {
                    newData = this.constructNewRefData(dataPos, data, operand, subsetLocalSubrCount, newRef, new int[]{10});
                    dataPos -= data.length - newData.length;
                    data = newData;
                }
                operand.clearNumber();
                continue;
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                subrNumber = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.globalUniques, this.globalIndexSubr, this.subsetGlobalIndexSubr, this.subsetGlobalSubrCount);
                if (newRef != -1) {
                    newData = this.constructNewRefData(dataPos, data, operand, this.subsetGlobalSubrCount, newRef, new int[]{29});
                    dataPos -= data.length - newData.length;
                    data = newData;
                }
                operand.clearNumber();
                continue;
            }
            if (b0 >= 0 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                operand.clearNumber();
                if (b0 != 19) continue;
                ++dataPos;
                continue;
            }
            if (b0 != 28 && (b0 < 32 || b0 > 255)) continue;
            operand = this.readNumber(b0, data, dataPos);
            dataPos += operand.getNumBytes() - 1;
        }
        return data;
    }

    private int getNewRefForReference(int subrNumber, List<Integer> uniquesArray, CFFDataReader.CFFIndexData indexSubr, List<byte[]> subsetIndexSubr, int subrCount) throws IOException {
        int newRef = -1;
        if (!uniquesArray.contains(subrNumber)) {
            if (subrNumber < indexSubr.getNumObjects()) {
                byte[] subr = indexSubr.getValue(subrNumber);
                subr = this.readCharStringData(subr, subrCount);
                if (!uniquesArray.contains(subrNumber)) {
                    uniquesArray.add(subrNumber);
                    subsetIndexSubr.add(subr);
                    newRef = subsetIndexSubr.size() - 1;
                } else {
                    newRef = uniquesArray.indexOf(subrNumber);
                }
            }
        } else {
            newRef = uniquesArray.indexOf(subrNumber);
        }
        return newRef;
    }

    private int getBias(int subrCount) {
        if (subrCount < 1240) {
            return 107;
        }
        if (subrCount < 33900) {
            return 1131;
        }
        return 32768;
    }

    private byte[] constructNewRefData(int curDataPos, byte[] currentData, BytesNumber operand, int fullSubsetIndexSize, int curSubsetIndexSize, int[] operatorCode) {
        int startRef = curDataPos - operand.getNumBytes();
        int length = operand.getNumBytes() + 1;
        byte[] preBytes = new byte[startRef];
        System.arraycopy(currentData, 0, preBytes, 0, startRef);
        int newBias = this.getBias(fullSubsetIndexSize);
        int newRef = curSubsetIndexSize - newBias;
        byte[] newRefBytes = OTFSubSetFile.createNewRef(newRef, operatorCode, -1);
        byte[] newData = OTFSubSetFile.concatArray(preBytes, newRefBytes);
        byte[] postBytes = new byte[currentData.length - (startRef + length)];
        System.arraycopy(currentData, startRef + length, postBytes, 0, currentData.length - (startRef + length));
        return OTFSubSetFile.concatArray(newData, postBytes);
    }

    public static byte[] createNewRef(int newRef, int[] operatorCode, int forceLength) {
        byte[] newRefBytes;
        int sizeOfOperator = operatorCode.length;
        if (forceLength == -1 && newRef <= 107 || forceLength == 1) {
            newRefBytes = new byte[1 + sizeOfOperator];
            newRefBytes[0] = (byte)(newRef + 139);
            for (int i = 0; i < operatorCode.length; ++i) {
                newRefBytes[1 + i] = (byte)operatorCode[i];
            }
        } else if (forceLength == -1 && newRef <= 1131 || forceLength == 2) {
            newRefBytes = new byte[2 + sizeOfOperator];
            newRefBytes[0] = newRef <= 363 ? -9 : (newRef <= 619 ? -8 : (newRef <= 875 ? -7 : -6));
            newRefBytes[1] = (byte)(newRef - 108);
            for (int i = 0; i < operatorCode.length; ++i) {
                newRefBytes[2 + i] = (byte)operatorCode[i];
            }
        } else if (forceLength == -1 && newRef <= Short.MAX_VALUE || forceLength == 3) {
            newRefBytes = new byte[3 + sizeOfOperator];
            newRefBytes[0] = 28;
            newRefBytes[1] = (byte)(newRef >> 8);
            newRefBytes[2] = (byte)newRef;
            for (int i = 0; i < operatorCode.length; ++i) {
                newRefBytes[3 + i] = (byte)operatorCode[i];
            }
        } else {
            newRefBytes = new byte[5 + sizeOfOperator];
            newRefBytes[0] = 29;
            newRefBytes[1] = (byte)(newRef >> 24);
            newRefBytes[2] = (byte)(newRef >> 16);
            newRefBytes[3] = (byte)(newRef >> 8);
            newRefBytes[4] = (byte)newRef;
            for (int i = 0; i < operatorCode.length; ++i) {
                newRefBytes[5 + i] = (byte)operatorCode[i];
            }
        }
        return newRefBytes;
    }

    public static byte[] concatArray(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    protected int writeIndex(List<byte[]> dataArray) {
        int i;
        int hdrTotal = 3;
        this.writeCard16(dataArray.size());
        int totLength = 0;
        for (int i2 = 0; i2 < dataArray.size(); ++i2) {
            totLength += dataArray.get(i2).length;
        }
        int offSize = 1;
        offSize = totLength <= 256 ? 1 : (totLength <= 65536 ? 2 : (totLength <= 0x1000000 ? 3 : 4));
        this.writeByte(offSize);
        hdrTotal += offSize;
        int total = 0;
        block7: for (i = 0; i < dataArray.size(); ++i) {
            hdrTotal += offSize;
            int length = dataArray.get(i).length;
            switch (offSize) {
                case 1: {
                    if (i == 0) {
                        this.writeByte(1);
                    }
                    this.writeByte((total += length) + 1);
                    continue block7;
                }
                case 2: {
                    if (i == 0) {
                        this.writeCard16(1);
                    }
                    this.writeCard16((total += length) + 1);
                    continue block7;
                }
                case 3: {
                    if (i == 0) {
                        this.writeThreeByteNumber(1);
                    }
                    this.writeThreeByteNumber((total += length) + 1);
                    continue block7;
                }
                case 4: {
                    if (i == 0) {
                        this.writeULong(1);
                    }
                    this.writeULong((total += length) + 1);
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Offset Size was not an expected value.");
                }
            }
        }
        for (i = 0; i < dataArray.size(); ++i) {
            this.writeBytes(dataArray.get(i));
        }
        return hdrTotal + total;
    }

    private BytesNumber readNumber(int b0, byte[] input, int curPos) throws IOException {
        if (b0 == 28) {
            int b1 = input[curPos + 1] & 0xFF;
            int b2 = input[curPos + 2] & 0xFF;
            return new BytesNumber((short)(b1 << 8 | b2), 3);
        }
        if (b0 >= 32 && b0 <= 246) {
            return new BytesNumber(b0 - 139, 1);
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input[curPos + 1] & 0xFF;
            return new BytesNumber((b0 - 247) * 256 + b1 + 108, 2);
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input[curPos + 1] & 0xFF;
            return new BytesNumber(-(b0 - 251) * 256 - b1 - 108, 2);
        }
        if (b0 == 255) {
            int b1 = input[curPos + 1] & 0xFF;
            int b2 = input[curPos + 2] & 0xFF;
            return new BytesNumber((short)(b1 << 8 | b2), 5);
        }
        throw new IllegalArgumentException();
    }

    private void writeCharsetTable(boolean cidFont) throws IOException {
        this.writeByte(0);
        for (int gid : this.gidToSID.keySet()) {
            if (cidFont && gid == 0) continue;
            this.writeCard16(cidFont ? gid : this.gidToSID.get(gid));
        }
    }

    protected void writePrivateDict() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            this.writeBytes(this.cffReader.getPrivateDictBytes(privateEntry));
        }
    }

    protected void updateOffsets(int topDictOffset, int charsetOffset, int charStringOffset, int privateDictOffset, int localIndexOffset, int encodingOffset) throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        Map<String, CFFDataReader.DICTEntry> privateDICT = null;
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            privateDICT = this.cffReader.getPrivateDict(privateEntry);
        }
        int dataPos = 3 + this.cffReader.getTopDictIndex().getOffSize() * this.cffReader.getTopDictIndex().getOffsets().length;
        int dataTopDictOffset = topDictOffset + dataPos;
        this.updateFixedOffsets(topDICT, dataTopDictOffset, charsetOffset, charStringOffset, encodingOffset);
        if (privateDICT != null) {
            int oldPrivateOffset = dataTopDictOffset + privateEntry.getOffset();
            this.output = this.updateOffset(this.output, oldPrivateOffset + privateEntry.getOperandLengths().get(0), privateEntry.getOperandLengths().get(1), privateDictOffset);
            CFFDataReader.DICTEntry subroutines = privateDICT.get("Subrs");
            if (subroutines != null) {
                int oldLocalSubrOffset = privateDictOffset + subroutines.getOffset();
                int encodeValue = 0;
                if (subroutines.getOperandLength() == 1) {
                    encodeValue = 139;
                }
                this.output = this.updateOffset(this.output, oldLocalSubrOffset, subroutines.getOperandLength(), localIndexOffset - privateDictOffset + encodeValue);
            }
        }
    }

    protected void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> topDICT, int dataTopDictOffset, int charsetOffset, int charStringOffset, int encodingOffset) {
        CFFDataReader.DICTEntry charset = topDICT.get("charset");
        int oldCharsetOffset = dataTopDictOffset + charset.getOffset();
        this.output = this.updateOffset(this.output, oldCharsetOffset, charset.getOperandLength(), charsetOffset);
        CFFDataReader.DICTEntry charString = topDICT.get("CharStrings");
        int oldCharStringOffset = dataTopDictOffset + charString.getOffset();
        this.output = this.updateOffset(this.output, oldCharStringOffset, charString.getOperandLength(), charStringOffset);
        CFFDataReader.DICTEntry encodingEntry = topDICT.get("Encoding");
        if (encodingEntry != null && encodingEntry.getOperands().get(0).intValue() != 0 && encodingEntry.getOperands().get(0).intValue() != 1) {
            int oldEncodingOffset = dataTopDictOffset + encodingEntry.getOffset();
            this.output = this.updateOffset(this.output, oldEncodingOffset, encodingEntry.getOperandLength(), encodingOffset);
        }
    }

    protected void updateCIDOffsets(int topDictDataOffset, int fdArrayOffset, int fdSelectOffset, int charsetOffset, int charStringOffset, int encodingOffset) {
        CFFDataReader.DICTEntry fdSelect;
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDict = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry fdArrayEntry = topDict.get("FDArray");
        if (fdArrayEntry != null) {
            this.output = this.updateOffset(this.output, topDictDataOffset + fdArrayEntry.getOffset() - 1, fdArrayEntry.getOperandLength(), fdArrayOffset);
        }
        if ((fdSelect = topDict.get("FDSelect")) != null) {
            this.output = this.updateOffset(this.output, topDictDataOffset + fdSelect.getOffset() - 1, fdSelect.getOperandLength(), fdSelectOffset);
        }
        this.updateFixedOffsets(topDict, topDictDataOffset, charsetOffset, charStringOffset, encodingOffset);
    }

    protected byte[] updateOffset(byte[] out, int position, int length, int replacement) {
        switch (length) {
            case 1: {
                out[position] = (byte)(replacement & 0xFF);
                break;
            }
            case 2: {
                out[position] = replacement <= 363 ? -9 : (replacement <= 619 ? -8 : (replacement <= 875 ? -7 : -6));
                out[position + 1] = (byte)(replacement - 108);
                break;
            }
            case 3: {
                out[position] = 28;
                out[position + 1] = (byte)(replacement >> 8 & 0xFF);
                out[position + 2] = (byte)(replacement & 0xFF);
                break;
            }
            case 5: {
                out[position] = 29;
                out[position + 1] = (byte)(replacement >> 24 & 0xFF);
                out[position + 2] = (byte)(replacement >> 16 & 0xFF);
                out[position + 3] = (byte)(replacement >> 8 & 0xFF);
                out[position + 4] = (byte)(replacement & 0xFF);
                break;
            }
        }
        return out;
    }

    protected void writeByte(int b) {
        this.output[this.currentPos++] = (byte)b;
        ++this.realSize;
    }

    protected void writeCard16(int s) {
        byte b1 = (byte)(s >> 8 & 0xFF);
        byte b2 = (byte)(s & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
    }

    private void writeThreeByteNumber(int s) {
        byte b1 = (byte)(s >> 16 & 0xFF);
        byte b2 = (byte)(s >> 8 & 0xFF);
        byte b3 = (byte)(s & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
        this.writeByte(b3);
    }

    private void writeULong(int s) {
        byte b1 = (byte)(s >> 24 & 0xFF);
        byte b2 = (byte)(s >> 16 & 0xFF);
        byte b3 = (byte)(s >> 8 & 0xFF);
        byte b4 = (byte)(s & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
        this.writeByte(b3);
        this.writeByte(b4);
    }

    public byte[] getFontSubset() {
        byte[] ret = new byte[this.realSize];
        System.arraycopy(this.output, 0, ret, 0, this.realSize);
        return ret;
    }

    public CFFDataReader getCFFReader() {
        return this.cffReader;
    }

    static class BytesNumber {
        private int number;
        private int numBytes;

        public BytesNumber(int number, int numBytes) {
            this.number = number;
            this.numBytes = numBytes;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumBytes() {
            return this.numBytes;
        }

        public void clearNumber() {
            this.number = -1;
            this.numBytes = -1;
        }

        public String toString() {
            return Integer.toString(this.number);
        }

        public boolean equals(Object entry) {
            assert (entry instanceof BytesNumber);
            BytesNumber bnEntry = (BytesNumber)entry;
            return this.number == bnEntry.getNumber() && this.numBytes == bnEntry.getNumBytes();
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.number;
            hash = hash * 31 + this.numBytes;
            return hash;
        }
    }

    private class FDIndexReference {
        private int newFDIndex;
        private int oldFDIndex;

        public FDIndexReference(int newFDIndex, int oldFDIndex) {
            this.newFDIndex = newFDIndex;
            this.oldFDIndex = oldFDIndex;
        }

        public int getNewFDIndex() {
            return this.newFDIndex;
        }

        public int getOldFDIndex() {
            return this.oldFDIndex;
        }
    }
}

