/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.AddIconAction;
import freemind.controller.actions.generated.instance.RemoveIconXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.IconInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.IconAction;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class RemoveIconAction
extends NodeGeneralAction
implements NodeActorXml,
IconInformation {
    private IconAction iconAction;

    public RemoveIconAction(MindMapController modeController) {
        super(modeController, "remove_last_icon", "images/remove.png");
        this.addActor(this);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        List icons = selected.getIcons();
        if (icons.size() == 0) {
            return null;
        }
        AddIconAction undoAction = this.iconAction.createAddIconAction(selected, (MindIcon)icons.get(icons.size() - 1), -1);
        return new ActionPair((XmlAction)this.createRemoveIconXmlAction(selected, -1), (XmlAction)undoAction);
    }

    @Override
    public Class getDoActionClass() {
        return RemoveIconXmlAction.class;
    }

    public RemoveIconXmlAction createRemoveIconXmlAction(MindMapNode node, int iconPosition) {
        RemoveIconXmlAction action = new RemoveIconXmlAction();
        action.setNode(node.getObjectId(this.modeController));
        action.setIconPosition(iconPosition);
        return action;
    }

    public int removeLastIcon(MindMapNode node) {
        this.modeController.doTransaction((String)this.getValue("Name"), this.apply(this.modeController.getMap(), node));
        return node.getIcons().size();
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof RemoveIconXmlAction) {
            RemoveIconXmlAction removeAction = (RemoveIconXmlAction)action;
            NodeAdapter node = this.modeController.getNodeFromID(removeAction.getNode());
            int position = removeAction.getIconPosition();
            node.removeIcon(position);
            this.modeController.nodeChanged(node);
        }
    }

    public void setIconAction(IconAction iconAction) {
        this.iconAction = iconAction;
    }

    @Override
    public String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    @Override
    public KeyStroke getKeyStroke() {
        return Tools.getKeyStroke(this.getMindMapController().getFrame().getAdjustableProperty(this.getKeystrokeResourceName()));
    }

    @Override
    public String getKeystrokeResourceName() {
        return "keystroke_remove_last_icon";
    }
}

