/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyMath;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.objects.IsANode;
import org.jruby.truffle.nodes.objects.IsANodeGen;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Math")
public abstract class MathNodes {

    protected static abstract class SimpleDyadicMathNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        protected IsANode isANode;
        @Node.Child
        protected CallDispatchHeadNode floatANode;
        @Node.Child
        protected CallDispatchHeadNode floatBNode;

        protected SimpleDyadicMathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
            this.floatANode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
            this.floatBNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        protected double doFunction(double a, double b) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(int a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double function(int a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(int a, double b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(long a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(long a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(long a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(long a, double b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, int b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, long b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)", "isRubyBignum(b)"})
        public double function(DynamicObject a, DynamicObject b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, double b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization
        public double function(double a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(double a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double function(double a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(double a, double b) {
            return this.doFunction(a, b);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a, Object b) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass()) && this.isANode.executeIsA(b, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.doFunction(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]), this.floatBNode.callFloat(frame, b, "to_f", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }
    }

    protected static abstract class SimpleMonadicMathNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        protected SimpleMonadicMathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        protected double doFunction(double a) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a) {
            return this.doFunction(a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public double function(double a) {
            return this.doFunction(a);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.doFunction(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }
    }

    @CoreMethod(names={"sqrt"}, isModuleFunction=true, required=1)
    public static abstract class SqrtNode
    extends SimpleMonadicMathNode {
        public SqrtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sqrt(a);
        }
    }

    @CoreMethod(names={"tanh"}, isModuleFunction=true, required=1)
    public static abstract class TanHNode
    extends SimpleMonadicMathNode {
        public TanHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.tanh(a);
        }
    }

    @CoreMethod(names={"tan"}, isModuleFunction=true, required=1)
    public static abstract class TanNode
    extends SimpleMonadicMathNode {
        public TanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.tan(a);
        }
    }

    @CoreMethod(names={"sinh"}, isModuleFunction=true, required=1)
    public static abstract class SinHNode
    extends SimpleMonadicMathNode {
        public SinHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sinh(a);
        }
    }

    @CoreMethod(names={"sin"}, isModuleFunction=true, required=1)
    public static abstract class SinNode
    extends SimpleMonadicMathNode {
        public SinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sin(a);
        }
    }

    @CoreMethod(names={"log2"}, isModuleFunction=true, required=1)
    public static abstract class Log2Node
    extends SimpleMonadicMathNode {
        private final double LOG2 = Math.log(2.0);

        public Log2Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log2", this));
            }
            return Math.log(a) / this.LOG2;
        }
    }

    @CoreMethod(names={"log10"}, isModuleFunction=true, required=1)
    public static abstract class Log10Node
    extends SimpleMonadicMathNode {
        public Log10Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log10", this));
            }
            return Math.log10(a);
        }
    }

    @CoreMethod(names={"log"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LogNode
    extends SimpleDyadicMathNode {
        public LogNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double function(int a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, NotProvided b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public double function(double a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(VirtualFrame frame, Object a, NotProvided b) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.doFunction(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }

        private double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log", this));
            }
            return Math.log(a);
        }

        @Override
        protected double doFunction(double a, double b) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log", this));
            }
            return Math.log(a) / Math.log(b);
        }
    }

    @CoreMethod(names={"lgamma"}, isModuleFunction=true, required=1)
    public static abstract class LGammaNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        public LGammaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        @Specialization
        public DynamicObject lgamma(int a) {
            return this.lgamma((double)a);
        }

        @Specialization
        public DynamicObject lgamma(long a) {
            return this.lgamma((double)a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public DynamicObject lgamma(DynamicObject a) {
            return this.lgamma(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public DynamicObject lgamma(double a) {
            if (a < 0.0 && Double.isInfinite(a)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log2", this));
            }
            RubyMath.NemesLogGamma l = new RubyMath.NemesLogGamma(a);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{l.value, l.sign}, 2);
        }

        @Fallback
        public DynamicObject lgamma(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.lgamma(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }
    }

    @CoreMethod(names={"ldexp"}, isModuleFunction=true, required=2)
    public static abstract class LdexpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatANode;
        @Node.Child
        private CallDispatchHeadNode integerBNode;

        protected LdexpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
            this.floatANode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
            this.integerBNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        @Specialization
        public double function(int a, int b) {
            return this.function((double)a, b);
        }

        @Specialization
        public double function(int a, long b) {
            return this.function((double)a, b);
        }

        @Specialization
        public double function(int a, double b) {
            return this.function((double)a, b);
        }

        @Specialization
        public double function(long a, int b) {
            return this.function((double)a, b);
        }

        @Specialization
        public double function(long a, long b) {
            return this.function((double)a, b);
        }

        @Specialization
        public double function(long a, double b) {
            return this.function((double)a, b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, int b) {
            return this.function(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, long b) {
            return this.function(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, double b) {
            return this.function(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization
        public double function(double a, int b) {
            return this.function(a, (double)b);
        }

        @Specialization
        public double function(double a, long b) {
            return this.function(a, (double)b);
        }

        @Specialization
        public double function(double a, double b) {
            if (Double.isNaN(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError("float", Double.toString(b), "integer", this));
            }
            return a * Math.pow(2.0, b);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a, Object b) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.function(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]), this.integerBNode.callLongFixnum(frame, b, "to_int", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }
    }

    @CoreMethod(names={"hypot"}, isModuleFunction=true, required=2)
    public static abstract class HypotNode
    extends SimpleDyadicMathNode {
        public HypotNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a, double b) {
            return Math.hypot(a, b);
        }
    }

    @CoreMethod(names={"gamma"}, isModuleFunction=true, required=1)
    public static abstract class GammaNode
    extends SimpleMonadicMathNode {
        public GammaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a == -1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (Double.isInfinite(a)) {
                if (a > 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            double result = RubyMath.nemes_gamma((double)a);
            if (Double.isInfinite(result)) {
                result = a < 0.0 ? Double.NaN : (a == 0.0 && 1.0 / a < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (Double.isNaN(a)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            return result;
        }
    }

    @CoreMethod(names={"frexp"}, isModuleFunction=true, required=1)
    public static abstract class FrExpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        public FrExpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        @Specialization
        public DynamicObject frexp(int a) {
            return this.frexp((double)a);
        }

        @Specialization
        public DynamicObject frexp(long a) {
            return this.frexp((double)a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public DynamicObject frexp(DynamicObject a) {
            return this.frexp(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public DynamicObject frexp(double a) {
            double mantissa = a;
            int sign = 1;
            long exponent = 0L;
            if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
                if (mantissa < 0.0) {
                    mantissa = -mantissa;
                    sign = -1;
                }
                while (mantissa < 0.5) {
                    mantissa *= 2.0;
                    --exponent;
                }
                while (mantissa >= 1.0) {
                    mantissa *= 0.5;
                    ++exponent;
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{(double)sign * mantissa, exponent}, 2);
        }

        @Fallback
        public DynamicObject frexp(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(a, this.getContext().getCoreLibrary().getNumericClass())) {
                return this.frexp(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(a, "Float", this));
        }
    }

    @CoreMethod(names={"exp"}, isModuleFunction=true, required=1)
    public static abstract class ExpNode
    extends SimpleMonadicMathNode {
        public ExpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.exp(a);
        }
    }

    @CoreMethod(names={"erfc"}, isModuleFunction=true, required=1)
    public static abstract class ErfcNode
    extends SimpleMonadicMathNode {
        public ErfcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public double doFunction(double a) {
            return ErfcNode.erfc(a);
        }

        public static double erfc(double a) {
            double y = Math.abs(a);
            if (a <= -6.013687357) {
                return 2.0;
            }
            if (y < 1.49012E-8) {
                return 1.0 - 2.0 * a / 1.772453850905516;
            }
            double ysq = y * y;
            if (y < 1.0) {
                return 1.0 - a * (1.0 + RubyMath.chebylevSerie((double)(2.0 * ysq - 1.0), (double[])RubyMath.ERFC_COEF));
            }
            if (y <= 4.0) {
                double result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((double)((8.0 / ysq - 5.0) / 3.0), (double[])RubyMath.ERFC2_COEF));
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                return result;
            }
            double result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((double)(8.0 / ysq - 1.0), (double[])RubyMath.ERFCC_COEF));
            if (a < 0.0) {
                result = 2.0 - result;
            }
            return result;
        }
    }

    @CoreMethod(names={"erf"}, isModuleFunction=true, required=1)
    public static abstract class ErfNode
    extends SimpleMonadicMathNode {
        public ErfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (y <= 1.49012E-8) {
                return 2.0 * a / 1.772453850905516;
            }
            if (y <= 1.0) {
                return a * (1.0 + RubyMath.chebylevSerie((double)(2.0 * a * a - 1.0), (double[])RubyMath.ERFC_COEF));
            }
            if (y < 6.013687357) {
                return RubyMath.sign((double)(1.0 - ErfcNode.erfc(y)), (double)a);
            }
            if (Double.isNaN(y)) {
                return Double.NaN;
            }
            return RubyMath.sign((double)1.0, (double)a);
        }
    }

    @CoreMethod(names={"cosh"}, isModuleFunction=true, required=1)
    public static abstract class CosHNode
    extends SimpleMonadicMathNode {
        public CosHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cosh(a);
        }
    }

    @CoreMethod(names={"cos"}, isModuleFunction=true, required=1)
    public static abstract class CosNode
    extends SimpleMonadicMathNode {
        public CosNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cos(a);
        }
    }

    @CoreMethod(names={"cbrt"}, isModuleFunction=true, required=1)
    public static abstract class CbRtNode
    extends SimpleMonadicMathNode {
        public CbRtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cbrt(a);
        }
    }

    @CoreMethod(names={"atanh"}, isModuleFunction=true, required=1)
    public static abstract class ATanHNode
    extends SimpleMonadicMathNode {
        public ATanHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("atanh", this));
            }
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y < 1.82501E-8) {
                return a;
            }
            if (y <= 0.5) {
                return a * (1.0 + RubyMath.chebylevSerie((double)(8.0 * a * a - 1.0), (double[])RubyMath.ATANH_COEF));
            }
            if (y < 1.0) {
                return 0.5 * Math.log((1.0 + a) / (1.0 - a));
            }
            if (y == 1.0) {
                return a * Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
    }

    @CoreMethod(names={"atan2"}, isModuleFunction=true, required=2)
    public static abstract class ATan2Node
    extends SimpleDyadicMathNode {
        public ATan2Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a, double b) {
            return Math.atan2(a, b);
        }
    }

    @CoreMethod(names={"atan"}, isModuleFunction=true, required=1)
    public static abstract class ATanNode
    extends SimpleMonadicMathNode {
        public ATanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            return Math.atan(a);
        }
    }

    @CoreMethod(names={"asinh"}, isModuleFunction=true, required=1)
    public static abstract class ASinHNode
    extends SimpleMonadicMathNode {
        public ASinHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y <= 1.05367E-8) {
                return a;
            }
            if (y <= 1.0) {
                return a * (1.0 + RubyMath.chebylevSerie((double)(2.0 * a * a - 1.0), (double[])RubyMath.ASINH_COEF));
            }
            if (y < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a + 1.0));
            }
            double result = 0.6931471805599453 + Math.log(y);
            if (a < 0.0) {
                result *= -1.0;
            }
            return result;
        }
    }

    @CoreMethod(names={"asin"}, isModuleFunction=true, required=1)
    public static abstract class ASinNode
    extends SimpleMonadicMathNode {
        public ASinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("asin", this));
            }
            return Math.asin(a);
        }
    }

    @CoreMethod(names={"acosh"}, isModuleFunction=true, required=1)
    public static abstract class ACosHNode
    extends SimpleMonadicMathNode {
        public ACosHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (a < 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("acosh", this));
            }
            if (a < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a - 1.0));
            }
            return 0.6931471805599453 + Math.log(a);
        }
    }

    @CoreMethod(names={"acos"}, isModuleFunction=true, required=1)
    public static abstract class ACosNode
    extends SimpleMonadicMathNode {
        public ACosNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("acos", this));
            }
            return Math.acos(a);
        }
    }
}

